/**********************************************************
 *     OPERATION MODULE TEST PROGRAM        <OPRTEST.C>
 *                                     '93.12.7 by R.K
 *                                     '93.12.11 update by R.K
 *                                     '93.12.15 update by R.K
 **********************************************************/

#include    <stdio.h>
#include    <fcntl.h>
#include    <sys/types.h>
#include    <memory.h>
#include    <sys/stat.h>
#include    <sys/errno.h>

#include    "oprprot.h"

/*** prottypes ***/
char  mod_sel();

/*** global data ***/
char  gd_buf[80+1] ;
extern errno;

/***** << programs >> ****************************************/
main()
{

  char      len_str[10];
  char      clsbuf[80+1] = {0,};
  char      data[80+1] ;   /*** read string save buffer from file ***/
  char      path[80+1] ;   /*** path name buffer(operator input string) ***/
  char      sel_num, *pnt, *endp, str[3] ;
  int       stat, bufflag ;
  FILE      *fp ;          /*** file pointer ***/
  size_t    len ;          /*** character length ***/
  unsigned  cnt ;

  /*** displays init message ***/
  printf("<<<<< OPERATION MODULE TEST PROGRAM >>>>>\n");

  /*** select use buffer ***/
  printf("which buffer? (global=0 or local=1):");
  gets(str);
  if( str[0] == '0'){
       bufflag = B_GLOBAL;
       printf("please buf set:\n");
       gets(gd_buf);
  }       
  else if( str[0] == '1')  bufflag = B_LOCAL;
  else{
    printf("!!!ERROR!!! invalid selected \n");
    exit(1);
  }

  /*** select test module ***/
  while(1){
    /*** buffer clear ***/
    memcpy(path,clsbuf,LINE_MAX);
    memcpy(data,clsbuf,LINE_MAX);
    
    /*** select module ***/
    sel_num = mod_sel();

    /*** parse selected module & executing ***/
    switch(sel_num) {

         case 'l' :  /*** look global buffer ***/
	   printf("*** look global buffer ***\n");
	   printf("global data buffer is [%s]\n",gd_buf);
	   break;

	 case 's' :  /*** select buffer ***/
	   printf("*** select buffer ***\n");
	   printf("please select buffer(global buf=0,local buf=1):");
	   gets(str);
	   if( str[0] == '0'){
	     bufflag = B_GLOBAL;
	     break;
	   }
	   else if( str[0] == '1' ){
	     bufflag = B_LOCAL;
	     break;
	   }
	   else{
	     printf("!!!ERROR!!! not selected/n");
	     break;
	   }

         case 'c' :  /*** global buffer clear ***/
	   printf("*** global buffer clear ***\n");
	   memcpy(gd_buf,clsbuf,LINE_MAX);
	   break;

         case '0' :  /*** selected opr_write() ***/
	   printf("*** opr_write() ***\n");

	   /*** input open file pathname ***/
	   printf("file path name ?:");
	   gets(path);

	   /*** open file ***/
	   if( (fp = fopen(path,"a")) == NULL ){   /*** file open ***/
	     printf("!!!ERROR!!! file open failed\n");
	     break;
	   }

	   /*** input file write message ***/
	   if( bufflag == B_LOCAL ) {
	     printf("file write string is?:\n");
	     gets(data);
	     len = strlen(data);

	   /*** execute opr_write() ***/
	     if( (stat = opr_write(fp,data,len)) == STS_ABNORM ){
	       fclose(fp);
	       printf("!!!ERROR!!! status is %d\n",stat);
	       break ;
	     }
	     printf("opr_write() write bytes num is %d\n",stat);
	     fclose(fp) ;            /*** file close ***/
	     break ;
	   }
	   else {
	     len = strlen(gd_buf);

	     /*** execute opr_write() ***/
	     if( (stat = opr_write(fp,gd_buf,len)) == STS_ABNORM ){
	       fclose(fp);
	       printf("!!!ERROR!!! status is %d\n",stat);
	       break ;
	     }
	     printf("opr_write() write bytes num is %d\n",stat);
	     fclose(fp) ;            /*** file close ***/
	     break ;
	   }

	 case '1' :  /*** selected opr_read() ***/
	   printf("*** opr_read() ***\n");

	   /*** input open file pathname ***/
           printf("file path name ?:");
	   gets(path);

	   /*** open file ***/
	   if( (fp = fopen(path,"r")) == NULL ){     /*** file open ***/
	     printf("!!!ERROR!!! file open failed\n");
	     break;
	   }

	   /*** set read num from file ***/
	   printf("reading length is? :");
	   scanf("%d",&len);

	   /*** execute opr_read() ***/
	   if( (stat = opr_read(fp,data,len)) == STS_ABNORM ){
	     fclose(fp);
	     printf("!!!ERROR!!! status is %d\n",stat);
	     break;
	   }
	   printf("\n");
	   printf("opr_read() reading data num is %d\n",stat);
	   printf("read data is [%s]\n",data);
	   fclose(fp);                      /*** file close ***/
	   break ;

	 case '2' :  /*** selected opr_cd() ***/
	   printf("*** opr_cd() ***\n");

	   /*** input open file pathname ***/
	   printf("path name ?:");
	   gets(path);

	   /*** execute opr_cd() ***/
	   system("pwd");
	   stat = opr_cd(path);
	   system("pwd");
	   printf("opr_cd() status is %d\n",stat);
	   printf("opr_cd() errno is %d\n",errno);
	   break ;

	 case '3' :  /*** execute unix command ***/
	   printf("*** execute unix command ***\n");

	   /*** input execute command ***/
	   printf("\n");
	   printf("command?>");
	   gets(data);

	   /*** execute opr_cmnd() ***/
	   stat = opr_cmnd(data);
	   printf("\n");
	   printf("opr_cmnd() status is %d(0 = normal,-1 = abnormal)\n",stat);
	   break ;

	 case '4' :  /*** selected opr_search_vstart() ***/
	   printf("*** opr_search_vstart() ***\n");

	   /*** make search text ***/
	   if( bufflag == B_LOCAL ){
	     printf("please make text:\n");
	     gets(data);

	     /*** set start number ***/
	     printf("set start number:");
	     scanf("%d",&cnt);

	     /*** execute opr_search_vstart() ***/
	     printf("\n");
	     pnt = opr_search_vstart(data,cnt);
	     if( pnt == NULL ){
	       printf("!!! not found !!!\n");
	       break;
	     }
	     else {
	       printf("pnt data is [%s]\n",pnt);
	       break;
	     }
	     break ;
	   }
	   else{
	     /*** set start number ***/
	     printf("set start number:");
	     scanf("%d",&cnt);

	     /*** execute opr_search_vstart() ***/
	     printf("\n");
	     pnt = opr_search_vstart(gd_buf,cnt);
	     if( pnt == NULL ){
	       printf("!!! not found !!!\n");
	       break;
	     }
	     else {
	       printf("pnt data is [%s]\n",pnt);
	       break;
	     }
	     break ;
	   }

	 case '5' :  /*** selected opr_search_vend() ***/
	   printf("*** opr_search_vend() ***\n");

	   /*** make search text ***/
	   if( bufflag == B_LOCAL ){
	     printf("please make text:\n");
	     gets(data);

	     /*** set start number ***/
	     printf("set start number:");
	     scanf("%d",&cnt);

	     /*** execute opr_search_vend() ***/
	     printf("\n");
	     pnt = opr_search_vend(data,cnt);
	     if( pnt == NULL ){
	       printf("!!! not found !!!\n");
	       break;
	     }
	     else {
	       printf("pnt data is [%s]\n",pnt);
	       break;
	     }
	     break ;
	   }
	   else {
	     /*** set start number ***/
	     printf("set start number:");
	     scanf("%d",&cnt);

	     /*** execute opr_search_vend() ***/
	     printf("\n");
	     pnt = opr_search_vend(gd_buf,cnt);
	     if( pnt == NULL ){
	       printf("!!! not found !!!\n");
	       break;
	     }
	     else {
	       printf("pnt data is [%s]\n",pnt);
	       break;
	     }
	     break ;
	   }

	 case '6' :  /*** selected opr_search_camma() ***/
	   printf("*** opr_search_camma() ***\n");

	   /*** make search text ***/
	   if( bufflag == B_LOCAL ){
	     printf("please make text:\n");
	     gets(data);

	     /*** set start number ***/
	     printf("set start number:");
	     scanf("%d",&cnt);

	     /*** execute opr_search_vstart() ***/
	     printf("\n");
	     pnt = opr_search_camma(data,cnt);
	     if( pnt == NULL ){
	       printf("!!! not found !!!\n");
	       break;
	     }
	     else {
	       printf("pnt data is [%s]\n",pnt);
	       break;
	     }
	     break ;
	   }
	   else{
	     /*** set start number ***/
	     printf("set start number:");
	     scanf("%d",&cnt);

	     /*** execute opr_search_vstart() ***/
	     printf("\n");
	     pnt = opr_search_camma(gd_buf,cnt);
	     if( pnt == NULL ){
	       printf("!!! not found !!!\n");
	       break;
	     }
	     else {
	       printf("pnt data is [%s]\n",pnt);
	       break;
	     }
	     break ;
	   }

	 case '7' :  /*** selected opr_search_vector() ***/
	   printf("*** opr_search_vector() ***\n");

	   /*** make search text ***/
	   if( bufflag == B_LOCAL ){
	     printf("please make text:\n");
	     gets(data);
	     
	     /*** set start number ***/
	     printf("set start number:");
	     scanf("%d",&cnt);
	     
	     /*** execute opr_search_vstart() ***/
	     printf("\n");
	     pnt = opr_search_vector(data,cnt,&endp);
	     if( pnt == NULL ){
	       printf("!!! not found !!!\n");
	       break;
	     }
	     else {
	       endp[0] = 0;
	       printf("get vector is [%s]\n",pnt);
	       break;
	     }
	     break ;
	   }
	   else {
	     /*** set start number ***/
	     printf("set start number:");
	     scanf("%d",&cnt);
	     
	     /*** execute opr_search_vstart() ***/
	     printf("\n");
	     pnt = opr_search_vector(gd_buf,cnt,&endp);
	     if( pnt == NULL ){
	       printf("!!! not found !!!\n");
	       break;
	     }
	     else {
	       endp[0] = 0;
	       printf("get vector is [%s]\n",pnt);
	       break;
	     }
	     break ;
	   }
	   
	default : /*** selected invalid number ***/
	   printf("!!!INPUT ERROR!!! invalid input number !!!\n");
	   break ;
    }
  }
}
/***** <<< main END >>> *****/

/**********************************************************
 *     SUB ROUTINS
 *********************************************************/
/****************************************
 *     DISPLAYS INIT MESSAGE
 *                  function = mod_sel()
 ***************************************/
char  mod_sel()
{
  char  num ;
  char  str_i[3];

  printf("\n");
  printf("opr_write()=0/opr_read()=1/opr_cd()=2/opr_cmnd()=3\n");
  printf("opr_search_vstart()=4/opr_search_vend()=5/opr_search_camma()=6\n");
  printf("opr_search_vector()=7\n");
  printf("\n");
  printf("global buf clear=c/global buf write=w/see global buf=l\n");
  printf("\n");
  printf("testing module is?:");
  gets(str_i);
  num = str_i[0];
  return   num;
}
/***** << mod_sel() END >> *****/
/***** <<< END OF OPRTEST.C >>> ***********************************************/
