#include  <stdio.h>
#include  <string.h>

#include  "pmdata.h"
#include  "pmfunc.h"
#include  "pmtool.h"
#include  "oprprot.h"

/**********************************************************
 *     FUNCTION MODULE
 *                                        '93.1.12 by R.K
 *---------------------------------------------------------
 * module name : ls_l_c()
 *
 * input :
 *
 *output :
 *
 **********************************************************/

/*** option element status definition ***/
#define  STAT_L   1
#define  STAT_F   2
#define  STAT_LF  3
#define  STAT_N   4
#define  STAT_LN  5
#define  STAT_FN  6
#define  STAT_LFN 7
#define  STAT_S   8

void ls_l_c(sn,buf)

     int  sn ;
     char *buf;
{

  char         finfo[40], wbuf[80], dirbuf[BUF_MAX], dbbuf[BUF_MAX] ;
  char         db_name[1024], db_name2[1024], curfname[80] ;
  char         *dir, *optele, *cond, *wp, *revsp ;
  int          ret, i, version, last_ver ;
  unsigned int optflag = 0 ;
  FILE         *fp, *fp2;

  /*** buffer clear ***/
  dirbuf[0] = NULL;
  dbbuf[0] = NULL;
  db_name[0] = NULL;

  /*** parameter set *************************************/
  if( (ret = pm_sep_prm(buf+1,prm_buf)) != 2){
    sprintf(wr_data,
    "result_ls_l(abnormal(\"invalid prm\"),\'&void\',\'&void\',done)\n");
    write(sn,wr_data,strlen(wr_data));
    return;
  }
  dir = prm_buf;                            /* get dir */
  wp = (dir+(strlen(dir)+1));
  pm_del_list(wp,wbuf);                     /* delete "{" "}" */
  if((ret = pm_sep_prm(wbuf,finfo)) != 2 ){
    sprintf(wr_data,
    "result_ls_l(abnormal(\"invalid prm\"),\'&void\',\'&void\',done)\n");
    write(sn,wr_data,strlen(wr_data));
    return;
  }
  optele = finfo;                          /* get option element */
  cond = (optele+(strlen(optele)+1));      /* get condition */

  /*** execute *******************************************/
  /*** change directory ***/
  pm_mkdir_name(dir,wbuf);
  if( (ret = opr_cd(wbuf)) == -1 ){
    sprintf(wr_data,
    "result_ls_l(abnormal(\"dir not found\"),\'&void\',\'&void\',done)\n");
    write(sn,wr_data,strlen(wr_data));
    return;
  }

  /*** set option element flag ***/
  for(i = 0; optele[i] != NULL; i++ ){
    if( optele[i] == 'l' )
      optflag |= STAT_L;
    else if( optele[i] == 'f' )
      optflag |= STAT_F;
    else if( optele[i] == 'n' )
      optflag |= STAT_N;
    else if( optele[i] == 's' )
      optflag |= STAT_S;
  }

  /*** execute "ls" command ***/
  opr_cmnd("ls -F > ls_get_file_tp");

  /*** read ls_get_file_tp file ***/
  fp = fopen("ls_get_file_tp","r");

  /*** get dir & DB name ***/
  while( (fgets(wbuf,sizeof(wbuf),fp)) != NULL ){
    wbuf[strlen(wbuf)-1] = NULL;
    if( wbuf[strlen(wbuf)-1] == '/' ){
      wbuf[strlen(wbuf)-1] = NULL;
      sprintf(dirbuf+strlen(dirbuf),"\"%s\",",wbuf);
    }
    else{
      if( (wp = strchr(wbuf,'.')) == NULL )
	continue;
      if( !strcmp(wp,".cntrl") ){
	wbuf[wp-wbuf] = NULL;
	sprintf(db_name+strlen(db_name),"%s,",wbuf);
      }
    }
  }
  dirbuf[strlen(dirbuf)-1] = NULL;
  db_name[strlen(db_name)-1] = NULL;
  fclose(fp);
  opr_cmnd("rm ls_get_file_tp");

  /*** check option element flag ***/
  ret = pm_sep_prm(db_name,db_name2);
  wp = db_name2;
  for( i = 0; i < ret; i++ ){
    if( (set_ls_data(optflag,wp,cond,(dbbuf+strlen(dbbuf)))) < -1 )
      continue;
    strcpy(dbbuf+strlen(dbbuf),",");
    wp = ((wp+strlen(wp))+1);
  }
  dbbuf[strlen(dbbuf)-1] = NULL;

  /*** write response ***/
  sprintf(wr_data,
	  "result_ls_l(normal,[%s],[%s],done)\n",dirbuf,dbbuf);
  write(sn,wr_data,strlen(wr_data));
  fclose(fp);
  strncpy(dirbuf,"",strlen(dirbuf));
  strncpy(dbbuf,"",strlen(dbbuf));

  /*** change directory ***/
  opr_cd(cur_dir);
}
/***** <<< END OF c_lsl.c >>> *****/

/*************************************************************************
 *       SUB ROUTIN
 ************************************************************************/

/*************************************************************************
 *       set_ls_data()
 *------------------------------------------------------------------------
 * INPUT:
 *       unsigned int  option         : option element flag
 *       char          *dbname        : DB name or condition
 *       char          *condition     : condition
 *       char          *dbbuf         :(r) ls data setting buffer
 *
 * OUTPUT:
 *       int           ret            : return status
 *                                        0 = normal
 *                                       -1 = not found DB
 *
 ************************************************************************/
int   set_ls_data(option,dbname,condition,dbbuf)

     unsigned int  option ;
     char          *dbname, *condition, *dbbuf ;
{

  char  wbuf[80], wbuf2[80], bigwbuf[1024], revstr[1024] ;
  char  cdate[1024], info[1024];
  char  sep_cdate[1024], sep_rev[1024], prev[40] ;

  char  *revsp, *revp, *datep, *wp ;

  int   i, last_ver, version, revnum ;
  FILE  *fp ;

  struct  info_tag{
    char  *DB_name;
    char  *VerNO;
    char  *Tag;
    char  *Pgm_name;
    char  *Author;
    char  *Date;
    char  *C_date;
    char  *Include;
    char  *RevNO;
    char  *Last_update;
  } s_info;
  
  /*** read ".cntrl" file ***/
  sprintf(wbuf,"%s.cntrl",dbname);      
  if( (fp = fopen(wbuf,"r")) == NULL )
    return -1;
  fgets(wbuf,sizeof(wbuf),fp);
  fscanf(fp,"%d",&last_ver);
  fclose(fp);
  sprintf(dbbuf,"{\"%s\",[",dbname);
  
  /*** option = 'l' or 'ln' or 'lf' or 'lfn' ***************************/
  if( (option == STAT_L) || (option == STAT_LN) ||
     (option == STAT_LF) || (option == STAT_LFN) ){  

    /*** read & get ".info" file ***/
    for( version = 1; version <= last_ver; version++ ){
      sprintf(wbuf,"%s.%d.info",dbname,version);      
      if( (fp = fopen(wbuf,"r")) == NULL )
	continue;
      if( ((option == STAT_LN) || (option == STAT_LFN))
	 && (version < last_ver) )
	continue;
      fgets(revstr,sizeof(revstr),fp);
      fgets(cdate,sizeof(cdate),fp);
      fgets(info,sizeof(info),fp);
      fclose(fp);
      sprintf(dbbuf+strlen(dbbuf),"{%d,[",version);

      /* get DB file name */
      sprintf(wbuf,"ls %s.%d* > temp",dbname,version);
      opr_cmnd(wbuf);

      /*** get revision ***/
      fp = fopen("temp","r");
      while( (fgets(wbuf,sizeof(wbuf),fp)) != NULL ){
	if( (!strncmp(wbuf+(strlen(wbuf)-5),".qxt",4)) ||
	   (!strncmp(wbuf+(strlen(wbuf)-5),".src",4)) ||
	   (!strncmp(wbuf+(strlen(wbuf)-5),".obj",4)) ){
	  revsp = (strchr((strchr(wbuf,'.')+1),'.')+1);
	  revsp[strlen(revsp)-5] = NULL;
	  if( strcmp(prev,revsp) ){
	    strcpy(prev,revsp);
	    pm_mk_rev(revsp,dbbuf+strlen(dbbuf));
	    strcpy(dbbuf+strlen(dbbuf),",");
	  }
	}
      }
      prev[0] = NULL;
      strcpy((dbbuf+strlen(dbbuf))-1,"]},");
    }
    fclose(fp);
    opr_cmnd("rm temp");
    strcpy((dbbuf+strlen(dbbuf))-1,"]}");
    return 0;
  }

  /*** option = 'f' or 'fn' or 's' ******************************************/
  else if( (option == STAT_F) || (option == STAT_FN) 
	  || (option == STAT_S) ){

    /*** read & get ".info" file ***/
    for( version = 1; version <= last_ver; version++ ){
      sprintf(wbuf,"%s.%d.info",dbname,version);      
      if( (fp = fopen(wbuf,"r")) == NULL )
	continue;
      if( (option == STAT_FN) && (version < last_ver) )
	continue;
      fgets(revstr,sizeof(revstr),fp);
      fgets(cdate,sizeof(cdate),fp);
      fgets(info,sizeof(bigwbuf),fp);
      fclose(fp);
      sprintf(dbbuf+strlen(dbbuf),"{%d,",version);

      /*** set info data to structure ***/
      if( (pm_sep_prm(bigwbuf+1,info)) < 5 ){
	if( (option == STAT_F) || (option == STAT_FN) || (option == STAT_S) )
	  sprintf(dbbuf+strlen(dbbuf),
	  "\'&void\',\'&void\',\'&void\',\'&void\',\'&void\',[],[]},");
	continue;
      }
      s_info.Tag = info;
      wp = (info+(strlen(info)+1));
      s_info.Pgm_name = wp;
      wp = (wp+(strlen(wp)+1));
      s_info.Author = wp;
      wp = (wp+(strlen(wp)+1));
      s_info.Date = wp;
      wp = (wp+(strlen(wp)+1));
      s_info.Include = wp;
      pm_sep_prm(cdate,sep_cdate);
      s_info.C_date = sep_cdate;
      if( (option == STAT_F) || (option == STAT_FN) || (option == STAT_S) )
	sprintf(dbbuf+strlen(dbbuf),"%s,%s,%s,%s,%s,%s,",
		s_info.Tag,s_info.Pgm_name,s_info.Author,s_info.Date,cdate,
		s_info.Include);
/*******
      else if( option == STAT_S ){
	condnum = pm_sep_prm(condition+1,bigwbuf);
	wp = bigwbuf;
	for(; condnum > 0; condnum-- ){
	  while( strncmp(wp,cmptag[ii],strlen(cmptag[ii]) )
	    ii++;
	}
      }
******/

      /*** set revision & last_update ***/
      revnum = pm_sep_prm(revstr,sep_rev);
      revp = sep_rev;
      datep = sep_cdate;
      for(i = 0; i < revnum; i++ ){
	pm_rep_rev(revp,wbuf2);
	sprintf(wbuf,"%s.%d.%s.",dbname,version,wbuf2);
	wp = wbuf+strlen(wbuf);
	strcpy(wp,"qxt");
	if( (fp = fopen(wbuf,"r")) != NULL ){
	  fclose(fp);
	  sprintf(dbbuf+strlen(dbbuf),"[{%s,%s},",revp,datep);
	  revp = ((revp+strlen(revp))+1);
	  datep = ((datep+strlen(datep))+1);
	  continue;
	}
	strcpy(wp,"src");
	if( (fp = fopen(wbuf,"r")) != NULL ){
	  fclose(fp);
	  sprintf(dbbuf+strlen(dbbuf),"[{%s,%s},",revp,datep);
	  revp = ((revp+strlen(revp))+1);
	  datep = ((datep+strlen(datep))+1);
	  continue;
	}
	strcpy(wp,"obj");
	if( (fp = fopen(wbuf,"r")) != NULL ){
	  fclose(fp);
	  sprintf(dbbuf+strlen(dbbuf),"[{%s,%s},",revp,datep);
	  revp = ((revp+strlen(revp))+1);
	  datep = ((datep+strlen(datep))+1);
	  continue;
	}
	revp = ((revp+strlen(revp))+1);
	datep = ((datep+strlen(datep))+1);
      }
      sprintf((dbbuf+strlen(dbbuf))-1,"]},");
    }
    sprintf((dbbuf+strlen(dbbuf))-1,"]}");
    return 0;
  }
  else
    return -1;
}
/*** <<< set_ls_data() END >>> *****/

/***** <<< END OF c_lsl.c >>> *****/
