#ifdef sequent
#include <strings.h>
#else
#include <string.h>
#endif

#include <math.h>

#include "dotsrc.h"

unparse(object,fp)
PseudoObject *object;
FILE *fp;
	{
	if(object->tag == PROGRAM)
	  	{
		unparse_program(object,fp);
		}
	else
		{
		unparse_query(object,fp);
		}
	}

Public unparse_program(program, fp)
     Program* program;
     FILE* fp;

{
    qxt_output( "{program,");
        unparse_pseudo_object(program->env_def, fp);
    qxt_output( ",");
        unparse_pseudo_object(program->exp_def, fp);
    qxt_output( ",");
        unparse_pseudo_object(program->obj_def, fp);
    qxt_output( ",");
        unparse_pseudo_object(program->mod_def, fp);
    qxt_output( ",");
        unparse_pseudo_object(program->link_def, fp);
    qxt_output( ",");
        unparse_pseudo_object(program->rule_def, fp);
    qxt_output( "}");
}

/*
  CAUTION: current version doesn't check cyclic data structure.
*/

static unparse_pseudo_objectx(object, fp)
     PseudoObject* object;
     FILE* fp;

{
    if(object == NULL) {
	qxt_output("[]");
        return(0);
    }
    switch (object->tag) {
      case NULL:
	qxt_output("[]");
	return(2);
      default:
	unparse_pseudo_object(object, fp);
	break;
    }
}

static unparse_pseudo_objecty(object, fp)
     PseudoObject* object;
     FILE* fp;

{
    if(object == NULL) {
        return(0);
    }
    unparse_pseudo_object(object, fp);
}

Public unparse_pseudo_object(object, fp)
     PseudoObject* object;
     FILE* fp;

{
    if(object == NULL) {
	qxt_output("'&void'");
	return(1);
    }
    switch (object->tag) {
      case PROGRAM:
	unparse_program((Program*)object, fp);
	return(0);
      case ENV_DEF:
	unparse_env_def((EnvDef*)object, fp);
	return(0);
      case DEF_LIB:
	unparse_def_lib((DefLib*)object, fp);
	return(0);
      case STRING:
	unparse_string((String*)object, fp);
	return(0);
      case EXP_DEF:
	unparse_exp_def((ExpDef*)object, fp);
	return(0);
      case EXP:
	unparse_exp((Exp*)object, fp);
	return(0);
      case EXP_NAME:
	unparse_exp_name((ExpName*)object, fp);
	return(0);
      case OBJ_DEF:
	unparse_obj_def((ObjDef*)object, fp);
	return(0);
      case OBJ_SUB:
	unparse_obj_sub((ObjSub*)object, fp);
	return(0);
      case MOD_DEF:
	unparse_mod_def((ModDef*)object, fp);
	return(0);
      case M_SUB:
	unparse_m_sub((MSub*)object, fp);
	return(0);
      case M_DESC:
	unparse_m_desc((MDesc*)object, fp);
	return(0);
      case M2_DESC:
	unparse_m2_desc((M2Desc*)object, fp);
	return(0);
      case LINK_DEF:
	unparse_link_def((LinkDef*)object, fp);
	return(0);
      case LINK:
	unparse_link((Link*)object, fp);
	return(0);
      case M_ID_PAIR:
	unparse_m_id_pair((MIdPair*)object, fp);
	return(0);
      case O_TERM_PAIR:
	unparse_o_term_pair((OTermPair*)object, fp);
	return(0);
      case RULE_DEF:
	unparse_rule_def((RuleDef*)object, fp);
	return(0);
      case RULE:
	unparse_rule((Rule*)object, fp);
	return(0);
      case RULE_ID:
	unparse_rule_id((RuleId*)object, fp);
	return(0);
      case NORMAL:
	unparse_normal((Normal*)object, fp);
	return(0);
      case REL:
	unparse_rel((Rel*)object, fp);
	return(0);
      case UPDATE:
	unparse_update((Update*)object, fp);
	return(0);
      case TRANSACTION:
	unparse_transaction((Transaction*)object, fp);
	return(0);
      case PROP:
	unparse_prop((Prop*)object, fp);
	return(0);
      case I_CHECK:
	unparse_i_check((ICheck*)object, fp);
	return(0);
      case CLUSTER:
	unparse_cluster((Cluster*)object, fp);
	return(0);
      case A_TERM:
	unparse_a_term((ATerm*)object, fp);
	return(0);
      case O_TERM:
	unparse_o_term((OTerm*)object, fp);
	return(0);
      case LABEL:
	unparse_label((Label*)object, fp);
	return(0);
      case LAB:
	unparse_lab((Label*)object, fp);
	return(0);
      case IND_LAB:
	unparse_ind_lab((Label*)object, fp);
	return(0);
      case SET_LAB:
	unparse_set_lab((Label*)object, fp);
	return(0);
      case CURL_IND:
	unparse_curl_ind((Label*)object, fp);
	return(0);
      case CURL_SET:
	unparse_curl_set((Label*)object, fp);
	return(0);
      case C_O_TERM:
	unparse_c_o_term((COTerm*)object, fp);
	return(0);
      case VAR:
	unparse_var((Var*)object, fp);
	return(0);
      case DOT:
	unparse_dot((Dot*)object, fp);
	return(0);
      case SUB_LIST:
	unparse_sub_list((SubList*)object, fp);
	return(0);
      case LIST:
	unparse_list((List*)object, fp);
	return(0);
      case REMAIN:
	unparse_remain((Remain*)object, fp);
	return(0);
      case INTEGER:
	unparse_integer((Integer*)object, fp);
	return(0);
      case NON_STRUCT:
	unparse_non_struct((NonStruct*)object, fp);
	return(0);
      case ATTR:
	unparse_attr((Attr*)object, fp);
	return(0);
      case SET:
	unparse_set((Set*)object, fp);
	return(0);
      case SORT:
	unparse_sort((Sort*)object, fp);
	return(0);
      case VALUE:
	unparse_value((Value*)object, fp);
	return(0);
      case QUERY_CNSTR:
	unparse_query_cnstr((QueryCnstr*)object, fp);
	return(0);
      case CNSTR:
	unparse_cnstr((Cnstr*)object, fp);
	return(0);
      case CNSTR_DATA:
	unparse_cnstr_data((Cnstr*)object, fp);
	return(0);
      case QUERY:
	unparse_query((Query*)object, fp);
	return(0);
      case P_MODE:
	unparse_p_mode((PMode*)object, fp);
	return(0);
      case A_MODE:
	unparse_a_mode((AMode*)object, fp);
	return(0);
      case I_MODE:
	unparse_i_mode((IMode*)object, fp);
	return(0);
      case M_MODE:
	unparse_m_mode((MMode*)object, fp);
	return(0);
      case E_MODE:
	unparse_e_mode((EMode*)object, fp);
	return(0);
      case Q_MODE:
	unparse_q_mode((QMode*)object, fp);
	return(0);
      case ANSWER:
	unparse_answer((Answer*)object, fp);
	return(0);
      case ANSWER_ELEMENT:
	unparse_answer_element((AnswerElement*)object, fp);
	return(0);
      case ANSE_EXPLANATION: 
	unparse_anse_explanation((AnseExplanation*)object, fp);
	return(0);
      case RIR_PAIR: 
	unparse_rir_pair((RirPair*)object, fp);
	return(0);
      case DOT_CNSTR:
	unparse_dot_cnstr((DotCnstr*)object, fp);
	return(0);
      case VAR_CNSTR:
	unparse_var_cnstr((VarCnstr*)object, fp);
	return(0);
      case INHERIT:
	unparse_inherit((Inherit*)object, fp);
	return(0);
      case REDUCE:
	unparse_reduce((Reduce*)object, fp);
	return(0);
      case SUB_GOAL:
	unparse_sub_goal((SubGoal*)object, fp);
	return(0);
      case VC_PAIR:
	unparse_vc_pair((VcPair*)object, fp);
	return(0);
      case ONE_RULE:
	unparse_one_rule((OneRule*)object, fp);
	return(0);
      case UNIT_EXPLANATION:
	unparse_unit_explanation((UnitExplanation*)object, fp);
	return(0);
      case MERGE_EXPLANATION:
	unparse_merge_explanation((MergeExplanation*)object, fp);
	return(0);
      case LOOKUP_EXPLANATION:
	unparse_lookup_explanation((LookupExplanation*)object, fp);
	return(0);
      case EXPLANATION:
	unparse_explanation((Explanation*)object, fp);
	return(0);
      case CONSTRAINT:
	unparse_constraint((Constraint*)object, fp);
	return(0);
      case CON:
	unparse_con((Con*)object, fp);
	return(0);
      case ASSUMP:
	unparse_assump((Assump*)object, fp);
	return(0);
      case QUERY_EXPLANATION: 
	unparse_query_explanation((QueryExplanation*)object, fp);
	return(0);
      case PSEUDO_OBJECT:
	union_tag("PSEUDO_OBJECT", fp);
	return(0);
      case OBJ_LIST:
	unparse_obj_list((ObjList*)object, fp);
	return(0);
      case OBJ_ARRAY:
	unparse_obj_array((ObjArray*)object, fp);
	return(0);
      case NULL:
	qxt_output("'&void'");
	return(1);
      default:
	illegal_type_descriptor("unparse_pseudo_object", object->tag);
	break;
    }
}

/*
  type_name
  return a type's type name string
*/

static char* type_name(td)
     TypeDescriptor td;
{
    switch (td) {
      case PROGRAM: return "PROGRAM";
      case ENV_DEF: return "ENV_DEF";
      case DEF_LIB: return "DEF_LIB";
      case STRING: return "STRING";
      case EXP_DEF: return "EXP_DEF";
      case EXP: return "EXP";
      case EXP_NAME: return "EXP_NAME";
      case OBJ_DEF: return "OBJ_DEF";
      case OBJ_SUB: return "OBJ_SUB";
      case MOD_DEF: return "MOD_DEF";
      case M_SUB: return "M_SUB";
      case M_DESC: return "M_DESC";
      case M2_DESC: return "M2_DESC";
      case LINK_DEF: return "LINK_DEF";
      case LINK: return "LINK";
      case M_ID_PAIR: return "M_ID_PAIR";
      case O_TERM_PAIR: return "O_TERM_PAIR";
      case RULE_DEF: return "RULE_DEF";
      case RULE: return "RULE";
      case RULE_ID: return "RULE_ID";
      case NORMAL: return "NORMAL";
      case REL: return "REL";
      case UPDATE: return "UPDATE";
      case TRANSACTION: return "TRANSACTION";
      case PROP: return "PROP";
      case I_CHECK: return "I_CHECK";
      case CLUSTER: return "CLUSTER";
      case A_TERM: return "A_TERM";
      case O_TERM: return "O_TERM";
      case LABEL: return "LABEL";
      case LAB: return "LAB";
      case C_O_TERM: return "C_O_TERM";
      case VAR: return "VAR";
      case DOT: return "DOT";
      case SUB_LIST: return "SUB_LIST";
      case LIST: return "LIST";
      case REMAIN: return "REMAIN";
      case INTEGER: return "INTEGER";
      case NON_STRUCT: return "NON_STRUCT";
      case ATTR: return "ATTR";
      case SET: return "SET";
      case SORT: return "SORT";
      case VALUE: return "VALUE";
      case QUERY_CNSTR: return "QUERY_CNSTR";
      case CNSTR: return "CNSTR";
      case QUERY: return "QUERY";
      case P_MODE: return "P_MODE";
      case A_MODE: return "A_MODE";
      case I_MODE: return "I_MODE";
      case M_MODE: return "M_MODE";
      case E_MODE: return "E_MODE";
      case Q_MODE: return "Q_MODE";
      case ANSWER: return "ANSWER";
      case ANSWER_ELEMENT: return "ANSWER_ELEMENT";
      case ANSE_EXPLANATION: return "ANSE_EXPLANATION";
      case RIR_PAIR: return "RIR_PAIR";
      case DOT_CNSTR: return "DOT_CNSTR";
      case VAR_CNSTR: return "VAR_CNSTR";
      case INHERIT: return "INHERIT";
      case REDUCE: return "REDUCE";
      case SUB_GOAL: return "SUB_GOAL";
      case VC_PAIR: return "VC_PAIR";
      case ONE_RULE: return "ONE_RULE";
      case UNIT_EXPLANATION: return "UNIT_EXPLANATION";
      case MERGE_EXPLANATION: return "MERGE_EXPLANATION";
      case LOOKUP_EXPLANATION: return "LOOKUP_EXPLANATION";
      case EXPLANATION: return "EXPLANATION";
      case CONSTRAINT: return "CONSTRAINT";
      case CON: return "CON";
      case ASSUMP: return "ASSUMP";
      case QUERY_EXPLANATION: return "QUERY_EXPLANATION";
      case PSEUDO_OBJECT: return "PSEUDO_OBJECT";
      case OBJ_LIST: return "OBJ_LIST";
      case OBJ_ARRAY: return "OBJ_ARRAY";
      default:
	illegal_type_descriptor("type_name", td);
	break;
    }
}

/*
  is_type(td1, td2):
  check if td1 is one of sub-types of td2
*/

static Bool is_type(td1, td2)
     TypeDescriptor td1, td2;
{
    if (td1 == td2)
      return TRUE;
    else
      switch (td2) {
	case PROGRAM:
	  return td1 == PROGRAM;
	case ENV_DEF:
	  return td1 == ENV_DEF;
	case DEF_LIB:
	  return td1 == DEF_LIB;
	case STRING:
	  return td1 == STRING;
	case EXP_DEF:
	  return td1 == EXP_DEF;
	case EXP:
	  return td1 == EXP;
	case EXP_NAME:
	  return td1 == EXP_NAME;
	case OBJ_DEF:
	  return td1 == OBJ_DEF;
	case OBJ_SUB:
	  return td1 == OBJ_SUB;
	case MOD_DEF:
	  return td1 == MOD_DEF;
	case M_SUB:
	  return td1 == M_SUB;
	case M_DESC:
	  return is_type(td1, M_ID) || is_type(td1, M2_DESC);
	case M2_DESC:
	  return td1 == M2_DESC;
	case LINK_DEF:
	  return td1 == LINK_DEF;
	case LINK:
	  return td1 == LINK;
	case M_ID_PAIR:
	  return td1 == M_ID_PAIR;
	case O_TERM_PAIR:
	  return td1 == O_TERM_PAIR;
	case RULE_DEF:
	  return td1 == RULE_DEF;
	case RULE:
	  return td1 == RULE;
	case RULE_ID:
	  return td1 == RULE_ID;
	case NORMAL:
	  return td1 == NORMAL;
	case REL:
	  return td1 == REL;
	case UPDATE:
	  return td1 == UPDATE;
	case TRANSACTION:
	  return td1 == TRANSACTION;
	case PROP:
	  return td1 == PROP;
	case I_CHECK:
	  return is_type(td1, PROP) || is_type(td1, OBJ_LIST);
	case CONSIS:
	  return is_type(td1, I_CHECK);
	case INCONSIS:
	  return is_type(td1, I_CHECK);
	case CLUSTER:
	  return is_type(td1, NORMAL) || is_type(td1, REL)
	         || is_type(td1, UPDATE) || is_type(td1, TRANSACTION)
		 || is_type(td1, CONSIS) || is_type(td1, INCONSIS);
	case A_TERM:
	  return td1 == A_TERM;
	case O_TERM:
	  return is_type(td1, PROGRAM) || is_type(td1, C_O_TERM)
	         || is_type(td1, VAR) || is_type(td1, DOT)
		 || is_type(td1, LIST) || is_type(td1, NON_STRUCT);
	case LABEL:
	  return td1 == LABEL;
	case LAB:
	  return is_type(td1, IND_LAB) || is_type(td1, SET_LAB)
	         || is_type(td1, CURL_IND) || is_type(td1, CURL_SET);
	case IND_LAB:
	  return is_type(td1, LABEL);
	case SET_LAB:
	  return is_type(td1, LABEL);
	case CURL_IND:
	  return is_type(td1, LABEL);
	case CURL_SET:
	  return is_type(td1, LABEL);
	case C_O_TERM:
	  return td1 == C_O_TERM;
	case VAR:
	  return td1 == VAR;
	case DOT:
	  return td1 == DOT;
	case SUB_LIST:
	  return td1 == SUB_LIST;
	case LIST:
	  return is_type(td1, OBJ_LIST) || is_type(SUB_LIST);
	case REMAIN:
	  return is_type(td1, LIST) || is_type(td1, VAR);
	case INTEGER:
	  return td1 == INTEGER;
	case NON_STRUCT:
	  return is_type(td1, EXP_NAME) || is_type(td1, STRING)
	         || is_type(td1, INTEGER);
	case ATTR:
	  return td1 == ATTR;
	case SET:
	  return td1 == SET;
	case SORT:
	  return td1 == SORT;
	case VALUE:
	  return is_type(td1, SET) || is_type(td1, SORT)
	         || is_type(td1, O_TERM);
	case QUERY_CNSTR:
	  return td1 == QUERY_CNSTR;
	case CNSTR:
	  return td1 == CNSTR || is_type(td1, QUERY_CNSTR);
	  /* temporary */
	case QUERY:
	  return td1 == QUERY;
	case P_MODE:
	  return td1 == P_MODE;
	case A_MODE:
	  return td1 == A_MODE;
	case I_MODE:
	  return td1 == I_MODE;
	case M_MODE:
	  return td1 == M_MODE;
	case E_MODE:
	  return td1 == E_MODE;
	case Q_MODE:
	  return is_type(td1, P_MODE) || is_type(td1, A_MODE)
	         || is_type(td1, I_MODE) || is_type(td1, M_MODE)
		 || is_type(td1, E_MODE);
	case ANSWER:
	  return td1 == ANSWER;
	case ANSWER_ELEMENT:
	  return td1 == ANSWER_ELEMENT;
	case ANSE_EXPLANATION: 
	  return td1 == ANSE_EXPLANATION;
	case RIR_PAIR: 
	  return td1 == RIR_PAIR;
	case DOT_CNSTR:
	  return td1 == DOT_CNSTR;
	case VAR_CNSTR:
	  return td1 == VAR_CNSTR;
	case INHERIT:
	  return td1 == INHERIT;
	case REDUCE:
	  return td1 == REDUCE;
	case SUB_GOAL:
	  return td1 == SUB_GOAL;
	case VC_PAIR:
	  return td1 == VC_PAIR;
	case ONE_RULE:
	  return is_type(td1, REDUCE) || is_type(td1, RULE_ID)
	         || is_type(td1, QUERY);
	case UNIT_EXPLANATION:
	  return is_type(td1, ONE_RULE) || is_type(td1, INHERIT);
	case MERGE_EXPLANATION:
	  return td1 == MERGE_EXPLANATION;
	case LOOKUP_EXPLANATION:
	  return td1 == LOOKUP_EXPLANATION;
	case EXPLANATION:
	  return is_type(td1, UNIT_EXPLANATION)
	         || is_type(td1, MERGE_EXPLANATION)
		 || is_type(td1, LOOKUP_EXPLANATION);
	case CONSTRAINT:
	  return td1 == CONSTRAINT;
	case CON:
	  return td1 == CON;
	case ASSUMP:
	  return td1 == ASSUMP;
	case QUERY_EXPLANATION: 
	  return td1 == QUERY_EXPLANATION;
	case PSEUDO_OBJECT:
	  return TRUE;
	  /* for speed */
	case OBJ_LIST:
	  return td1 == OBJ_LIST;
	case OBJ_ARRAY:
	  return td1 == OBJ_ARRAY;
	default:
	  illegal_type_descriptor("is_type", td2);
	  break;
      }
}

Local union_tag(type_name, fp)
     char* type_name;
     FILE* fp;
{

}

Public unparse_env_def(env_def, fp)
     EnvDef* env_def;
     FILE* fp;

{
    if(env_def == NULL)
	{
	qxt_output( "'&void'");
	}
    else
	{
	qxt_output( "{env_def,");

	if(env_def->name == NULL)
		qxt_output( "'&void'");
	else
		qxt_output( env_def->name);

	qxt_output( ",");

	if(env_def->author == NULL)
		qxt_output( "'&void'");
	else
		qxt_output( env_def->author);

	qxt_output( ",");

	if(env_def->date == NULL)
		qxt_output( "'&void'");
	else
		qxt_output( env_def->date);

	qxt_output( ",");

	if(env_def->def_libs == NULL)
		qxt_output( "[]");
	else
        	unparse_pseudo_object(env_def->def_libs, fp);

	qxt_output( "}");
	}
}

Local void unparse_lib_lab(lib_lab, fp)
     LibLab lib_lab;
     FILE* fp;
{
    switch (lib_lab) {
      case EXPLIB:
	qxt_output( "'&exp_lib'");
	break;
      case PGMLIB:
	qxt_output( "'&pgm_lib'");
	break;
      case SORTLIB:
	qxt_output( "'&sort_lib'");
	break;
      default:

	break;
    }
}

Public unparse_def_lib(def_lib, fp)
     DefLib* def_lib;
     FILE* fp;

{
    qxt_output( "{def_lib,");
    unparse_lib_lab(def_lib->lib_lab, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(def_lib->lib_names, fp);
    qxt_output( "}");
}

Public unparse_string(string, fp)
     String* string;
     FILE* fp;

{
    qxt_output( "{string,");
    qxt_output( string->str_data);
    qxt_output( "}");
}

Public unparse_exp_def(exp_def, fp)
     ExpDef* exp_def;
     FILE* fp;

{
    qxt_output( "{exp_def,");
    unparse_pseudo_objectx(exp_def->exps, fp);
    qxt_output( "}");
}

Public unparse_exp(exp, fp)
     Exp* exp;
     FILE* fp;

{
    qxt_output( "{exp,");
    unparse_pseudo_object(exp->exp_name, fp);
    qxt_output( ",");
    unparse_pseudo_object(exp->o_term, fp);
    qxt_output( "}");
}

Public unparse_obj_def(obj_def, fp)
     ObjDef* obj_def;
     FILE* fp;

{
    qxt_output( "{obj_def,");
    unparse_pseudo_objectx(obj_def->obj_subs, fp);
    qxt_output( "}");
}

Public unparse_obj_sub(obj_sub, fp)
     ObjSub* obj_sub;
     FILE* fp;

{
    qxt_output( "{obj_sub,");
    qxt_output( obj_sub->bobj1);
    qxt_output( ",");
    qxt_output( obj_sub->bobj2);
    qxt_output( "}");
}

Public unparse_mod_def(mod_def, fp)
     ModDef* mod_def;
     FILE* fp;

{
    qxt_output( "{mod_def,");
    unparse_pseudo_objectx(mod_def->m_subs, fp);
    qxt_output( "}");
}

Public unparse_m_sub(m_sub, fp)
     MSub* m_sub;
     FILE* fp;

{
    qxt_output( "{m_sub,");
    unparse_pseudo_object(m_sub->m_id, fp);
    qxt_output( ",");
    unparse_m_desc(m_sub->m_desc, fp);
    qxt_output( "}");
}

Public unparse_m_desc(m_desc, fp)
     MDesc* m_desc;
     FILE* fp;

{
     if(m_desc->tag == M2_DESC) 
          unparse_m2_desc(m_desc, fp);
     else
         {
	 qxt_output( "{m_id,");
	 unparse_pseudo_object(m_desc, fp);
         qxt_output( "}");
         }
}

Public unparse_m2_desc(m2_desc, fp)
     M2Desc* m2_desc;
     FILE* fp;

{
    qxt_output( "{m_desc,");

    unparse_m_desc(m2_desc->m_desc1, fp);
    qxt_output( ",");
    qxt_output( "'");
    putc(m2_desc->op, fp);
    qxt_output( "'");
    qxt_output( ",");
    unparse_m_desc(m2_desc->m_desc2, fp);
    qxt_output( "}");
}

Public unparse_link_def(link_def, fp)
     LinkDef* link_def;
     FILE* fp;

{
    qxt_output( "{link_def,");
    unparse_pseudo_object(link_def->links, fp);
    qxt_output( "}");
}

Public unparse_link(link, fp)
     Link* link;
     FILE* fp;

{
    qxt_output( "{link,");
    qxt_output( link->link_name);
    qxt_output( ",");
    unparse_pseudo_objectx(link->m_ids, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(link->o_terms, fp);
    qxt_output( "}");
}

Public unparse_m_id_pair(m_id_pair, fp)
     MIdPair* m_id_pair;
     FILE* fp;

{
    qxt_output( "{");
    unparse_pseudo_object(m_id_pair->m_id1, fp);
    qxt_output( ",");
    unparse_pseudo_object(m_id_pair->m_id2, fp);
    qxt_output( "}");
}

Public unparse_o_term_pair(o_term_pair, fp)
     OTermPair* o_term_pair;
     FILE* fp;

{
    qxt_output( "{");
    unparse_pseudo_object(o_term_pair->o_term1, fp);
    qxt_output( ",");
    unparse_pseudo_object(o_term_pair->o_term2, fp);
    qxt_output( "}");
}

Public unparse_rule_def(rule_def, fp)
     RuleDef* rule_def;
     FILE* fp;

{
    qxt_output( "{rule_def,");
    unparse_pseudo_objectx(rule_def->rules, fp);
    qxt_output( "}");
}

Local void unparse_rule_class(rule_class, fp)
     RuleClass rule_class;
     FILE* fp;
{
    switch (rule_class) {
      case NULL:
	qxt_output( "'&void'");
	break;
      case RCNOUPDATE:
	qxt_output( "'&noupdate'");
	break;
      case RCUPDATE:
	qxt_output( "'&update'");
	break;
      default:

	break;
    }
}

Local void unparse_inheritance_mode(inheritance_mode, fp)
     InheritanceMode inheritance_mode;
     FILE* fp;
{
    switch (inheritance_mode) {
      case NULL:
	qxt_output( "'&void'");
	break;
      case IML:
	qxt_output( "'&l'");
	break;
      case IMO:
	qxt_output( "'&o'");
	break;
      case IMLO:
	qxt_output( "'&lo'");
	break;
      case IMOL:
	qxt_output( "'&ol'");
	break;
      default:

	break;
    }
}

Local void unparse_no_assume(no_assume, fp)
     NoAssume no_assume;
     FILE* fp;
{
    switch (no_assume) {
      case NULL:
	qxt_output( "'&void'");
	break;
      case NOASSUME:
	qxt_output( "'&no_assume'");
	break;
      default:

	break;
    }
}

Public unparse_rule(rule, fp)
     Rule* rule;
     FILE* fp;

{
    qxt_output( "{rule,");
    unparse_rule_class(rule->rule_class, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(rule->m_ids, fp);
    qxt_output( ",");
    unparse_pseudo_object(rule->rule_id, fp);
    qxt_output( ",");
    unparse_inheritance_mode(rule->inheritance_mode, fp);
    qxt_output( ",");
    unparse_no_assume(rule->no_assume, fp);
    qxt_output( ",");
    unparse_pseudo_object(rule->a_term, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(rule->clusters, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(rule->cnstrs, fp);
    qxt_output( "}");
}

Public unparse_rule_id(rule_id, fp)
     RuleId* rule_id;
     FILE* fp;

{
    if(rule_id->rule_id_string == NULL)
	qxt_output( "'&void'");
    else
	qxt_output( rule_id->rule_id_string);
}

Public unparse_normal(normal, fp)
     Normal *normal;
     FILE* fp;

{
    qxt_output( "{normal,");
    qxt_output( "{");
    unparse_pseudo_object(normal->m_id, fp);
    qxt_output( ",");
    unparse_pseudo_object(normal->a_term, fp);
    qxt_output( "}");
    qxt_output( "}");
}

Local void unparse_sub_rel(sub_rel, fp)
     CnRel sub_rel;
     FILE* fp;
{
    switch (sub_rel) {
      case NULL:
	qxt_output( "'&void'");
	break;
      case CNLE:
	qxt_output( "'=<'");
	break;
      case CNGE:
	qxt_output( "'>='");
	break;
      case CNEQ:
	qxt_output( "'=='");
	break;
      case CNPL:
	qxt_output( "'+<'");
	break;
      case CNPG:
	qxt_output( "'>+'");
	break;
      case CNEPE:
	qxt_output( "'=+='");
	break;
      case CNIN:
	qxt_output( "'&in'");
	break;
      case CNNI:
	qxt_output( "'&ni'");
	break;
      default:

	break;
    }
}

Public unparse_rel(rel, fp)
     Rel* rel;
     FILE* fp;

{
    qxt_output( "{rel,");
    qxt_output( "{");
    unparse_pseudo_object(rel->o_term1, fp);
    qxt_output( ",");
    unparse_sub_rel(rel->sub_rel, fp);
    qxt_output( ",");
    unparse_pseudo_object(rel->o_term2, fp);
    qxt_output( "}");
    qxt_output( "}");
}

Public unparse_update(update, fp)
     Update* update;
     FILE* fp;

{
    qxt_output( "{update,");
    qxt_output( "{");
    if(update->u_flag == UFPLUS)
	qxt_output( "'+'");
    else if(update->u_flag == UFMINUS)
	qxt_output( "'-'");
    else
	qxt_output( "'&void'");
    qxt_output( ",");
    unparse_pseudo_object(update->m_id, fp);
    qxt_output( ",");
    unparse_pseudo_object(update->a_term, fp);
    qxt_output( "}");
    qxt_output( "}");
}

Local void unparse_transaction_controller(trn_data, fp)
     TrnData trn_data;
     FILE* fp;
{
    switch (trn_data) {
      case NULL:
	qxt_output( "'&void'");
	break;
      case TDBT:
	qxt_output( "'&bt'");
	break;
      case TDET:
	qxt_output( "'&et'");
	break;
      case TDAT:
	qxt_output( "'&at'");
	break;
      defaut:

	break;
    }
}

Public unparse_transaction(transaction, fp)
     Transaction* transaction;
     FILE* fp;

{
    qxt_output( "{transaction,");
    unparse_transaction_controller(transaction->trn_data, fp);
    qxt_output( "}");
}

Public unparse_prop(prop, fp)
     Prop* prop;
     FILE* fp;

{
    qxt_output( "{prop,");
    qxt_output( "{");
    unparse_pseudo_object(prop->m_id, fp);
    qxt_output( ",");
    unparse_pseudo_object(prop->a_term, fp);
    qxt_output( "}");
    qxt_output( "}");
}

Public unparse_i_check(i_check , fp)
     ICheck* i_check;
     FILE* fp;

{
      unparse_pseudo_object(i_check, fp);
}

Public unparse_cluster(cluster, fp)
     Cluster* cluster;
     FILE* fp;

{
      unparse_pseudo_object(cluster, fp);
}

Public unparse_a_term(a_term, fp)
     ATerm* a_term;
     FILE* fp;

{
    qxt_output( "{a_term,");
    unparse_pseudo_object(a_term->o_term, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(a_term->attrs, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(a_term->cnstrs, fp);
    qxt_output( "}");
}

Public unparse_o_term(o_term, fp)
     OTerm* o_term;
     FILE* fp;

{
      unparse_pseudo_object(o_term, fp);
}

Public unparse_c_o_term(c_o_term, fp)
     COTerm* c_o_term;
     FILE* fp;

{
    qxt_output( "{c_o_term,");
    qxt_output( c_o_term->head);
    qxt_output( ",");
    unparse_pseudo_objectx(c_o_term->attrs, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(c_o_term->cnstrs, fp);
    qxt_output( "}");
}

Public unparse_dot(dot, fp)
     Dot* dot;
     FILE* fp;

{
    qxt_output( "{dot,");
    unparse_pseudo_object(dot->o_term, fp);
    qxt_output( ",");
    unparse_pseudo_object(dot->label, fp);
    qxt_output( "}");
}

Public unparse_lab(lab, fp)
     Label* lab;
     FILE* fp;

{
    qxt_output( "{ind,");
    unparse_pseudo_object(lab->o_term, fp);
    qxt_output( "}");
}

Public unparse_label(label, fp)
     Label* label;
     FILE* fp;

{
    unparse_lab(label, fp);
}

Public unparse_ind_lab(lab, fp)
     IndLab* lab;
     FILE* fp;

{
    qxt_output( "{ind,");
    unparse_pseudo_object(lab->o_term, fp);
    qxt_output( "}");
}

Public unparse_set_lab(lab, fp)
     SetLab* lab;
     FILE* fp;

{
    qxt_output( "{set,");
    unparse_pseudo_object(lab->o_term, fp);
    qxt_output( "}");
}

Public unparse_curl_ind(lab, fp)
     CurlInd* lab;
     FILE* fp;

{
    qxt_output( "{curl_ind,");
    unparse_pseudo_object(lab->o_term, fp);
    qxt_output( "}");
}

Public unparse_curl_set(lab, fp)
     CurlSet* lab;
     FILE* fp;

{
    qxt_output( "{curl_set,");
    unparse_pseudo_object(lab->o_term, fp);
    qxt_output( "}");
}

Public unparse_list(list, fp)
     List* list;
     FILE* fp;

{
      unparse_pseudo_object(list, fp);
}

Public unparse_sub_list(sub_list, fp)
     SubList* sub_list;
     FILE* fp;

{
    qxt_output( "{sublist,");
    unparse_pseudo_objectx(sub_list->o_terms, fp);
    qxt_output( ",");
    unparse_pseudo_object(sub_list->remain, fp);
    qxt_output( "}");
}

Public unparse_remain(remain, fp)
     Remain* remain;
     FILE* fp;

{
      unparse_pseudo_object(remain, fp);
}

Public unparse_non_struct(non_struct, fp)
     NonStruct* non_struct;
     FILE* fp;

{
      unparse_pseudo_object(non_struct, fp);
}

Public unparse_exp_name(exp_name, fp)
     ExpName* exp_name;
     FILE* fp;

{
    qxt_output( "{exp_name,");
    qxt_output( exp_name->name);
    qxt_output( "}");
}

Public unparse_integer(integer, fp)
     Integer* integer;
     FILE* fp;

{
    char buf[256];

    qxt_output("{integer,");
    sprintf(buf,"%d",integer->value);
    qxt_output(buf);
    qxt_output("}");
}

Local void unparse_attr_op(attr_op, fp)
     AttrOp attr_op;
     FILE* fp;
{
    switch (attr_op) {
      case ATRARROW:
	qxt_output( "'->'");
	break;
      case ATLARROW:
	qxt_output( "'<-'");
	break;
      case ATEQ:
	qxt_output( "'='");
	break;
      case CNPL:
	qxt_output( "'*<'");
	break;
      case CNPG:
	qxt_output( "'>*'");
	break;
      case CNEPE:
	qxt_output( "'=*='");
	break;
      default:

	break;
    }
}

Public unparse_attr(attr, fp)
     Attr* attr;
     FILE* fp;

{
    qxt_output( "{attr,");
    unparse_pseudo_object(attr->label, fp);
    qxt_output( ",");
    unparse_attr_op(attr->attr_op, fp);
    qxt_output( ",");
    unparse_pseudo_object(attr->value, fp);
    qxt_output( "}");
}

Public unparse_value(value, fp)
     Value* value;
     FILE* fp;

{
      unparse_pseudo_object(value, fp);
}

Public unparse_set(set, fp)
     Set* set;
     FILE* fp;

{
    qxt_output( "{set,");
    unparse_pseudo_objectx(set->o_terms, fp);
    qxt_output( "}");
}

Public unparse_cnstr(cnstr, fp)
     Cnstr* cnstr;
     FILE* fp;

{
      unparse_pseudo_object(cnstr, fp);
}

Local void unparse_rel_op(rel, fp)
     CnRel rel;
     FILE* fp;
{
    switch (rel) {
      case CNLE:
	qxt_output( "'=<'");
	break;
      case CNGE:
	qxt_output( "'>='");
	break;
      case CNEQ:
	qxt_output( "'=='");
	break;
      case CNPL:
	qxt_output( "'+<'");
	break;
      case CNPG:
	qxt_output( "'>+'");
	break;
      case CNEPE:
	qxt_output( "'=+='");
	break;
      case CNIN:
	qxt_output( "'&in'");
	break;
      case CNNI:
	qxt_output( "'&ni'");
	break;
      default:

	break;
    }
}

Public unparse_cnstr_data(cnstr_data, fp)
     CnstrData* cnstr_data;
     FILE* fp;

{
    qxt_output( "{cnstr,");
    unparse_pseudo_object(cnstr_data->m_id1, fp);
    qxt_output( ",");
    unparse_pseudo_object(cnstr_data->value1, fp);
    qxt_output( ",");
    unparse_rel_op(cnstr_data->rel, fp);
    qxt_output( ",");
    unparse_pseudo_object(cnstr_data->m_id2, fp);
    qxt_output( ",");
    unparse_pseudo_object(cnstr_data->value2, fp);
    qxt_output( "}");
}

Public unparse_query_cnstr(query_cnstr, fp)
     QueryCnstr* query_cnstr;
     FILE* fp;

{
    qxt_output( "{query_cnstr,");
    unparse_pseudo_object(query_cnstr->m_id1, fp);
    qxt_output( ",");
    unparse_pseudo_object(query_cnstr->m_id2, fp);
    qxt_output( "}");
}

Local void unparse_var_type(type, fp)
     VarType type;
     FILE* fp;
{
    switch (type) {
      case VARIND:
	qxt_output( "ind");
	break;
      case VARSET:
	qxt_output( "set");
	break;
      default:

	break;
    }
}

Public unparse_var(var, fp)
     Var* var;
     FILE* fp;

{
    qxt_output( "{var,");
    unparse_var_type(var->type, fp);
    qxt_output( ",");
    qxt_output( "\"");
    qxt_output( var->var_data);
    qxt_output( "\"");
    qxt_output( "}");
}

Public unparse_sort(sort, fp)
     Sort* sort;
     FILE* fp;

{
    qxt_output( "{sort,");
    unparse_pseudo_object(sort->prolog, fp);
    qxt_output( "}");
}

Public unparse_query(query, fp)
     Query* query;
     FILE* fp;

{
    qxt_output( "{query,");
    unparse_rule_class(query->query_class, fp);
    qxt_output( ",");
    unparse_rule_class(query->q_head, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(query->clusters, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(query->cnstrs, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(query->q_modes, fp);
    qxt_output( ",");
    unparse_pseudo_object(query->program, fp);
    qxt_output( "}");
}

Public unparse_q_mode(q_mode, fp)
     QMode* q_mode;
     FILE* fp;

{
      unparse_pseudo_object(q_mode, fp);
}

Local unparse_p_mode_data(p_mode_data, fp)
     PModeData p_mode_data;
     FILE* fp;
{
    switch (p_mode_data) {
      case PSINGLE:
	qxt_output( "'&single'");
	break;
      case PMULTI:
	qxt_output( "'&multi'");
	break;
      default:

	break;
    }
}

Public unparse_p_mode(p_mode, fp)
     PMode* p_mode;
     FILE* fp;

{
    qxt_output( "{proc,");
    unparse_p_mode_data(p_mode->p_mode_data, fp);
    qxt_output( "}");
}

Local void unparse_a_mode_data(a_mode_data, fp)
     AModeData a_mode_data;
     FILE* fp;
{
    switch (a_mode_data) {
      case ANORMAL:
	qxt_output( "'&normal'");
	break;
      case AMINIMAL:
	qxt_output( "'&minimal'");
	break;
      default:

	break;
    }
}

Public unparse_a_mode(a_mode, fp)
     AMode* a_mode;
     FILE* fp;

{
    qxt_output( "{ans,");
    unparse_a_mode_data(a_mode->a_mode_data, fp);
    qxt_output( "}");
}

Local void unparse_i_mode_data(i_mode_data, fp)
     IModeData i_mode_data;
     FILE* fp;
{
    switch (i_mode_data) {
      case IALL:
	qxt_output( "'&all'");
	break;
      case IDOWN:
	qxt_output( "'&down'");
	break;
      case IUP:
	qxt_output( "'&up'");
	break;
      case INO:
	qxt_output( "'&no'");
	break;
      default:

	break;
    }
}

Public unparse_i_mode(i_mode, fp)
     IMode *i_mode;
     FILE* fp;

{
    qxt_output( "{inheritance,");
    unparse_i_mode_data(i_mode->i_mode_data, fp);
    qxt_output( "}");
}

Local void unparse_m_mode_data(m_mode_data, fp)
     MModeData m_mode_data;
     FILE* fp;
{
    switch (m_mode_data) {
      case MYES:
	qxt_output( "'&yes'");
	break;
      case MNO:
	qxt_output( "'&no'");
	break;
      default:

	break;
    }
}

Public unparse_m_mode(m_mode, fp)
     MMode* m_mode;
     FILE* fp;

{
    qxt_output( "{merge,");
    unparse_m_mode_data(m_mode->m_mode_data, fp);
    qxt_output( "}");
}

Local void unparse_e_mode_data(e_mode_data, fp)
     EModeData e_mode_data;
     FILE* fp;
{
    switch (e_mode_data) {
      case EON:
	qxt_output( "'&on'");
	break;
      case EOFF:
	qxt_output( "'&off'");
	break;
      default:

	break;
    }
}

Public unparse_e_mode(e_mode, fp)
     EMode* e_mode;
     FILE* fp;

{
    qxt_output( "{explanation,");
    unparse_e_mode_data(e_mode->e_mode_data, fp);
    qxt_output( "}");
}

Public unparse_answer(answer, fp)
     Answer* answer;
     FILE* fp;

{
    qxt_output( "{answer,");
    unparse_pseudo_objectx(answer->answer_elements, fp);
    qxt_output( "}");
}

Public unparse_answer_element(answer_element, fp)
     AnswerElement* answer_element;
     FILE* fp;

{
    qxt_output( "{answer_element,");
    unparse_pseudo_objectx(answer_element->dot_cnstrs, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(answer_element->var_cnstrs, fp);
    qxt_output( ",");
    unparse_pseudo_object(answer_element->anse_explanation, fp);
    qxt_output( "}");
}

Public unparse_anse_explanation(anse_explanation, fp)
     AnseExplanation* anse_explanation;
     FILE* fp;

{
    qxt_output( "{");
    unparse_pseudo_object(anse_explanation->explanation, fp);
    qxt_output( ",");
    unparse_pseudo_object(anse_explanation->rir_pairs, fp);
    qxt_output( "}");
}

Public unparse_rir_pair(rir_pair, fp)
     RirPair* rir_pair;
     FILE* fp;

{
    qxt_output( "{");
    unparse_pseudo_object(rir_pair->rule_id, fp);
    qxt_output( ",");
    unparse_pseudo_object(rir_pair->rule, fp);
    qxt_output( "}");
}

Public unparse_dot_cnstr(dot_cnstr, fp)
     DotCnstr* dot_cnstr;
     FILE* fp;

{
    qxt_output( "{dot_cnstr,");
    unparse_pseudo_object(dot_cnstr->m_id, fp);
    qxt_output( ",");
    unparse_pseudo_object(dot_cnstr->dot, fp);
    qxt_output( ",");
    unparse_pseudo_object(dot_cnstr->rel, fp);
    qxt_output( ",");
    unparse_pseudo_object(dot_cnstr->value, fp);
    qxt_output( "}");
}

Public unparse_var_cnstr(var_cnstr, fp)
     VarCnstr* var_cnstr;
     FILE* fp;

{
    qxt_output( "{var_cnstr,");
    unparse_pseudo_object(var_cnstr->var, fp);
    qxt_output( ",");
    unparse_pseudo_object(var_cnstr->rel, fp);
    qxt_output( ",");
    unparse_pseudo_object(var_cnstr->value, fp);
    qxt_output( "}");
}

Public unparse_explanation(explanation, fp)
     Explanation* explanation;
     FILE* fp;

{
      unparse_pseudo_object(explanation, fp);
}

Public unparse_unit_explanation(unit_explanation, fp)
     UnitExplanation* unit_explanation;
     FILE* fp;

{
    qxt_output( "{unit,");
    unparse_pseudo_object(unit_explanation, fp);
    qxt_output( "}");
}

Public unparse_inherit(inherit, fp)
     Inherit* inherit;
     FILE* fp;

{
    qxt_output( "{inheritance,");
    qxt_output( "{");
    unparse_pseudo_object(inherit->one_rule, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(inherit->ups, fp);
    qxt_output( ",");
    unparse_pseudo_objectx(inherit->downs, fp);
    qxt_output( "}");
    qxt_output( "}");
}

Public unparse_merge_explanation(merge_explanation, fp)
     MergeExplanation* merge_explanation;
     FILE* fp;

{
    qxt_output( "{merge,");
    unparse_pseudo_object(merge_explanation->unit_explanations, fp);
    qxt_output( "}");
}

Public unparse_lookup_explanation(lookup_explanation, fp)
     LookupExplanation* lookup_explanation;
     FILE* fp;

{

    unparse_pseudo_object(lookup_explanation->sub_goal, fp);

    unparse_pseudo_object(lookup_explanation->looked_s, fp);

    unparse_pseudo_object(lookup_explanation->looking_s, fp);

    unparse_pseudo_object(lookup_explanation->explanation, fp);
}

Public unparse_one_rule(one_rule, fp)
     OneRule* one_rule;
     FILE* fp;

{

    unparse_pseudo_object(one_rule->reduce, fp);
    qxt_output(",");
    unparse_pseudo_object(one_rule->rule_id, fp);
    qxt_output(",");
    unparse_pseudo_object(one_rule->query, fp);
}

Public unparse_reduce(reduce, fp)
     Reduce* reduce;
     FILE* fp;

{

    unparse_pseudo_object(reduce->sub_goal, fp);
    qxt_output(",");
    unparse_pseudo_object(reduce->rule_id, fp);
    qxt_output(",");
    unparse_pseudo_objectx(reduce->explanations, fp);
    qxt_output(",");
    unparse_pseudo_object(reduce->assumps, fp);
}

Public unparse_sub_goal(subgoal, fp)
     SubGoal* subgoal;
     FILE* fp;

{

    unparse_pseudo_object(subgoal->m_id, fp);
    qxt_output(",");
    unparse_pseudo_object(subgoal->o_term, fp);
    qxt_output(",");
    unparse_pseudo_objectx(subgoal->vc_pairs, fp);
}

Public unparse_vc_pair(vc_pair, fp)
     VcPair* vc_pair;
     FILE* fp;

{

    unparse_pseudo_object(vc_pair->var, fp);
    qxt_output(",");
    unparse_pseudo_object(vc_pair->constraint, fp);
}

Public unparse_constraint(constraint, fp)
     Constraint* constraint;
     FILE* fp;

{

    unparse_pseudo_object(constraint->const_data, fp);
}

Public unparse_con(con, fp)
     Con* con;
     FILE* fp;

{

    unparse_pseudo_objectx(con->o_terms1, fp);
    qxt_output(",");
    unparse_pseudo_objectx(con->o_terms2, fp);
}

Public unparse_assump(assump, fp)
     Assump* assump;
     FILE* fp;

{

    unparse_pseudo_object(assump->m_id, fp);
    qxt_output(",");
    unparse_pseudo_object(assump->dot, fp);
    qxt_output(",");
    unparse_pseudo_objectx(assump->vc_pairs, fp);
}

Public unparse_query_explanation(query_explanation, fp)
     QueryExplanation* query_explanation;
     FILE* fp;

{

    qxt_output( query_explanation->str_data);
}

Public unparse_obj_list(obj_list, fp)
     ObjList* obj_list;
     FILE* fp;

{
    ObjElement* p;

    if (obj_list == NULL) {
	return;
    }
    p = obj_list->first;
    qxt_output( "[");
    if (p != NULL) {
	unparse_pseudo_object(p->element, fp);
	p = p->next;
    }
    while (p != NULL) {
	qxt_output( ",");
	unparse_pseudo_object(p->element, fp);
	p = p->next;
    }
    qxt_output( "]");
}

Public unparse_obj_array(obj_array, fp)
     ObjArray* obj_array;
     FILE* fp;

{
    int i;
    char *string;

    unparse_pseudo_object(obj_array->element_tag, fp);

    unparse_pseudo_object(obj_array->size, fp);
/*    string = dotsrc_malloc(strlen("elements") + 2 +
			   (int)log10(obj_array->size) + 1 + 1); */
    for (i = 0; i < obj_array->size; ++i) {
	unparse_pseudo_object(obj_array->elements[i], fp);
    }
}

/*
  type_error:
  output type error message to stderr and exit with code 2.
*/

static void type_error(object, type_name, func_name)
     PseudoObject* object;
     char *type_name, *func_name;
{
    fprintf(stderr, "type error\n");

    exit(2);
}

static void type_conflict(td1, td2, func_name)
     TypeDescriptor td1, td2;
     char *func_name;
{
    fprintf(stderr, "type confliction\n");
    exit(2);
}

/*
  write_through_NULL:
  output error message to stderr and exit with code 2.
*/

static void write_through_NULL(func_name)
     char* func_name;
{
    exit(2);
}

/*
  illegal_type_descriptor:
  output error message to stderr and exit with code 2.
*/
static void illegal_type_descriptor(func_name, td)
     char* func_name;
     TypeDescriptor td;
{
    fprintf(stderr, "illegal type descriptor\n");
    exit(2);
}

/*
  array_type_check:
  checks all elements of a pseudo object array are of given type
*/

static array_type_check(td, n, obj_array)
     TypeDescriptor td;
     int n;
     PseudoObject** obj_array;
{
    int i;

    for (i = 0; i < n; ++i) {
	if (! is_type(obj_array[i]->tag, td))
	  type_error(obj_array[i], type_name(td), "array_type_check");
    }
}

Local int cmp_keys(key1, key2)
     char *key1, *key2;
{
    return strcmp(key1, key2) == 0;
}

static freed_unused(ptr)
     char *ptr;
{
    printf("freed unused area at %x\n", (int)ptr);
}

Local void unparse_log(log)
     AllocLog *log;
{
    if (log->tag == Malloc)
      printf("at %x, size %d\n", (int)((MallocLog*)log)->ptr,
	     ((MallocLog*)log)->size);
    else
      printf("at %x, size %d x %d\n", (int)((CallocLog*)log)->ptr,
	     ((CallocLog*)log)->nelem, ((CallocLog*)log)->elsize);
}

Local void duplicate_allocation(dup, log)
     AllocLog *dup, *log;
{
    printf("duplicate allocation\n");
    printf("Old: ");
    unparse_log(dup);
    printf("New: ");
    unparse_log(log);
}
