%{
int (*inputfunc) ();
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
    { \
	result = inputfunc (buf,max_size); \
    }

int yylineno = 1;

#ifdef DEBUG
#define token(tk) printf("%-12s is \"%s\" (lval=%d)\n","tk",yytext,yylval)
#else
#define token(tk) return(tk)
#endif
%}
kanji		[\241-\376][\241-\376]
upper-char	[A-Z]
number		[0-9]
lower-char	[a-z]
char		({lower-char}|{number}|{upper-char}|_)
/* lower-char	([_a-z0-9&] | {kanji}) */
/* char		{upper-char} | {lower-char} */
/* print-char	{char} | [- !#$%'()*+,./:;<=>?@`\[\\\]^{|}~] */
/* print-char	[A-Z] | [_a-z0-9&] | [- !#$%'()*+,./:;<=>?@`\[\\\]^\{\|\}~] */
%%
"?-"		{
		token(Qry);
		}
"&q_mode"	{
		token(Qmd);
		}
"&program"      {
		token(Pgm);
		}
"&pgm"          {
		token(Pgm);
		}
"&database"     {
		token(Pgm);
		}
"&db"           {
		token(Env);
		}
"&env"          {
		token(Env);
		}
"&environment"  {
		token(Env);
		}
"&expression"   {
		token(Exp);
		}
"&exp"          {
		token(Exp);
		}
"&object"       {
		token(Obj);
		}
"&obj"          {
		token(Obj);
		}
"&subsumption"  {
		token(Obj);
		}
"&subsum"       {
		token(Obj);
		}
"&module"       {
		token(Mod);
		}
"&mod"          {
		token(Mod);
		}
"&submodule"    {
		token(Mod);
		}
"&submod"       {
		token(Mod);
		}
"&link"         {
		token(Link);
		}
"&rule"         {
		token(Rule);
		}
"&end"		{
		token(End);
		}
e_{char}+	{
		yylval.name = pool(yytext);
		token(ExpName);
		}
s_{char}+	{
		yylval.name = pool(yytext);
		token(SortName);
		}
{number}+	{
		yylval.name = pool(yytext);
		token(Integer);
		}
{upper-char}{char}*"*"	{
			yylval.name = pool(yytext);
			/* printf("SetVariable:%s\n",yylval.name); */
			token(SetVariable);
			}
{upper-char}{char}*	{
			yylval.name = pool(yytext);
			/* printf("Variable:%s\n",yylval.name); */
			token(Variable);
			}
_{char}+"*"	{
		yylval.name = pool(yytext);
		/* printf("SetVariable:%s\n",yylval.name); */
		token(SetVariable);
		}
_{char}+	{
		yylval.name = pool(yytext);
		/* printf("Variable:%s\n",yylval.name); */
		token(Variable);
		}
{lower-char}{char}*"*"	{
			yylval.name = pool(yytext);
			/* printf("SetAtom:%s\n",yylval.name); */
			token(SetAtom);
			}
{lower-char}{char}*	{
			yylval.name = pool(yytext);
			/* printf("Atom:%s\n",yylval.name); */
			token(Atom);
			}
\"[^\"\n]*\"            {
			yylval.name = pool(yytext);
			/* printf("String:%s\n",yylval.name); */
			token(String);
			}
";;"		{  
		token(DoubleSemicolon);
		}
"::"		{
		token(DoubleColon);
		}
"{{"		{
		token(DoubleLeftBrace);
		}
"}}"		{
		token(DoubleRightBrace);
		}
"<="		{
		token(LargeLeftArrow);
		}
"||"		{
		token(Parallel);
		}
"=<"		{
		token(SetSubsumed);
		}
">="		{
		token(SetSubsumes);
		}
"=="		{
		token(SetCong);
		}
"*<"		{
		token(SetSubsumedop);
		}
">*"		{
		token(SetSubsumesop);
		}
"=*="		{
		token(SetCongop);
		}
">-"		{
		token(Subsumes);
		}
"-<"		{
		token(Subsumed);
		}
"->"		{
		token(RightArrow);
		}
"<-"		{
		token(LeftArrow);
		}
"[]"		{
		token(Nil);
		}
"."		{
		token(Period);
		}
"["		{
		token(SqBrL);
		}
"]"		{
		token(SqBrR);
		}
"="		{
		token(Equal);
		}
","		{
		token(Comma);
		}
"{"		{
		token(BrL);
		}
"}"		{
		token(BrR);
		}
"("		{
		token(RnBrL);
		}
")"		{
		token(RnBrR);
		}
"+"		{
		token(Plus);
		}
"-"		{
		token(Minus);
		}
":"		{
		token(Cln);
		}
";"		{
		token(SCln);
		}
"/"		{
		token(Slash);
		}
"|"		{
		token(VtLn);
		}
"!"		{
		token(Excl);
		}
"@"		{
		token(At);
		}
"&proc_mode"    {
		token(Procmode);
		}
"&ans_mode"     {
		token(Ansmode);
		}
"&inheritance"  {
		token(Inheritance);
		}
"&merge"        {
		token(Merge);
		}
"&explanation"  {
		token(Explanation);
		}
"&single"	{
		token(Single);
		}
"&multi"	{
		token(Multi);
		}
"&normal"	{
		token(Normal);
		}
"&minimal"	{
		token(Minimal);
		}
"&yes"		{
		token(Yes);
		}
"&no"		{
		token(No);
		}
"&on"		{
		token(On);
		}
"&off"		{
		token(Off);
		}
"&all"		{
		token(All);
		}
"&down"		{
		token(Down);
		}
"&up"		{
		token(Up);
		}
"&name"         {
		token(Name);
		}
"&pgm-name"     {  
		token(Pgmname);
		}
"&pgm_name"     {  
		token(Pgmname);
		}
"&author"       { 
		token(Author);
		}
"&aut-name"     {  
		token(Autname);
		}
"&aut_name"     {  
		token(Autname);
		}
"&date"         {  
		token(Date);
		}
"&include"      {  
		token(Include);
		}
"&exp_lib"      {  
		token(Explib);
		}
"&pgm_lib"      {  
		token(Pgmlib);
		}
"&sort_lib"     {  
		token(Sortlib);
		}
"&no_assume"	{  
		token(NoAssume);
		}
"&consis"	{  
		token(Consis);
		}
"&inconsis"	{  
		token(InConsis);
		}
"&self"		{  
		token(Self);
		}
"&del"		{  
		token(Del);
		}
"&add"		{  
		token(Add);
		}
"&abs"		{  
		token(Abs);
		}
"&car"		{  
		token(Car);
		}
"&cdr"		{  
		token(Cdr);
		}
"&in"           {  
		token(In);
		}
"&ni"           {  
		token(Ni);
		}
"&ol"           {  
		token(LocalAndOverwrite);
		}
"&lo"           {  
		token(LocalAndOverwrite);
		}
"&l"            {  
		token(Localx);
		}
"&o"            {  
		token(OverWrite);
		}
"&bt"           {  
		token(BT);
		}
"&et"           {  
		token(ET);
		}
"&at"           {  
		token(AT);
		}
\%.*\n		{
		yylineno++;
		}
\n              {
		yylineno++;
		}
[ \t]           ;
.                 {
		  /* yylval.name = yytext; */
		  token(yytext[0]);
		  }
%%
xxfatal (msg)
    char *msg;
{
    fprintf (stderr, "%s\n", msg);
    exit (1);
}

char *input_string;
int input_string_length;

input_from_string (buf, max_size)
	char *buf;
	int max_size;
{
  int result;

  if (input_string_length <= 0)
      return 0;

  if (input_string_length <= max_size)
    {
       result = input_string_length;
       memcpy (buf, input_string, input_string_length);
       input_string += input_string_length;
       input_string_length = 0;

       return result;
    }
  else
    {
       result = max_size;
       memcpy (buf, input_string, max_size);
       input_string += max_size;
       input_string_length -= max_size;
       
       return result;
    }
}

init_input_from_string (string)
	char *string;
{
    input_string = string;
    input_string_length = strlen (string);
    inputfunc = input_from_string;
}

input_from_yyin (buf, max_size)
	char *buf;
	int max_size;
{
    int result;

    if ((result = read (fileno(yyin), (char *) buf, max_size)) < 0)
	xxfatal ("read() in flex scanner failed");

    return result;
}

init_input_from_yyin ()
{
    inputfunc = input_from_yyin;
}
