#ifdef sequent
#include <strings.h>
#else
#include <string.h>
#endif

#include <math.h>

#include "dotsrc.h"

static int ccnt;	/* for print position */
static int cmem[128];	/* for */
static int cmemi;

static char *rule_separator;
static int imod;	/* mode number for pretty-print */
static int icnt;	/* for indentation depth */

static p_str(fp,str)
FILE *fp;
char str[];
	{
	int i,w;
	char c,wc;

	if(ccnt == 0) wc = 0;

	for(i = 0; c = str[i]; i++)
		{
		switch(c)
			{
			case '\n':
				ccnt = 0;
				putc(c,fp);
				wc = 0;
				break;
			case '\t':
				w = 8-(ccnt%8);
				ccnt += w;
				putb(w,fp);
				wc = 0;
				break;
			case '[':
			case '{':
				ccnt++;
				push();
				putc(c,fp);
				wc = 0;
				break;
			case '=':
				ccnt++;
				if(wc == '<') push();
				putc(c,fp);
				wc = 0;
				break;
			case ']':
			case '}':
				ccnt++;
				pop();
				putc(c,fp);
				wc = 0;
				break;
			case '<':
				ccnt++;
				putc(c,fp);
				wc = '<';
				break;
			case ';':
				ccnt++;
				putc(c,fp);
				if(wc == ';')
					{
					pop();
					wc = 0;
					}
				else
					wc = ';';
				break;
			default:
				ccnt++;
				putc(c,fp);
				wc = 0;
				break;
			}

		
		}
	}

push()
	{
	cmem[cmemi++] = ccnt;
	}

pop()
	{
	cmemi--;
	}

putb(n,fp)
int n;
FILE *fp;
	{
	int i;

	for(i = 0; i < n; i++)
		{
		putc(' ',fp);
		}
	}

put_blank(fp)
FILE *fp;
	{
	int i;

	ccnt = cmem[cmemi-1];
	for(i = 0; i < ccnt; i++)
		{
		putc(' ',fp);
		}
	}

static p_int(fp,x)
FILE *fp;
int x;
	{
	char str[16];

	sprintf(str,"%d",x);
	p_str(fp,str);
	}

pprint(object,fp,n)
PseudoObject *object;
FILE *fp;
int n;
	{
	ccnt = 0;
	imod = n;
	cmem[0] = 0;
	cmemi = 1;

	if(object->tag == PROGRAM)
		pprint_program(object,fp);
	else if(object->tag == ANSWER)
		pprint_answer(object,fp);
	else if(object->tag == QUERY)
		pprint_query(object,fp);
	else
		pprint_pseudo_object(object,fp);
	}

Public pprint_program(program, fp)
     Program* program;
     FILE* fp;

{
    p_str(fp, "&program;;\n");
        pprint_pseudo_object(program->env_def, fp);
        pprint_pseudo_object(program->exp_def, fp);
        pprint_pseudo_object(program->obj_def, fp);
        pprint_pseudo_object(program->mod_def, fp);
        pprint_pseudo_object(program->link_def, fp);
        pprint_pseudo_object(program->rule_def, fp);
    p_str(fp, "&end.\n");
}

/*

*/

static pprint_pseudo_objectx(object, fp)
     PseudoObject* object;
     FILE* fp;

{
    if(object == NULL) return(0);

    switch (object->tag) {
      case NULL:
	/* p_str(fp,"[]"); */
	return(2);
      default:
	pprint_pseudo_object(object, fp);
	break;
    }
}

Public pprint_pseudo_object(object, fp)
     PseudoObject* object;
     FILE* fp;

{
    if(object == NULL) return(0);

    switch (object->tag) {
      case PROGRAM:
	pprint_program((Program*)object, fp);
	return(0);
      case ENV_DEF:
	pprint_env_def((EnvDef*)object, fp);
	return(0);
      case DEF_LIB:
	pprint_def_lib((DefLib*)object, fp);
	return(0);
      case STRING:
	pprint_string((String*)object, fp);
	return(0);
      case EXP_DEF:
	pprint_exp_def((ExpDef*)object, fp);
	return(0);
      case EXP:
	pprint_exp((Exp*)object, fp);
	return(0);
      case EXP_NAME:
	pprint_exp_name((ExpName*)object, fp);
	return(0);
      case OBJ_DEF:
	pprint_obj_def((ObjDef*)object, fp);
	return(0);
      case OBJ_SUB:
	pprint_obj_sub((ObjSub*)object, fp);
	return(0);
      case MOD_DEF:
	pprint_mod_def((ModDef*)object, fp);
	return(0);
      case M_SUB:
	pprint_m_sub((MSub*)object, fp);
	return(0);
      case M_DESC:
	pprint_m_desc((MDesc*)object, fp);
	return(0);
      case M2_DESC:
	pprint_m2_desc((M2Desc*)object, fp);
	return(0);
      case LINK_DEF:
	pprint_link_def((LinkDef*)object, fp);
	return(0);
      case LINK:
	pprint_link((Link*)object, fp);
	return(0);
      case M_ID_PAIR:
	pprint_m_id_pair((MIdPair*)object, fp);
	return(0);
      case O_TERM_PAIR:
	pprint_o_term_pair((OTermPair*)object, fp);
	return(0);
      case RULE_DEF:
	pprint_rule_def((RuleDef*)object, fp);
	return(0);
      case RULE:
	pprint_rule((Rule*)object, fp);
	return(0);
      case RULE_ID:
	pprint_rule_id((RuleId*)object, fp);
	return(0);
      case NORMAL:
	pprint_normal((Normal*)object, fp);
	return(0);
      case REL:
	pprint_rel((Rel*)object, fp);
	return(0);
      case UPDATE:
	pprint_update((Update*)object, fp);
	return(0);
      case TRANSACTION:
	pprint_transaction((Transaction*)object, fp);
	return(0);
      case PROP:
	pprint_prop((Prop*)object, fp);
	return(0);
      case I_CHECK:
	pprint_i_check((ICheck*)object, fp);
	return(0);
      case CLUSTER:
	pprint_cluster((Cluster*)object, fp);
	return(0);
      case A_TERM:
	pprint_a_term((ATerm*)object, fp);
	return(0);
      case O_TERM:
	pprint_o_term((OTerm*)object, fp);
	return(0);
      case LABEL:
	pprint_label((Label*)object, fp);
	return(0);
      case LAB:
	pprint_lab((Label*)object, fp);
	return(0);
      case C_O_TERM:
	pprint_c_o_term((COTerm*)object, fp);
	return(0);
      case VAR:
	pprint_var((Var*)object, fp);
	return(0);
      case DOT:
	pprint_dot((Dot*)object, fp);
	return(0);
      case SUB_LIST:
	pprint_sub_list((SubList*)object, fp);
	return(0);
      case LIST:
	pprint_list((List*)object, fp);
	return(0);
      case REMAIN:
	pprint_remain((Remain*)object, fp);
	return(0);
      case INTEGER:
	pprint_integer((Integer*)object, fp);
	return(0);
      case NON_STRUCT:
	pprint_non_struct((NonStruct*)object, fp);
	return(0);
      case ATTR:
	pprint_attr((Attr*)object, fp);
	return(0);
      case SET:
	pprint_set((Set*)object, fp);
	return(0);
      case SORT:
	pprint_sort((Sort*)object, fp);
	return(0);
      case VALUE:
	pprint_value((Value*)object, fp);
	return(0);
      case QUERY_CNSTR:
	pprint_query_cnstr((QueryCnstr*)object, fp);
	return(0);
      case CNSTR:
	pprint_cnstr((Cnstr*)object, fp);
	return(0);
      case CNSTR_DATA:
	pprint_cnstr_data((Cnstr*)object, fp);
	return(0);
      case QUERY:
	pprint_query((Query*)object, fp);
	return(0);
      case P_MODE:
	pprint_p_mode((PMode*)object, fp);
	return(0);
      case A_MODE:
	pprint_a_mode((AMode*)object, fp);
	return(0);
      case I_MODE:
	pprint_i_mode((IMode*)object, fp);
	return(0);
      case M_MODE:
	pprint_m_mode((MMode*)object, fp);
	return(0);
      case E_MODE:
	pprint_e_mode((EMode*)object, fp);
	return(0);
      case Q_MODE:
	pprint_q_mode((QMode*)object, fp);
	return(0);
      case ANSWER:
	pprint_answer((Answer*)object, fp);
	return(0);
      case ANSWER_ELEMENT:
	pprint_answer_element((AnswerElement*)object, fp);
	return(0);
      case ANSE_EXPLANATION: 
	pprint_anse_explanation((AnseExplanation*)object, fp);
	return(0);
      case RIR_PAIR: 
	pprint_rir_pair((RirPair*)object, fp);
	return(0);
      case DOT_CNSTR:
	pprint_dot_cnstr((DotCnstr*)object, fp);
	return(0);
      case VAR_CNSTR:
	pprint_var_cnstr((VarCnstr*)object, fp);
	return(0);
      case INHERIT:
	pprint_inherit((Inherit*)object, fp);
	return(0);
      case REDUCE:
	pprint_reduce((Reduce*)object, fp);
	return(0);
      case SUB_GOAL:
	pprint_sub_goal((SubGoal*)object, fp);
	return(0);
      case VC_PAIR:
	pprint_vc_pair((VcPair*)object, fp);
	return(0);
      case ONE_RULE:
	pprint_one_rule((OneRule*)object, fp);
	return(0);
      case UNIT_EXPLANATION:
	pprint_unit_explanation((UnitExplanation*)object, fp);
	return(0);
      case MERGE_EXPLANATION:
	pprint_merge_explanation((MergeExplanation*)object, fp);
	return(0);
      case LOOKUP_EXPLANATION:
	pprint_lookup_explanation((LookupExplanation*)object, fp);
	return(0);
      case EXPLANATION:
	pprint_explanation((Explanation*)object, fp);
	return(0);
      case CONSTRAINT:
	pprint_constraint((Constraint*)object, fp);
	return(0);
      case CON:
	pprint_con((Con*)object, fp);
	return(0);
      case ASSUMP:
	pprint_assump((Assump*)object, fp);
	return(0);
      case QUERY_EXPLANATION: 
	pprint_query_explanation((QueryExplanation*)object, fp);
	return(0);
      case PSEUDO_OBJECT:
	union_tag("PSEUDO_OBJECT", fp);
	return(0);
      case OBJ_LIST:
	pprint_obj_list((ObjList*)object, fp, ",");
	return(0);
      case OBJ_ARRAY:
	pprint_obj_array((ObjArray*)object, fp);
	return(0);
      case NULL:
	/* p_str(fp,"'&void'"); */
	return(1);
      default:
	illegal_type_descriptor("pprint_pseudo_object", object->tag);
	break;
    }
}

Public pprint_obj_list(obj_list, fp, str)
     ObjList* obj_list;
     FILE* fp;
     char *str;
{
    ObjElement* p;

    if (obj_list == NULL) {
	return;
    }
    p = obj_list->first;
    if (p != NULL) {
	pprint_pseudo_object(p->element, fp);
	p = p->next;
    }
    while (p != NULL) {
	p_str(fp, str);
	if(imod == 2 && (strncmp(str,";;",2) != 0))
		{
		p_str(fp, "\n");
		put_blank(fp);
		}
	pprint_pseudo_object(p->element, fp);
	p = p->next;
    }
}

/*
  type_name
  return a type's type name string
*/

static char* type_name(td)
     TypeDescriptor td;
{
    switch (td) {
      case PROGRAM: return "PROGRAM";
      case ENV_DEF: return "ENV_DEF";
      case DEF_LIB: return "DEF_LIB";
      case STRING: return "STRING";
      case EXP_DEF: return "EXP_DEF";
      case EXP: return "EXP";
      case EXP_NAME: return "EXP_NAME";
      case OBJ_DEF: return "OBJ_DEF";
      case OBJ_SUB: return "OBJ_SUB";
      case MOD_DEF: return "MOD_DEF";
      case M_SUB: return "M_SUB";
      case M_DESC: return "M_DESC";
      case M2_DESC: return "M2_DESC";
      case LINK_DEF: return "LINK_DEF";
      case LINK: return "LINK";
      case M_ID_PAIR: return "M_ID_PAIR";
      case O_TERM_PAIR: return "O_TERM_PAIR";
      case RULE_DEF: return "RULE_DEF";
      case RULE: return "RULE";
      case RULE_ID: return "RULE_ID";
      case NORMAL: return "NORMAL";
      case REL: return "REL";
      case UPDATE: return "UPDATE";
      case TRANSACTION: return "TRANSACTION";
      case PROP: return "PROP";
      case I_CHECK: return "I_CHECK";
      case CLUSTER: return "CLUSTER";
      case A_TERM: return "A_TERM";
      case O_TERM: return "O_TERM";
      case LABEL: return "LABEL";
      case LAB: return "LAB";
      case C_O_TERM: return "C_O_TERM";
      case VAR: return "VAR";
      case DOT: return "DOT";
      case SUB_LIST: return "SUB_LIST";
      case LIST: return "LIST";
      case REMAIN: return "REMAIN";
      case INTEGER: return "INTEGER";
      case NON_STRUCT: return "NON_STRUCT";
      case ATTR: return "ATTR";
      case SET: return "SET";
      case SORT: return "SORT";
      case VALUE: return "VALUE";
      case QUERY_CNSTR: return "QUERY_CNSTR";
      case CNSTR: return "CNSTR";
      case QUERY: return "QUERY";
      case P_MODE: return "P_MODE";
      case A_MODE: return "A_MODE";
      case I_MODE: return "I_MODE";
      case M_MODE: return "M_MODE";
      case E_MODE: return "E_MODE";
      case Q_MODE: return "Q_MODE";
      case ANSWER: return "ANSWER";
      case ANSWER_ELEMENT: return "ANSWER_ELEMENT";
      case ANSE_EXPLANATION: return "ANSE_EXPLANATION";
      case RIR_PAIR: return "RIR_PAIR";
      case DOT_CNSTR: return "DOT_CNSTR";
      case VAR_CNSTR: return "VAR_CNSTR";
      case INHERIT: return "INHERIT";
      case REDUCE: return "REDUCE";
      case SUB_GOAL: return "SUB_GOAL";
      case VC_PAIR: return "VC_PAIR";
      case ONE_RULE: return "ONE_RULE";
      case UNIT_EXPLANATION: return "UNIT_EXPLANATION";
      case MERGE_EXPLANATION: return "MERGE_EXPLANATION";
      case LOOKUP_EXPLANATION: return "LOOKUP_EXPLANATION";
      case EXPLANATION: return "EXPLANATION";
      case CONSTRAINT: return "CONSTRAINT";
      case CON: return "CON";
      case ASSUMP: return "ASSUMP";
      case QUERY_EXPLANATION: return "QUERY_EXPLANATION";
      case PSEUDO_OBJECT: return "PSEUDO_OBJECT";
      case OBJ_LIST: return "OBJ_LIST";
      case OBJ_ARRAY: return "OBJ_ARRAY";
      default:
	illegal_type_descriptor("type_name", td);
	break;
    }
}

/*
  is_type(td1, td2):
  check if td1 is one of sub-types of td2
*/

static Bool is_type(td1, td2)
     TypeDescriptor td1, td2;
{
    if (td1 == td2)
      return TRUE;
    else
      switch (td2) {
	case PROGRAM:
	  return td1 == PROGRAM;
	case ENV_DEF:
	  return td1 == ENV_DEF;
	case DEF_LIB:
	  return td1 == DEF_LIB;
	case STRING:
	  return td1 == STRING;
	case EXP_DEF:
	  return td1 == EXP_DEF;
	case EXP:
	  return td1 == EXP;
	case EXP_NAME:
	  return td1 == EXP_NAME;
	case OBJ_DEF:
	  return td1 == OBJ_DEF;
	case OBJ_SUB:
	  return td1 == OBJ_SUB;
	case MOD_DEF:
	  return td1 == MOD_DEF;
	case M_SUB:
	  return td1 == M_SUB;
	case M_DESC:
	  return is_type(td1, M_ID) || is_type(td1, M2_DESC);
	case M2_DESC:
	  return td1 == M2_DESC;
	case LINK_DEF:
	  return td1 == LINK_DEF;
	case LINK:
	  return td1 == LINK;
	case M_ID_PAIR:
	  return td1 == M_ID_PAIR;
	case O_TERM_PAIR:
	  return td1 == O_TERM_PAIR;
	case RULE_DEF:
	  return td1 == RULE_DEF;
	case RULE:
	  return td1 == RULE;
	case RULE_ID:
	  return td1 == RULE_ID;
	case NORMAL:
	  return td1 == NORMAL;
	case REL:
	  return td1 == REL;
	case UPDATE:
	  return td1 == UPDATE;
	case TRANSACTION:
	  return td1 == TRANSACTION;
	case PROP:
	  return td1 == PROP;
	case I_CHECK:
	  return is_type(td1, PROP) || is_type(td1, OBJ_LIST);
	case CONSIS:
	  return is_type(td1, I_CHECK);
	case INCONSIS:
	  return is_type(td1, I_CHECK);
	case CLUSTER:
	  return is_type(td1, NORMAL) || is_type(td1, REL)
	         || is_type(td1, UPDATE) || is_type(td1, TRANSACTION)
		 || is_type(td1, CONSIS) || is_type(td1, INCONSIS);
	case A_TERM:
	  return td1 == A_TERM;
	case O_TERM:
	  return is_type(td1, PROGRAM) || is_type(td1, C_O_TERM)
	         || is_type(td1, VAR) || is_type(td1, DOT)
		 || is_type(td1, LIST) || is_type(td1, NON_STRUCT);
	case LABEL:
	  return td1 == LABEL;
	case LAB:
	  return is_type(td1, IND_LAB) || is_type(td1, SET_LAB)
	         || is_type(td1, CURL_IND) || is_type(td1, CURL_SET);
	case IND_LAB:
	  return is_type(td1, LABEL);
	case SET_LAB:
	  return is_type(td1, LABEL);
	case CURL_IND:
	  return is_type(td1, LABEL);
	case CURL_SET:
	  return is_type(td1, LABEL);
	case C_O_TERM:
	  return td1 == C_O_TERM;
	case VAR:
	  return td1 == VAR;
	case DOT:
	  return td1 == DOT;
	case SUB_LIST:
	  return td1 == SUB_LIST;
	case LIST:
	  return is_type(td1, OBJ_LIST) || is_type(SUB_LIST);
	case REMAIN:
	  return is_type(td1, LIST) || is_type(td1, VAR);
	case INTEGER:
	  return td1 == INTEGER;
	case NON_STRUCT:
	  return is_type(td1, EXP_NAME) || is_type(td1, STRING)
	         || is_type(td1, INTEGER);
	case ATTR:
	  return td1 == ATTR;
	case SET:
	  return td1 == SET;
	case SORT:
	  return td1 == SORT;
	case VALUE:
	  return is_type(td1, SET) || is_type(td1, SORT)
	         || is_type(td1, O_TERM);
	case QUERY_CNSTR:
	  return td1 == QUERY_CNSTR;
	case CNSTR:
	  return td1 == CNSTR || is_type(td1, QUERY_CNSTR);
	  /* temporary */
	case QUERY:
	  return td1 == QUERY;
	case P_MODE:
	  return td1 == P_MODE;
	case A_MODE:
	  return td1 == A_MODE;
	case I_MODE:
	  return td1 == I_MODE;
	case M_MODE:
	  return td1 == M_MODE;
	case E_MODE:
	  return td1 == E_MODE;
	case Q_MODE:
	  return is_type(td1, P_MODE) || is_type(td1, A_MODE)
	         || is_type(td1, I_MODE) || is_type(td1, M_MODE)
		 || is_type(td1, E_MODE);
	case ANSWER:
	  return td1 == ANSWER;
	case ANSWER_ELEMENT:
	  return td1 == ANSWER_ELEMENT;
	case ANSE_EXPLANATION: 
	  return td1 == ANSE_EXPLANATION;
	case RIR_PAIR: 
	  return td1 == RIR_PAIR;
	case DOT_CNSTR:
	  return td1 == DOT_CNSTR;
	case VAR_CNSTR:
	  return td1 == VAR_CNSTR;
	case INHERIT:
	  return td1 == INHERIT;
	case REDUCE:
	  return td1 == REDUCE;
	case SUB_GOAL:
	  return td1 == SUB_GOAL;
	case VC_PAIR:
	  return td1 == VC_PAIR;
	case ONE_RULE:
	  return is_type(td1, REDUCE) || is_type(td1, RULE_ID)
	         || is_type(td1, QUERY);
	case UNIT_EXPLANATION:
	  return is_type(td1, ONE_RULE) || is_type(td1, INHERIT);
	case MERGE_EXPLANATION:
	  return td1 == MERGE_EXPLANATION;
	case LOOKUP_EXPLANATION:
	  return td1 == LOOKUP_EXPLANATION;
	case EXPLANATION:
	  return is_type(td1, UNIT_EXPLANATION)
	         || is_type(td1, MERGE_EXPLANATION)
		 || is_type(td1, LOOKUP_EXPLANATION);
	case CONSTRAINT:
	  return td1 == CONSTRAINT;
	case CON:
	  return td1 == CON;
	case ASSUMP:
	  return td1 == ASSUMP;
	case QUERY_EXPLANATION: 
	  return td1 == QUERY_EXPLANATION;
	case PSEUDO_OBJECT:
	  return TRUE;
	  /* for speed */
	case OBJ_LIST:
	  return td1 == OBJ_LIST;
	case OBJ_ARRAY:
	  return td1 == OBJ_ARRAY;
	default:
	  illegal_type_descriptor("is_type", td2);
	  break;
      }
}

Local union_tag(type_name, fp)
     char* type_name;
     FILE* fp;
{

}

Public pprint_env_def(env_def, fp)
     EnvDef* env_def;
     FILE* fp;

{
    if(env_def != NULL)
	{
	p_str(fp, "&environment;;\n");

	if(env_def->name != NULL)
		{
		p_str(fp, "\t&name[&pgm-name=");
		p_str(fp, env_def->name);
		p_str(fp, "];;\n"); 
		}
	if(env_def->author != NULL)
		{
		p_str(fp, "\t&author[&aut-name=");
		p_str(fp, env_def->author);
		p_str(fp, "];;\n"); 
		}
	if(env_def->date != NULL)
		{
		p_str(fp, "\t&date[&date=");
		p_str(fp, env_def->date);
		p_str(fp, "];;\n"); 
		}
	if(env_def->def_libs != NULL)
		{
		p_str(fp, "\t&include[");
        	pprint_obj_list(env_def->def_libs, fp, ",");
		p_str(fp, "];;\n");
		}
	}
}

Public pprint_def_lib(def_lib, fp)
     DefLib* def_lib;
     FILE* fp;

{
    pprint_lib_lab(def_lib->lib_lab, fp);
    p_str(fp, "=");
    pprint_pseudo_objectx(def_lib->lib_names, fp);
}

Local pprint_lib_lab(lib_lab, fp)
     LibLab lib_lab;
     FILE* fp;
{
    switch (lib_lab) {
      case EXPLIB:
	p_str(fp, "&exp_lib");
	break;
      case PGMLIB:
	p_str(fp, "&pgm_lib");
	break;
      case SORTLIB:
	p_str(fp, "&sort_lib");
	break;
      default:

	break;
    }
}

Public pprint_exp_def(exp_def, fp)
     ExpDef* exp_def;
     FILE* fp;

{
    p_str(fp, "&expression;;\n\t");
    pprint_obj_list(exp_def->exps, fp, ";;\n\t");
    p_str(fp, ";;\n");
}

Public pprint_exp(exp, fp)
     Exp* exp;
     FILE* fp;

{
    pprint_pseudo_object(exp->exp_name, fp);
    p_str(fp, "=");
    pprint_pseudo_object(exp->o_term, fp);
}

Public pprint_obj_def(obj_def, fp)
     ObjDef* obj_def;
     FILE* fp;

{
    p_str(fp, "&object;;\n\t");
    pprint_obj_list(obj_def->obj_subs, fp, ";;\n\t");
    p_str(fp, ";;\n");
}

Public pprint_obj_sub(obj_sub, fp)
     ObjSub* obj_sub;
     FILE* fp;

{
    p_str(fp, obj_sub->bobj1);
    p_str(fp, "=<");
    p_str(fp, obj_sub->bobj2);
}

Public pprint_mod_def(mod_def, fp)
     ModDef* mod_def;
     FILE* fp;

{
    p_str(fp, "&module;;\n\t");
    pprint_obj_list(mod_def->m_subs, fp, ";;\n\t");
    p_str(fp, ";;\n");
}

Public pprint_m_sub(m_sub, fp)
     MSub* m_sub;
     FILE* fp;

{
    pprint_pseudo_object(m_sub->m_id, fp);
    p_str(fp, ">-");
    pprint_m_desc(m_sub->m_desc, fp);
}

Public pprint_m_desc(m_desc, fp)
     MDesc* m_desc;
     FILE* fp;

{
     if(m_desc->tag == M2_DESC) 
          pprint_m2_desc(m_desc, fp);
     else
         {
	 pprint_pseudo_object(m_desc, fp);
         }
}

Public pprint_m2_desc(m2_desc, fp)
     M2Desc* m2_desc;
     FILE* fp;

{
    p_str(fp, "(");
    pprint_m_desc(m2_desc->m_desc1, fp);
    putc(m2_desc->op, fp);
    pprint_m_desc(m2_desc->m_desc2, fp);
    p_str(fp, ")");
}

Public pprint_link_def(link_def, fp)
     LinkDef* link_def;
     FILE* fp;

{
    p_str(fp, "&link;;\n\t");
    p_str(fp, "[");
    pprint_obj_list(link_def->links, fp, ";;\n\t");
    p_str(fp, "]");
}

Public pprint_link(link, fp)
     Link* link;
     FILE* fp;

{
    p_str(fp, link->link_name);
    p_str(fp, ",");
    if(link->m_ids != NULL)
	{
    	p_str(fp, "{");
    	pprint_obj_list(link->m_ids, fp, ",");
	p_str(fp, "}");
	}
    if(link->o_terms != NULL)
	{
    	p_str(fp, "{");
    	pprint_obj_list(link->o_terms, fp, ",");
    	p_str(fp, "}");
	}
}

Public pprint_m_id_pair(m_id_pair, fp)
     MIdPair* m_id_pair;
     FILE* fp;

{
    p_str(fp, "[");
    pprint_pseudo_object(m_id_pair->m_id1, fp);
    p_str(fp, ",");
    pprint_pseudo_object(m_id_pair->m_id2, fp);
    p_str(fp, "]");
}

Public pprint_o_term_pair(o_term_pair, fp)
     OTermPair* o_term_pair;
     FILE* fp;

{
    p_str(fp, "[");
    pprint_pseudo_object(o_term_pair->o_term1, fp);
    p_str(fp, ",");
    pprint_pseudo_object(o_term_pair->o_term2, fp);
    p_str(fp, "]");
}

Public pprint_rule_def(rule_def, fp)
     RuleDef* rule_def;
     FILE* fp;

{
    p_str(fp, "&rule;;\n\t");
    pprint_obj_list(rule_def->rules, fp, ";;\n\t");
    p_str(fp, ";;\n");
}

Public pprint_rule(rule, fp)
     Rule* rule;
     FILE* fp;

{
    pprint_rule_class(rule->rule_class, fp);

    pprint_no_assume(rule->no_assume, fp);
    if(rule->m_ids->first != NULL)
	if(rule->m_ids->first == rule->m_ids->last)
		{
		pprint_obj_list(rule->m_ids, fp, ",");
		p_str(fp, "::");
		}
	else
		{
		p_str(fp, "{");
		pprint_obj_list(rule->m_ids, fp, ",");
		p_str(fp, "}::");
		}
    if((rule->rule_id != NULL) || (rule->inheritance_mode != NULL))
	{   
	p_str(fp, "(");
	pprint_pseudo_object(rule->rule_id, fp);
        if(rule->rule_id != NULL)
	    p_str(fp, ",");
    	pprint_inheritance_mode(rule->inheritance_mode, fp);
	p_str(fp, ")");
	}
    pprint_pseudo_object(rule->a_term, fp);
    if(rule->clusters != NULL)
	{
    	p_str(fp, "<=");
    	pprint_obj_list(rule->clusters, fp, rule_separator);
	}
    if(rule->cnstrs != NULL)
	{
    	p_str(fp, "||{");
    	pprint_obj_list(rule->cnstrs, fp, ",");
    	p_str(fp, "}");
	}
}

Local pprint_rule_class(rule_class, fp)
     RuleClass rule_class;
     FILE* fp;
{
    switch (rule_class) {
      case NULL:
	rule_separator = ",";
	break;
      case RCNOUPDATE:
	rule_separator = ",";
	break;
      case RCUPDATE:
	rule_separator = ";";
	break;
      default:
	rule_separator = ",";
	break;
    }
}

Local pprint_no_assume(no_assume, fp)
     NoAssume no_assume;
     FILE* fp;
{
    switch (no_assume) {
      case NULL:
	break;
      case NOASSUME:
	p_str(fp, "&no_assume");
	break;
      default:

	break;
    }
}

Public pprint_rule_id(rule_id, fp)
     RuleId* rule_id;
     FILE* fp;

{
    if(rule_id->rule_id_string != NULL)
	p_str(fp, rule_id->rule_id_string);
}

Local pprint_inheritance_mode(inheritance_mode, fp)
     InheritanceMode inheritance_mode;
     FILE* fp;
{
    switch (inheritance_mode) {
      case NULL:
	break;
      case IML:
	p_str(fp, "&l");
	break;
      case IMO:
	p_str(fp, "&o");
	break;
      case IMLO:
	p_str(fp, "&lo");
	break;
      case IMOL:
	p_str(fp, "&ol");
	break;
      default:

	break;
    }
}

Public pprint_cluster(cluster, fp)
     Cluster* cluster;
     FILE* fp;

{
      pprint_pseudo_object(cluster, fp);
}

Public pprint_normal(normal, fp)
     Normal *normal;
     FILE* fp;

{
    if(normal->m_id != NULL)
	{
    	pprint_pseudo_object(normal->m_id, fp);
    	p_str(fp, ":");
	}
    pprint_pseudo_object(normal->a_term, fp);
}

Public pprint_update(update, fp)
     Update* update;
     FILE* fp;

{
    if(update->u_flag == UFPLUS)
	p_str(fp, "+");
    else if(update->u_flag == UFMINUS)
	p_str(fp, "-");
    if(update->m_id != NULL)
	{
    	pprint_pseudo_object(update->m_id, fp);
    	p_str(fp, ":");
	}
    pprint_pseudo_object(update->a_term, fp);
}

Public pprint_rel(rel, fp)
     Rel* rel;
     FILE* fp;

{
    pprint_pseudo_object(rel->o_term1, fp);
    pprint_sub_rel(rel->sub_rel, fp);
    pprint_pseudo_object(rel->o_term2, fp);
}

Public pprint_transaction(transaction, fp)
     Transaction* transaction;
     FILE* fp;

{
    pprint_transaction_controller(transaction->trn_data, fp);
}

Local pprint_transaction_controller(trn_data, fp)
     TrnData trn_data;
     FILE* fp;
{
    switch (trn_data) {
      case NULL:
	break;
      case TDBT:
	p_str(fp, "&bt");
	break;
      case TDET:
	p_str(fp, "&et");
	break;
      case TDAT:
	p_str(fp, "&at");
	break;
      defaut:

	break;
    }
}

Public pprint_a_term(a_term, fp)
     ATerm* a_term;
     FILE* fp;

{
    pprint_pseudo_object(a_term->o_term, fp);
    if((a_term->attrs != NULL) || (a_term->cnstrs != NULL))
	{
    	p_str(fp, "/");
	}
    if(a_term->attrs != NULL)
	{
    	p_str(fp, "[");
    	pprint_obj_list(a_term->attrs, fp, ",");
    	p_str(fp, "]");
	}
    if(a_term->cnstrs != NULL)
	{
    	p_str(fp, "|{");
    	pprint_pseudo_objectx(a_term->cnstrs, fp);
    	p_str(fp, "}");
	}
}

Public pprint_o_term(o_term, fp)
     OTerm* o_term;
     FILE* fp;

{
      pprint_pseudo_object(o_term, fp);
}

Public pprint_list(list, fp)
     List* list;
     FILE* fp;

{
	if(list->tag == SUB_LIST)
		pprint_sub_list(list, fp);
	p_str(fp, "[");      
	pprint_obj_list(list->normal, fp, ",");
	p_str(fp, "]");      
}

Public pprint_sub_list(sub_list, fp)
     SubList* sub_list;
     FILE* fp;

{
	p_str(fp, "[");      
        pprint_pseudo_objectx(sub_list->o_terms, fp);
    	p_str(fp, "|");      
	pprint_pseudo_object(sub_list->remain, fp);
    	p_str(fp, "]");
}

Public pprint_remain(remain, fp)
     Remain* remain;
     FILE* fp;

{
      pprint_pseudo_object(remain, fp);
}

Public pprint_non_struct(non_struct, fp)
     NonStruct* non_struct;
     FILE* fp;

{
      pprint_pseudo_object(non_struct, fp);
}

Public pprint_exp_name(exp_name, fp)
     ExpName* exp_name;
     FILE* fp;

{
    p_str(fp, exp_name->name);
}

Public pprint_integer(integer, fp)
     Integer* integer;
     FILE* fp;

{
    p_int(fp, integer->value);
}

Public pprint_string(string, fp)
     String* string;
     FILE* fp;

{
    p_str(fp, string->str_data);
}

Public pprint_c_o_term(c_o_term, fp)
     COTerm* c_o_term;
     FILE* fp;

{
    p_str(fp, c_o_term->head);
    if(c_o_term->attrs != NULL)
	{
    	p_str(fp, "[");
    	pprint_pseudo_objectx(c_o_term->attrs, fp);
    	p_str(fp, "]");
	}
    if(c_o_term->cnstrs != NULL)
	{
	p_str(fp, "{");
    	pprint_pseudo_objectx(c_o_term->cnstrs, fp);
    	p_str(fp, "}");
	}
}

Public pprint_dot(dot, fp)
     Dot* dot;
     FILE* fp;

{
    pprint_pseudo_object(dot->o_term, fp);
    p_str(fp, "!");
    pprint_pseudo_object(dot->label, fp);
}

Public pprint_attr(attr, fp)
     Attr* attr;
     FILE* fp;

{
    pprint_pseudo_object(attr->label, fp);
    pprint_attr_op(attr->attr_op, fp);
    pprint_pseudo_object(attr->value, fp);
}

Public pprint_label(label, fp)
     Label* label;
     FILE* fp;

{
      pprint_lab(label, fp);
}

Public pprint_lab(lab, fp)
     Label* lab;
     FILE* fp;

{
    pprint_pseudo_object(lab->o_term, fp);
}

Local pprint_attr_op(attr_op, fp)
     AttrOp attr_op;
     FILE* fp;
{
    switch (attr_op) {
      case ATRARROW:
	p_str(fp, "->");
	break;
      case ATLARROW:
	p_str(fp, "<-");
	break;
      case ATEQ:
	p_str(fp, "=");
	break;
      default:

	break;
    }
}

Public pprint_value(value, fp)
     Value* value;
     FILE* fp;

{
      pprint_pseudo_object(value, fp);
}

Public pprint_set(set, fp)
     Set* set;
     FILE* fp;

{
    p_str(fp, "{");
    pprint_obj_list(set->o_terms, fp, ",");
    p_str(fp, "}");
}

Public pprint_sort(sort, fp)
     Sort* sort;
     FILE* fp;

{
    pprint_pseudo_object(sort->prolog, fp);
}

Public pprint_var(var, fp)
     Var* var;
     FILE* fp;

{
    p_str(fp, var->var_data);
    pprint_var_type(var->type, fp);
}

Local pprint_var_type(type, fp)
     VarType type;
     FILE* fp;
{
    switch (type) {
      case VARIND:
	break;
      case VARSET:
	p_str(fp, "*");
	break;
      default:

	break;
    }
}

Public pprint_cnstr(cnstr, fp)
     Cnstr* cnstr;
     FILE* fp;

{
      pprint_pseudo_object(cnstr, fp);
}

Public pprint_cnstr_data(cnstr_data, fp)
     CnstrData* cnstr_data;
     FILE* fp;

{
    if(cnstr_data->m_id1 != NULL)
	{
    	pprint_pseudo_object(cnstr_data->m_id1, fp);
    	p_str(fp, ":");
	}
    pprint_pseudo_object(cnstr_data->value1, fp);
    pprint_rel_op(cnstr_data->rel, fp);
    if(cnstr_data->m_id2 != NULL)
	{
    	pprint_pseudo_object(cnstr_data->m_id2, fp);
    	p_str(fp, ":");
	}
    pprint_pseudo_object(cnstr_data->value2, fp);
}

Local pprint_sub_rel(sub_rel, fp)
     CnRel sub_rel;
     FILE* fp;
{
    switch (sub_rel) {
      case NULL:
	break;
      case CNLE:
	p_str(fp, " =< ");
	break;
      case CNGE:
	p_str(fp, " >= ");
	break;
      case CNEQ:
	p_str(fp, " == ");
	break;
      case CNPL:
	p_str(fp, " *< ");
	break;
      case CNPG:
	p_str(fp, " >* ");
	break;
      case CNEPE:
	p_str(fp, " =*= ");
	break;
      case CNIN:
	p_str(fp, " &in ");
	break;
      case CNNI:
	p_str(fp, " &ni ");
	break;
      default:

	break;
    }
}

Local pprint_rel_op(rel, fp)
     CnRel rel;
     FILE* fp;
	{
	pprint_sub_rel(rel, fp);
	}

Public pprint_i_check(i_check , fp)
     ICheck* i_check;
     FILE* fp;

{
      pprint_pseudo_object(i_check, fp);
}

Public pprint_prop(prop, fp)
     Prop* prop;
     FILE* fp;

{
    if(prop->m_id != NULL)
	{
    	pprint_pseudo_object(prop->m_id, fp);
    	p_str(fp, ":");
	}
    pprint_pseudo_object(prop->a_term, fp);
}

Public pprint_query(query, fp)
     Query* query;
     FILE* fp;

{
    p_str(fp, "?-");
    pprint_rule_class(query->query_class, fp);
    pprint_obj_list(query->clusters, fp, rule_separator);
    if(query->cnstrs != NULL)
	{
	p_str(fp, "||{");
	pprint_pseudo_objectx(query->cnstrs, fp);
	p_str(fp, "}");
	}
    if(query->q_modes != NULL)
	{
	p_str(fp, ";;\n");
    	pprint_pseudo_objectx(query->q_modes, fp);
	}
    if(query->program != NULL)
	{
    	p_str(fp, ";;\n");
    	pprint_pseudo_object(query->program, fp);
	}
    else
    	p_str(fp, ".\n");
}

Public pprint_query_cnstr(query_cnstr, fp)
     QueryCnstr* query_cnstr;
     FILE* fp;

{
    pprint_pseudo_object(query_cnstr->m_id1, fp);
    p_str(fp, ">-");
    pprint_pseudo_object(query_cnstr->m_id2, fp);
}

Public pprint_q_mode(q_mode, fp)
     QMode* q_mode;
     FILE* fp;

{
      pprint_pseudo_object(q_mode, fp);
}

Public pprint_p_mode(p_mode, fp)
     PMode* p_mode;
     FILE* fp;

{
    p_str(fp, "&proc_mode=");
    pprint_p_mode_data(p_mode->p_mode_data, fp);
}

Local pprint_p_mode_data(p_mode_data, fp)
     PModeData p_mode_data;
     FILE* fp;
{
    switch (p_mode_data) {
      case PSINGLE:
	p_str(fp, "&single");
	break;
      case PMULTI:
	p_str(fp, "&multi");
	break;
      default:

	break;
    }
}

Public pprint_a_mode(a_mode, fp)
     AMode* a_mode;
     FILE* fp;

{
    p_str(fp, "&ans_mode=");
    pprint_a_mode_data(a_mode->a_mode_data, fp);
}

Local pprint_a_mode_data(a_mode_data, fp)
     AModeData a_mode_data;
     FILE* fp;
{
    switch (a_mode_data) {
      case ANORMAL:
	p_str(fp, "&normal");
	break;
      case AMINIMAL:
	p_str(fp, "&minimal");
	break;
      default:

	break;
    }
}

Public pprint_i_mode(i_mode, fp)
     IMode *i_mode;
     FILE* fp;

{
    p_str(fp, "&inheritance=");
    pprint_i_mode_data(i_mode->i_mode_data, fp);
}

Local pprint_i_mode_data(i_mode_data, fp)
     IModeData i_mode_data;
     FILE* fp;
{
    switch (i_mode_data) {
      case IALL:
	p_str(fp, "&all");
	break;
      case IDOWN:
	p_str(fp, "&down");
	break;
      case IUP:
	p_str(fp, "&up");
	break;
      case INO:
	p_str(fp, "&no");
	break;
      default:

	break;
    }
}

Public pprint_m_mode(m_mode, fp)
     MMode* m_mode;
     FILE* fp;

{
    p_str(fp, "&merge=");
    pprint_m_mode_data(m_mode->m_mode_data, fp);
}

Local pprint_m_mode_data(m_mode_data, fp)
     MModeData m_mode_data;
     FILE* fp;
{
    switch (m_mode_data) {
      case MYES:
	p_str(fp, "&yes");
	break;
      case MNO:
	p_str(fp, "&no");
	break;
      default:

	break;
    }
}

Public pprint_e_mode(e_mode, fp)
     EMode* e_mode;
     FILE* fp;

{
    p_str(fp, "&explanation=");
    pprint_e_mode_data(e_mode->e_mode_data, fp);
}

Local pprint_e_mode_data(e_mode_data, fp)
     EModeData e_mode_data;
     FILE* fp;
{
    switch (e_mode_data) {
      case EON:
	p_str(fp, "&on");
	break;
      case EOFF:
	p_str(fp, "&off");
	break;
      default:

	break;
    }
}

Public pprint_answer(answer, fp)
     Answer* answer;
     FILE* fp;

{
	if(answer->answer_elements->first == NULL)
		{
		p_str(fp, "no answers\n\n");
		}
	else
		{
    		p_str(fp, "answers are as follows\n\n");
    		pprint_obj_list(answer->answer_elements, fp, "");
    		/* pprint_pseudo_objectx(answer->answer_elements, fp); */
    		/* p_str(fp, "\n"); */
		}
}

Public pprint_answer_element(answer_element, fp)
     AnswerElement* answer_element;
     FILE* fp;

{
    if(answer_element->dot_cnstrs == NULL)
	{
	p_str(fp, "    always\n");
	p_str(fp, "        ");
	}
    else if(answer_element->dot_cnstrs->first == NULL)
	{
	p_str(fp, "    always\n");
	p_str(fp, "        ");
	}
    else
	{
	p_str(fp, "    if\n");
	p_str(fp, "        ");
    	pprint_obj_list(answer_element->dot_cnstrs, fp, "\n        ");
	p_str(fp, "\n    then\n        ");
	}
    if(answer_element->var_cnstrs == NULL)
	{
	p_str(fp, "yes\n\n");
	}
    else if(answer_element->var_cnstrs->first == NULL)
	{
	p_str(fp, "yes\n\n");
	}
    else
	{
    	pprint_obj_list(answer_element->var_cnstrs, fp,"\n        ");
	p_str(fp, "\n\n");
	}
    /* pprint_pseudo_object(answer_element->anse_explanation, fp); */
}

Public pprint_dot_cnstr(dot_cnstr, fp)
     DotCnstr* dot_cnstr;
     FILE* fp;

{
    if(dot_cnstr->m_id != NULL)
	{
    	pprint_pseudo_object(dot_cnstr->m_id, fp);
    	p_str(fp, ":");
	}
    pprint_pseudo_object(dot_cnstr->dot, fp);
    pprint_sub_rel(dot_cnstr->rel, fp);
    pprint_pseudo_object(dot_cnstr->value, fp);
}

Public pprint_var_cnstr(var_cnstr, fp)
     VarCnstr* var_cnstr;
     FILE* fp;

{
    pprint_pseudo_object(var_cnstr->var, fp);
    pprint_sub_rel(var_cnstr->rel, fp);
    pprint_pseudo_object(var_cnstr->value, fp);
}

/**************************************************************/

Public pprint_anse_explanation(anse_explanation, fp)
     AnseExplanation* anse_explanation;
     FILE* fp;

{
    p_str(fp, "{");
    pprint_pseudo_object(anse_explanation->explanation, fp);
    p_str(fp, ",");
    pprint_pseudo_object(anse_explanation->rir_pairs, fp);
    p_str(fp, "}");
}

Public pprint_rir_pair(rir_pair, fp)
     RirPair* rir_pair;
     FILE* fp;

{
    p_str(fp, "{");
    pprint_pseudo_object(rir_pair->rule_id, fp);
    p_str(fp, ",");
    pprint_pseudo_object(rir_pair->rule, fp);
    p_str(fp, "}");
}

Public pprint_explanation(explanation, fp)
     Explanation* explanation;
     FILE* fp;

{
      pprint_pseudo_object(explanation, fp);
}

Public pprint_unit_explanation(unit_explanation, fp)
     UnitExplanation* unit_explanation;
     FILE* fp;

{
    p_str(fp, "{unit,");
    pprint_pseudo_object(unit_explanation, fp);
    p_str(fp, "}");
}

Public pprint_inherit(inherit, fp)
     Inherit* inherit;
     FILE* fp;

{
    p_str(fp, "{inherit,");
    p_str(fp, "{");
    pprint_pseudo_object(inherit->one_rule, fp);
    p_str(fp, ",");
    pprint_pseudo_objectx(inherit->ups, fp);
    p_str(fp, ",");
    pprint_pseudo_objectx(inherit->downs, fp);
    p_str(fp, "}");
    p_str(fp, "}");
}

Public pprint_merge_explanation(merge_explanation, fp)
     MergeExplanation* merge_explanation;
     FILE* fp;

{
    p_str(fp, "{merge,");
    pprint_pseudo_object(merge_explanation->unit_explanations, fp);
    p_str(fp, "}");
}

Public pprint_lookup_explanation(lookup_explanation, fp)
     LookupExplanation* lookup_explanation;
     FILE* fp;

{

    pprint_pseudo_object(lookup_explanation->sub_goal, fp);

    pprint_pseudo_object(lookup_explanation->looked_s, fp);

    pprint_pseudo_object(lookup_explanation->looking_s, fp);

    pprint_pseudo_object(lookup_explanation->explanation, fp);
}

Public pprint_one_rule(one_rule, fp)
     OneRule* one_rule;
     FILE* fp;

{

    pprint_pseudo_object(one_rule->reduce, fp);
    p_str(fp,",");
    pprint_pseudo_object(one_rule->rule_id, fp);
    p_str(fp,",");
    pprint_pseudo_object(one_rule->query, fp);
}

Public pprint_reduce(reduce, fp)
     Reduce* reduce;
     FILE* fp;

{

    pprint_pseudo_object(reduce->sub_goal, fp);
    p_str(fp,",");
    pprint_pseudo_object(reduce->rule_id, fp);
    p_str(fp,",");
    pprint_pseudo_objectx(reduce->explanations, fp);
    p_str(fp,",");
    pprint_pseudo_object(reduce->assumps, fp);
}

Public pprint_sub_goal(subgoal, fp)
     SubGoal* subgoal;
     FILE* fp;

{

    pprint_pseudo_object(subgoal->m_id, fp);
    p_str(fp,",");
    pprint_pseudo_object(subgoal->o_term, fp);
    p_str(fp,",");
    pprint_pseudo_objectx(subgoal->vc_pairs, fp);
}

Public pprint_vc_pair(vc_pair, fp)
     VcPair* vc_pair;
     FILE* fp;

{

    pprint_pseudo_object(vc_pair->var, fp);
    p_str(fp,",");
    pprint_pseudo_object(vc_pair->constraint, fp);
}

Public pprint_constraint(constraint, fp)
     Constraint* constraint;
     FILE* fp;

{

    pprint_pseudo_object(constraint->const_data, fp);
}

Public pprint_con(con, fp)
     Con* con;
     FILE* fp;

{

    pprint_pseudo_objectx(con->o_terms1, fp);
    p_str(fp,",");
    pprint_pseudo_objectx(con->o_terms2, fp);
}

Public pprint_assump(assump, fp)
     Assump* assump;
     FILE* fp;

{

    pprint_pseudo_object(assump->m_id, fp);
    p_str(fp,",");
    pprint_pseudo_object(assump->dot, fp);
    p_str(fp,",");
    pprint_pseudo_objectx(assump->vc_pairs, fp);
}

Public pprint_query_explanation(query_explanation, fp)
     QueryExplanation* query_explanation;
     FILE* fp;

{

    p_str(fp, query_explanation->str_data);
}

Public pprint_obj_array(obj_array, fp)
     ObjArray* obj_array;
     FILE* fp;

{
    int i;
    char *string;

    pprint_pseudo_object(obj_array->element_tag, fp);

    pprint_pseudo_object(obj_array->size, fp);
/*    string = dotsrc_malloc(strlen("elements") + 2 +
			   (int)log10(obj_array->size) + 1 + 1); */
    for (i = 0; i < obj_array->size; ++i) {
	pprint_pseudo_object(obj_array->elements[i], fp);
    }
}

/*
  type_error:
  output type error message to stderr and exit with code 2.
*/

static void type_error(object, type_name, func_name)
     PseudoObject* object;
     char *type_name, *func_name;
{
    fprintf(stderr, "type error\n");

    exit(2);
}

static void type_conflict(td1, td2, func_name)
     TypeDescriptor td1, td2;
     char *func_name;
{
    fprintf(stderr, "type confliction\n");
    exit(2);
}

/*
  write_through_NULL:
  output error message to stderr and exit with code 2.
*/

static void write_through_NULL(func_name)
     char* func_name;
{
    exit(2);
}

/*
  illegal_type_descriptor:
  output error message to stderr and exit with code 2.
*/
static void illegal_type_descriptor(func_name, td)
     char* func_name;
     TypeDescriptor td;
{
    fprintf(stderr, "illegal type descriptor\n");
    exit(2);
}

/*
  array_type_check:
  checks all elements of a pseudo object array are of given type
*/

static array_type_check(td, n, obj_array)
     TypeDescriptor td;
     int n;
     PseudoObject** obj_array;
{
    int i;

    for (i = 0; i < n; ++i) {
	if (! is_type(obj_array[i]->tag, td))
	  type_error(obj_array[i], type_name(td), "array_type_check");
    }
}

Local int cmp_keys(key1, key2)
     char *key1, *key2;
{
    return strcmp(key1, key2) == 0;
}

static freed_unused(ptr)
     char *ptr;
{
    printf("freed unused area at %x\n", (int)ptr);
}

Local pprint_log(log)
     AllocLog *log;
{
    if (log->tag == Malloc)
      printf("at %x, size %d\n", (int)((MallocLog*)log)->ptr,
	     ((MallocLog*)log)->size);
    else
      printf("at %x, size %d x %d\n", (int)((CallocLog*)log)->ptr,
	     ((CallocLog*)log)->nelem, ((CallocLog*)log)->elsize);
}

Local duplicate_allocation(dup, log)
     AllocLog *dup, *log;
{
    printf("duplicate allocation\n");
    printf("Old: ");
    pprint_log(dup);
    printf("New: ");
    pprint_log(log);
}
