#ifdef sequent
#include <strings.h>
#else
#include <string.h>
#endif

#include <math.h>

#include "dotsrc.h"
void prnt_pseudo_object();

/* not portable macro */
#ifdef sun
#define POINTER_STRING_SIZE 10
#else
#ifdef sequent
#define POINTER_STRING_SIZE 7
#else
#define POINTER_STRING_SIZE 8
#endif
#endif


Public void prnt_pseudo_object(object, fp, indent)
     PseudoObject* object;
     FILE* fp;
     int indent;
{
     /* p_pseudo_object(object, fp, indent); */
}

fprintfx(fp,str,a,b,c,d,e,f,g,h,i,j)
FILE *fp;
char *str;
	{
	/* fprintf(fp,str,a,b,c,d,e,f,g,h,i,j); */
	}

static char* type_name(td)
     TypeDescriptor td;
{
    switch (td) {
      case PROGRAM: return "PROGRAM";
      case ENV_DEF: return "ENV_DEF";
      case DEF_LIB: return "DEF_LIB";
      case STRING: return "STRING";
      case EXP_DEF: return "EXP_DEF";
      case EXP: return "EXP";
      case EXP_NAME: return "EXP_NAME";
      case OBJ_DEF: return "OBJ_DEF";
      case OBJ_SUB: return "OBJ_SUB";
      case MOD_DEF: return "MOD_DEF";
      case M_SUB: return "M_SUB";
      case M_DESC: return "M_DESC";
      case M2_DESC: return "M2_DESC";
      case LINK_DEF: return "LINK_DEF";
      case LINK: return "LINK";
      case M_ID_PAIR: return "M_ID_PAIR";
      case O_TERM_PAIR: return "O_TERM_PAIR";
      case RULE_DEF: return "RULE_DEF";
      case RULE: return "RULE";
      case RULE_ID: return "RULE_ID";
      case NORMAL: return "NORMAL";
      case REL: return "REL";
      case UPDATE: return "UPDATE";
      case TRANSACTION: return "TRANSACTION";
      case PROP: return "PROP";
      case I_CHECK: return "I_CHECK";
      case CLUSTER: return "CLUSTER";
      case A_TERM: return "A_TERM";
      case O_TERM: return "O_TERM";
      case LABEL: return "LABEL";
      case LAB: return "LAB";
      case C_O_TERM: return "C_O_TERM";
      case VAR: return "VAR";
      case DOT: return "DOT";
      case SUB_LIST: return "SUB_LIST";
      case LIST: return "LIST";
      case REMAIN: return "REMAIN";
      case INTEGER: return "INTEGER";
      case NON_STRUCT: return "NON_STRUCT";
      case ATTR: return "ATTR";
      case SET: return "SET";
      case SORT: return "SORT";
      case VALUE: return "VALUE";
      case QUERY_CNSTR: return "QUERY_CNSTR";
      case CNSTR: return "CNSTR";
      case QUERY: return "QUERY";
      case P_MODE: return "P_MODE";
      case A_MODE: return "A_MODE";
      case I_MODE: return "I_MODE";
      case M_MODE: return "M_MODE";
      case E_MODE: return "E_MODE";
      case Q_MODE: return "Q_MODE";
      case ANSWER: return "ANSWER";
      case ANSWER_ELEMENT: return "ANSWER_ELEMENT";
      case ANSE_EXPLANATION: return "ANSE_EXPLANATION";
      case RIR_PAIR: return "RIR_PAIR";
      case DOT_CNSTR: return "DOT_CNSTR";
      case VAR_CNSTR: return "VAR_CNSTR";
      case INHERIT: return "INHERIT";
      case REDUCE: return "REDUCE";
      case SUB_GOAL: return "SUB_GOAL";
      case VC_PAIR: return "VC_PAIR";
      case ONE_RULE: return "ONE_RULE";
      case UNIT_EXPLANATION: return "UNIT_EXPLANATION";
      case MERGE_EXPLANATION: return "MERGE_EXPLANATION";
      case LOOKUP_EXPLANATION: return "LOOKUP_EXPLANATION";
      case EXPLANATION: return "EXPLANATION";
      case CONSTRAINT: return "CONSTRAINT";
      case CON: return "CON";
      case ASSUMP: return "ASSUMP";
      case QUERY_EXPLANATION: return "QUERY_EXPLANATION";
      case PSEUDO_OBJECT: return "PSEUDO_OBJECT";
      case OBJ_LIST: return "OBJ_LIST";
      case OBJ_ARRAY: return "OBJ_ARRAY";
      default:
	illegal_type_descriptor("type_name", td);
	break;
    }
}

/*
  is_type(td1, td2):
  check if td1 is one of sub-types of td2
*/

static Bool is_type(td1, td2)
     TypeDescriptor td1, td2;
{
    if (td1 == td2)
      return TRUE;
    else
      switch (td2) {
	case PROGRAM:
	  return td1 == PROGRAM;
	case ENV_DEF:
	  return td1 == ENV_DEF;
	case DEF_LIB:
	  return td1 == DEF_LIB;
	case STRING:
	  return td1 == STRING;
	case EXP_DEF:
	  return td1 == EXP_DEF;
	case EXP:
	  return td1 == EXP;
	case EXP_NAME:
	  return td1 == EXP_NAME;
	case OBJ_DEF:
	  return td1 == OBJ_DEF;
	case OBJ_SUB:
	  return td1 == OBJ_SUB;
	case MOD_DEF:
	  return td1 == MOD_DEF;
	case M_SUB:
	  return td1 == M_SUB;
	case M_DESC:
	  return is_type(td1, M_ID) || is_type(td1, M2_DESC);
	case M2_DESC:
	  return td1 == M2_DESC;
	case LINK_DEF:
	  return td1 == LINK_DEF;
	case LINK:
	  return td1 == LINK;
	case M_ID_PAIR:
	  return td1 == M_ID_PAIR;
	case O_TERM_PAIR:
	  return td1 == O_TERM_PAIR;
	case RULE_DEF:
	  return td1 == RULE_DEF;
	case RULE:
	  return td1 == RULE;
	case RULE_ID:
	  return td1 == RULE_ID;
	case NORMAL:
	  return td1 == NORMAL;
	case REL:
	  return td1 == REL;
	case UPDATE:
	  return td1 == UPDATE;
	case TRANSACTION:
	  return td1 == TRANSACTION;
	case PROP:
	  return td1 == PROP;
	case I_CHECK:
	  return is_type(td1, PROP) || is_type(td1, OBJ_LIST);
	case CONSIS:
	  return is_type(td1, I_CHECK);
	case INCONSIS:
	  return is_type(td1, I_CHECK);
	case CLUSTER:
	  return is_type(td1, NORMAL) || is_type(td1, REL)
	         || is_type(td1, UPDATE) || is_type(td1, TRANSACTION)
		 || is_type(td1, CONSIS) || is_type(td1, INCONSIS);
	case A_TERM:
	  return td1 == A_TERM;
	case O_TERM:
	  return is_type(td1, PROGRAM) || is_type(td1, C_O_TERM)
	         || is_type(td1, VAR) || is_type(td1, DOT)
		 || is_type(td1, LIST) || is_type(td1, NON_STRUCT);
	case LABEL:
	  return td1 == LABEL;
	case LAB:
	  return is_type(td1, IND_LAB) || is_type(td1, SET_LAB)
	         || is_type(td1, CURL_IND) || is_type(td1, CURL_SET);
	case IND_LAB:
	  return is_type(td1, LABEL);
	case SET_LAB:
	  return is_type(td1, LABEL);
	case CURL_IND:
	  return is_type(td1, LABEL);
	case CURL_SET:
	  return is_type(td1, LABEL);
	case C_O_TERM:
	  return td1 == C_O_TERM;
	case VAR:
	  return td1 == VAR;
	case DOT:
	  return td1 == DOT;
	case SUB_LIST:
	  return td1 == SUB_LIST;
	case LIST:
	  return is_type(td1, OBJ_LIST) || is_type(SUB_LIST);
	case REMAIN:
	  return is_type(td1, LIST) || is_type(td1, VAR);
	case INTEGER:
	  return td1 == INTEGER;
	case NON_STRUCT:
	  return is_type(td1, EXP_NAME) || is_type(td1, STRING)
	         || is_type(td1, INTEGER);
	case ATTR:
	  return td1 == ATTR;
	case SET:
	  return td1 == SET;
	case SORT:
	  return td1 == SORT;
	case VALUE:
	  return is_type(td1, SET) || is_type(td1, SORT)
	         || is_type(td1, O_TERM);
	case QUERY_CNSTR:
	  return td1 == QUERY_CNSTR;
	case CNSTR:
	  return td1 == CNSTR || is_type(td1, QUERY_CNSTR);
	  /* temporary */
	case QUERY:
	  return td1 == QUERY;
	case P_MODE:
	  return td1 == P_MODE;
	case A_MODE:
	  return td1 == A_MODE;
	case I_MODE:
	  return td1 == I_MODE;
	case M_MODE:
	  return td1 == M_MODE;
	case E_MODE:
	  return td1 == E_MODE;
	case Q_MODE:
	  return is_type(td1, P_MODE) || is_type(td1, A_MODE)
	         || is_type(td1, I_MODE) || is_type(td1, M_MODE)
		 || is_type(td1, E_MODE);
	case ANSWER:
	  return td1 == ANSWER;
	case ANSWER_ELEMENT:
	  return td1 == ANSWER_ELEMENT;
	case ANSE_EXPLANATION: 
	  return td1 == ANSE_EXPLANATION;
	case RIR_PAIR: 
	  return td1 == RIR_PAIR;
	case DOT_CNSTR:
	  return td1 == DOT_CNSTR;
	case VAR_CNSTR:
	  return td1 == VAR_CNSTR;
	case INHERIT:
	  return td1 == INHERIT;
	case REDUCE:
	  return td1 == REDUCE;
	case SUB_GOAL:
	  return td1 == SUB_GOAL;
	case VC_PAIR:
	  return td1 == VC_PAIR;
	case ONE_RULE:
	  return is_type(td1, REDUCE) || is_type(td1, RULE_ID)
	         || is_type(td1, QUERY);
	case UNIT_EXPLANATION:
	  return is_type(td1, ONE_RULE) || is_type(td1, INHERIT);
	case MERGE_EXPLANATION:
	  return td1 == MERGE_EXPLANATION;
	case LOOKUP_EXPLANATION:
	  return td1 == LOOKUP_EXPLANATION;
	case EXPLANATION:
	  return is_type(td1, UNIT_EXPLANATION)
	         || is_type(td1, MERGE_EXPLANATION)
		 || is_type(td1, LOOKUP_EXPLANATION);
	case CONSTRAINT:
	  return td1 == CONSTRAINT;
	case CON:
	  return td1 == CON;
	case ASSUMP:
	  return td1 == ASSUMP;
	case QUERY_EXPLANATION: 
	  return td1 == QUERY_EXPLANATION;
	case PSEUDO_OBJECT:
	  return TRUE;
	  /* for speed */
	case OBJ_LIST:
	  return td1 == OBJ_LIST;
	case OBJ_ARRAY:
	  return td1 == OBJ_ARRAY;
	default:
	  illegal_type_descriptor("is_type", td2);
	  break;
      }
}

/*
  prnt_pseudo_object:
  prints contents of pseudo_object 'object' to file 'fp' indenting
'indent' length.
  CAUTION: current version doesn't check cyclic data structure.
*/

#define MEMBER_INDENT 2

Local void put_indent(indent, fp)
     int indent;
     FILE* fp;
{
    Local /* const */ char *longBlank = "                                                                                                                                                                                                        ";
    Local int len = 0;

    if (len == 0)
      len = strlen(longBlank);
    fprintfx(fp, "\n%s", longBlank+len-indent);
}

Local int prnt_member_name(member_name, fp, indent)
     char* member_name;
     FILE* fp;
     int indent;
{
    put_indent(indent + MEMBER_INDENT, fp);
    fprintfx(fp, member_name);
    return indent + MEMBER_INDENT + strlen(member_name);
}

Local void union_tag(type_name, fp)
     char* type_name;
     FILE* fp;
{
    fprintfx(fp, "?union tag %s is used for entity?", type_name);
}

Public void prnt_program (program, fp, indent)
     Program* program;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: PROGRAM");
    new_indent = prnt_member_name("env_def: ", fp, indent);
    prnt_pseudo_object(program->env_def, fp, new_indent);
    new_indent = prnt_member_name("exp_def: ", fp, indent);
    prnt_pseudo_object(program->exp_def, fp, new_indent);
    new_indent = prnt_member_name("obj_def: ", fp, indent);
    prnt_pseudo_object(program->obj_def, fp, new_indent);
    new_indent = prnt_member_name("mod_def: ", fp, indent);
    prnt_pseudo_object(program->mod_def, fp, new_indent);
    new_indent = prnt_member_name("link_def:", fp, indent);
    prnt_pseudo_object(program->link_def, fp, new_indent);
    new_indent = prnt_member_name("rule_def:", fp, indent);
    prnt_pseudo_object(program->rule_def, fp, new_indent);
}

Public void prnt_env_def(env_def, fp, indent)
     EnvDef* env_def;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: ENV_DEF");
    prnt_member_name("name:  ", fp, indent);
    fprintfx(fp, env_def->name);
    prnt_member_name("author:", fp, indent);
    fprintfx(fp, env_def->author);
    prnt_member_name("date:  ", fp, indent);
    fprintfx(fp, env_def->date);
    new_indent = prnt_member_name("def_libs:", fp, indent);
    prnt_pseudo_object(env_def->def_libs, fp, new_indent);
}

Local void prnt_lib_lab(lib_lab, fp)
     LibLab lib_lab;
     FILE* fp;
{
    switch (lib_lab) {
      case EXPLIB:
	fprintfx(fp, "&exp_lib");
	break;
      case PGMLIB:
	fprintfx(fp, "&pgm_lib");
	break;
      case SORTLIB:
	fprintfx(fp, "&sort_lib");
	break;
      default:
	fprintfx(fp, "?unknown lib_lab value %d?", lib_lab);
	break;
    }
}

Public void prnt_def_lib(def_lib, fp, indent)
     DefLib* def_lib;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: DEF_LIB");
    prnt_member_name("library type:", fp, indent);
    prnt_lib_lab(def_lib->lib_lab, fp);
    new_indent = prnt_member_name("lib_names:", fp, indent);
    prnt_pseudo_object(def_lib->lib_names, fp, new_indent);
}

Public void prnt_string(string, fp, indent)
     String* string;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: STRING");
    prnt_member_name("string data: ", fp, indent);
    fprintfx(fp, string->str_data);
}

Public void prnt_exp_def(exp_def, fp, indent)
     ExpDef* exp_def;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: EXP_DEF");
    new_indent = prnt_member_name("exps: ", fp, indent);
    prnt_pseudo_object(exp_def->exps, fp, new_indent);
}

Public void prnt_exp(exp, fp, indent)
     Exp* exp;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: EXP");
    new_indent = prnt_member_name("exp_name:", fp, indent);
    prnt_pseudo_object(exp->exp_name, fp, new_indent);
    new_indent = prnt_member_name("o_term:  ", fp, indent);
    prnt_pseudo_object(exp->o_term, fp, new_indent);
}

Public void prnt_obj_def(obj_def, fp, indent)
     ObjDef* obj_def;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: OBJ_DEF");
    new_indent = prnt_member_name("obj_subs: ", fp, indent);
    prnt_pseudo_object(obj_def->obj_subs, fp, new_indent);
}

Public void prnt_obj_sub(obj_sub, fp, indent)
     ObjSub* obj_sub;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: OBJ_SUB");
    prnt_member_name("bobj1: ", fp, indent);
    fprintfx(fp, obj_sub->bobj1);
    prnt_member_name("bobj2: ", fp, indent);
    fprintfx(fp, obj_sub->bobj2);
}

Public void prnt_mod_def(mod_def, fp, indent)
     ModDef* mod_def;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: MOD_DEF");
    new_indent = prnt_member_name("m_subs: ", fp, indent);
    prnt_pseudo_object(mod_def->m_subs, fp, new_indent);
}

Public void prnt_m_sub(m_sub, fp, indent)
     MSub* m_sub;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: M_SUB");
    new_indent = prnt_member_name("m_id:  ", fp, indent);
    prnt_pseudo_object(m_sub->m_id, fp, indent);
    new_indent = prnt_member_name("m_desc:", fp, indent);
    prnt_pseudo_object(m_sub->m_desc, fp, indent);
}

Public void prnt_m_desc(m_desc, fp, indent)
     MDesc* m_desc;
     FILE* fp;
     int indent;
{
    if (m_desc->tag == M_DESC)
      union_tag(fp, "O_TERM");
    else
      prnt_pseudo_object(m_desc, fp, indent);
}

Public void prnt_m2_desc(m2_desc, fp, indent)
     M2Desc* m2_desc;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: M2_DESC");
    new_indent = prnt_member_name("m_desc1:", fp, indent);
    prnt_pseudo_object(m2_desc->m_desc1, fp, indent);
    prnt_member_name("operator:", fp, indent);
    putc(m2_desc->op, fp);
    new_indent = prnt_member_name("m_desc2:", fp, indent);
    prnt_pseudo_object(m2_desc->m_desc2, fp, new_indent);
}

Public void prnt_link_def(link_def, fp, indent)
     LinkDef* link_def;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: LINK_DEF");
    new_indent = prnt_member_name("links:", fp, indent);
    prnt_pseudo_object(link_def->links, fp, new_indent);
}

Public void prnt_link(link, fp, indent)
     Link* link;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: LINK");
    prnt_member_name("link name:", fp, indent);
    fprintfx(fp, link->link_name);
    new_indent = prnt_member_name("m_ids:  ", fp, indent);
    prnt_pseudo_object(link->m_ids, fp, new_indent);
    new_indent = prnt_member_name("o_terms:", fp, indent);
    prnt_pseudo_object(link->o_terms, fp, new_indent);
}

Public void prnt_m_id_pair(m_id_pair, fp, indent)
     MIdPair* m_id_pair;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: M_ID_PAIR");
    new_indent = prnt_member_name("m_id1:", fp, indent);
    prnt_pseudo_object(m_id_pair->m_id1, fp, new_indent);
    new_indent = prnt_member_name("m_id2:", fp, indent);
    prnt_pseudo_object(m_id_pair->m_id2, fp, new_indent);
}

Public void prnt_o_term_pair(o_term_pair, fp, indent)
     OTermPair* o_term_pair;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: O_TERM_PAIR");
    new_indent = prnt_member_name("o_term1:", fp, indent);
    prnt_pseudo_object(o_term_pair->o_term1, fp, new_indent);
    new_indent = prnt_member_name("o_term2:", fp, indent);
    prnt_pseudo_object(o_term_pair->o_term2, fp, new_indent);
}

Public void prnt_rule_def(rule_def, fp, indent)
     RuleDef* rule_def;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: RULE_DEF");
    new_indent = prnt_member_name("rules:", fp, indent);
    prnt_pseudo_object(rule_def->rules, fp, new_indent);
}

Local void prnt_rule_class(rule_class, fp)
     RuleClass rule_class;
     FILE* fp;
{
    switch (rule_class) {
      case NULL:
	fprintfx(fp, "&void");
	break;
      case RCNOUPDATE:
	fprintfx(fp, "&noupdate");
	break;
      case RCUPDATE:
	fprintfx(fp, "&update");
	break;
      default:
	fprintfx(fp, "?unknown rule class %d?", rule_class);
	break;
    }
}

Local void prnt_inheritance_mode(inheritance_mode, fp)
     InheritanceMode inheritance_mode;
     FILE* fp;
{
    switch (inheritance_mode) {
      case NULL:
	fprintfx(fp, "NULL");
	break;
      case IML:
	fprintfx(fp, "&l");
	break;
      case IMO:
	fprintfx(fp, "&o");
	break;
      case IMLO:
	fprintfx(fp, "&lo");
	break;
      case IMOL:
	fprintfx(fp, "&ol");
	break;
      default:
	fprintfx(fp, "?unknown rule inheritance mode %d?", inheritance_mode);
	break;
    }
}

Local void prnt_no_assume(no_assume, fp)
     NoAssume no_assume;
     FILE* fp;
{
    switch (no_assume) {
      case NULL:
	fprintfx(fp, "&void");
	break;
      case NOASSUME:
	fprintfx(fp, "yes");
	break;
      default:
	fprintfx(fp, "?unknown no-assumption mode %d?", no_assume);
	break;
    }
}

Public void prnt_rule(rule, fp, indent)
     Rule* rule;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: RULE");
    prnt_member_name("rule class:", fp, indent);
    prnt_rule_class(rule->rule_class, fp);
    new_indent = prnt_member_name("modules:  ", fp, indent);
    prnt_pseudo_object(rule->m_ids, fp, new_indent);
    new_indent = prnt_member_name("rule id:", fp, indent);
    prnt_pseudo_object(rule->rule_id, fp, new_indent);
    new_indent = prnt_member_name("inheritance mode:   ", fp,
				   indent);
    prnt_inheritance_mode(rule->inheritance_mode, fp);
    prnt_member_name("no assumption:", fp, indent);
    prnt_no_assume(rule->no_assume, fp);
    new_indent = prnt_member_name("head:", fp, indent);
    prnt_pseudo_object(rule->a_term, fp, new_indent);
    new_indent = prnt_member_name("clusters:", fp, indent);
    prnt_pseudo_object(rule->clusters, fp, new_indent);
    new_indent = prnt_member_name("constraints:",fp, indent);
    prnt_pseudo_object(rule->cnstrs, fp, new_indent);
}

Public void prnt_rule_id(rule_id, fp, indent)
     RuleId* rule_id;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: RULE_ID");
    prnt_member_name("rule id:", fp, indent);
    fprintfx(fp, rule_id->rule_id_string);
}

Public void prnt_normal(normal, fp, indent)
     Normal *normal;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: NORMAL");
    new_indent = prnt_member_name("module:", fp, indent);
    prnt_pseudo_object(normal->m_id, fp, new_indent);
    new_indent = prnt_member_name("a_term:", fp, indent);
    prnt_pseudo_object(normal->a_term, fp, new_indent);
}

Local void prnt_sub_rel(sub_rel, fp)
     CnRel sub_rel;
     FILE* fp;
{
    switch (sub_rel) {
      case NULL:
	fprintfx(fp, "&void");
	break;
      case CNLE:
	fprintfx(fp, "=<");
	break;
      case CNGE:
	fprintfx(fp, ">=");
	break;
      case CNEQ:
	fprintfx(fp, "==");
	break;
      case CNPL:
	fprintfx(fp, "+<");
	break;
      case CNPG:
	fprintfx(fp, ">+");
	break;
      case CNEPE:
	fprintfx(fp, "=+=");
	break;
      case CNIN:
	fprintfx(fp, "&in");
	break;
      case CNNI:
	fprintfx(fp, "&ni");
	break;
      default:
	fprintfx(fp, "?unknown constraint relation %d?", sub_rel);
	break;
    }
}

Public void prnt_rel(rel, fp, indent)
     Rel* rel;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: REL");
    new_indent = prnt_member_name("o_term1:", fp, indent);
    prnt_pseudo_object(rel->o_term1, fp, new_indent);
    prnt_member_name("sub_rel:", fp, indent);
    prnt_sub_rel(rel->sub_rel, fp);
    prnt_member_name("o_term2:", fp, indent);
    prnt_pseudo_object(rel->o_term2, fp, new_indent);
}

Public void prnt_update(update, fp, indent)
     Update* update;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: UPDATE");
    prnt_member_name("update flag:", fp, indent);
    fprintfx("%c", update->u_flag);
    new_indent = prnt_member_name("module:", fp, indent);
    prnt_pseudo_object(update->m_id, fp, new_indent);
    new_indent = prnt_member_name("a_term:", fp, indent);
    prnt_pseudo_object(update->a_term, fp, new_indent);
}

Local void prnt_transaction_controller(trn_data, fp)
     TrnData trn_data;
     FILE* fp;
{
    switch (trn_data) {
      case NULL:
	fprintfx(fp, "&void");
	break;
      case TDBT:
	fprintfx(fp, "&bt");
	break;
      case TDET:
	fprintfx(fp, "&et");
	break;
      case TDAT:
	fprintfx(fp, "&at");
	break;
      defaut:
	fprintfx(fp, "?unknwon transaction controller %d?", trn_data);
	break;
    }
}

Public void prnt_transaction(transaction, fp, indent)
     Transaction* transaction;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: TRANSACTION");
    prnt_member_name("transaction controller:", fp, indent);
    prnt_transaction_controller(transaction->trn_data, fp);
}

Public void prnt_prop(prop, fp, indent)
     Prop* prop;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: PROP");
    new_indent = prnt_member_name("module:", fp, indent);
    prnt_pseudo_object(prop->m_id, fp, new_indent);
    new_indent = prnt_member_name("a_term:", fp, indent);
    prnt_pseudo_object(prop->a_term, fp, new_indent);
}

Public void prnt_i_check(i_check , fp, indent)
     ICheck* i_check;
     FILE* fp;
     int indent;
{
    if (i_check->tag == I_CHECK)
      union_tag("I_CHECK", fp);
    else
      prnt_pseudo_object(i_check, fp, indent);
}

Public void prnt_cluster(cluster, fp, indent)
     Cluster* cluster;
     FILE* fp;
     int indent;
{
    if (cluster->tag == CLUSTER)
      union_tag("CLUSTER", fp);
    else
      prnt_pseudo_object(cluster, fp, indent);
}

Public void prnt_a_term(a_term, fp, indent)
     ATerm* a_term;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: A_TERM");
    new_indent = prnt_member_name("o_terms:", fp, indent);
    prnt_pseudo_object(a_term->o_term, fp, new_indent);
    new_indent = prnt_member_name("attrs:", fp, indent);
    prnt_pseudo_object(a_term->attrs, fp, new_indent);
    new_indent = prnt_member_name("cnstrs:", fp, indent);
    prnt_pseudo_object(a_term->cnstrs, fp, new_indent);
}

Public void prnt_o_term(o_term, fp, indent)
     OTerm* o_term;
     FILE* fp;
     int indent;
{
    if (o_term->tag == O_TERM)
      union_tag("O_TERM", fp);
    else
      prnt_pseudo_object(o_term, fp, indent);
}

Public void prnt_c_o_term(c_o_term, fp, indent)
     COTerm* c_o_term;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: C_O_TERM");
    prnt_member_name("head:", fp, indent);
    fprintfx(fp, c_o_term->head);
    new_indent = prnt_member_name("attrs:", fp, indent);
    prnt_pseudo_object(c_o_term->attrs, fp, new_indent);
    new_indent = prnt_member_name("cnstrs:", fp, indent);
    prnt_pseudo_object(c_o_term->cnstrs, fp, new_indent);
}

Public void prnt_dot(dot, fp, indent)
     Dot* dot;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: DOT");
    new_indent = prnt_member_name("o_term:", fp, indent);
    prnt_pseudo_object(dot->o_term, fp, new_indent);
    new_indent = prnt_member_name("label: ", fp, indent);
    prnt_pseudo_object(dot->label, fp, new_indent);
}

Public void prnt_lab(lab, fp, indent)
     Label* lab;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: LAB");
    new_indent = prnt_member_name("o_term", fp, indent);
    prnt_pseudo_object(lab->o_term, fp, new_indent);
}

Public void prnt_label(label, fp, indent)
     Label* label;
     FILE* fp;
     int indent;
{
    if (label->tag == LAB)
      union_tag("LABEL", fp);
    else
      prnt_pseudo_object(label, fp, indent);
}

Public void prnt_list(list, fp, indent)
     List* list;
     FILE* fp;
     int indent;
{
    if (list->tag == LIST)
      union_tag("LIST", fp);
    else
      prnt_pseudo_object(list, fp, indent);
}

Public void prnt_sub_list(sub_list, fp, indent)
     SubList* sub_list;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: SUB_LIST");
    new_indent = prnt_member_name("o_terms:", fp, indent);
    prnt_pseudo_object(sub_list->o_terms, fp, new_indent);
    new_indent = prnt_member_name("remain: ", fp, indent);
    prnt_pseudo_object(sub_list->remain, fp, new_indent);
}

Public void prnt_remain(remain, fp, indent)
     Remain* remain;
     FILE* fp;
     int indent;
{
    if (remain->tag == REMAIN)
      union_tag("REMAIN", fp);
    else
      prnt_pseudo_object(remain, fp, indent);
}

Public void prnt_non_struct(non_struct, fp, indent)
     NonStruct* non_struct;
     FILE* fp;
     int indent;
{
    if (non_struct->tag == NON_STRUCT)
      union_tag("NON_STRUCT", fp);
    else
      prnt_pseudo_object(non_struct, fp, indent);
}

Public void prnt_exp_name(exp_name, fp, indent)
     ExpName* exp_name;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: EXP_NAME");
    prnt_member_name("name:", fp, indent);
    fprintfx(fp, exp_name->name);
}

Public void prnt_integer(integer, fp, indent)
     Integer* integer;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: INTEGER");
    prnt_member_name("value:", fp, indent);
    fprintfx(fp, "%d", integer->value);
}

Local void prnt_attr_op(attr_op, fp)
     AttrOp attr_op;
     FILE* fp;
{
    switch (attr_op) {
      case ATRARROW:
	fprintfx(fp, " ->");
	break;
      case ATLARROW:
	fprintfx(fp, " <-");
	break;
      case ATEQ:
	fprintfx(fp, " =");
	break;
      default:
	fprintfx(fp, "?unknwon attribute operator %d?", attr_op);
	break;
    }
}

Public void prnt_attr(attr, fp, indent)
     Attr* attr;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: ATTR");
    new_indent = prnt_member_name("label:", fp, indent);
    prnt_pseudo_object(attr->label, fp, new_indent);
    prnt_member_name("attr op:", fp, indent);
    prnt_attr_op(attr->attr_op, fp);
    new_indent = prnt_member_name("value:", fp, indent);
    prnt_pseudo_object(attr->value, fp, new_indent);
}

Public void prnt_value(value, fp, indent)
     Value* value;
     FILE* fp;
     int indent;
{
    if (value->tag == VALUE)
      union_tag("VALUE", fp);
    else
      prnt_pseudo_object(value, fp, indent);
}

Public void prnt_set(set, fp, indent)
     Set* set;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: SET");
    new_indent = prnt_member_name("oterms: ", fp, indent);
    prnt_pseudo_object(set->o_terms, fp, new_indent);
}

Public void prnt_cnstr(cnstr, fp, indent)
     Cnstr* cnstr;
     FILE* fp;
     int indent;
{
    if (cnstr->tag == CNSTR)
      union_tag("CNSTR", fp);
    else
      prnt_pseudo_object(cnstr, fp, indent);
}

Local void prnt_rel_op(rel, fp)
     CnRel rel;
     FILE* fp;
{
    switch (rel) {
      case CNLE:
	fprintfx(fp, " =<");
	break;
      case CNGE:
	fprintfx(fp, " >=");
	break;
      case CNEQ:
	fprintfx(fp, " ==");
	break;
      case CNPL:
	fprintfx(fp, " +<");
	break;
      case CNPG:
	fprintfx(fp, " >+");
	break;
      case CNEPE:
	fprintfx(fp, " =+=");
	break;
      case CNIN:
	fprintfx(fp, " &in");
	break;
      case CNNI:
	fprintfx(fp, " &ni");
	break;
      default:
	fprintfx(fp, "?unknwon constraint relation %d?", rel);
	break;
    }
}

Public void prnt_cnstr_data(cnstr_data, fp, indent)
     CnstrData* cnstr_data;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: CNSTR_DATA");
    new_indent = prnt_member_name("module 1:", fp, indent);
    prnt_pseudo_object(cnstr_data->m_id1, fp, new_indent);
    new_indent = prnt_member_name("value 1: ", fp, indent);
    prnt_pseudo_object(cnstr_data->value1, fp, new_indent);
    new_indent = prnt_member_name("relation:", fp, indent);
    prnt_rel_op(cnstr_data->rel, fp);
    new_indent = prnt_member_name("module 2:", fp, indent);
    prnt_pseudo_object(cnstr_data->m_id2, fp, new_indent);
    new_indent = prnt_member_name("value 2: ", fp, indent);
    prnt_pseudo_object(cnstr_data->value2, fp, new_indent);
}

Public void prnt_query_cnstr(query_cnstr, fp, indent)
     QueryCnstr* query_cnstr;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: QUERY_CNSTR");
    new_indent = prnt_member_name("module 1:", fp, indent);
    prnt_pseudo_object(query_cnstr->m_id1, fp, new_indent);
    new_indent = prnt_member_name("module 2:", fp, indent);
    prnt_pseudo_object(query_cnstr->m_id2, fp, new_indent);
}

Local void prnt_var_type(type, fp)
     VarType type;
     FILE* fp;
{
    switch (type) {
      case VARIND:
	fprintfx(fp, "individual var");
	break;
      case VARSET:
	fprintfx(fp, "set var");
	break;
      default:
	fprintfx(fp, "?unknwon variable type %d?", type);
	break;
    }
}

Public void prnt_var(var, fp, indent)
     Var* var;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: VAR");
    prnt_member_name("var-type: ", fp, indent);
    prnt_var_type(var->type, fp);
    prnt_member_name("var name: ", fp, indent);
    fprintfx(fp, var->var_data);
}

Public void prnt_sort(sort, fp, indent)
     Sort* sort;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: SORT");
    new_indent = prnt_member_name("prolog: ", fp, indent);
    prnt_pseudo_object(sort->prolog, fp, new_indent);
}

Public void prnt_query(query, fp, indent)
     Query* query;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: QUERY");
    prnt_member_name("query_class: ", fp, indent);
    prnt_rule_class(query->query_class, fp);
    prnt_member_name("q_head: ", fp, indent);
    prnt_rule_class(query->q_head, fp);
    new_indent = prnt_member_name("clusters: ", fp, indent);
    prnt_pseudo_object(query->clusters, fp, new_indent);
    new_indent = prnt_member_name("cnstrs:   ", fp, indent);
    prnt_pseudo_object(query->cnstrs, fp, new_indent);
    new_indent = prnt_member_name("q_modes:  ", fp, indent);
    prnt_pseudo_object(query->q_modes, fp, new_indent);
    new_indent = prnt_member_name("program:  ", fp, indent);
    prnt_pseudo_object(query->program, fp, new_indent);
}

Public void prnt_q_mode(q_mode, fp, indent)
     QMode* q_mode;
     FILE* fp;
     int indent;
{
    if (q_mode->tag == Q_MODE)
      union_tag("Q_MODE", fp);
    else
      prnt_pseudo_object(q_mode, fp, indent);
}

Local prnt_p_mode_data(p_mode_data, fp)
     PModeData p_mode_data;
     FILE* fp;
{
    switch (p_mode_data) {
      case PSINGLE:
	fprintfx(fp, "&single");
	break;
      case PMULTI:
	fprintfx(fp, "&multi");
	break;
      default:
	fprintfx(fp, "?unknown process mode value %d?", p_mode_data);
	break;
    }
}

Public void prnt_p_mode(p_mode, fp, indent)
     PMode* p_mode;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: P_MODE");
    prnt_member_name("p_mode_data: ", fp, indent);
    prnt_p_mode_data(p_mode->p_mode_data, fp);
}

Local void prnt_a_mode_data(a_mode_data, fp)
     AModeData a_mode_data;
     FILE* fp;
{
    switch (a_mode_data) {
      case ANORMAL:
	fprintfx(fp, "&normal");
	break;
      case AMINIMAL:
	fprintfx(fp, "&minimal");
	break;
      default:
	fprintfx(fp, "?unknown answer mode value %d?", a_mode_data);
	break;
    }
}

Public void prnt_a_mode(a_mode, fp, indent)
     AMode* a_mode;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: A_MODE");
    prnt_member_name("a_mode_data: ", fp, indent);
    prnt_a_mode_data(a_mode->a_mode_data, fp);
}

Local void prnt_i_mode_data(i_mode_data, fp)
     IModeData i_mode_data;
     FILE* fp;
{
    switch (i_mode_data) {
      case IALL:
	fprintfx(fp, "&all");
	break;
      case IDOWN:
	fprintfx(fp, "&down");
	break;
      case IUP:
	fprintfx(fp, "&up");
	break;
      case INO:
	fprintfx(fp, "&no");
	break;
      default:
	fprintfx(fp, "?unknown inheritance mode value %d?", i_mode_data);
	break;
    }
}

Public void prnt_i_mode(i_mode, fp, indent)
     IMode *i_mode;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: I_MODE");
    prnt_member_name("i_mode_data: ", fp, indent);
    prnt_i_mode_data(i_mode->i_mode_data, fp);
}

Local void prnt_m_mode_data(m_mode_data, fp)
     MModeData m_mode_data;
     FILE* fp;
{
    switch (m_mode_data) {
      case MYES:
	fprintfx(fp, "&yes");
	break;
      case MNO:
	fprintfx(fp, "&no");
	break;
      default:
	fprintfx(fp, "?unknown merge mode value %d?", m_mode_data);
	break;
    }
}

Public void prnt_m_mode(m_mode, fp, indent)
     MMode* m_mode;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: M_MODE");
    prnt_member_name("m_mode_data: ", fp, indent);
    prnt_m_mode_data(m_mode->m_mode_data, fp);
}

Local void prnt_e_mode_data(e_mode_data, fp)
     EModeData e_mode_data;
     FILE* fp;
{
    switch (e_mode_data) {
      case EON:
	fprintfx(fp, "&on");
	break;
      case EOFF:
	fprintfx(fp, "&off");
	break;
      default:
	fprintfx(fp, "?unknown explanation mode value %d?", e_mode_data);
	break;
    }
}

Public void prnt_e_mode(e_mode, fp, indent)
     EMode* e_mode;
     FILE* fp;
     int indent;
{
    fprintfx(fp, "type: E_MODE");
    prnt_member_name("e_mode_data: ", fp, indent);
    prnt_e_mode_data(e_mode->e_mode_data, fp);
}

Public void prnt_answer(answer, fp, indent)
     Answer* answer;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: ANSWER");
    prnt_member_name("answer_elements: ", fp, indent);
    prnt_pseudo_object(answer->answer_elements, fp, new_indent);
}

Public void prnt_answer_element(answer_element, fp, indent)
     AnswerElement* answer_element;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: ANSWER_ELEMENT");
    new_indent = prnt_member_name("dot_cnstrs: ", fp, indent);
    prnt_pseudo_object(answer_element->dot_cnstrs, fp, new_indent);
    new_indent = prnt_member_name("var_cnstrs: ", fp, indent);
    prnt_pseudo_object(answer_element->var_cnstrs, fp, new_indent);
    new_indent = prnt_member_name("anse_explanation:", fp, indent);
    prnt_pseudo_object(answer_element->anse_explanation, fp, new_indent);
}

Public void prnt_anse_explanation(anse_explanation, fp, indent)
     AnseExplanation* anse_explanation;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: ANSE_EXPLANATION");
    new_indent = prnt_member_name("explanation:", fp, indent);
    prnt_pseudo_object(anse_explanation->explanation, fp, new_indent);
    new_indent = prnt_member_name("rir_pairs:     ", fp, indent);
    prnt_pseudo_object(anse_explanation->rir_pairs, fp, new_indent);
}

Public void prnt_rir_pair(rir_pair, fp, indent)
     RirPair* rir_pair;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: RIR_PAIR");
    new_indent = prnt_member_name("rule_id:", fp, indent);
    prnt_pseudo_object(rir_pair->rule_id, fp, new_indent);
    new_indent = prnt_member_name("rule:     ", fp, indent);
    prnt_pseudo_object(rir_pair->rule, fp, new_indent);
}

Public void prnt_dot_cnstr(dot_cnstr, fp, indent)
     DotCnstr* dot_cnstr;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: DOT_CNSTR");
    new_indent = prnt_member_name("m_id:  ", fp, indent);
    prnt_pseudo_object(dot_cnstr->m_id, fp, new_indent);
    new_indent = prnt_member_name("dot:   ", fp, indent);
    prnt_pseudo_object(dot_cnstr->dot, fp, new_indent);
    new_indent = prnt_member_name("rel:   ", fp, indent);
    prnt_pseudo_object(dot_cnstr->rel, fp, new_indent);
    new_indent = prnt_member_name("o-term:", fp, indent);
    prnt_pseudo_object(dot_cnstr->value, fp, new_indent);
}

Public void prnt_var_cnstr(var_cnstr, fp, indent)
     VarCnstr* var_cnstr;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: VAR_CNSTR");
    new_indent = prnt_member_name("var:   ", fp, indent);
    prnt_pseudo_object(var_cnstr->var, fp, new_indent);
    new_indent = prnt_member_name("rel:   ", fp, indent);
    prnt_pseudo_object(var_cnstr->rel, fp, new_indent);
    new_indent = prnt_member_name("o_term:", fp, indent);
    prnt_pseudo_object(var_cnstr->value, fp, new_indent);
}

Public void prnt_explanation(explanation, fp, indent)
     Explanation* explanation;
     FILE* fp;
     int indent;
{
    if (explanation->tag == EXPLANATION)
      union_tag("EXPLANATION", fp);
    else
      prnt_pseudo_object(explanation, fp, indent);
}

Public void prnt_unit_explanation(unit_explanation, fp, indent)
     UnitExplanation* unit_explanation;
     FILE* fp;
     int indent;
{
    if (unit_explanation->tag == UNIT_EXPLANATION)
      union_tag("UNIT_EXPLANATION", fp);
    else
      prnt_pseudo_object(unit_explanation, fp, indent);
}

Public void prnt_inherit(inherit, fp, indent)
     Inherit* inherit;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: INHERIT");
    new_indent = prnt_member_name("one_rule:", fp, indent);
    prnt_pseudo_object(inherit->one_rule, fp, new_indent);
    new_indent = prnt_member_name("ups:     ", fp, indent);
    prnt_pseudo_object(inherit->ups, fp, new_indent);
    new_indent = prnt_member_name("downs:   ", fp, indent);
    prnt_pseudo_object(inherit->downs, fp, new_indent);
}

Public void prnt_merge_explanation(merge_explanation, fp, indent)
     MergeExplanation* merge_explanation;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: MERGE_EXPLANATION");
    new_indent = prnt_member_name("unit explanations: ", fp, indent);
    prnt_pseudo_object(merge_explanation->unit_explanations, fp,
			new_indent);
}

Public void prnt_lookup_explanation(lookup_explanation, fp, indent)
     LookupExplanation* lookup_explanation;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: LOOKUP_EXPLANATION");
    new_indent = prnt_member_name("subgoal:        ", fp, indent);
    prnt_pseudo_object(lookup_explanation->sub_goal, fp, new_indent);
    new_indent = prnt_member_name("looked subgoal: ", fp, indent);
    prnt_pseudo_object(lookup_explanation->looked_s, fp, new_indent);
    new_indent = prnt_member_name("looking subgoal:", fp, indent);
    prnt_pseudo_object(lookup_explanation->looking_s, fp,
			new_indent);
    new_indent = prnt_member_name("explanation    :", fp, indent);
    prnt_pseudo_object(lookup_explanation->explanation, fp, new_indent);
}

Public void prnt_one_rule(one_rule, fp, indent)
     OneRule* one_rule;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: ONE_RULE");
    new_indent = prnt_member_name("reduce: ", fp, indent);
    prnt_pseudo_object(one_rule->reduce, fp, new_indent);
    new_indent = prnt_member_name("rule ID:", fp, indent);
    prnt_pseudo_object(one_rule->rule_id, fp, new_indent);
    new_indent = prnt_member_name("query:  ", fp, indent);
    prnt_pseudo_object(one_rule->query, fp, new_indent);
}

Public void prnt_reduce(reduce, fp, indent)
     Reduce* reduce;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: REDUCE");
    new_indent = prnt_member_name("subgoal:     ", fp, indent);
    prnt_pseudo_object(reduce->sub_goal, fp, new_indent);
    new_indent = prnt_member_name("rule ID:     ", fp, indent);
    prnt_pseudo_object(reduce->rule_id, fp, new_indent);
    new_indent = prnt_member_name("explanations:", fp, indent);
    prnt_pseudo_object(reduce->explanations, fp, new_indent);
    new_indent = prnt_member_name("assumption:  ", fp, indent);
    prnt_pseudo_object(reduce->assumps, fp, new_indent);
}

Public void prnt_sub_goal(subgoal, fp, indent)
     SubGoal* subgoal;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: SUB_GOAL");
    new_indent = prnt_member_name("m_id:    ", fp, indent);
    prnt_pseudo_object(subgoal->m_id, fp, new_indent);
    new_indent = prnt_member_name("o_term:  ", fp, indent);
    prnt_pseudo_object(subgoal->o_term, fp, new_indent);
    new_indent = prnt_member_name("vc_pairs:", fp, indent);
    prnt_pseudo_object(subgoal->vc_pairs, fp, new_indent);
}

Public void prnt_vc_pair(vc_pair, fp, indent)
     VcPair* vc_pair;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: VC_PAIR");
    new_indent = prnt_member_name("var:       ", fp, indent);
    prnt_pseudo_object(vc_pair->var, fp, new_indent);
    new_indent = prnt_member_name("constraint:", fp, indent);
    prnt_pseudo_object(vc_pair->constraint, fp, new_indent);
}

Public void prnt_constraint(constraint, fp, indent)
     Constraint* constraint;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: ");
    new_indent = prnt_member_name("constraint data: ", fp, indent);
    prnt_pseudo_object(constraint->const_data, fp, new_indent);
}

Public void prnt_con(con, fp, indent)
     Con* con;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: CON");
    new_indent = prnt_member_name("o_terms1: ", fp, indent);
    prnt_pseudo_object(con->o_terms1, fp, new_indent);
    new_indent = prnt_member_name("o_terms2: ", fp, indent);
    prnt_pseudo_object(con->o_terms2, fp, new_indent);
}

Public void prnt_assump(assump, fp, indent)
     Assump* assump;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: ASSUMP");
    new_indent = prnt_member_name("m_id:    ", fp, indent);
    prnt_pseudo_object(assump->m_id, fp, new_indent);
    new_indent = prnt_member_name("dot:     ", fp, indent);
    prnt_pseudo_object(assump->dot, fp, new_indent);
    new_indent = prnt_member_name("vc_pairs:", fp, indent);
    prnt_pseudo_object(assump->vc_pairs, fp, new_indent);
}

Public void prnt_query_explanation(query_explanation, fp, indent)
     QueryExplanation* query_explanation;
     FILE* fp;
     int indent;
{
    int new_indent;

    fprintfx(fp, "type: QUERY_EXPLANATION");
    new_indent = prnt_member_name("str_data:    ", fp, indent);
    fprintfx(fp, query_explanation->str_data);
}

Public void prnt_obj_list(obj_list, fp, indent)
     ObjList* obj_list;
     FILE* fp;
     int indent;
{
    int new_indent;
    ObjElement* p = obj_list->first;

    fprintfx(fp, "type: OBJ_LIST");
    new_indent = prnt_member_name("element_tag: ", fp, indent);
    prnt_pseudo_object(obj_list->element_tag, fp, new_indent);
    while (p != NULL) {
	new_indent = prnt_member_name("element: ", fp, indent);
	prnt_pseudo_object(p->element, fp, new_indent);
	p = p->next;
    }
}

Public void prnt_obj_array(obj_array, fp, indent)
     ObjArray* obj_array;
     FILE* fp;
     int indent;
{
    int new_indent;
    int i;
    char *string;

    fprintfx(fp, "type: OBJ_ARRAY");
    new_indent = prnt_member_name("element_tag: ", fp, indent);
    prnt_pseudo_object(obj_array->element_tag, fp, new_indent);
    new_indent = prnt_member_name("size:        ", fp, indent);
    prnt_pseudo_object(obj_array->size, fp, new_indent);
    string = dotsrc_malloc(strlen("elements") + 2 +
			   (int)log10(obj_array->size) + 1 + 1);
    for (i = 0; i < obj_array->size; ++i) {
	sprintf(string, "elements[%d]", i);
	new_indent = prnt_member_name(string, fp, indent);
	prnt_pseudo_object(obj_array->elements[i], fp, new_indent);
    }
}

static void p_pseudo_object(object, fp, indent)
     PseudoObject* object;
     FILE* fp;
     int indent;
{
    switch (object->tag) {
      case PROGRAM:
	prnt_program((Program*)object, fp, indent);
	break;
      case DEF_LIB:
	prnt_def_lib((DefLib*)object, fp, indent);
	break;
      case STRING:
	prnt_string((String*)object, fp, indent);
	break;
      case EXP_DEF:
	prnt_exp_def((ExpDef*)object, fp, indent);
	break;
      case EXP:
	prnt_exp((Exp*)object, fp, indent);
	break;
      case EXP_NAME:
	prnt_exp_name((ExpName*)object, fp, indent);
	break;
      case OBJ_DEF:
	prnt_obj_def((ObjDef*)object, fp, indent);
	break;
      case OBJ_SUB:
	prnt_obj_sub((ObjSub*)object, fp, indent);
	break;
      case MOD_DEF:
	prnt_mod_def((ModDef*)object, fp, indent);
	break;
      case M_SUB:
	prnt_m_sub((MSub*)object, fp, indent);
	break;
      case M_DESC:
	prnt_m_desc((MDesc*)object, fp, indent);
	break;
      case M2_DESC:
	prnt_m2_desc((M2Desc*)object, fp, indent);
	break;
      case LINK_DEF:
	prnt_link_def((LinkDef*)object, fp, indent);
	break;
      case LINK:
	prnt_link((Link*)object, fp, indent);
	break;
      case M_ID_PAIR:
	prnt_m_id_pair((MIdPair*)object, fp, indent);
	break;
      case O_TERM_PAIR:
	prnt_o_term_pair((OTermPair*)object, fp, indent);
	break;
      case RULE_DEF:
	prnt_rule_def((RuleDef*)object, fp, indent);
	break;
      case RULE:
	prnt_rule((Rule*)object, fp, indent);
	break;
      case RULE_ID:
	prnt_rule_id((RuleId*)object, fp, indent);
	break;
      case NORMAL:
	prnt_normal((Normal*)object, fp, indent);
	break;
      case REL:
	prnt_rel((Rel*)object, fp, indent);
	break;
      case UPDATE:
	prnt_update((Update*)object, fp, indent);
	break;
      case TRANSACTION:
	prnt_transaction((Transaction*)object, fp, indent);
	break;
      case PROP:
	prnt_prop((Prop*)object, fp, indent);
	break;
      case I_CHECK:
	prnt_i_check((ICheck*)object, fp, indent);
	break;
      case CLUSTER:
	prnt_cluster((Cluster*)object, fp, indent);
	break;
      case A_TERM:
	prnt_a_term((ATerm*)object, fp, indent);
	break;
      case O_TERM:
	prnt_o_term((OTerm*)object, fp, indent);
	break;
      case LABEL:
	prnt_label((Label*)object, fp, indent);
	break;
      case LAB:
	prnt_lab((Label*)object, fp, indent);
	break;
      case C_O_TERM:
	prnt_c_o_term((COTerm*)object, fp, indent);
	break;
      case VAR:
	prnt_var((Var*)object, fp, indent);
	break;
      case DOT:
	prnt_dot((Dot*)object, fp, indent);
	break;
      case SUB_LIST:
	prnt_sub_list((SubList*)object, fp, indent);
	break;
      case LIST:
	prnt_list((List*)object, fp, indent);
	break;
      case REMAIN:
	prnt_remain((Remain*)object, fp, indent);
	break;
      case INTEGER:
	prnt_integer((Integer*)object, fp, indent);
	break;
      case NON_STRUCT:
	prnt_non_struct((NonStruct*)object, fp, indent);
	break;
      case ATTR:
	prnt_attr((Attr*)object, fp, indent);
	break;
      case SET:
	prnt_set((Set*)object, fp, indent);
	break;
      case SORT:
	prnt_sort((Sort*)object, fp, indent);
	break;
      case VALUE:
	prnt_value((Value*)object, fp, indent);
	break;
      case QUERY_CNSTR:
	prnt_query_cnstr((QueryCnstr*)object, fp, indent);
	break;
      case CNSTR:
	prnt_cnstr((Cnstr*)object, fp, indent);
	break;
      case CNSTR_DATA:
	prnt_cnstr_data((Cnstr*)object, fp, indent);
	break;
      case QUERY:
	prnt_query((Query*)object, fp, indent);
	break;
      case P_MODE:
	prnt_p_mode((PMode*)object, fp, indent);
	break;
      case A_MODE:
	prnt_a_mode((AMode*)object, fp, indent);
	break;
      case I_MODE:
	prnt_i_mode((IMode*)object, fp, indent);
	break;
      case M_MODE:
	prnt_m_mode((MMode*)object, fp, indent);
	break;
      case E_MODE:
	prnt_e_mode((EMode*)object, fp, indent);
	break;
      case Q_MODE:
	prnt_q_mode((QMode*)object, fp, indent);
	break;
      case ANSWER:
	prnt_answer((Answer*)object, fp, indent);
	break;
      case ANSWER_ELEMENT:
	prnt_answer_element((AnswerElement*)object, fp, indent);
	break;
      case ANSE_EXPLANATION: 
	prnt_anse_explanation((AnseExplanation*)object, fp, indent);
	break;
      case RIR_PAIR: 
	prnt_rir_pair((RirPair*)object, fp, indent);
	break;
      case DOT_CNSTR:
	prnt_dot_cnstr((DotCnstr*)object, fp, indent);
	break;
      case VAR_CNSTR:
	prnt_var_cnstr((VarCnstr*)object, fp, indent);
	break;
      case INHERIT:
	prnt_inherit((Inherit*)object, fp, indent);
	break;
      case REDUCE:
	prnt_reduce((Reduce*)object, fp, indent);
	break;
      case SUB_GOAL:
	prnt_sub_goal((SubGoal*)object, fp, indent);
	break;
      case VC_PAIR:
	prnt_vc_pair((VcPair*)object, fp, indent);
	break;
      case ONE_RULE:
	prnt_one_rule((OneRule*)object, fp, indent);
	break;
      case UNIT_EXPLANATION:
	prnt_unit_explanation((UnitExplanation*)object, fp, indent);
	break;
      case MERGE_EXPLANATION:
	prnt_merge_explanation((MergeExplanation*)object, fp, indent);
	break;
      case LOOKUP_EXPLANATION:
	prnt_lookup_explanation((LookupExplanation*)object, fp, indent);
	break;
      case EXPLANATION:
	prnt_explanation((Explanation*)object, fp, indent);
	break;
      case CONSTRAINT:
	prnt_constraint((Constraint*)object, fp, indent);
	break;
      case CON:
	prnt_con((Con*)object, fp, indent);
	break;
      case ASSUMP:
	prnt_assump((Assump*)object, fp, indent);
	break;
      case QUERY_EXPLANATION: 
	prnt_query_explanation((QueryExplanation*)object, fp, indent);
	break;
      case PSEUDO_OBJECT:
	union_tag("PSEUDO_OBJECT", fp);
	break;
      case OBJ_LIST:
	prnt_obj_list((ObjList*)object, fp, indent);
	break;
      case OBJ_ARRAY:
	prnt_obj_array((ObjArray*)object, fp, indent);
	break;
      case NULL:
	break;
      default:
	illegal_type_descriptor("prnt_pseudo_object", object->tag);
	break;
    }
}

/*
  delete_pseudo_object:
  eliminate an any type of pseudo object.
*/

static void delete_pseudo_object(object)
     PseudoObject* object;
{
    switch (object->tag) {
      case PROGRAM:
	delete_program((Program*)object);
	break;
      case DEF_LIB:
	delete_def_lib((DefLib*)object);
	break;
      case STRING:
	delete_string((String*)object);
	break;
      case EXP_DEF:
	delete_exp_def((ExpDef*)object);
	break;
      case EXP:
	delete_exp((Exp*)object);
	break;
      case EXP_NAME:
	delete_exp_name((ExpName*)object);
	break;
      case OBJ_DEF:
	delete_obj_def((ObjDef*)object);
	break;
      case OBJ_SUB:
	delete_obj_sub((ObjSub*)object);
	break;
      case MOD_DEF:
	delete_mod_def((ModDef*)object);
	break;
      case M_SUB:
	delete_m_sub((MSub*)object);
	break;
      case M_DESC:
	delete_m_desc((MDesc*)object);
	break;
      case M2_DESC:
	delete_m2_desc((M2Desc*)object);
	break;
      case LINK_DEF:
	delete_link_def((LinkDef*)object);
	break;
      case LINK:
	delete_link((Link*)object);
	break;
      case M_ID_PAIR:
	delete_m_id_pair((MIdPair*)object);
	break;
      case O_TERM_PAIR:
	delete_o_term_pair((OTermPair*)object);
	break;
      case RULE_DEF:
	delete_rule_def((RuleDef*)object);
	break;
      case RULE:
	delete_rule((Rule*)object);
	break;
      case RULE_ID:
	delete_rule_id((RuleId*)object);
	break;
      case NORMAL:
	delete_normal((Normal*)object);
	break;
      case REL:
	delete_rel((Rel*)object);
	break;
      case UPDATE:
	delete_update((Update*)object);
	break;
      case TRANSACTION:
	delete_transaction((Transaction*)object);
	break;
      case PROP:
	delete_prop((Prop*)object);
	break;
      case I_CHECK:
	delete_i_check((ICheck*)object);
	break;
      case CLUSTER:
	delete_cluster((Cluster*)object);
	break;
      case A_TERM:
	delete_a_term((ATerm*)object);
	break;
      case O_TERM:
	delete_o_term((OTerm*)object);
	break;
      case LABEL:
	delete_label((Label*)object);
	break;
      case LAB:
	delete_label((Label*)object);
	break;
      case C_O_TERM:
	delete_c_o_term((COTerm*)object);
	break;
      case VAR:
	delete_var((Var*)object);
	break;
      case DOT:
	delete_dot((Dot*)object);
	break;
      case SUB_LIST:
	delete_sub_list((SubList*)object);
	break;
      case LIST:
	delete_list((List*)object);
	break;
      case REMAIN:
	delete_remain((Remain*)object);
	break;
      case INTEGER:
	delete_integer((Integer*)object);
	break;
      case NON_STRUCT:
	delete_non_struct((NonStruct*)object);
	break;
      case ATTR:
	delete_attr((Attr*)object);
	break;
      case SET:
	delete_set((Set*)object);
	break;
      case SORT:
	delete_sort((Sort*)object);
	break;
      case VALUE:
	delete_value((Value*)object);
	break;
      case QUERY_CNSTR:
	delete_query_cnstr((QueryCnstr*)object);
	break;
      case CNSTR:
	delete_cnstr((Cnstr*)object);
	break;
      case QUERY:
	delete_query((Query*)object);
	break;
      case P_MODE:
	delete_p_mode((PMode*)object);
	break;
      case A_MODE:
	delete_a_mode((AMode*)object);
	break;
      case I_MODE:
	delete_i_mode((IMode*)object);
	break;
      case M_MODE:
	delete_m_mode((MMode*)object);
	break;
      case E_MODE:
	delete_e_mode((EMode*)object);
	break;
      case Q_MODE:
	delete_q_mode((QMode*)object);
	break;
      case ANSWER:
	delete_answer((Answer*)object);
	break;
      case ANSWER_ELEMENT:
	delete_answer_element((AnswerElement*)object);
	break;
      case ANSE_EXPLANATION: 
	delete_anse_explanation((AnseExplanation*)object);
	break;
      case RIR_PAIR: 
	delete_rir_pair((RirPair*)object);
	break;
      case DOT_CNSTR:
	delete_dot_cnstr((DotCnstr*)object);
	break;
      case VAR_CNSTR:
	delete_var_cnstr((VarCnstr*)object);
	break;
      case INHERIT:
	delete_inherit((Inherit*)object);
	break;
      case REDUCE:
	delete_reduce((Reduce*)object);
	break;
      case SUB_GOAL:
	delete_sub_goal((SubGoal*)object);
	break;
      case VC_PAIR:
	delete_vc_pair((VcPair*)object);
	break;
      case ONE_RULE:
	delete_one_rule((OneRule*)object);
	break;
      case UNIT_EXPLANATION:
	delete_unit_explanation((UnitExplanation*)object);
	break;
      case MERGE_EXPLANATION:
	delete_merge_explanation((MergeExplanation*)object);
	break;
      case LOOKUP_EXPLANATION:
	delete_lookup_explanation((LookupExplanation*)object);
	break;
      case EXPLANATION:
	delete_explanation((Explanation*)object);
	break;
      case CONSTRAINT:
	delete_constraint((Constraint*)object);
	break;
      case CON:
	delete_con((Con*)object);
	break;
      case ASSUMP:
	delete_assump((Assump*)object);
	break;
      case QUERY_EXPLANATION: 
	delete_query_explanation((QueryExplanation*)object);
	break;
      case PSEUDO_OBJECT:
	union_tag("PSEUDO_OBJECT", stderr);
	exit(2);
	break;
      case OBJ_LIST:
	delete_obj_list((ObjList*)object);
	break;
      case OBJ_ARRAY:
	delete_obj_array((ObjArray*)object);
	break;
      default:
	illegal_type_descriptor("delete_pseudo_object", object->tag);
	break;
    }
}

/*
  copy_pseudo_object:
  eliminate an any type of pseudo object.
*/

static PseudoObject* copy_pseudo_object(object)
     PseudoObject* object;
{
    switch (object->tag) {
      case PROGRAM:
	return (PseudoObject*)copy_program((Program*)object);
      case DEF_LIB:
	return (PseudoObject*)copy_def_lib((DefLib*)object);
      case STRING:
	return (PseudoObject*)copy_string((String*)object);
      case EXP_DEF:
	return (PseudoObject*)copy_exp_def((ExpDef*)object);
      case EXP:
	return (PseudoObject*)copy_exp((Exp*)object);
      case EXP_NAME:
	return (PseudoObject*)copy_exp_name((ExpName*)object);
      case OBJ_DEF:
	return (PseudoObject*)copy_obj_def((ObjDef*)object);
      case OBJ_SUB:
	return (PseudoObject*)copy_obj_sub((ObjSub*)object);
      case MOD_DEF:
	return (PseudoObject*)copy_mod_def((ModDef*)object);
      case M_SUB:
	return (PseudoObject*)copy_m_sub((MSub*)object);
      case M_DESC:
	return (PseudoObject*)copy_m_desc((MDesc*)object);
      case M2_DESC:
	return (PseudoObject*)copy_m2_desc((M2Desc*)object);
      case LINK_DEF:
	return (PseudoObject*)copy_link_def((LinkDef*)object);
      case LINK:
	return (PseudoObject*)copy_link((Link*)object);
      case M_ID_PAIR:
	return (PseudoObject*)copy_m_id_pair((MIdPair*)object);
      case O_TERM_PAIR:
	return (PseudoObject*)copy_o_term_pair((OTermPair*)object);
      case RULE_DEF:
	return (PseudoObject*)copy_rule_def((RuleDef*)object);
      case RULE:
	return (PseudoObject*)copy_rule((Rule*)object);
      case RULE_ID:
	return (PseudoObject*)copy_rule_id((RuleId*)object);
      case NORMAL:
	return (PseudoObject*)copy_normal((Normal*)object);
      case REL:
	return (PseudoObject*)copy_rel((Rel*)object);
      case UPDATE:
	return (PseudoObject*)copy_update((Update*)object);
      case TRANSACTION:
	return (PseudoObject*)copy_transaction((Transaction*)object);
      case PROP:
	return (PseudoObject*)copy_prop((Prop*)object);
      case I_CHECK:
	return (PseudoObject*)copy_i_check((ICheck*)object);
      case CLUSTER:
	return (PseudoObject*)copy_cluster((Cluster*)object);
      case A_TERM:
	return (PseudoObject*)copy_a_term((ATerm*)object);
      case O_TERM:
	return (PseudoObject*)copy_o_term((OTerm*)object);
      case LABEL:
	return (PseudoObject*)copy_label((Label*)object);
      case LAB:
	return (PseudoObject*)copy_label((Label*)object);
      case C_O_TERM:
	return (PseudoObject*)copy_c_o_term((COTerm*)object);
      case VAR:
	return (PseudoObject*)copy_var((Var*)object);
      case DOT:
	return (PseudoObject*)copy_dot((Dot*)object);
      case SUB_LIST:
	return (PseudoObject*)copy_sub_list((SubList*)object);
      case LIST:
	return (PseudoObject*)copy_list((List*)object);
      case REMAIN:
	return (PseudoObject*)copy_remain((Remain*)object);
      case INTEGER:
	return (PseudoObject*)copy_integer((Integer*)object);
      case NON_STRUCT:
	return (PseudoObject*)copy_non_struct((NonStruct*)object);
      case ATTR:
	return (PseudoObject*)copy_attr((Attr*)object);
      case SET:
	return (PseudoObject*)copy_set((Set*)object);
      case SORT:
	return (PseudoObject*)copy_sort((Sort*)object);
      case VALUE:
	return (PseudoObject*)copy_value((Value*)object);
      case QUERY_CNSTR:
	return (PseudoObject*)copy_query_cnstr((QueryCnstr*)object);
      case CNSTR:
	return (PseudoObject*)copy_cnstr((Cnstr*)object);
      case QUERY:
	return (PseudoObject*)copy_query((Query*)object);
      case P_MODE:
	return (PseudoObject*)copy_p_mode((PMode*)object);
      case A_MODE:
	return (PseudoObject*)copy_a_mode((AMode*)object);
      case I_MODE:
	return (PseudoObject*)copy_i_mode((IMode*)object);
      case M_MODE:
	return (PseudoObject*)copy_m_mode((MMode*)object);
      case E_MODE:
	return (PseudoObject*)copy_e_mode((EMode*)object);
      case Q_MODE:
	return (PseudoObject*)copy_q_mode((QMode*)object);
      case ANSWER:
	return (PseudoObject*)copy_answer((Answer*)object);
      case ANSWER_ELEMENT:
	return (PseudoObject*)copy_answer_element((AnswerElement*)object);
      case ANSE_EXPLANATION: 
	return (PseudoObject*)copy_anse_explanation((AnseExplanation*)object);
      case RIR_PAIR: 
	return (PseudoObject*)copy_rir_pair((RirPair*)object);
      case DOT_CNSTR:
	return (PseudoObject*)copy_dot_cnstr((DotCnstr*)object);
      case VAR_CNSTR:
	return (PseudoObject*)copy_var_cnstr((VarCnstr*)object);
      case INHERIT:
	return (PseudoObject*)copy_inherit((Inherit*)object);
      case REDUCE:
	return (PseudoObject*)copy_reduce((Reduce*)object);
      case SUB_GOAL:
	return (PseudoObject*)copy_sub_goal((SubGoal*)object);
      case VC_PAIR:
	return (PseudoObject*)copy_vc_pair((VcPair*)object);
      case ONE_RULE:
	return (PseudoObject*)copy_one_rule((OneRule*)object);
      case UNIT_EXPLANATION:
	return (PseudoObject*)
	  copy_unit_explanation((UnitExplanation*)object);
      case MERGE_EXPLANATION:
	return (PseudoObject*)
	  copy_merge_explanation((MergeExplanation*)object);
      case LOOKUP_EXPLANATION:
	return (PseudoObject*)
	  copy_lookup_explanation((LookupExplanation*)object);
      case EXPLANATION:
	return (PseudoObject*)copy_explanation((Explanation*)object);
      case CONSTRAINT:
	return (PseudoObject*)copy_constraint((Constraint*)object);
      case CON:
	return (PseudoObject*)copy_con((Con*)object);
      case ASSUMP:
	return (PseudoObject*)copy_assump((Assump*)object);
      case QUERY_EXPLANATION: 
	return (PseudoObject*)
	         copy_query_explanation((QueryExplanation*)object);
      case PSEUDO_OBJECT:
	union_tag("PSEUDO_OBJECT", stderr);
	exit(2);
	break;
      case OBJ_LIST:
	return (PseudoObject*)copy_obj_list((ObjList*)object);
      case OBJ_ARRAY:
	return (PseudoObject*)copy_obj_array((ObjArray*)object);
      default:
	illegal_type_descriptor("copy_pseudo_object", object->tag);
	break;
    }
}

/*
  type_error:
  output type error message to stderr and exit with code 2.
*/

static void type_error(object, type_name, func_name)
     PseudoObject* object;
     char *type_name, *func_name;
{
    fprintfx(stderr, "type error in function %s\n", func_name);
#ifdef TYPE_DEBUG
    fprintfx(stderr, "  expected type: %s\n", type_name);
    fprintfx(stderr, "  incoming data:\n");
    prnt_pseudo_object(object, stderr, 4);
#endif
    exit(2);
}

static void type_conflict(td1, td2, func_name)
     TypeDescriptor td1, td2;
     char *func_name;
{
    fprintfx(stderr, "type confliction %s with %s in %s\n",
	    type_name(td1), type_name(td2), func_name);
    exit(2);
}

/*
  write_through_NULL:
  output error message to stderr and exit with code 2.
*/

static void write_through_NULL(func_name)
     char* func_name;
{
    fprintfx(stderr, "write through NULL pointer in function %s\n",
	    func_name);
    exit(2);
}

/*
  illegal_type_descriptor:
  output error message to stderr and exit with code 2.
*/
static void illegal_type_descriptor(func_name, td)
     char* func_name;
     TypeDescriptor td;
{
    fprintfx(stderr, "illegal type descriptor is found in function %s\n",
	    func_name);
#ifdef TYPE_DEBUG
    fprintfx(stderr, "descriptor value: %d", object->tag);
#endif
    exit(2);
}

/*
  array_type_check:
  checks all elements of a pseudo object array are of given type
*/

static void array_type_check(td, n, obj_array)
     TypeDescriptor td;
     int n;
     PseudoObject** obj_array;
{
    int i;

    for (i = 0; i < n; ++i) {
	if (! is_type(obj_array[i]->tag, td))
	  type_error(obj_array[i], type_name(td), "array_type_check");
    }
}

Local void prnt_log(log)
     AllocLog *log;
{
    if (log->tag == Malloc)
      printf("at %x, size %d\n", (int)((MallocLog*)log)->ptr,
	     ((MallocLog*)log)->size);
    else
      printf("at %x, size %d x %d\n", (int)((CallocLog*)log)->ptr,
	     ((CallocLog*)log)->nelem, ((CallocLog*)log)->elsize);
}
