%{
#include "dotsrc.h"
/* #define YYSTYPE char * */

#define QPMAX 4096
static char qp[QPMAX] = {0,};
static int qpi = 0;
static char wrk[128] = {0,};

PseudoObject	*xanswer = NULL;
static ObjList	*xanswer_element = NULL;
static ObjList	*xdot_cnstr = NULL;
static ObjList	*xvar_cnstr = NULL;

/* PseudoObject	*xquery = NULL; */
/* PseudoObject	*xprogram = NULL; */
static PseudoObject	*xenv_def = NULL;
static PseudoObject	*xexp_def = NULL;
static PseudoObject	*xobj_def = NULL;
static PseudoObject	*xmod_def = NULL;
static PseudoObject	*xlink_def = NULL;
static PseudoObject 	*xrule_def = NULL;

static ObjList *xobj_subs = NULL;
static ObjList *xmod_subs = NULL;
static ObjList *xrules = NULL;
static ObjList *xm_ids = NULL;
static ObjList *xclusters = NULL;
static ObjList *xcnstrs = NULL;
static ObjList *xo_terms[32] = {NULL,};
static int xo_termsi = 0;
static ObjList *xa_terms = NULL;
static NoAssume xnoassume = NULL;	/* NULL or NOASSUME */

static int xbasic_obj = NULL;

%}

%union {	int	name;
		PseudoObject	*psob;
		int	tnum;
	}

%token TOK_Void		    /* &void */
%token TOK_Pgm		    /* program */
%token TOK_Qry		    /* query */
%token TOK_Env		    /* env_def */
%token TOK_DefLib		    /* def_lib */
%token TOK_ExpLib		    /* &exp_lib */
%token TOK_PgmLib		    /* &pgm_lib */
%token TOK_SrtLib		    /* &sort_lib */
%token TOK_Exp		    /* exp_def */
%token TOK_ExpNam		    /* exp_name */
%token TOK_Obj		    /* obj_def */
%token TOK_ObjSub		    /* obj_sub */
%token TOK_Mod		    /* mod_def */
%token TOK_MSub		    /* m_sub */
%token TOK_MId		    /* m_id */
%token TOK_MDsc		    /* m_desc */
%token TOK_Link		    /* link_def */
%token TOK_Lnk		    /* link */
%token TOK_Rule		    /* rule_def */
%token TOK_Rul		    /* rule */
%token TOK_Nrm			/* normal */
%token TOK_Rel			/* rel */
%token TOK_Upd			/* update */
%token TOK_Trn			/* transaction */
%token TOK_Con			/* consis */
%token TOK_InCon			/* inconsis */
%token TOK_Prp		/* prop */
%token TOK_Cns		/* cnstr */
%token TOK_Cns		/* cnstrs */
%token TOK_ATrm		/* a_term */
%token TOK_COTrm		/* c_o_term */
%token TOK_Prl		/* prolog */
%token TOK_Dot		/* dot */
%token TOK_Lst		/* list */
%token TOK_SubLst		/* sublist */
%token TOK_Nil		/* nill */
%token TOK_Str		/* string */
%token TOK_Int		/* integer */
%token TOK_Atr		/* attr */
%token TOK_Var		/* var */
%token TOK_Ind		/* ind */
%token TOK_Set		/* set */
%token TOK_CrlInd		/* curl_ind */
%token TOK_CrlSet		/* curl_set */
%token TOK_QryCns		/* query_cnstr */
%token TOK_Prc			/* proc */
%token TOK_Ans			/* ans */
%token TOK_Inh			/* inherit */
%token TOK_Mrg			/* merge */
%token TOK_Xpl			/* explana */
%token TOK_Srt			/* sort */
%token TOK_Ans		/* answer */
%token TOK_AnsElm		/* answer_element */
%token TOK_DotCns		/* dot_cnstr */
%token TOK_VarCns		/* var_cnstr */
%token TOK_Lkp		/* lookup */
%token TOK_Unt		/* unit */
	 		/* up */
%token TOK_Dwn		/* down */
%token TOK_Rdc		/* reduce */
%token TOK_Sbg		/* subgoal */
%token TOK_Con		/* con */
%token TOK_Asm		/* assump */
%token TOK_Rid		/* ruleID */

%token TOK_NoUpd		    /* &noupdate */
			    /* &update */
%token TOK_L     		    /* &l */
%token TOK_O            	    /* &o */
%token TOK_LO    		    /* &lo */
%token TOK_OL    		    /* &ol */
%token TOK_NoAsm		    /* &no_assume */
%token TOK_BT                   /* &bt */
%token TOK_ET                   /* &et */
%token TOK_AT                   /* &at */
%token TOK_In	            /* &in */
%token TOK_Ni	            /* &ni */
%token TOK_Single			/* &single */
%token TOK_Multi			/* &multi */
%token TOK_Normal			/* &normal */
%token TOK_Minimal			/* &minimal */
%token TOK_Yes			/* &yes */
%token TOK_No			/* &no */
%token TOK_On			/* &on */
%token TOK_Off			/* &off */
%token TOK_All			/* &all */
%token TOK_Down			/* &down */
%token TOK_Up			/* &up */

%token <name>TOK_Atom
%token <name>TOK_Variable
%token <name>TOK_String
%token <name>TOK_Integer

%left TOK_Equal      /* = */
%left TOK_Plus       /* + */
%left TOK_Minus      /* - */

%token TOK_SetSubsumed        /* =< */  
%token TOK_SetSubsumes        /* >= */
%token TOK_SetCong            /* == */
%token TOK_SetSubsumedop        /* +< */  
%token TOK_SetSubsumesop        /* >+ */
%token TOK_SetCongop            /* =+= */
%token TOK_Subsumed             /* -< */
%token TOK_Subsumes             /* >- */
%token TOK_RightArrow           /* -> */
%token TOK_LeftArrow            /* <- */

%type <name>basic_obj
%type <name>o_head
%type <name>rule_id

%type <psob>l_var
%type <psob>g_var
%type <psob>answer_element
%type <psob>dot_cnstr
%type <psob>var_cnstr

%type <psob>cnstr
%type <psob>attr
%type <psob>c_o_term
%type <psob>ind_term
%type <psob>dot_term
%type <psob>o_term
%type <psob>mid
%type <psob>lab
%type <psob>a_term
%type <psob>trans
%type <psob>rules_sub
%type <psob>cluster

%type <tnum>attr_op
%type <tnum>u_flag
%type <tnum>rel
%type <tnum>inheritance_mode
%type <tnum>no_assume

%start answer

%%
answer:	  ansx '(' '[' answer_elements ']' ')'
		{	xanswer = (PseudoObject *)
				  create_answer(xanswer_element);
			YYACCEPT;
		}
	| '{' ansx ',' answer_elements '}'
		{	xanswer = (PseudoObject *)
				  create_answer(xanswer_element);
			YYACCEPT;
		}
	;

ansx:	  TOK_Ans
		{	xanswer_element = new_obj_list(ANSWER_ELEMENT);
		}
	;

answer_elements:
	| answer_element
	| answer_elements ',' answer_element
	;

answer_element:
	  anselmx '(' '[' dot_cnstrs ']' ',' 
		      '[' var_cnstrs ']' ',' 
		      TOK_Void ')'
		{	PseudoObject *w;
			w = (PseudoObject *)new_answer_element();
			w = (PseudoObject *)write_dot_cnstrs(w,xdot_cnstr);
			w = (PseudoObject *)write_var_cnstrs(w,xvar_cnstr);
			append_to_obj_list(xanswer_element,w);
		}
	| '{' anselmx ',' '[' dot_cnstrs ']' ',' 
		          '[' var_cnstrs ']' ',' 
		          TOK_Void '}'
		{	PseudoObject *w;
			w = (PseudoObject *)new_answer_element();
			w = (PseudoObject *)write_dot_cnstrs(w,xdot_cnstr);
			w = (PseudoObject *)write_var_cnstrs(w,xvar_cnstr);
			append_to_obj_list(xanswer_element,w);
		}
	| anselmx '(' '[' dot_cnstrs ']' ',' 
		      '[' var_cnstrs ']' ',' 
		      explanationx ')'
		{	PseudoObject *w;
			w = (PseudoObject *)new_answer_element();
			w = (PseudoObject *)write_dot_cnstrs(w,xdot_cnstr);
			w = (PseudoObject *)write_var_cnstrs(w,xvar_cnstr);
			/* w = (PseudoObject *)
			    write_explanation_inAnswerElement(w,$11); */
			append_to_obj_list(xanswer_element,w);
		}
	| '{' anselmx ',' '[' dot_cnstrs ']' ',' 
		          '[' var_cnstrs ']' ',' 
		          explanationx '}'
		{	PseudoObject *w;
			w = (PseudoObject *)new_answer_element();
			w = (PseudoObject *)write_dot_cnstrs(w,xdot_cnstr);
			w = (PseudoObject *)write_var_cnstrs(w,xvar_cnstr);
			/* w = (PseudoObject *)
			    write_explanation_inAnswerElement(w,$12); */
			append_to_obj_list(xanswer_element,w);
		}
	;

anselmx:  TOK_AnsElm
		{	xdot_cnstr = new_obj_list(DOT_CNSTR);
			xvar_cnstr = new_obj_list(VAR_CNSTR);
		}
	;

dot_cnstrs:
	| dot_cnstr
	| dot_cnstrs ',' dot_cnstr
	;

var_cnstrs:
	| var_cnstr
	| var_cnstrs ',' var_cnstr
	;

explanationx:
	  '{' explanation ',' '[' ']' '}'
	| '{' explanation ',' '[' rule_id_and_rules ']' '}'
	;
	
rule_id_and_rules:
	  rule_id_and_rule
	| rule_id_and_rules ',' rule_id_and_rule
	;

rule_id_and_rule:
	  '{' rule_id ',' rules_sub '}'
	;

rule_id:  TOK_Void
		{	$$ = NULL;
		}
	| TOK_Atom
		{	$$ = $1;
		}
        | TOK_Variable
		{	$$ = $1;
		}
	;

rules_sub:
	  rulx '(' TOK_NoUpd ',' stmids rule_mids ']' ',' rule_id ','
	  inheritance_mode ',' no_assume ',' a_term
	  '[' clusters ']' ',' stcnstrs cnstrs ']' ')' 
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_rule();
			$$ = (PseudoObject *)write_rule_class($$,RCNOUPDATE);
			$$ = (PseudoObject *)write_m_ids_inRule($$,xm_ids);
			w = (PseudoObject *)create_rule_id(&qp[$9]);
			$$ = (PseudoObject *)write_rule_id_inRule($$,w);
			$$ = (PseudoObject *)
			     write_inheritance_mode_inRule($$,$11);
			$$ = (PseudoObject *)
			     write_no_assume_inRule($$,$13);
			$$ = (PseudoObject *)write_head_inRule($$,$15);
			$$ = (PseudoObject *)
			     write_clusters_inRule($$,xclusters);
			$$ = (PseudoObject *)
			     write_cnstrs_inRule($$,xcnstrs);
			append_to_obj_list(xrules,$$);
		}
	| '{' rulx ',' TOK_NoUpd ',' stmids rule_mids ']' ',' rule_id ','
	  inheritance_mode ',' no_assume ',' a_term
	  '[' clusters ']' ',' stcnstrs cnstrs ']' '}' 
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_rule();
			$$ = (PseudoObject *)write_rule_class($$,RCNOUPDATE);
			$$ = (PseudoObject *)write_m_ids_inRule($$,xm_ids);
			w = (PseudoObject *)create_rule_id(&qp[$10]);
			$$ = (PseudoObject *)write_rule_id_inRule($$,w);
			$$ = (PseudoObject *)
			     write_inheritance_mode_inRule($$,$12);
			$$ = (PseudoObject *)
			     write_no_assume_inRule($$,$14);
			$$ = (PseudoObject *)write_head_inRule($$,$16);
			$$ = (PseudoObject *)
			     write_clusters_inRule($$,xclusters);
			$$ = (PseudoObject *)
			     write_cnstrs_inRule($$,xcnstrs);
			append_to_obj_list(xrules,$$);
		}
	| rulx '(' TOK_Upd',' stmids rule_mids ']' ',' rule_id ','
	  inheritance_mode ',' no_assume ',' a_term
	  '[' clusters ']' ',' stcnstrs cnstrs ']' ')' 
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_rule();
			$$ = (PseudoObject *)write_rule_class($$,RCUPDATE);
			$$ = (PseudoObject *)write_m_ids_inRule($$,xm_ids);
			w = (PseudoObject *)create_rule_id(&qp[$9]);
			$$ = (PseudoObject *)write_rule_id_inRule($$,w);
			$$ = (PseudoObject *)
			     write_inheritance_mode_inRule($$,$11);
			$$ = (PseudoObject *)
			     write_no_assume_inRule($$,$13);
			$$ = (PseudoObject *)write_head_inRule($$,$15);
			$$ = (PseudoObject *)
			     write_clusters_inRule($$,xclusters);
			$$ = (PseudoObject *)
			     write_cnstrs_inRule($$,xcnstrs);
			append_to_obj_list(xrules,$$);
		}
	| '{' rulx ',' TOK_Upd',' stmids rule_mids ']' ',' rule_id ','
	  inheritance_mode ',' no_assume ',' a_term
	  '[' clusters ']' ',' stcnstrs cnstrs ']' '}' 
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_rule();
			$$ = (PseudoObject *)write_rule_class($$,RCUPDATE);
			$$ = (PseudoObject *)write_m_ids_inRule($$,xm_ids);
			w = (PseudoObject *)create_rule_id(&qp[$10]);
			$$ = (PseudoObject *)write_rule_id_inRule($$,w);
			$$ = (PseudoObject *)
			     write_inheritance_mode_inRule($$,$12);
			$$ = (PseudoObject *)
			     write_no_assume_inRule($$,$14);
			$$ = (PseudoObject *)write_head_inRule($$,$16);
			$$ = (PseudoObject *)
			     write_clusters_inRule($$,xclusters);
			$$ = (PseudoObject *)
			     write_cnstrs_inRule($$,xcnstrs);
			append_to_obj_list(xrules,$$);
		}
	;

rulx:     TOK_Rul
		{	xclusters = new_obj_list(CLUSTER);
		}
	;

stmids:	  '['
		{	xm_ids = new_obj_list(O_TERM);
		}

rule_mids:  
	| rule_mid
	| rule_mids ',' rule_mid
	;

rule_mid: o_term
		{	append_to_obj_list(xm_ids,$1);
		}
	;

inheritance_mode:
	  TOK_Void
		{	$$ = NULL;
		}
        | TOK_L
		{	$$ = IML;
		}
        | TOK_O
		{	$$ = IMO;
		}
        | TOK_LO
		{	$$ = IMOL;
		}
        | TOK_OL
		{	$$ = IMOL;
		}
	;

no_assume:
	  TOK_Void
		{	$$ = NULL;
		}
	| TOK_NoAsm
		{	$$ = NOASSUME;
		}
	;

clusters:
	| cluster
	| clusters ',' cluster
	;

cluster:  TOK_Nrm '(' '{' mid ',' a_term '}' ')'
		{	$$ = (PseudoObject *)create_normal($4,$6);
			/* $$ = (PseudoObject *)create_cluster_normal($$); */
			append_to_obj_list(xclusters,$$);
		}
	| '{' TOK_Nrm ',' '{' mid ',' a_term '}' '}'
		{	$$ = (PseudoObject *)create_normal($5,$7);
			/* $$ = (PseudoObject *)create_cluster_normal($$); */
			append_to_obj_list(xclusters,$$);
		}
	| TOK_Upd '(' '{' u_flag ',' mid ',' a_term '}' ')'
		{	$$ = (PseudoObject *)create_update($4,$6,$8);
			$$ = (PseudoObject *)create_cluster_update($$);
			append_to_obj_list(xclusters,$$);
		}
	| '{' TOK_Upd ',' '{' u_flag ',' mid ',' a_term '}' '}'
		{	$$ = (PseudoObject *)create_update($5,$7,$9);
			$$ = (PseudoObject *)create_cluster_update($$);
			append_to_obj_list(xclusters,$$);
		}
	| TOK_Trn '(' trans ')'
		{	append_to_obj_list(xclusters,$3);
		}
	| '{' TOK_Trn ',' trans '}'
		{	append_to_obj_list(xclusters,$4);
		}
	;

u_flag:	  TOK_Plus
		{	$$ = (int)UFPLUS;
		}
	| TOK_Minus
		{	$$ = (int)UFMINUS;
		}
	;

trans:	  TOK_BT
		{	$$ = (PseudoObject *)create_transaction(TDBT);
			$$ = (PseudoObject *)create_cluster_transaction($$);
		}
	| TOK_ET
		{	$$ = (PseudoObject *)create_transaction(TDET);
			$$ = (PseudoObject *)create_cluster_transaction($$);
		}
        | TOK_AT
		{	$$ = (PseudoObject *)create_transaction(TDAT);
			$$ = (PseudoObject *)create_cluster_transaction($$);
		}
	;

stcnstrs: '['
		{	xcnstrs = new_obj_list(CNSTR_DATA);
		}
	;

cnstrs:   cnstr
	| cnstrs ',' cnstr
	;

cnstr:    TOK_Cns '(' TOK_Void ',' ind_term ',' rel ',' TOK_Void ',' ind_term ')'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			w = (PseudoObject *)create_value_o_term($5);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$7);
			w = (PseudoObject *)create_value_o_term($11);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
	| '{' TOK_Cns ',' TOK_Void ',' ind_term ',' rel ',' TOK_Void ',' ind_term '}'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			w = (PseudoObject *)create_value_o_term($6);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$8);
			w = (PseudoObject *)create_value_o_term($12);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
	| TOK_Cns '(' TOK_Void ',' ind_term ',' rel ',' mid ',' ind_term ')'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			w = (PseudoObject *)create_value_o_term($5);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$7);
			$$ = (PseudoObject *)write_m_id2_inCnstrData($$,$9);
			w = (PseudoObject *)create_value_o_term($11);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
	| '{' TOK_Cns ',' TOK_Void ',' ind_term ',' rel ',' mid ',' ind_term '}'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			w = (PseudoObject *)create_value_o_term($6);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$8);
			$$ = (PseudoObject *)write_m_id2_inCnstrData($$,$10);
			w = (PseudoObject *)create_value_o_term($12);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
	| TOK_Cns '(' mid ',' ind_term ',' rel ',' TOK_Void ',' ind_term ')'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)write_m_id1_inCnstrData($$,$3);
			w = (PseudoObject *)create_value_o_term($5);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$7);
			w = (PseudoObject *)create_value_o_term($11);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
	| '{' TOK_Cns ',' mid ',' ind_term ',' rel ',' TOK_Void ',' ind_term '}'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)write_m_id1_inCnstrData($$,$4);
			w = (PseudoObject *)create_value_o_term($6);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$8);
			w = (PseudoObject *)create_value_o_term($12);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
	| TOK_Cns '(' mid ',' ind_term ',' rel ',' mid ',' ind_term ')'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)write_m_id1_inCnstrData($$,$3);
			w = (PseudoObject *)create_value_o_term($5);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$7);
			$$ = (PseudoObject *)write_m_id2_inCnstrData($$,$9);
			w = (PseudoObject *)create_value_o_term($11);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
	| '{' TOK_Cns ',' mid ',' ind_term ',' rel ',' mid ',' ind_term '}'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)write_m_id1_inCnstrData($$,$4);
			w = (PseudoObject *)create_value_o_term($6);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$8);
			$$ = (PseudoObject *)write_m_id2_inCnstrData($$,$10);
			w = (PseudoObject *)create_value_o_term($12);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
	;

rel:	  TOK_SetSubsumed
		{	$$ = CNLE;
		}
        | TOK_SetSubsumes
		{	$$ = CNGE;
		}
        | TOK_SetCong
		{	$$ = CNEQ;
		}
	| TOK_SetSubsumedop
		{	$$ = CNPL;
		}
        | TOK_SetSubsumesop
		{	$$ = CNPG;
		}
        | TOK_SetCongop
		{	$$ = CNEPE;
		}
        | TOK_Ni
		{	$$ = CNNI;
		}
        | TOK_In
		{	$$ = CNIN;
		}
        ;

ind_term: c_o_term
		{	$$ = (PseudoObject *)create_o_term_c_o_term($1);
		}
/*	| exp_name */
/*	| list */
	| TOK_Str '(' TOK_String ')'
		{	$$ = (PseudoObject *)create_string(&qp[$3]);
			$$ = (PseudoObject *)create_non_struct_string($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| '{' TOK_Str ',' TOK_String '}'
		{	$$ = (PseudoObject *)create_string(&qp[$4]);
			$$ = (PseudoObject *)create_non_struct_string($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| TOK_Int '(' TOK_Integer ')'
		{	$$ = (PseudoObject *)create_integer(atoi(&qp[$3]));
			$$ = (PseudoObject *)create_non_struct_integer($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| '{' TOK_Int ',' TOK_Integer '}'
		{	$$ = (PseudoObject *)create_integer(atoi(&qp[$4]));
			$$ = (PseudoObject *)create_non_struct_integer($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| g_var
		{	$$ = (PseudoObject *)create_o_term_var($1);
		}
	| dot_term
		{	$$ = (PseudoObject *)create_o_term_dot($1);
		}
/*	| TOK_Self*/
/*	| sort */
	;

dot_term: TOK_Dot '(' o_term ',' lab ')'
		{	$$ = (PseudoObject *)create_dot($3,$5);
		}
	| '{' TOK_Dot ',' o_term ',' lab '}'
		{	$$ = (PseudoObject *)create_dot($4,$6);
		}
	;

g_var:    TOK_Var '(' TOK_Ind ',' TOK_String ')'
		{	strcpy(wrk,&qp[$5]);
			wrk[strlen(wrk)-1] = 0;
		  	$$ = (PseudoObject *)create_var(VARIND,wrk+1);
		}
	| '{' TOK_Var ',' TOK_Ind ',' TOK_String '}'
		{	strcpy(wrk,&qp[$6]);
			wrk[strlen(wrk)-1] = 0;
		  	$$ = (PseudoObject *)create_var(VARIND,wrk+1);
		}
        ;

l_var:    TOK_Var '(' TOK_Ind ',' TOK_String ')'
		{	strcpy(wrk,&qp[$5]);
			wrk[strlen(wrk)-1] = 0;
		  	$$ = (PseudoObject *)create_var(VARIND,wrk+1);
		}
	| '{' TOK_Var ',' TOK_Ind ',' TOK_String '}'
		{	strcpy(wrk,&qp[$6]);
			wrk[strlen(wrk)-1] = 0;
		  	$$ = (PseudoObject *)create_var(VARIND,wrk+1);
		}
        ;

a_term:	  TOK_ATrm '(' o_term ',' '[' ']' ',' '[' ']' ')'
		{	$$ = (PseudoObject *)create_a_term($3,NULL,NULL);
		}
	| '{' TOK_ATrm ',' o_term ',' '[' ']' ',' '[' ']' '}'
		{	$$ = (PseudoObject *)create_a_term($4,NULL,NULL);
		}
	| TOK_ATrm '(' o_term ',' sqbrlx attrs sqbrrx ',' '[' ']' ')'
		{	$$ = (PseudoObject *)
			     create_a_term($3,xo_terms[xo_termsi+1],NULL);
		}
	| '{' TOK_ATrm ',' o_term ',' sqbrlx attrs sqbrrx ',' '[' ']' '}'
		{	$$ = (PseudoObject *)
			     create_a_term($4,xo_terms[xo_termsi+1],NULL);
		}
	| TOK_ATrm '(' o_term ',' '[' ']' ',' stcnstrs cnstrs ']' ')'
		{	$$ = (PseudoObject *)create_a_term($3,NULL,xcnstrs);
		}
	| '{' TOK_ATrm ',' o_term ',' '[' ']' ',' stcnstrs cnstrs ']' '}'
		{	$$ = (PseudoObject *)create_a_term($4,NULL,xcnstrs);
		}
	| TOK_ATrm '(' o_term ',' sqbrlx attrs sqbrrx ','
			      stcnstrs cnstrs ']' ')'
		{	$$ = (PseudoObject *)
			     create_a_term($3,xo_terms[xo_termsi+1],NULL);
			$$ = (PseudoObject *)write_cnstrs_inATerm($$,xcnstrs);
		}
	| '{' TOK_ATrm ',' o_term ',' sqbrlx attrs sqbrrx ','
			          stcnstrs cnstrs ']' '}'
		{	$$ = (PseudoObject *)
			     create_a_term($4,xo_terms[xo_termsi+1],NULL);
			$$ = (PseudoObject *)write_cnstrs_inATerm($$,xcnstrs);
		}
	;

sqbrlx:	  '['
		{	xo_terms[++xo_termsi] = new_obj_list(ATTR);
		}
	;

sqbrrx:	  ']'
		{	--xo_termsi;
		}
	;

attrs:    attr
	| attrs ',' attr
	;

attr:	  TOK_Atr '(' lab ',' attr_op ',' ind_term ')'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_attr();
			$$ = (PseudoObject *)write_label_inAttr($$,$3);
			$$ = (PseudoObject *)write_attr_op($$,$5);
			w = (PseudoObject *)create_value_o_term($7);
			$$ = (PseudoObject *)write_value($$,w);
			append_to_obj_list(xo_terms[xo_termsi],$$);
		}
	| '{' TOK_Atr ',' lab ',' attr_op ',' ind_term '}'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_attr();
			$$ = (PseudoObject *)write_label_inAttr($$,$4);
			$$ = (PseudoObject *)write_attr_op($$,$6);
			w = (PseudoObject *)create_value_o_term($8);
			$$ = (PseudoObject *)write_value($$,w);
			append_to_obj_list(xo_terms[xo_termsi],$$);
		}
/*	| set_lab set_rel set_terms */
/*	| lab RightArrow set_terms */
/*	| set_lab LeftArrow ind_term */
	;

lab:	  TOK_Ind '(' c_o_term ')'
		{	PseudoObject *w;
			w = (PseudoObject *)create_o_term_c_o_term($3);
			/* w = (PseudoObject *)create_lab(w,LAB); */
			$$ = (PseudoObject *)create_label(w);
		}
	| '{' TOK_Ind ',' c_o_term '}'
		{	PseudoObject *w;
			w = (PseudoObject *)create_o_term_c_o_term($4);
			/* w = (PseudoObject *)create_lab(w,LAB); */
			$$ = (PseudoObject *)create_label(w);
		}
/*	| TOK_Car*/
/*	| TOK_Cdr*/
	;

attr_op:  TOK_RightArrow
		{	$$ = ATRARROW;
		}
	| TOK_LeftArrow
		{	$$ = ATLARROW;
		}
	| TOK_Equal
		{	$$ = ATEQ;
		}
	;

mid:	  o_term
		{	$$ = $1;
		}
	;

o_term:	  c_o_term
		{	$$ = (PseudoObject *)create_o_term_c_o_term($1);
		}
/*	| exp_name */
/*	| list */
	| TOK_Str '(' TOK_String ')'
		{	$$ = (PseudoObject *)create_string(&qp[$3]);
			$$ = (PseudoObject *)create_non_struct_string($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| '{' TOK_Str ',' TOK_String '}'
		{	$$ = (PseudoObject *)create_string(&qp[$4]);
			$$ = (PseudoObject *)create_non_struct_string($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| TOK_Int '(' TOK_Integer ')'
		{	$$ = (PseudoObject *)create_integer(atoi(&qp[$3]));
			$$ = (PseudoObject *)create_non_struct_integer($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| '{' TOK_Int ',' TOK_Integer '}'
		{	$$ = (PseudoObject *)create_integer(atoi(&qp[$4]));
			$$ = (PseudoObject *)create_non_struct_integer($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| g_var
		{	$$ = (PseudoObject *)create_o_term_var($1);
		}
	| dot_term
		{	$$ = (PseudoObject *)create_o_term_dot($1);
		}
	;

c_o_term: TOK_COTrm '(' o_head ',' '[' ']' ',' '[' ']' ')'
		{	$$ = (PseudoObject *)create_c_o_term(&qp[$3],
							     NULL,NULL);
		}
	| '{' TOK_COTrm ',' o_head ',' '[' ']' ',' '[' ']' '}'
		{	$$ = (PseudoObject *)create_c_o_term(&qp[$4],
							     NULL,NULL);
		}
	| TOK_COTrm '(' o_head ',' sqbrlx attrs sqbrrx ',' '[' ']' ')'
		{	
			$$ = (PseudoObject *)
			     create_c_o_term(&qp[$3],
					     xo_terms[xo_termsi+1],
					     NULL);
		}
	| '{' TOK_COTrm ',' o_head ',' sqbrlx attrs sqbrrx ',' '[' ']' '}'
		{	
			$$ = (PseudoObject *)
			     create_c_o_term(&qp[$4],
					     xo_terms[xo_termsi+1],
					     NULL);
		}
/*	| o_head sqbrlx attrs sqbrrx vtlnx cnstr_list */
/*	| o_head RnBrL o_terms RnBrR */
/*	| a_o_term */
	;

o_head:	  basic_obj
		{	$$ = $1;
		}
	;

basic_obj:
          TOK_Atom
		{	$$ = $1;
		}
        ;

dot_cnstr:
	  TOK_DotCns '(' mid ',' dot_term ',' rel ',' o_term ')'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_dot_cnstr();
			$$ = (PseudoObject *)write_m_id_inDotCnstr($$,$3);
			$$ = (PseudoObject *)write_dot_inDotCnstr($$,$5);
			$$ = (PseudoObject *)write_rel_inDotCnstr($$,$7);
			$$ = (PseudoObject *)write_value_inDotCnstr($$,$9);
			append_to_obj_list(xdot_cnstr,$$);
		}
	| TOK_DotCns '(' TOK_Void ',' dot_term ',' rel ',' o_term ')'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_dot_cnstr();
			$$ = (PseudoObject *)write_dot_inDotCnstr($$,$5);
			$$ = (PseudoObject *)write_rel_inDotCnstr($$,$7);
			$$ = (PseudoObject *)write_value_inDotCnstr($$,$9);
			append_to_obj_list(xdot_cnstr,$$);
		}
	| '{' TOK_DotCns '{' mid ',' dot_term ',' rel ',' o_term '}'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_dot_cnstr();
			$$ = (PseudoObject *)write_m_id_inDotCnstr($$,$4);
			$$ = (PseudoObject *)write_dot_inDotCnstr($$,$6);
			$$ = (PseudoObject *)write_rel_inDotCnstr($$,$8);
			$$ = (PseudoObject *)write_value_inDotCnstr($$,$10);
			append_to_obj_list(xdot_cnstr,$$);
		}
	| '{' TOK_DotCns '{' TOK_Void ',' dot_term ',' rel ',' o_term '}'
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_dot_cnstr();
			$$ = (PseudoObject *)write_dot_inDotCnstr($$,$6);
			$$ = (PseudoObject *)write_rel_inDotCnstr($$,$8);
			$$ = (PseudoObject *)write_value_inDotCnstr($$,$10);
			append_to_obj_list(xdot_cnstr,$$);
		}

var_cnstr:
	  TOK_VarCns '(' g_var ',' rel ',' o_term ')'
		{	$$ = (PseudoObject *)new_var_cnstr();
			$$ = (PseudoObject *)write_var_inVarCnstr($$,$3);
			$$ = (PseudoObject *)write_rel_inVarCnstr($$,$5);
			$$ = (PseudoObject *)write_value_inVarCnstr($$,$7);
			append_to_obj_list(xvar_cnstr,$$);
		}
	| '{' TOK_VarCns ',' g_var ',' rel ',' o_term '}'
		{	$$ = (PseudoObject *)new_var_cnstr();
			$$ = (PseudoObject *)write_var_inVarCnstr($$,$4);
			$$ = (PseudoObject *)write_rel_inVarCnstr($$,$6);
			$$ = (PseudoObject *)write_value_inVarCnstr($$,$8);
			append_to_obj_list(xvar_cnstr,$$);
		}

explanation:
	  unit_explanation
	| TOK_Mrg '(' '[' unit_explanations ']' ')'
	| '{' TOK_Mrg ',' '[' unit_explanations ']' '}'
	| TOK_Lkp '(' '{' subgoal ',' lookeds ',' lookings ',' explanation ')'
	| '{' TOK_Lkp ',' '{' subgoal ',' lookeds ',' lookings ',' explanation '}'
	;

unit_explanations:
	| unit_explanation
	| unit_explanations ',' unit_explanation
	;

unit_explanation:
	  TOK_Unt '(' one_rule ')'
	| '{' TOK_Unt ',' one_rule '}'
	| TOK_Inh '(' one_rule ',' up ',' down ')'
	| '{' TOK_Inh ',' one_rule ',' up ',' down '}'
	;

up:	  TOK_Up '(' '[' one_rules ']' ')'
	| TOK_Void
	;

down:	  TOK_Dwn '(' '[' one_rules ']' ')'
	| TOK_Void
	;

one_rules:
	| one_rule
	| one_rules ',' one_rule
	;

one_rule:
	  TOK_Rdc '(' '{' subgoal ',' 
		      rule_id ',' 
		      '[' explanations ']' ',' 
		      assump '}' ')'
	| '{' TOK_Rdc ',' '{' subgoal ',' 
		          rule_id ',' 
		          '[' explanations ']' ',' 
		          assump '}' '}'
	| TOK_Rid '(' rule_id ')'
	| '{' TOK_Rid ',' rule_id '}'
	;

explanations:
	| explanation
	| explanations ',' explanation
	;

lookeds:
	  TOK_Integer
	;

lookings:
	  TOK_Integer
	;

subgoal:
	  TOK_Sbg '(' mid ',' o_term ',' '[' vc_pairs ']' ')'
	| '{' TOK_Sbg ',' mid ',' o_term ',' '[' vc_pairs ']' '}'
	;

assump:
	  TOK_Asm '(' mid ',' dot_term ',' '[' vc_pairs ']' ')'
	| '{' TOK_Asm ',' mid ',' dot_term ',' '[' vc_pairs ']' '}'
	;

vc_pairs:
	| vc_pair
	| vc_pairs ',' vc_pair
	;

vc_pair:
	  '{' g_var ',' constraint '}'
	;

constraint:
	  TOK_Con '(' '{' '[' o_terms ']' ',' '[' o_terms ']' '}'
	;

o_terms:
	| o_term
	| o_terms ',' o_term
	;

%%

int ans_pool(p)
	char *p;
	{
	int i, j;

	if((i = qpi + strlen(p) + 1) > QPMAX)
		qpi = 0;
	j = qpi;
	strcpy(&qp[qpi], p);
	qpi = i;
	return(j);
	}

#include "term_l.c"
