;;
;; tracer session commands
;;

;;
;;    S: trace_event(Status, EventTag, NumberOfSolutions, 
;;            Tracing, SequenceID, Children, BelongingRule, LookupCycle)
;;        EventTag = callSubgoal | exitSubgoal | callRule  | exitRule
;;            | fail | lookup    | bt | et | at | update | ic
;;        NumberOfSolutions = Integer  (if EventTag = fail then 0 )
;;        Tracing = Subgoal(EventTag = callSubgoal, exitSubgoal
;;                       fail, lookup )
;;            | Rule    (EventTag = callRule, exitRule)
;;            | Cluster (EventTag = update, ic)
;;            | '&void' (EventTag = bt, et, at)
;;        SequenceID = Integer    (EventTag = callSubgoal, exitSubgoal,
;;                        callRule, exitRule, fail, lookup )
;;            | '&void'    (EventTag =  bt, et, at, update, ic)
;;        Children = [Rule, ... ]    (EventTag = callSubgoal )
;;            | [Subgoal, ... ]    (EventTag = callRule)
;;            | '&void'    (EventTag = otherwise)
;;        Subgoal = SRC form
;;        BelongingRule = Rule    (EventTag = fail, bt, et, at)
;;            | '&void'    (EventTag = otherwise)
;;        LookupCycle = Integer    (EventTag = lookup)
;;            | '&void'    (EventTag =lookup)
;;
(defun qxt-trace-event(Result)
  "$B%H%l!<%9>pJs$rI=<($9$k!#(B"
  (let ((EventTag          (aref Result 2))
	(NumberOfSolutions (aref Result 3))
	(Tracing           (aref Result 4))
	(SequenceID        (aref Result 5))
	(Children          (aref Result 6))
	(BelongingRule     (aref Result 7))
	(LookupCycle       (aref Result 8)))
    (setq qxt-current-session 'trace)
    (insert "<")
    (insert (symbol-name EventTag))
    (if (eq SequenceID '&void) ()
      (insert (concat ":" SequenceID)))
    (if (eq LookupCycle '&void) ()
      (insert (concat ":" LookupCycle)))
    (if (eq NumberOfSolutions 0) ()
      (insert (concat "," NumberOfSolutions)))
    (insert "> ")
    (if (eq Tracing '&void) 
	(insert (symbol-name EventTag))
      (if (listp Tracing) (setq Tracing (car Tracing)))
      (insert (qxt-lisp2qxt Tracing)))
    (newline)
    (if (eq BelongingRule '&void)
	()
      (insert (concat "in " (qxt-lisp2qxt BelongingRule) "\n")))
    (if (eq Children '&void)
	()
      (let ((ChildNumber 1))
	(while Children
	  (insert (concat "  (" (int-to-string ChildNumber) ") "
			  (qxt-lisp2qxt (car Children))))
	  (newline)
	  (setq Children (cdr Children))
	  (setq ChildNumber (+ 1 ChildNumber)))))))
;;
;; set_gate_on_trace
;;	C: set_gate_on_trace(GateID,Switch)
;;		GateID = call | exit | fail | lookup
;;			bt | et | at | it | update
;;		Switch = on | off 
;;	S: result_set_gate_on_trace(Status)
;;
(defun qxt-set-gate-on-trace(GateID Switch)
  "gateID$B$H(BSwitch$B$G;XDj$7$?%2!<%H$N>uBV$N<hF@$rAw?.$9$k4X?t$G$"$k!#(B
GateID = \"call\" | \"exit\" | \"fail\" | \"lookup\" | 
         \"bt\" | \"et\" | \"at\" | \"ic\" | \"update\"
Switch = \"on\" | \"off\" 
"
  (interactive
   (let (GateId Switch)
     (setq GateId (completing-read "GateId: " 
	   '( ("call" 1) ("exit" 2) ("fail" 3) ("lookup" 4) ("bt" 5)
	      ("et" 6) ("at" 7) ("ic" 8) ("update"  9)) nil t ))
     (setq Switch (completing-read "Switch: " 
		  '( ("on" 1) ("off" 2) ) nil t ))
     (list GateId Switch)))
  (qxt-check-status 'trace)
  (qxt-send-command (concat "{set_gate_on_trace," GateID "," Switch "}" )))

;;
;; set_gate_all_on_trace
;;	C: set_gate_all_on_trace(Gate)
;;		Gate = {Call, Exit, Fail, Lookup, Bt, Et, At, Ic, Update}
;;		Call = Switch 
;;		Exit = Switch 
;;		Fail = Switch 
;;		Lookup = Switch
;;		Bt = Switch
;;		Et = Switch
;;		At = Switch
;;		Ic = Switch
;;		Update = Switch
;;	S: result_gate_all_on_trace(Status)
;;
(defun qxt-set-gate-all-on-trace(Call Exit Fail Lookup Bt Et At Ic Update)
  "Call Exit Fail Lookup Bt Et At Ic Update$B$G%2!<%H$N@_Dj$rAw?.$9$k!#(B
Call Exit Fail Lookup Bt Et At Ic Update = \"on\" | \"off\"
"
  (interactive
   (let (Call Exit Fail Lookup Bt Et At Ic Update)
     (setq Call (completing-read "Call: " 
		  '( ("on" 1) ("off" 2) ) nil t ))
     (if (string= Call "") (setq Call "off"))
     (setq Exit (completing-read "Exit: " 
		  '( ("on" 1) ("off" 2) ) nil t ))
     (if (string= Exit "") (setq Exit "off"))
     (setq Fail (completing-read "Fail: " 
		  '( ("on" 1) ("off" 2) ) nil t ))
     (if (string= Fail "") (setq Fail "off"))
     (setq Lookup (completing-read "Lookup: " 
		  '( ("on" 1) ("off" 2) ) nil t ))
     (if (string= Lookup "") (setq Lookup "off"))
     (setq Bt (completing-read "Bt: " 
		  '( ("on" 1) ("off" 2) ) nil t ))
     (if (string= Bt "") (setq Bt "off"))
     (setq Et (completing-read "Et: " 
		  '( ("on" 1) ("off" 2) ) nil t ))
     (if (string= Et "") (setq Et "off"))
     (setq At (completing-read "At: " 
		  '( ("on" 1) ("off" 2) ) nil t ))
     (if (string= At "") (setq At "off"))
     (setq Ic (completing-read "Ic: " 
		  '( ("on" 1) ("off" 2) ) nil t ))
     (if (string= Ic "") (setq Ic "off"))
     (setq Update (completing-read "Update: "
		  '( ("on" 1) ("off" 2) ) nil t ))
     (if (string= Update "") (setq Update "off"))
     (list Call Exit Fail Lookup Bt Et At Ic Update)))
  (qxt-check-status 'trace)
  (qxt-send-command
   (concat "{set_gate_all_on_trace,{" Call "," Exit "," Fail ","
	   Lookup "," Bt "," Et "," At "," Ic "," Update "}}" )))

;;
;; execute_by_trace_mode
;;	C: execute_by_trace_mode(StepNodes, SpyNodes, NotraceNodes)
;;		StepNodes = [NodeId, ...] 
;;		NotraceNodes = [NodeId, ....] 
;;		SpyNodes = [NodeId, ...]
;;		NodeId = Integer
;;	S: trace_event(Status, EventTag, NumberOfSolutions, 
;;			Tracing, SequenceID, 
;;			Children, BelongingRule, LookupCycle)
;;	or
;;	S: result_query(Status, Answer)
;;
(defun qxt-execute-by-trace-mode (StepNodes  SpyNodes  NotraceNodes)
  "StepNodes  SpyNodes  NotraceNodes $B;XDj$N<B9T$rAw?.$9$k!#(B
StepNodes = list of Node Numbers (comma separated, can be NULL)
SpyNodes  = list of Node Numbers (comma separated, can be NULL)
NotraceNodes = list of Node Numbers (comma separated, can be NULL)
"
  (interactive "sStep node:\nsSpy node:\nsNotrace node:")
  (qxt-check-status 'trace)
  (qxt-send-command
   (format "{execute_by_trace_mode,[%s],[%s],[%s]}"
	   StepNodes SpyNodes NotraceNodes)))

;;
;; execute_step
;; 	C: execute_step
;;	S: trace_event(Status, EventTag, NumberOfSolutions, 
;;			Tracing, SequenceID, 
;;			Children, BelongingRule, LookupCycle)
;;	or
;;	S: result_query(Status, Answer)
;;
(defun qxt-execute-step()
  "$B%H%l!<%9$N%9%F%C%W<B9T$rAw?.$9$k!#(B"
  (interactive)
  (qxt-check-status 'trace)
  (qxt-send-command "execute_step" ))

;;
;; execute_spy
;; 	C: execute_spy
;;	S: trace_event(Status, EventTag, NumberOfSolutions, 
;;			Tracing, SequenceID, 
;;			Children, BelongingRule, LookupCycle)
;;	or
;;	S: result_query(Status, Answer)
;;
(defun qxt-execute-spy()
  "$B%H%l!<%9$N%9%Q%$<B9T$rAw?.$9$k!#(B"
  (interactive)
  (qxt-check-status 'trace)
  (qxt-send-command "execute_spy" ))

;;
;; execute_notrace
;; 	C: execute_notrace
;;	S: result_query(Status, Answer)
;;
(defun qxt-execute-notrace()
  "$B%N!<%H%l!<%9$G$N<B9T$rAw?.$9$k!#(B"
  (interactive)
  (qxt-check-status 'trace)
  (qxt-send-command "execute_notrace" ))

;;
;; list_spy_on_trace
;;	C: list_spy_on_trace
;;	S: result_list_spy_on_trace(Status,SpyingList)
;;		SpyingList = {[Subgoal, ...], [{Mid, RuleID}, ...]}
(defun qxt-list-spy-on-trace ()
  "$B8=:_@_Dj$7$F$$$k%9%Q%$$N<hF@$rAw?.$9$k!#(B"
  (interactive)
  (qxt-check-status 'trace)
  (qxt-send-command "list_spy_on_trace"))
;;
;;(defun qxt-result-list-spy-on-trace (Result)
;;  "$B8=:_@_Dj$7$F$$$k%9%Q%$$rI=<($9$k!#(B"
;;  (qxt-result-list-spy Result))

;;
;; abort
;;	C: abort_trace
;;	S: result_query(Status, Answer)
;;
(defun qxt-abort-trace()
  "$B%H%l!<%9$N%"%\!<%H$rAw?.$9$k!#(B"
  (interactive)
  (qxt-check-status 'trace)
  (setq qxt-current-session 'database)
  (qxt-send-command "abort_trace"))

;;
;; inspect
;;	C: inspect
;;	S: result_inspect(Status)
;;
(defun qxt-inspect ()
  "$B%$%s%9%Z%/%H$N3+;O$rAw?.$9$k!#(B"
  (interactive)
  (qxt-check-status 'trace)
  (qxt-send-command "inspect"))

(defun qxt-result-inspect (Result)
  "$B%+%l%s%H%;%C%7%g%s$r%$%s%9%Z%/%H$K$9$k!#(B"
  (setq qxt-current-session 'inspect))
