(defconst qxt-meta-command-table
  '(("set-qmacs-i-mode".  meta)
    ("set-window-mode".   meta)
    ("set-time-switch".   meta)
    ("set-synchronous".    meta)
    ("show-qmacs-mode".   meta)
    ("quit".              meta)
    ("reset".             meta)
    ("to-message".        meta)
    ("to-message-region". meta))
  "$B%a%?%3%^%s%I$N%F!<%V%k(B")

(defconst qxt-ss-command-table
  '(("create-database".      server)
    ;;;;("create-database-file". server)
    ("open-database".        server)
    ("show-status".          server)
    ("cd".                   server)
    ("pwd".                  server)
    ("ls".                   server)
    ("ls-l".                 server)
    ("mkdir".                server)
    ("rmdir".                server)
    ("rm".                   server)
    ("rm-all".               server)
    ("purge".                server)
    ("get-text-DB".          server)
    ("get-DBswitch".         server)
    ("set-DBswitch".         server))
  "$B%5!<%P!<%;%C%7%g%s$N%F!<%V%k(B")

(defconst qxt-db-command-table
  '(("query".                 database)
    ;;;;;;("query-file".      database)
    ("close-database".        database)
    ("begin-transaction".     database)
    ("end-transaction".       database)
    ("abort-transaction".     database)
    ("show-module".           database)
    ("show-module-nodes".     database)
    ("show-lattice".          database)
    ("show-lattice-nodes".    database)
    ("compress-set".          database)
    ("delete-database".       database)
    ("show-rules".            database)
    ("show-normalize-rules".  database)
    ("get-id-rule".           database)
    ("get-default-mode".      database)
    ("set-default-mode".      database)
    ("show-basic-objects".    database)
    ("show-objects".          database)
    ("change-conv-mode".      database)
    ("show-dot-labels".       database)
    ("show-module-hierarchy". database)
    ;;
    ;; tracer
    ("set-trace-mode".    database)
    ("get-trace-mode".    database)
    ("set-gate".          database)
    ("set-gate-all".      database)
    ("get-gate".          database)
    ("get-gate-all".      database)
    ("list-spy".          database)
    ("spy-at-subgoals".   database)
    ("spy-at-rules".      database)
    ("spy-at-modules".    database)
    ("unspy-at-subgoals". database)
    ("unspy-at-rules".    database)
    ("unspy-at-modules".  database)
    ("unspy-at-spypoints".database)
    ("enable-all".        database)
    ("enable-at-spypoints".database)
    ("disable-all".       database)
    ("disable-at-spypoints".database)
    ("save-spy".          database)
    ("load-spy".          database)
    ("reset-trace".       database))
  "$B%G!<%?%Y!<%9%;%C%7%g%s$N%F!<%V%k(B"
  )

(defconst qxt-tr-command-table
  '(
    ("set-gate-on-trace". trace)
    ("set-gate-all-on-trace". trace)
    ("list-spy-on-trace". trace)
    ("execute-by-trace-mode".        trace)
    ("execute-step".        trace)
    ("execute-spy".        trace)
    ("execute-notrace".        trace)
    ("abort-trace".        trace)
    ("inspect".           trace))
  "$B%H%l!<%9%;%C%7%g%s$N%F!<%V%k(B"
  )

(defconst qxt-is-command-table
  '(
    ("inspect-assumption".   inspect)
    ("inspect-conclusion".   inspect)
    ("inspect-variable".     inspect)
    ("quit-inspect".         inspect))
  "$B%$%s%9%Z%/%H%;%C%7%g%s$N%F!<%V%k(B"
  )

(defconst qxt-interact-command-table
  (append qxt-meta-command-table
	  qxt-ss-command-table
	  qxt-db-command-table
	  )
  "interaction $B$K;H$&%3%^%s%I%F!<%V%k(B")

(defconst qxt-debug-command-table
  (append qxt-meta-command-table
	  qxt-tr-command-table
	  qxt-is-command-table
	  )
  "debug $B$K;H$&%3%^%s%I%F!<%V%k(B")
