;; Quixote testing scheme

(defun qxt-test ()
  (interactive)
  (let ((qxt-synchronous t)
	(database-name "test")
	eval-line-start
	eval-line
	start
	end)
    (qxt-start nil)
    (goto-char (point-min))
    (message (buffer-name))
    (forward-page 1)
    (setq eval-line-start (point))
    (forward-line 1)
    (setq start (point))
    (setq eval-line (buffer-substring eval-line-start (1- (point))))
    (if (string= eval-line "")
	()
      (eval (read eval-line)))
    (save-excursion
      (forward-page 1)
      (setq end (1- (point))))
    (qxt-create-database start end database-name)
    (forward-page 1)
    (save-excursion
    (forward-page 1)
    (setq end-of-this-page (point)))
    (while (re-search-forward "^\\?-" end-of-this-page t)
      (forward-line 0)
      (let* ((expected
	      (buffer-substring
	       (save-excursion (re-search-backward "\n\n\\|\C-L\n")
			       (point))
	       (point))))
	(save-excursion
	  (set-buffer qxt-result-buffer)
	  (goto-char (point-max))
	  (insert expected))
	(setq start (point))
	(re-search-forward "\\.$" end-of-this-page)
	(setq end (point))
	(goto-char (point))
	(qxt-query start end)))
    (qxt-delete-database)
    (qxt-quit t)
    (accept-process-output qxt-process)
    ;; assume the file name is *.test ;;
    (let ((file-name buffer-file-name))
      (setq file-name (concat (substring file-name 0 -4) "result"))
      (switch-to-buffer "*Quixote*")
      (write-file file-name)
      (kill-buffer (current-buffer)))))
