
;;
;; inspect session commands
;;

;;
;; inspect_assumption
;;	C: inspect_assumption(SolutionNumber)
;;		SolutionNumber = Integer
;;	S: result_inspect_assuption(Status, Assumptions)
;;		Assumptions = [Assumption, ...]
;;		Assumption = Dot_cnstr | Var_cnstr
;;		Dot_cnstr  = form of SRC
;;		Var_cnstr  = form of SRC
;;
(defun qxt-inspect-assumption(SolutionNumber)
  "SolutionNumber$B$N%4!<%k$N2>DjIt$N<hF@$rAw?.$9$k!#(B
SolutionNumber = Integer
"
  (interactive "nSolutionNumber: ")
  (qxt-check-status 'inspect)
  (qxt-send-command (concat "{inspect_assumption," SolutionNumber "}" )))

;;
(defun qxt-result-inspect-assumption(Result)
  "$B%4!<%k$N2>DjIt$rI=<($9$k!#(B"
  (let ((Assumptions (aref Result 2)))
    (insert "** Assumption **\n")
    (while Assumptions
      (insert (concat "  " (qxt-lisp2qxt (car Assumptions))))
      (newline)
      (setq Assumptions (cdr Assumptions)))))

;;
;; inspect_conclusion
;;	C: inspect_conclusion(SolutionNumber)
;;	S: result_inspect_conclusion(Status,Conclusions)
;;		Conclusions = [Conclusion, ...]
;;		Conslusion = Dot_cnstr | Var_cnstr
;;
(defun qxt-inspect-conclusion(SolutionNumber)
  "SolutionNumber$B$N%4!<%k$N7kO@It$N<hF@$rAw?.$9$k!#(B
SolutionNumber = Integer
"
  (interactive "nSolutionNumber: ")
  (qxt-check-status 'inspect)
  (qxt-send-command (concat "{inspect_conclusion," SolutionNumber "}" )))

;;
(defun qxt-result-inspect-conclusion(Result)
  "$B%4!<%k$N7kO@It$rI=<($9$k!#(B"
  (let ((Conclusions (aref Result 2)))
    (insert "** Conclusion **\n")
    (while Conclusions
      (insert (concat "  " (qxt-lisp2qxt (car Conclusions))))
      (newline)
      (setq Conclusions (cdr Conclusions)))))

;;
;; inspect_variable
;;	C: inspect_variable(SolutionNumber, VariableName)
;;		VariableName = String
;;      S: result_inspect_variable(Status, Var_cnstrs)
;;              Var_cnstrs = [Var_cnstrs, ... ]
;;              Var_cnstr  = form of SRC
;;
(defun qxt-inspect-variable(SolutionNumber  VariableName)
  "SolutionNumber$B$N%4!<%k$NJQ?t(BVariableName$B$NCM$N<hF@$rAw?.$9$k!#(B
SolutionNumber = Integer
VariableName = String
"
  (interactive "nSolutionNumber: \nsVariableName: ")
  (qxt-check-status 'inspect)
  (qxt-send-command
   (concat "{inspect_variable," SolutionNumber ",\"" VariableName "\"}" )))

;;
(defun qxt-result-inspect-variable(Result)
  "$B%4!<%k$NJQ?t@)Ls$rI=<($9$k!#(B"
  (let ((VarCnstrs (aref Result 2)))
    (insert "** Variables **\n")
    (while VarCnstrs
      (insert (qxt-lisp2qxt (car VarCnstrs)))
      (newline)
      (setq VarCnstrs (cdr VarCnstrs)))))

;;
;; quit_inspect
;;	C: quit_inspect
;;	S: result_quit_inspect(Status)
;;
(defun qxt-quit-inspect()
  "$B%$%s%9%Z%/%H%;%C%7%g%s$N=*N;$rAw?.$9$k!#(B"
  (interactive)
  (qxt-check-status 'inspect)
  (qxt-send-command "quit_inspect" ) )

(defun qxt-result-quit-inspect (Result)
  "$B%+%l%s%H%;%C%7%g%s$r%H%l!<%9$K$9$k!#(B"
    (setq qxt-current-session 'trace))
