# Makefile for Qemacs-D

# for ME

QXTLISPDIR=/db/Quixote/v3/ME/lib/emacs
EMACS=/usr/local/bin/nemacs
ETAGS=/usr/local/bin/etags
COPY= /bin/cp
RM= /bin/rm
CAT= /bin/cat

SRCS= result.el comm.el databases.el lex.el parse.el server-s.el trace-s.el qshell.el

.SUFFIXES: .el .elc

all: qxt-mode.elc qxt-all.elc

install: qxt-mode.el qxt-all.el qxt-mode.elc qxt-all.elc
	${RM} -f ${QXTLISPDIR}/qxt-mode.elc ${QXTLISPDIR}/qxt-all.elc
	${RM} -f ${QXTLISPDIR}/qxt-mode.el ${QXTLISPDIR}/qxt-all.el
	${COPY} qxt-mode.el qxt-all.el qxt-mode.elc qxt-all.elc ${QXTLISPDIR}

clean:
	${RM} -f qxt-all.el qxt-all.elc qxt-mode.elc

TAGS:  ${SRCS}
	${ETAGS} ${SRCS}

qxt-all.el: ${SRCS}
	${RM} -f qxt-all.el
	${CAT} ${SRCS} > qxt-all.el

.el.elc:
	${RM} -f $@
	${EMACS} -batch -f batch-byte-compile $<
