/** read macros **/

/* PROGRAM */

#define mread_from_program(OBJECT, MEMBER, MACRO) \
  mread((OBJECT), "program", is_program_non_NULL, MEMBER, (MACRO))
#define mread_env_def(A) mread_from_program((A), env_def, "mread_env_def")
#define mread_exp_def(A) mread_from_program((A), exp_def, "mread_exp_def")
#define mread_obj_def(A) mread_from_program((A), obj_def, "mread_obj_def")
#define mread_mod_def(A) mread_from_program((A), mod_def, "mread_mod_def")
#define mread_link_def(A) mread_from_program((A), link_def, "mread_link_def")
#define mread_rule_def(A) mread_from_program((A), rule_def, "mread_rule_def")

/* ENVDEF */

#define mread_from_env_def(OBJECT, MEMBER, MACRO) \
  mread((OBJECT), "env_def", is_env_def_non_NULL, MEMBER, (MACRO))
#define mread_name(A) mread_from_env_def((A), name, "mread_name")
#define mread_author(A) mread_from_env_def((A), author, "mread_author")
#define mread_date(A) mread_from_env_def((A), date, "mread_date")
#define mread_def_libs(A) mread_from_env_def((A), def_libs, "mread_deflibs")

/* DEFLIB */

#define mread_from_def_lib(OBJECT, MEMBER, MACRO) \
  mread((OBJECT), "def_lib", is_def_lib_non_NULL, MEMBER, (MACRO))
#define mread_lib_lab(A) \
  ((A) == NULL ? NULL \
               : ((A)->tag == DEF_LIB) \
                     ? (A)->lib_lab \
                     : (type_error((A), "def_lib", "mread_lib_lab"), \
			NULL))
#define mread_lib_names(A) mread_from_def_lib((A), lib_names,"mread_lib_names")

/* STRING */

#define mread_str_data(A) \
  mread((A), "string", is_string_non_NULL, str_data, "mread_str_data")

/* EXP_DEF */

#define mread_exps(A) \
  mread((A), "exp_def", is_exp_def_non_NULL, exps, "mread_exps")

/* EXP */

#define mread_from_exp(OBJECT, MEMBER, MACRO) \
  mread((OBJECT), "exp", is_exp_non_NULL, MEMBER, (MACRO))
#define mread_exp_name(A) mread_from_exp((A), exp_name, "mread_exp_name")
#define mread_o_term_inExp(A) mread_from_exp((A), o_term, "mread_o_term_inExp")

/* OBJ_DEF */

#define mread_from_obj_def(OBJECT, MEMBER, MACRO) \
  mread((OBJECT), "obj_def", is_obj_def_non_NULL, MEMBER, (MACRO))
#define mread_obj_subs(A) mread_from_obj_def((A), obj_subs, "mread_obj_subs")

/* OBJ_SUB */
#define mread_from_obj_sub(OBJECT, MEMBER, MACRO) \
  mread((OBJECT), "obj_sub", is_obj_sub_non_NULL, MEMBER, (MACRO))
#define mread_bobj1(A) mread_from_obj_sub((A), bobj1, "mread_bobj1")
#define mread_bobj2(A) mread_from_obj_sub((A), bobj2, "mread_bobj2")
