/** identification macros **/

#define is_set_non_NULL(A) ((A)->tag == SET)
#define is_value_non_NULL(A) ((A)->tag == VALUE || \
  is_set_non_NULL(A) || is_sort_non_NULL(A) || is_o_term_non_NULL(A))
#define is_cnstr_data_non_NULL(A) ((A)->tag == CNSTR_DATA)
#define is_query_cnstr_non_NULL(A) ((A)->tag == QUERY_CNSTR)
#define is_cnstr_non_NULL(A) ((A)->tag == CNSTR || \
  is_cnstr_data_non_NULL(A) || is_query_cnstr_non_NULL(A))
#define is_prolog_non_NULL(A) ((A)->tag == PROLOG)
#define is_var_non_NULL(A) ((A)->tag == VAR)
#define is_sort_non_NULL(A) ((A)->tag == SORT)
#define is_query_non_NULL(A) ((A)->tag == QUERY)
#define is_p_mode_non_NULL(A) ((A)->tag == P_MODE)
#define is_a_mode_non_NULL(A) ((A)->tag == A_MODE)
#define is_i_mode_non_NULL(A) ((A)->tag == I_MODE)
#define is_m_mode_non_NULL(A) ((A)->tag == M_MODE)
#define is_e_mode_non_NULL(A) ((A)->tag == E_MODE)
#define is_q_mode_non_NULL(A) ((A)->tag == Q_MODE || \
  is_p_mode_non_NULL(A) || is_a_mode_non_NULL(A) || \
  is_i_mode_non_NULL(A) || is_m_mode_non_NULL(A) || is_e_mode_non_NULL(A))
#define is_answer_non_NULL(A) ((A)->tag == ANSWER)
#define is_answer_element_non_NULL(A) ((A)->tag == ANSWER_ELEMENT)
#define is_anse_explanation_non_NULL(A) ((A)->tag == ANSE_EXPLANATION)
#define is_rir_pair_non_NULL(A) ((A)->tag == RIR_PAIR)
#define is_dot_cnstr_non_NULL(A) ((A)->tag == DOT_CNSTR)
#define is_var_cnstr_non_NULL(A) ((A)->tag == VAR_CNSTR)



#define is_set(A) ((A) == NULL || is_set_non_NULL(A))
#define is_value(A) ((A) == NULL || is_value_non_NULL(A))
#define is_cnstr_data(A) ((A) == NULL || is_cnstr_data_non_NULL(A))
#define is_query_cnstr(A) ((A) == NULL || is_query_cnstr_non_NULL(A))
#define is_cnstr(A) ((A) == NULL || is_cnstr_non_NULL(A))
#define is_prolog(A) ((A) == NULL || is_prolog_non_NULL(A))
#define is_var(A) ((A) == NULL || is_var_non_NULL(A))
#define is_sort(A) ((A) == NULL || is_sort_non_NULL(A))
#define is_query(A) ((A) == NULL || is_query_non_NULL(A))
#define is_p_mode(A) ((A) == NULL || is_p_mode_non_NULL(A))
#define is_a_mode(A) ((A) == NULL || is_a_mode_non_NULL(A))
#define is_i_mode(A) ((A) == NULL || is_i_mode_non_NULL(A))
#define is_m_mode(A) ((A) == NULL || is_m_mode_non_NULL(A))
#define is_e_mode(A) ((A) == NULL || is_e_mode_non_NULL(A))
#define is_q_mode(A) ((A) == NULL || is_q_mode_non_NULL(A))
#define is_answer(A) ((A) == NULL || is_answer_non_NULL(A))
#define is_answer_element(A) ((A) == NULL || is_answer_element_non_NULL(A))
#define is_anse_explanation(A) ((A) == NULL || is_anse_explanation_non_NULL(A))
#define is_rir_pair(A) ((A) == NULL || is_rir_pair_non_NULL(A))
#define is_dot_cnstr(A) ((A) == NULL || is_dot_cnstr_non_NULL(A))
#define is_var_cnstr(A) ((A) == NULL || is_var_cnstr_non_NULL(A))






