#ifdef sequent
#include <stdio.h>
#else
#include <stddef.h>
#endif /* for NULL */

#include "hash.h"

Local int hasher(key)
     char* key;
{
    int hash = 0;

    if (key != NULL)
      for (; *key != '\0'; ++key)
	hash += 3 * *key + 7;
    return hash;
}

Public HashTable* new_hash_table(size)
     int size;
{
    HashTable* h = (HashTable*)malloc(sizeof(HashTable));
    HashEntry* e = (HashEntry*)calloc(size, sizeof(HashEntry));
    h->count = 0;
    h->size = size;
    h->elements = e;
    return h;
}

Local char* find_item_in_entry_list(hash_entry, key, cmp)
     HashEntry* hash_entry;
     char* key;
     int (*cmp)();
{
    if (hash_entry == NULL)
      return NULL;
    else
      if ((*cmp)(hash_entry->key, key))
	return hash_entry->data;
      else
	return find_item_in_entry_list(hash_entry->next, key, cmp);
}

Public char* find_item(hash_table, key, cmp)
     HashTable *hash_table;
     char* key;
     int (*cmp)();
{
    int hash = hasher(key) % hash_table->size;

    return find_item_in_entry_list(hash_table->elements[hash].next,
				   key, cmp);
}

Local char* add_item_in_entry_list(hash_entry, key, data, cmp)
     HashEntry* hash_entry;
     char *key, *data;
     int (*cmp)();
{
    if (hash_entry->next == NULL) {
	hash_entry->next = (HashEntry*)malloc(sizeof(HashEntry));
	hash_entry->next->key = key;
	hash_entry->next->data = data;
	hash_entry->next->next = NULL;
	return NULL;
    }
    else
      if ((*cmp)(hash_entry->next->key, key))
	return hash_entry->next->data;
      else
	return add_item_in_entry_list(hash_entry->next, key, data,
				      cmp);
}

Public char* add_item(hash_table, key, data, cmp)
     HashTable *hash_table;
     char *key, *data;
     int (*cmp)();
{
    int hash = hasher(key) % hash_table->size;
    char* result = add_item_in_entry_list(&hash_table->elements[hash],
					  key, data, cmp);
    if (result == NULL)
      ++hash_table->count;
    return result;
}

Local char* remove_item_in_entry_list(hash_entry, key, cmp)
     HashEntry* hash_entry;
     char* key;
     int (*cmp)();
{
    if (hash_entry->next == NULL)
      return NULL;
    else
      if ((*cmp)(hash_entry->next->key, key)) {
	  HashEntry* tmp = hash_entry->next;
	  char* result = tmp->data;
	  hash_entry->next = tmp->next;
	  free(tmp->key);
	  free((char*)tmp);
	  return result;
      }
      else
	return remove_item_in_entry_list(hash_entry->next, key, cmp);
}

Public char* remove_item(hash_table, key, cmp)
     HashTable *hash_table;
     char* key;
     int (*cmp)();
{
    int hash = hasher(key) % hash_table->size;
    char* result =
      remove_item_in_entry_list(&hash_table->elements[hash],
				key, cmp);
    if (result != NULL)
      --hash_table->count;
    return result;
}
