/***********************************
 *    dotsrc.h                     *
%$             1992-10-13          $%
 ***********************************/

#include <stdio.h>
#include <assert.h>
#include <sys/types.h>

typedef  int  Bool;

/******************   Structure Declarations  ************************/

struct program;
struct env_def;
struct def_lib;
struct string;
struct exp_def;
struct exp;
struct obj_def;
struct obj_sub;
struct mod_def;
struct m_sub;
union  m_desc;
struct m2_desc;
union  o_term;
struct link_def;
struct link;
struct m_id_pair;
struct o_term_pair;
struct rule_def;
struct rule;
struct rule_id;
union  cluster;
struct normal;
struct rel;
struct update;
struct transaction;
union  i_check_content;
struct i_check;
struct prop;
struct a_term;
struct c_o_term;
struct dot;
struct label;
union  list;
struct sub_list;
union  remain;
union  non_struct;
struct exp_name;
struct integer;
struct attr;
union  value;
struct set;
union  cnstr;
struct cnstr_data;
struct query_cnstr;
struct prolog;
struct var;
struct sort;
struct query;
union  q_mode;
struct p_mode;
struct a_mode;
struct i_mode;
struct m_mode;
struct e_mode;
struct answer;
struct answer_element;
struct anse_explanation;
struct rir_pair;
struct dot_cnstr;
struct var_cnstr;
union  explanation;
union  unit_explanation;
struct inherit;
struct merge_explanation;
struct lookup_explanation;
struct fact;
union  one_rule;
struct reduce;
struct sub_goal;
struct vc_pair;
struct constraint;
struct con;
struct assump;
struct obj_element;
struct obj_list;
struct obj_array;
union  pseudo_object;

/******************   Type Definitions  ************************/

typedef  struct program          Program;
typedef  struct env_def          EnvDef;
typedef  struct def_lib          DefLib;
typedef  struct string           String;
typedef  struct exp_def          ExpDef;
typedef  struct exp              Exp;
typedef  struct obj_def          ObjDef;
typedef  struct obj_sub          ObjSub;
typedef  struct mod_def          ModDef;
typedef  struct m_sub            MSub;
typedef  union  m_desc           MDesc;
typedef  struct m2_desc          M2Desc;
typedef  union  o_term           MId;
typedef  struct link_def         LinkDef;
typedef  struct link             Link;
typedef  struct m_id_pair        MIdPair;
typedef  struct o_term_pair      OTermPair;
typedef  struct rule_def         RuleDef;
typedef  struct rule             Rule;
typedef  struct rule_id          RuleId;
typedef  union  cluster          Cluster;
typedef  struct normal           Normal;
typedef  struct rel              Rel;
typedef  struct update           Update;
typedef  struct transaction      Transaction;
typedef  union  i_check_content  ICheckContent;
typedef  struct i_check          ICheck;
typedef  ICheck                  Consis;
typedef  ICheck                  InConsis;
typedef  struct prop             Prop;
typedef  struct a_term           ATerm;
typedef  union  o_term           OTerm;
typedef  struct c_o_term         COTerm;
typedef  struct dot              Dot;
typedef  struct label            Label;
typedef  Label                   IndLab;
typedef  Label                   SetLab;
typedef  Label                   CurlInd;
typedef  Label                   CurlSet;
typedef  union  list             List;
typedef  struct sub_list         SubList;
typedef  union  remain           Remain;
typedef  union  non_struct       NonStruct;
typedef  struct exp_name         ExpName;
typedef  struct integer          Integer;
typedef  struct attr             Attr;
typedef  union  value            Value;
typedef  struct set              Set;
typedef  union  cnstr            Cnstr;
typedef  struct cnstr_data       CnstrData;
typedef  struct query_cnstr      QueryCnstr;
typedef  struct prolog           Prolog;
typedef  struct var              Var;
typedef  struct sort             Sort;
typedef  struct query            Query;
typedef  union  q_mode           QMode;
typedef  struct p_mode           PMode;
typedef  struct a_mode           AMode;
typedef  struct i_mode           IMode;
typedef  struct m_mode           MMode;
typedef  struct e_mode           EMode;
typedef  struct answer           Answer;
typedef  struct answer_element   AnswerElement;
typedef  struct anse_explanation AnseExplanation;
typedef  struct rir_pair         RirPair;
typedef  struct dot_cnstr        DotCnstr;
typedef  struct var_cnstr        VarCnstr;
typedef  union  explanation      Explanation;
typedef  union  unit_explanation UnitExplanation;
typedef  struct inherit          Inherit;
typedef  struct merge_explanation   MergeExplanation;
typedef  struct lookup_explanation  LookupExplanation;
typedef  struct fact             Fact;
typedef  union  one_rule         OneRule;
typedef  struct reduce           Reduce;
typedef  struct sub_goal         SubGoal;
typedef  struct vc_pair          VcPair;
typedef  struct constraint       Constraint;
typedef  struct con              Con;
typedef  struct assump           Assump;
typedef  struct string           QueryExplanation; 
typedef  struct obj_element      ObjElement;
typedef  struct obj_list         ObjList;
typedef  struct obj_array        ObjArray;
typedef  union  pseudo_object    PseudoObject;

/**********************  Enumeration Constant  **********************/
typedef enum {PROGRAM=1, ENV_DEF, DEF_LIB, STRING, EXP_DEF, EXP,
		EXP_NAME, OBJ_DEF, OBJ_SUB, MOD_DEF, M_SUB, M_DESC,
		M2_DESC, LINK_DEF, LINK, M_ID_PAIR, O_TERM_PAIR,
		RULE_DEF, RULE, RULE_ID, NORMAL, REL, UPDATE,
		TRANSACTION, PROP, I_CHECK_CONTENT,I_CHECK, CONSIS, 
		INCONSIS, CLUSTER, A_TERM, O_TERM, LABEL, LAB, IND_LAB, 
		SET_LAB, CURL_IND, CURL_SET, C_O_TERM, PROLOG, VAR, DOT,
		SUB_LIST, LIST, REMAIN, INTEGER, NON_STRUCT, ATTR,
		SET, SORT, VALUE, CNSTR_DATA, QUERY_CNSTR, CNSTR,
		QUERY, P_MODE, A_MODE, I_MODE, M_MODE, E_MODE, Q_MODE,
		ANSWER, ANSWER_ELEMENT, ANSE_EXPLANATION, RIR_PAIR, 
		DOT_CNSTR, VAR_CNSTR, INHERIT,	REDUCE, SUB_GOAL, 
		VC_PAIR, ONE_RULE, FACT, UNIT_EXPLANATION, MERGE_EXPLANATION, 
		LOOKUP_EXPLANATION, EXPLANATION, CONSTRAINT, CON, ASSUMP, 
		QUERY_EXPLANATION, PSEUDO_OBJECT, OBJ_LIST, OBJ_ARRAY}
TypeDescriptor;

#define M_ID O_TERM

/*** Library Labels ***/
/*  '&exp_lib | '&pgm_lib' | '&sort_lib'  */
typedef enum{EXPLIB=1, PGMLIB, SORTLIB} LibLab;

/*** Rule Classes ***/
/*  '&no_update' | '&update' */
typedef enum {RCNOUPDATE=1, RCUPDATE} RuleClass;

/*** Rule Inheritance Mode ***/
/* '&l' | '&o' | '&lo' | '&ol' | &void  */
typedef enum {IML=1, IMO, IMLO, IMOL} InheritanceMode;

/*** No Assumption  ***/
typedef enum {NOASSUME=1} NoAssume;

/*** Update Flags ***/
/*  '+' | '-'  */
typedef enum {UFPLUS=1, UFMINUS} UFlag;

/*** Transaction Controllers ***/
/*  '&bt' | '&et' | '&at' */
typedef enum {TDBT=1, TDET, TDAT}  TrnData;

/*** Attribute Operators ***/
/*  '->' | '<-' | '=' */
typedef enum {ATRARROW=1, ATLARROW, ATEQ} AttrOp;

/*** Constraint Relations ***/
/*  '=<' | '>=' | '==' | '+<' | '>+' | '=+=' | '*<' | '>*' | '=*=' | 
    '&in' | '&ni'  */
typedef enum {CNLE=1,CNGE,CNEQ,CNPL,CNPG,CNEPE,CNAL,CNAG,CNEAE,CNIN,CNNI} 
             CnRel;

/*** VarType var$B$N%G!<%?%?%$%W(B ***/
typedef enum {VARIND=1,VARSET}  VarType;

/*** Process Mode Data ***/
/*  '&single' | '&multi'  */
typedef  enum{PSINGLE=1,PMULTI}     PModeData;

/*** Assumption Mode Data ***/
/*  '&normal' | '&minimal'  */
typedef  enum{ANORMAL=1,AMINIMAL}   AModeData;

/*** Inheritance Mode Data ***/
/*  '&all' | '&down' | '&up' | '&no'  */
typedef  enum{IALL=1,IDOWN,IUP,INO} IModeData;

/*** Merge Mode Data ***/
/*  '&yes' | '&no'  */
typedef  enum{MYES=1,MNO}           MModeData;

/*** Explanation Mode Data ***/
/*  '&on | '&off'  */
typedef  enum{EON=1,EOFF}           EModeData;


/*********************  Object List & Array   **************************/
/**** ObjElement ****/
struct obj_element {
    PseudoObject* element;
    ObjElement* next;
};

/********  ObjList  *******/
struct obj_list {
    TypeDescriptor tag;
    TypeDescriptor element_tag;   
    ObjElement*    first;
    ObjElement*    last;
};

/********  ObjArray  *******/
struct obj_array {
    TypeDescriptor tag;
    TypeDescriptor element_tag;
    size_t         size;
    PseudoObject** elements;
};

/******************  Program  ***************/
/**********************/
/*   Program          */
/**********************/
/***  $Program  ***/
struct program {
    TypeDescriptor tag;
    EnvDef*        env_def;       /* $Env_def | NULL -> &void */
    ExpDef*        exp_def;       /* $Exp_def | NULL -> &void */
    ObjDef*        obj_def;       /* $Obj_def | NULL -> &void */
    ModDef*        mod_def;       /* $Mod_def | NULL -> &void */
    LinkDef*       link_def;      /* $Link_def | NULL -> &void */
    RuleDef*       rule_def;      /* $Rule_def | NULL -> &void */
};
          /* $B%a%s%P!<$NCM$,(B NULL $B$N$H$-$O(B &void   */

/********************* Env_def *******************/
/******************/
/*  Env_def       */
/******************/
/*** $Env_def ***/
struct env_def {
    TypeDescriptor tag;  
    char*          name;      /*  atom | NULL -> &void  */
    char*          author;    /*  atom | NULL -> &void  */
    char*          date;      /*  atom | NULL -> &void */
    ObjList*       def_libs;  /* [$Def_lib ,...] */
};

/**************/
/* Def_lib    */
/**************/
/*** $Def_lib ***/
struct def_lib {
    TypeDescriptor tag;  
    LibLab         lib_lab;     /* &exp_lib|&prg_lib|&sort_lib */
    ObjList*       lib_names;   /* [String,...] */
};
          
/*** String ***/
struct string {
    TypeDescriptor tag;  
    char*          str_data;       /* $BJ8;zNs%G!<%?$X$N%]%$%s%?(B */
};

/*************************  Exp_def *************************/
/******************/
/*   Exp_def      */
/******************/
/*** $Exp_def  ***/
struct exp_def {
    TypeDescriptor tag;
    ObjList*       exps;                /* [$Exp,...] */
};

/***************/
/*  Exp        */
/***************/
/*** $Exp_name ***/
struct exp_name {
    TypeDescriptor tag;
    char*          name;                /* "e_"<string> */
};

/*** $Exp ***/
struct exp {
    TypeDescriptor tag;  
    ExpName*       exp_name;           /* $Exp_name */
    OTerm*         o_term;             /* O_term */
};

/************************ Obj_def ******************************/
/********************/
/*  Obj_def         */
/********************/
/*** $Obj_def ***/
struct obj_def {
    TypeDescriptor tag;  
    ObjList*       obj_subs;            /* [$Obj_sub,...]  */
};

/*************/
/* Obj_sub   */
/*************/
/*** obj_sub ***/
struct obj_sub {
    TypeDescriptor tag;  
    char*          bobj1;              /* atom */
    char*          bobj2;              /* atom */
};  

/********************** Mod_def ***********************************/
/*****************/
/*  Mod_def      */
/*****************/
/*** $Mod_def ***/
struct mod_def {
    TypeDescriptor tag;  
    ObjList*       m_subs;             /* [$M_sub,...] */
};

/**************/
/*  M_sub     */
/**************/
/*** $M_sub ***/
struct m_sub{
  TypeDescriptor    tag;  
  MId*              m_id;             /* $M_id */
  MDesc*            m_desc;           /* $M_desc */
};

/**************/
/* M_desc     */
/**************/
/*** $M_desc ***/
union m_desc {
  TypeDescriptor    tag;  
  MId*              m_id;           /* $M_id */
  M2Desc*           m2_desc;        /* $M_desc1, Op, $M_desc2 --> m2_desc */
};

/*** m2_desc ***/
struct m2_desc {
  TypeDescriptor    tag;  
  MDesc*            m_desc1;        /* m_desc1 */
  char              op;             /* op = +|- */
  MDesc*            m_desc2;        /* m_desc2 */
};

/***************************** Link_def ******************************/
/***************/
/* Link_def    */
/***************/
/*** $Link_def ***/
struct link_def {
    TypeDescriptor tag;  
    ObjList*       links;           /* [$Link,...] */
};

/**************/
/*  Link      */
/**************/
/*** $Link ***/
struct link {
  TypeDescriptor    tag;  
  char*             link_name; /* atom */
  ObjList*          m_ids;     /* [{$M_id1,$Mid2},...] */
  ObjList*          o_terms;   /* [{$O_term1,$O_term2},...] */
};

/* m_id_pair ---> {$M_id1,$Mid2} */
struct m_id_pair {
  TypeDescriptor    tag;  
  MId*              m_id1;
  MId*              m_id2;
};

/* o_term_pair ---> {$O_term1,$O_term2} */
struct o_term_pair {
  TypeDescriptor    tag;  
  OTerm*            o_term1;
  OTerm*            o_term2;
};

/*************************** Rule_def **********************/
/*******************/
/*   Rule_def      */
/*******************/
/*** $Rule_def ***/
struct rule_def {
    TypeDescriptor    tag;  
    ObjList*          rules;      /* [$Rule,...] */
};

/*****************/
/*   Rule        */
/*****************/
/*** $Rule ***/
struct rule {
    TypeDescriptor    tag;  
    RuleClass         rule_class;        /* &no_update | &update */
    ObjList*          m_ids;             /* [$M_id,...] */
    RuleId*           rule_id;           /* String | &void */
    InheritanceMode   inheritance_mode;  /* &l | &o | &lo | &ol */
    NoAssume          no_assume;         /* '&no_assume' | &void */
    ATerm*            a_term;            /* $A_term */
    ObjList*          clusters;          /* [$Cluster,...] */
    ObjList*          cnstrs;            /* [$Cnstr,..] */
};

/*** RuleId ***/
struct rule_id {
   TypeDescriptor   tag;
   char*            rule_id_string;
};

/************/
/*  Cluster */
/************/
/*** normal ***/
struct normal {
  TypeDescriptor    tag;  
  MId*              m_id;           /* $Mid */
  ATerm*            a_term;         /* $A_term */
};

/*** rel ***/
struct rel {
    TypeDescriptor tag;  
    OTerm*         o_term1;    /* $O_term  */
    CnRel          sub_rel;    /* '<=' |  '>=' | '==' */
    OTerm*         o_term2;    /* $O_term  */
};

/*** update ***/
struct update {
    TypeDescriptor    tag;  
    UFlag             u_flag;      /*  '+' | '-' */
    MId*              m_id;       /* $Mid */
    ATerm*            a_term;     /* $A_term */
};

/*** transaction ***/
struct transaction {
  TypeDescriptor    tag;  
  TrnData           trn_data;    /* '&bt' | '&et' | '&at'  */
};

/***********/
/* I_check */
/***********/
/** Prop **/
struct prop {
  TypeDescriptor    tag;  
  MId*              m_id;      /* $Mid */
  ATerm*            a_term;     /* $A_term */
};

/*** $I_check_conyent  ***/
union i_check_content {
  TypeDescriptor    tag;  
  Prop              prop;      /* prop$B$N%G!<%?(B  */
  ObjList           cnstrs;    /* [$Cnstr,...] */
};

/*** $I_check **/
struct i_check {
     TypeDescriptor   tag;
  ICheckContent    *i_check_content;
};

/*** $Cluster ***/
union cluster {
  TypeDescriptor    tag;  
  Normal            normal;        
  Rel               rel;
  Update            update;
  Transaction       transaction;
  Consis            consis;
  InConsis          inconsis;
};

/********************  A_term  *******************************/
/**************/
/*  A_term    */
/**************/
/*** $A_term  ***/
struct a_term {
    TypeDescriptor    tag;
    OTerm*            o_term;    /* $Oterm  */
    ObjList*          attrs;      /* [$Attr,...]  */
    ObjList*          cnstrs;     /* [$Cnstr,...]  */
};

/*********************  O_term  *********************************/
/*** $Label ***/
/** Label **/
struct label {
    TypeDescriptor    tag;
    OTerm*            o_term;
};

/*****************/
/*  C_o_term     */
/*****************/
/*** $C_o_term ***/
struct c_o_term {
    TypeDescriptor    tag;  
    char*             head;      /* atom */
    ObjList*          attrs;     /* [$Attr,...] */
    ObjList*          cnstrs;    /* [$Cnstr,...] */
};

/**************/
/*  Prolog    */
/**************/
struct  prolog{
   TypeDescriptor    tag;  
   char*             head;
   ObjList*          o_terms;
 };

/***********/
/*  Var    */
/***********/
/*** $Var ***/
struct var {
  TypeDescriptor    tag;  
  VarType           type;       /* var$B%G!<%?$N%?%$%W<1JL(B   ind or set */
  char*             var_data;   /* var$B$N%G!<%?(B  String */
};
         
/*************/
/* Dot       */
/*************/
/*** $Dot ***/
struct dot {
  TypeDescriptor     tag;  
  OTerm*             o_term;   /* $O_term */
  Label*             label;    /* $Label = $O_term */
};

/************/
/* List     */
/************/
/*** sub_list  {[$O_term,...],Remain} ***/
struct sub_list {
    TypeDescriptor tag;
    ObjList*       o_terms;     /* [$O_term,..] */
    Remain*        remain;      /* Remain */
};

/*** $List ***/
union list {
    TypeDescriptor tag;
    ObjList        normal;    /*  [$O_term,...]          */
    SubList        sub_list;  /*  {[$O_term,...],Remain} */
};
/* nil([]) $B$O(BNULL $B$GI=$9(B */

/*** Remain ***/
/* Remain = $List | $Var  */
union remain {
    TypeDescriptor tag;
    List           list;
    Var            var;
};

/***************/
/* Non_struct  */
/***************/
/*** Integer ***/
struct integer {
    TypeDescriptor tag;  
    int            value;
};

/*** $Non_struct ***/
union non_struct {
    TypeDescriptor tag;  
    ExpName        exp_name;
    String         string;
    Integer        integer;
};

/**************/
/*  O_term    */
/**************/
/*** $O_term ***/
union o_term {
  TypeDescriptor    tag;  
  Prolog            prolog;      /*  $Progaram */
  COTerm            c_o_term;     /*  $C_o_term */
  Var               var;          /*  $Var */
  Dot               dot;          /*  $Dot */
  List              list;         /*  $List */
  NonStruct         non_struct;   /*  $Non_struct */
};

/**************************  ETC ************************************/
/**************/
/* Attr       */
/**************/
/*** $Attr ***/

struct attr {
    TypeDescriptor    tag;  
    Label*            label;        /* $Label */
    AttrOp            attr_op;      /*   '->' | '<-' | '=='  */
    Value*            value;        /* $Value */
};

/*** $Set ***/
struct set {
    TypeDescriptor    tag;  
    ObjList*          o_terms;       /*  [$O_term,...] */
};

/*****************/
/* Sort          */
/*****************/         
/*** $Sort ***/
struct sort {
    TypeDescriptor tag;
    Prolog*        prolog;   /*  $Prolog ???  */
};

/*** $Value ***/
/* $Value = $Set | $Sort | $OTerm */

/*** value_data ***/
union value {
    TypeDescriptor    tag;  
    Set               set;          /* $Set */
    Sort              sort;         /* $Sort */
    OTerm             o_term;       /* $O_term */
};

/**************/
/* Cnstr      */
/**************/
/*** query_cnstr ***/
struct query_cnstr {
    TypeDescriptor tag;
    MId* m_id1;
    MId* m_id2;
};

/*** cnstr_data ***/
struct cnstr_data {
    TypeDescriptor    tag;  
    MId*              m_id1;       /* $M_id | NULL -> &void */
    Value*            value1;      /* $Value */
    CnRel             rel;         /* '=<' | '>=' | '==' | '+<' | '>+' */
                                   /* '=+=' |'&in" | '&ni' */
    MId*              m_id2;       /* $M_id | NULL -> &void */
    Value*            value2;      /* $Value */
};

/*** $Cnstr ***/
union cnstr {
    TypeDescriptor tag;
    CnstrData      cnstr;
    QueryCnstr     query_cnstr;
};  

/********************  Query ********************************/
/*************/
/* Query     */
/*************/
/*** query ***/
struct query {
    TypeDescriptor    tag;  
    RuleClass         query_class;    /* &no_update | &update  */
    ATerm*            q_head;         /* $A_term | &void */
    ObjList*          clusters;       /* [$Cluster,...] */
    ObjList*          cnstrs;         /* [Cnstr,...]    */
    ObjList*          q_modes;        /* [Q_mode,...]   */
    Program*          program;        /* Program | &void = NULL  */
};

/*** P_mode ***/
struct p_mode {
    TypeDescriptor tag;  
    PModeData      p_mode_data;
};

/*** A_mode ***/
struct a_mode {
    TypeDescriptor tag;  
    AModeData      a_mode_data;
};

/*** I_mode ***/
struct i_mode {
    TypeDescriptor tag;  
    IModeData      i_mode_data;
};

/*** M_mode ***/
struct  m_mode {
    TypeDescriptor tag;  
    MModeData      m_mode_data;
};

/*** E_mode ***/
struct e_mode {
    TypeDescriptor tag;  
    EModeData      e_mode_data;
};

/*** q_mode ***/
union q_mode {
    TypeDescriptor tag;  
    PMode          p_mode;
    AMode          a_mode;
    IMode          i_mode;
    MMode          m_mode;
    EMode          e_mode;
};

/*************/
/*  Answer   */
/*************/
/*** $Answer ***/
struct answer {
    TypeDescriptor    tag;  
    ObjList*          answer_elements;   /* [$Answer_element,..] */
};

/**** $Answer_element ***/
struct answer_element {
    TypeDescriptor    tag;  
    ObjList*          dot_cnstrs;        /* [$Dot_cnstr,..] */
    ObjList*          var_cnstrs;        /* [$Var_cnstr,..] */
    AnseExplanation*  anse_explanation;       
};
 
/*** answer_element_explanation ***/
struct anse_explanation {
    TypeDescriptor    tag;  
    Explanation*      explanation;        
    ObjList*          rir_pairs;         /* [{Rule_id, $Rule},...] */
};
  
/*** pair_of_rule_id_and_rule ***/
struct rir_pair {
    TypeDescriptor    tag;  
    RuleId*           rule_id;
    Rule*             rule;
};

/*************/
/* Dot_cnstr */
/*************/
/*** $Dot_cnstr ***/
struct dot_cnstr {
  TypeDescriptor    tag;  
  MId*              m_id;      /* $M_id | NULL -> &void */
  Dot*              dot;       /*  $Dot  */
  CnRel             rel;       /* '=<' | '>=' | '==' | '*<' | '>*' | '=*='*/
  Value*            value;     /* $Value */
};

/*************/
/* Var_cnstr */
/*************/
/*** $Var_cnstr ***/
struct var_cnstr {
  TypeDescriptor    tag;  
  Var*              var;       /* $Var */
  CnRel             rel;       /* '=<' | '>=' | '==' | '*<' | '>*' | '=*='*/
  Value*            value;     /* $Value */
};

/****************/
/* Explanation  */
/****************/
/*** inherit ***/
/*  inherit({$One_rule,Up,Down}) */
struct inherit {
    TypeDescriptor tag;
    OneRule*       one_rule;   /* $One_rule  */
    ObjList*       ups;        /* up([$OneRule,..] | &void = NULL */
    ObjList*       downs;      /* down([$OneRule,..] | &void = NULL */
};

/***************/
/*  One_rule   */
/***************/
/*** Reduce ***/
/* reduce({$Subgoal,Rule_id,[$Explanation,...],[$Assumption,...]}) */
struct reduce {
    TypeDescriptor tag;
    SubGoal*       sub_goal;    /* $Subgoal */
    RuleId*        rule_id;     /* Rule_id */
    ObjList*       explanations; /* [$Explanation,..] */
    ObjList*       assumps;   /* [&Assump,...] | &void = NULL */
                              /* .src data structure modified. &void => [] */
};  

/*************/
/* Subgoal   */
/*************/
struct sub_goal {
    TypeDescriptor tag;  
    MId*           m_id;              /* $MId */
    OTerm*         o_term;            /* $O_term */
    ObjList*       vc_pairs;          /* [{$Var,$Constraint},...] */
};

/*** vc_pair ***/
struct vc_pair {
  TypeDescriptor tag;  
  Var*           var;               /* $Var */
  Constraint*    constraint;        /* $Constraint */
};

/*** Fact ***/
struct fact {
    TypeDescriptor   tag;  
    char*            fact_data;
};

/*** $One_rule ***/
union one_rule {
    TypeDescriptor   tag;  
    Reduce           reduce;  /* {$Subgoal,Rule_id,[$Explanation,..],Assump} */
    Fact             rule_id; /* string */
    QueryExplanation query;   /* query $B$H$$$&(B atom */
};


/*********************/
/* Unit_explanation  */
/*********************/
/*** $Unit_explanation ***/
/* unit($Unit_explanation) */
union unit_explanation {
    TypeDescriptor tag;  
    OneRule        one_rule;
    Inherit        inherit;
};

/*** $MergeExplanation ***/
/* merge([$Unit_explanation,...]) */
struct merge_explanation {
    TypeDescriptor tag;  
    ObjList*       unit_explanations;   /* [$Unit_explanation,...] */
};

/*** $LookupExplanation  ***/
/* lookup({$Subgoal, LookedS, LookingS, $Explanation}) */
struct lookup_explanation {
    TypeDescriptor    tag;  
    SubGoal*          sub_goal;            /* $Subgoal */
    int               looked_s;            /* LookedS */
    int               looking_s;           /* LookingS */
    Explanation*      explanation;         /* $Explanation */
};

/*** $Explanation ***/
union explanation {
    TypeDescriptor    tag;  
    UnitExplanation   unit;   /* $Unit_explanation */
    MergeExplanation  merge;  /* [$Unit_explanation,...] */
    LookupExplanation lookup; /* {$Subgoal,LookedS,LookingS,$Expalnation} */
};

/***************/
/* Constraint  */
/***************/
struct constraint{
    TypeDescriptor tag;  
    Con*           const_data;  /*  con({[$O_term,..],[$O_term,..]} | &void */
};

/*** con ***/
/*  {[$O_term,..],[$O_term,..]}  */
struct con {
    TypeDescriptor tag;  
    ObjList*       o_terms1;     /* [$O_term,..] */
    ObjList*       o_terms2;     /* [$O_term,..] */
};

/**************/
/* Assump     */
/**************/
/*** $Assump  ***/
struct assump {
    TypeDescriptor tag;  
    MId*           m_id;           /* $M_id | NULL -> &void  */
    Dot*           dot;            /* $Dot */
    ObjList*       vc_pairs;       /* [{$Var,$Constraint},...] */
};

/**** PseudoObject ****/
union pseudo_object {
    TypeDescriptor  tag;
    Program         program;
    EnvDef          env_def;
    DefLib          def_lib;
    String          string;
    Exp             exp;
    ObjSub          obj_sub;
    MSub            m_sub;
    Link            link;
    MIdPair         m_id_pair;
    OTermPair       o_term_pair;
    Rule            rule;
    Cluster         cluster;
    OTerm           oterm;
    Attr            attr;
    Set             set;
    Cnstr           cnstr;
    QMode           q_mode;
    AnswerElement   answer_element;
    DotCnstr        dot_cnstr;
    VarCnstr        var_cnstr;
    VcPair          vc_pair;
    OneRule         one_rule;
    UnitExplanation unit_explanation;
    Explanation     explanation;
};
