/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *      ifmt_convifmt.c
 *   DESCRIPTION
 *      ֥եޥåȡKlicǡˤեޥåȡʣåǡ
 *      Ѵ롣
 *   INTERFACE ROUTINES
 *      fmt_ConvIfmt  - ֥եޥåȤեޥåȤѴ롣
 *      fmt_FreeArea  - եޥåȤΰ롣
 *   NOTES:
 *
 *$  EDITOR : Toru Kawamura
 *$  CREATE : '94-06-07
 *$  UPDATE :     06-30
 *$               07-13   ConvNilWK
 *$               08-19   (1) "Table" added at GetAttrInfo
 *$                       (2) fmt_FreeArea
 *$               09-12
 *$           '95-02-10   ConvOccCnt  add (*tmp)->next = NULL;
 ***********************************************************************/
#include <stddef.h>
#include <string.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/index.h>
#include <klic/generic.h>
#include <klic/gd_macro.h>
#include <klic/g_basic.h>
#include <klic/atomstuffs.h>
#include <klic/functorstuffs.h>
#include <klic/g_pointer.h>
#include "ifmt.h"
/*#include "shp.h"*/
#include "../../lib/libstring.h"
#include "../../shp/shp.h"

#define KP_DEREF(x) \
{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) \
	break; \
      else  \
	(x) = derefone(x); \
    } else \
        break; \
  } \
}

#define C_POINTER(x) ((struct pointer_object *)data_objectp(x))->pointer

enum fmt_AreaKind {ifmt_IFormat,ifmt_AllWK,ifmt_NilWK,ifmt_Grouping,
         ifmt_OccCount,ifmt_Group,ifmt_GroupChildList,ifmt_ValuePosiList};

static struct ifmt_AllWK *ConvAllWK(q imtfmt, struct fmt_FreeTable *freetblp);
static struct ifmt_NilWK *ConvNilWK(q imtfmt, struct fmt_FreeTable *freetblp);
static struct ifmt_Grouping *ConvGrouping(q imtfmt, 
                                    struct fmt_FreeTable *freetblp);
static struct ifmt_OccCount *ConvOccCnt(q imtfmt, 
                                    struct fmt_FreeTable *freetblp);
static struct ifmt_Group *CreateGroup(q group, 
                                    struct fmt_FreeTable *freetblp);
static struct ifmt_GroupChildList *CreateChildList(q child_list, 
                                    struct fmt_FreeTable *freetblp);
static struct ifmt_GroupChildList *CreateChild(q child, 
                                    struct fmt_FreeTable *freetblp);
static struct ifmt_ValuePosiList *CreateVPList(q vplist, 
                                    struct fmt_FreeTable *freetblp);
static char *Atom2String(q atom);
static char *GetAttrInfo(struct shp_SchemaInfo *schip,
                                    struct shp_AccessPath **accpathp);
static void *GetIfmtArea(enum fmt_AreaKind kind, 
                                    struct fmt_FreeTable *freetblp);
static struct shp_TableSchemaInfo *GetTableSchemaInfo(q ptrobj);
static struct fmt_FreeTable *init_freetbl(void);

/*-----------------------------------------------------------------------
 *   fmt_ConvIfmt
 *
 *     ֥եޥåȡKlicǡˤեޥåȤѴ롣
 *
 *     ARGUMENT: imtfmt    - ֥եޥåȡKlicǡ
 *               freetblpp - ե꡼ꥢơ֥ؤΥݥ󥿤Υݥ
 *        <imtfmt>   ::= imtfmt(<kind>, <imtfmt1>)
 *        <kind>     ::= 0 | 1 | 2 | 3 | 4 | 5
 *        <imtfmt1>  ::= @tblschip                       % 0 : all
 *                     | allwk(@tblschip, @attrschip)    % 1 : all_wk
 *                     | nil                             % 2 : nil
 *                     | @attrschip                      % 3 : nil_wk
 *                     | grouping(@attrschi, <Group>)    % 4 : grouping
 *                     | [@attrschip, ... ]              % 5 : occ_count
 *        <Group>    ::= group(<AttrName>,<Repeat>,<VecSize>,<ChildList>)
 *        <AttrName> ::= ATOM
 *        <Repeat>   ::= set | single
 *        <VecSize>  ::= INTEGER(0 origin)
 *        <ChildList>::= [<Child>,....]
 *        <Child>    ::= attr_child(<AttrPosi>,<NextIPosi>,<VPL>,@attrschip)
 *                     | group_child(<AttrPosi>,<NextIPosi>,<VPL>,<Group>)
 *        <AttrPosi> ::= INTEGER(0 origin)
 *        <NextIPosi>::= INTEGER(0 origin)
 *        <VPL>      ::= [<ValPosi>,.....]
 *        <ValPosi>  ::= INTEGER(0 origin)
 *        tblschip   ::= ΤΥ޾ؤΥݥ
 *                                               (shp_TableSchemaInfo *)
 *        attrschip  ::= °޾ؤΥݥ(shp_SchemaInfo *)
 *                % @xxxx ϥݥ󥿥֥(gpointer.c)
 *                
 *     RETURN: եޥåȡʣåǡˤؤΥݥ
 *
 *     NOTE:
 *-----------------------------------------------------------------------
 */
struct ifmt_IFormat *
fmt_ConvIfmt(q imtfmt, struct fmt_FreeTable **freetblpp)
{
    struct ifmt_IFormat *ifmtp;
    struct fmt_FreeTable *freetblp;
    enum ifmt_Kind kind;
    q tmpq;

    freetblp = init_freetbl();
    *freetblpp = freetblp;

    KP_DEREF(imtfmt);
    ifmtp = (struct ifmt_IFormat *)GetIfmtArea(ifmt_IFormat, freetblp);
    tmpq = G_ARG(imtfmt,0);
    KP_DEREF(tmpq);
    kind = G_INTVAL(tmpq);
    tmpq = G_ARG(imtfmt,1);
    KP_DEREF(tmpq);
    switch (kind) {
    case 0:      /* all */
	ifmtp->format_kind = All;
	ifmtp->i_format.table_schema_info = 
                           GetTableSchemaInfo(tmpq);
	break;
    case 1:      /* all_wk */
	ifmtp->format_kind = All_wk;
	ifmtp->i_format.all_wk = ConvAllWK(tmpq, freetblp);
	break;
    case 2:      /* nil */
	ifmtp->format_kind = Nil;
	break;
    case 3:      /* nil_wk */
	ifmtp->format_kind = Nil_wk;
	ifmtp->i_format.nil_wk = ConvNilWK(tmpq, freetblp);
	break;
    case 4:      /* grouping */
	ifmtp->format_kind = Grouping;
	ifmtp->i_format.grouping = ConvGrouping(tmpq, freetblp);
	break;
    case 5:      /* occ_count */
	ifmtp->format_kind = Occ_count;
	ifmtp->i_format.occ_count = ConvOccCnt(tmpq, freetblp);
	break;
    default:
        break;
    }
    return ifmtp;
}

/*-----------------------------------------------------------------------
 *    fmt_FreeArea
 *
 *    եޥåΰơ֥ϿƤΰ롣
 *
 *    ARGUMENT: freetblp - ե꡼ꥢơ֥ؤΥݥ
 *
 *    RETURN: ʤ
 *
 *    NOTE: 
 *-----------------------------------------------------------------------
 */
static void FreeTable(char **headtbl, char **curtbl, int curposi);
static void FreeArea(char **headtbl, int curposi);

void 
fmt_FreeArea(struct fmt_FreeTable *freetblp)
{

    FreeTable(freetblp->headtbl, freetblp->curtbl, freetblp->curposi);
}

static void 
FreeTable(char **headtbl, char **curtbl, int curposi)
{
    if(headtbl == curtbl)
	FreeArea(headtbl, curposi);
    else {
	FreeArea(headtbl, FREE_TABLE_SIZE);
	FreeTable((char **)headtbl[FREE_TABLE_SIZE], curtbl, curposi);
    }
    free((char *) headtbl);
}

static void 
FreeArea(char **headtbl, int count)
{
    int i;
    
    for(i = 0; i < count; i++)
	free(*(headtbl + i));
}

/*-----------------------------------------------------------------------
 *    GetTableSchemaInfo
 *
 *    shp_SchemaInfo顢shp_TableSchemaInfoФ֤
 *
 *    ARGUMENT: imtfmt - shp_SchemaInfoؤΥݥ󥿤ĥݥ󥿥֥
 *
 *    RETURN: shp_TableSchemaInfoΥɥ쥹
 *-----------------------------------------------------------------------
 */
static struct shp_TableSchemaInfo *
GetTableSchemaInfo(q imtfmt)
{
    struct shp_SchemaInfo *schip;

    schip = (struct shp_SchemaInfo *) C_POINTER(imtfmt);
    return schip->sch_info->table_info;
}

/*-----------------------------------------------------------------------
 *    ConvAllWK
 *
 *    "դΥեޥå"֥եޥåȾ
 *    եޥåȤѴ롣
 *
 *    ARGUMENT: imtfmt - դΥեޥåȤ֥եޥå
 *                       (Klicǡ)
 *              freetblp - ե꡼ꥢơ֥ؤΥݥ
 *         <imtfmt> ::= allwk(@tblschip, @attrschip)
 *
 *    RETURN: դΥեޥåȤեޥå
 *-----------------------------------------------------------------------
 */
static struct ifmt_AllWK *
ConvAllWK(q imtfmt, struct fmt_FreeTable *freetblp)
{
    struct ifmt_AllWK *ifmtp;
    struct shp_SchemaInfo *schip;
    q tmpq;

    ifmtp = (struct ifmt_AllWK *)GetIfmtArea(ifmt_AllWK, freetblp);
    tmpq = G_ARG(imtfmt,0); KP_DEREF(tmpq);
    ifmtp->table_schema_info = GetTableSchemaInfo(tmpq);
    tmpq = G_ARG(imtfmt,1); KP_DEREF(tmpq);
    schip = (struct shp_SchemaInfo *) C_POINTER(tmpq);
    ifmtp->attr_name = GetAttrInfo(schip, &ifmtp->key_access_path);
    ifmtp->key_schema_info = schip->sch_info->attr_info2;
    return ifmtp;
}

/*-----------------------------------------------------------------------
 *    ConvNilWK
 *
 *    "դnilեޥå"֥եޥåȾեޥå
 *    Ѵ롣
 *
 *    ARGUMENT: imtfmt - դnilեޥåȤ֥եޥåȾ
 *                       (Klicǡ)
 *              freetblp - ե꡼ꥢơ֥ؤΥݥ              
 *         <imtfmt> ::= @attrschip   
 *               % °Υ޾ؤΥݥ(PointerObject)
 *
 *    RETURN: դnilեޥåȤեޥå
 *-----------------------------------------------------------------------
 */
static struct ifmt_NilWK *
ConvNilWK(q imtfmt, struct fmt_FreeTable *freetblp)
{
    struct ifmt_NilWK *ifmtp;
    struct shp_SchemaInfo *schip;

    ifmtp = (struct ifmt_NilWK *)GetIfmtArea(ifmt_NilWK, freetblp);
    schip = (struct shp_SchemaInfo *) C_POINTER(imtfmt);
    ifmtp->attr_name = GetAttrInfo(schip, &ifmtp->key_access_path);
    ifmtp->key_schema_info = schip->sch_info->attr_info2;
    return ifmtp;
}

/*-----------------------------------------------------------------------
 *    ConvOccCnt
 *
 *    "󥹷եޥå"֥եޥåȾեޥå
 *    Ѵ롣
 *
 *    ARGUMENT: imtfmt - 󥹷եޥåȤ֥եޥåȾ
 *                       (Klicǡ)
 *              freetblp - ե꡼ꥢơ֥ؤΥݥ
 *         <imtfmt> ::= [@attrschip, ... ]
 *
 *    RETURN: 󥹷եޥåȤեޥå
 *-----------------------------------------------------------------------
 */
static struct ifmt_OccCount *
ConvOccCnt(q imtfmt, struct fmt_FreeTable *freetblp)
{
    struct ifmt_OccCount *ifmtp, **tmp;
    struct shp_SchemaInfo *ship;
    struct shp_AccessPath *accpathp;
    q imtfmtcar;

    tmp = &ifmtp;
    do {
        *tmp = (struct ifmt_OccCount *)GetIfmtArea(ifmt_OccCount, freetblp);
	imtfmtcar = G_CAR_OF(imtfmt);
        KP_DEREF(imtfmtcar);
	ship = (struct shp_SchemaInfo *)C_POINTER(imtfmtcar);
	(*tmp)->attr_name = GetAttrInfo(ship,&accpathp);
        (*tmp)->access_path = accpathp;
	(*tmp)->schema_info = ship;
	(*tmp)->next        = NULL;     /* T.K */
        tmp = &(*tmp)->next;
        imtfmt = G_CDR_OF(imtfmt);
        KP_DEREF(imtfmt);
    } while(imtfmt != NILATOM);    
    return ifmtp;
}

/*-----------------------------------------------------------------------
 *    ConvGrouping
 *
 *    "롼ԥ󥰥եޥå"֥եޥåȾեޥå
 *    Ѵ롣
 *
 *    ARGUMENT: imtfmt - 롼ԥ󥰥եޥåȤ֥եޥåȾ
 *                       (Klicǡ)
 *              freetblp - ե꡼ꥢơ֥ؤΥݥ
 *         <imtfmt> ::= grouping(@attrschi, <Group>)
 *
 *    RETURN: 롼ԥ󥰥եޥåȤեޥå
 *-----------------------------------------------------------------------
 */
static struct ifmt_Grouping *
ConvGrouping(q imtfmt, struct fmt_FreeTable *freetblp) 
{
    struct ifmt_Grouping *ifmtp;
    struct shp_SchemaInfo *schip;
    q tmpq;

    ifmtp = (struct ifmt_Grouping *)GetIfmtArea(ifmt_Grouping, freetblp);
    tmpq = G_ARG(imtfmt,0); KP_DEREF(tmpq);
    schip = (struct shp_SchemaInfo *)C_POINTER(tmpq);
    GetAttrInfo(schip, &ifmtp->access_path);
    ifmtp->group = CreateGroup(G_ARG(imtfmt,1), freetblp);
    return ifmtp;
}

/*-----------------------------------------------------------------------
 *    CreateGroup
 *
 *    롼ԥ󥰤֥եޥåȾ"롼׾"եޥå
 *    ʣåǡˤѴ롣
 *
 *    ARGUMENT: imtgroup - 롼׾(Klicǡ)
 *              freetblp - ե꡼ꥢơ֥ؤΥݥ
 *         <imtfmt> ::= group(<AttrName>,<Repeat>,<VecSize>,<ChildList>)
 *
 *    RETURN: 롼ԥ󥰥եޥåȤեޥå
 *-----------------------------------------------------------------------
 */
static struct ifmt_Group *
CreateGroup(q imtgroup, struct fmt_FreeTable *freetblp)
{
    struct ifmt_Group *groupp;
    q tmpq;
    char *type;

    KP_DEREF(imtgroup);
    groupp = (struct ifmt_Group *)GetIfmtArea(ifmt_Group, freetblp);
    groupp->attr_name = Atom2String(G_ARG(imtgroup,0));
    tmpq = G_ARG(imtgroup,1); KP_DEREF(tmpq);
    type = namestringof(tmpq);
    if (!strcmp(type,"single"))
	groupp->repeat = Single;
    else if (!strcmp(type,"set"))
	groupp->repeat = Repeat;
    tmpq = G_ARG(imtgroup,2); KP_DEREF(tmpq);
    groupp->vector_size = G_INTVAL(tmpq);
    groupp->child_list  = CreateChildList(G_ARG(imtgroup,3), freetblp);
    return groupp;
}


/*-----------------------------------------------------------------------
 *    CreateChildList
 *
 *    롼ԥ󥰤֥եޥåȾ"°ꥹ"
 *    եޥåȷʣåǡˤѴ롣
 *
 *    ARGUMENT: imtclist - ֥եޥåȾλ°ꥹ
 *              freetblp - ե꡼ꥢơ֥ؤΥݥ
 *         <imtclist> ::= [<Child>,....]
 *
 *    RETURN: եޥåȷλ°ꥹ
 *-----------------------------------------------------------------------
 */
static struct ifmt_GroupChildList *
CreateChildList(q imtclist, struct fmt_FreeTable *freetblp)
{
    struct ifmt_GroupChildList *clistp, **tmp;

    KP_DEREF(imtclist);
    tmp = &clistp;
    do {
        *tmp = CreateChild(G_CAR_OF(imtclist), freetblp);
	tmp = &(*tmp)->next;
	imtclist = G_CDR_OF(imtclist);
	KP_DEREF(imtclist);
    } while( imtclist != NILATOM);
    return clistp;
}

/*-----------------------------------------------------------------------
 *    CreateChild
 *
 *    롼ԥ󥰤֥եޥåȾ"°"եޥå
 *    ʣåǡˤѴ롣
 *
 *    ARGUMENT: imtchild - ֥եޥåȾλ°
 *              freetblp - ե꡼ꥢơ֥ؤΥݥ
 *         <imtchild> ::= attr_child(<AttrPosi>,<NextIPosi>,<VPL>,@attrschip)
 *                      | group_child(<AttrPosi>,<NextIPosi>,<VPL>,<Group>)
 *
 *    RETURN: եޥåȷλ°
 *-----------------------------------------------------------------------
 */
static struct ifmt_GroupChildList *
CreateChild(q imtchild, struct fmt_FreeTable *freetblp)
{
    q f, tmpq;
    struct ifmt_GroupChildList *childp;
    char *type;

    KP_DEREF(imtchild);
    childp = (struct ifmt_GroupChildList *)
                     GetIfmtArea(ifmt_GroupChildList, freetblp);
    tmpq = G_ARG(imtchild,0);
    KP_DEREF(tmpq);
    childp->attr_posi = G_INTVAL(tmpq);
    tmpq = G_ARG(imtchild,1);
    KP_DEREF(tmpq);
    childp->next_posi = G_INTVAL(tmpq);
    childp->value_posi_list = CreateVPList(G_ARG(imtchild,2), freetblp);
    childp->next = NULL; /* M. KAWAMURA */
    f = G_FUNCTOR_OF(imtchild);
    type = functoratomname(f);
    if(!strcmp(type,"attr_child")) {
	childp->type = Attribute;
        tmpq = G_ARG(imtchild,3);
        KP_DEREF(tmpq);
	childp->group_child.schema_info = 
               (struct shp_SchemaInfo *) C_POINTER(tmpq);
    } 
    else if (!strcmp(type,"group_child")) {
	childp->type = Grouping1;
	childp->group_child.group = CreateGroup(G_ARG(imtchild,3), freetblp);
    } 
    return childp;
}

/*-----------------------------------------------------------------------
 *    CreateVPList
 *
 *    ֥եޥåȾ"ͥꥹ֥ꥹ"եޥå
 *    ʣåǡˤѴ롣
 *
 *    ARGUMENT: imtvpl - ͥꥹ֥ꥹ(Klicǡ)
 *              freetblp - ե꡼ꥢơ֥ؤΥݥ
 *         <imtvpl>  ::= [<ValPosi>,.....]
 *         <ValPosi> ::= INTEGER (0 origin)
 *
 *    RETURN: եޥåȷͥꥹ֥ꥹ
 *-----------------------------------------------------------------------
 */
static struct ifmt_ValuePosiList *
CreateVPList(q imtvpl, struct fmt_FreeTable *freetblp)
{
    struct ifmt_ValuePosiList *vplistp, **tmp;
    q imtvplcar;

    KP_DEREF(imtvpl);
    tmp = &vplistp;
    do {
        *tmp = (struct ifmt_ValuePosiList *)
                          GetIfmtArea(ifmt_ValuePosiList, freetblp);
        imtvplcar = G_CAR_OF(imtvpl);
        KP_DEREF(imtvplcar);
	(*tmp)->value_posi = G_INTVAL(imtvplcar);
	(*tmp)->next = NULL; /* M.KAWAMURA */
	tmp = &(*tmp)->next;
	imtvpl = G_CDR_OF(imtvpl);
	KP_DEREF(imtvpl);
    } while( imtvpl != NILATOM);
    return vplistp;
}

/*-----------------------------------------------------------------------
 *    GetAttrInfo
 *
 *    ޾ʣåǡˤ°Υѥ°̾Ф
 *
 *    ARGUMENT: schip - ޾ʣåǡˤؤΥݥ
 *              accpathp - ѥʣåǡˤؤΥݥ󥿤Υݥ
 *
 *    RETURN: °̾
 *-----------------------------------------------------------------------
 */
static char *
GetAttrInfo(struct shp_SchemaInfo *schip,struct shp_AccessPath **accpathp)
{
    if(schip->type == Table) {
	struct shp_TableSchemaInfo *tablep = schip->sch_info->table_info;
	*accpathp = NULL;
	return tablep->table_name;
    }
    else if(schip->type == Group || schip->type == Repeat_Group) {
	struct shp_AttrInfo1 *attrip = schip->sch_info->attr_info1;
	*accpathp  = attrip->acc_path;
	return attrip->attr_name;
    }
    else {
        struct shp_AttrInfo2 *attrip = schip->sch_info->attr_info2;
        *accpathp  = attrip->acc_path;
	return attrip->attr_name;
    }
}

/*-----------------------------------------------------------------------
 *    Atom2String
 *
 *    ȥǡKlicǡˤ򥹥ȥ󥰡ʣåǡˤѴ롣
 *
 *    ARGUMENT: atom - ȥǡKlicǡ
 *
 *    RETURN: ȥ̾ȥ
 *
 *    NOTE: 
 *-----------------------------------------------------------------------
 */
static char *
Atom2String(q atom)
{
    int size;
    char *string, *atomstr;

    KP_DEREF(atom);
    atomstr = namestringof(atom);
    size = strlen(atomstr);
    string = (char *) malloc(size + 1);
    BCOPY(atomstr, string, size);
    string[size] = '\0';
    return string;
}


/*-----------------------------------------------------------------------
 *    GetIfmtArea
 *
 *    եޥåѤΰݤ֤
 *
 *    ARGUMENT: kind     - 
 *              freetblp - ե꡼ꥢơ֥ؤΥݥ
 *
 *    RETURN: 
 *
 *    NOTE: |<-TABLE_SIZE-->|      |<-TABLE_SIZE-->|
 *          +-+-+-+---------+-+    +-+-+-+---------+-+
 *          | | | | ....... | +--->| | | | ......  | +----> Next Address
 *          +-+-+-+---------+-+    +-+-+-+---------+-+
 *
 *-----------------------------------------------------------------------
 */
static void *
GetIfmtArea(enum fmt_AreaKind kind, struct fmt_FreeTable *freetblp)
{
    unsigned size;
    void *areap;
    char **newtbl;

    switch (kind) {
    case ifmt_IFormat:
	size = sizeof(struct ifmt_IFormat);
	break;
    case ifmt_AllWK:
	size = sizeof(struct ifmt_AllWK);
	break;
    case ifmt_NilWK:
	size = sizeof(struct ifmt_NilWK);
	break;
    case ifmt_Grouping:
	size = sizeof(struct ifmt_Grouping);
	break;
    case ifmt_OccCount:
	size = sizeof(struct ifmt_OccCount);
	break;
    case ifmt_Group:
	size = sizeof(struct ifmt_Group);
	break;
    case ifmt_GroupChildList:
	size = sizeof(struct ifmt_GroupChildList);
	break;
    case ifmt_ValuePosiList:
	size = sizeof(struct ifmt_ValuePosiList);
	break;
    default:
	break;
    }
    areap = (char *) malloc(size);
    if(freetblp->curposi < FREE_TABLE_SIZE)
	freetblp->curtbl[freetblp->curposi++] = areap;
    else if(freetblp->curposi == FREE_TABLE_SIZE) {
	newtbl = (char **) malloc(sizeof(char *) * (FREE_TABLE_SIZE + 1));
	freetblp->curtbl[FREE_TABLE_SIZE] = (char *)newtbl;
	freetblp->curtbl = newtbl;
	freetblp->curtbl[0] = areap;
	freetblp->curtbl[FREE_TABLE_SIZE] = NULL;
	freetblp->curposi = 1;
    }
    return (void *)areap;
}


static struct fmt_FreeTable *
init_freetbl(void)
{
    struct fmt_FreeTable *freetblp;

    freetblp = (struct fmt_FreeTable *) malloc(sizeof(struct fmt_FreeTable));
    freetblp->headtbl = 
	        (char **) malloc(sizeof(char *) * (FREE_TABLE_SIZE + 1));
    freetblp->curtbl  = freetblp->headtbl;
    freetblp->curtbl[FREE_TABLE_SIZE] = NULL;
    freetblp->curposi = 0;
    return freetblp;
}



















