/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *	shp.c
 *   DESCRIPTION
 *	ޥץ(Use Generic Object)
 *   INTERFACE ROUTINES
 *      
 *   NOTES       
 *	
 *$  EDITOR : Tooru Shida
 *$           (MITSUBISHI ELECTRIC COMPUTER SYSTEMS (TOKYO) CORPORATION)
 *$  CREATE : '94-03-10 Thu
 *$  UPDATE : 
 ***********************************************************************/

#include <stdio.h>
#include <klic/gdobject.h>
#include "shp.h"
/*
 #ifndef SHPTEST
 #include "../atom.h"
 #include "../funct.h"
 #else
 */
#include "atom.h"
#include "funct.h"
/*
 #endif
 */


extern int shp_ConvertKLIC2C(q klic_info, struct shp_SchemaInfo *c_info);
extern void shp_CDataPrint(struct shp_SchemaInfo *c_info, FILE *g_fp);
extern q gd_new_pointer();

/* ޥץ֥ݻǡ¤ */
struct kappa_schema_process_object {
    struct data_object_method_table *method_table;
    struct shp_SchemaInfo *shp_info_c;
    q shp_info_klic;
};

#define GD_CLASS_NAME()  kappa__schema__process
#define GD_OBJ_TYPE      struct kappa_schema_process_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))

#include <klic/gd_macro.h>

/* Basic Method definitions */

/* --------------------------------------------------------------------
 *	GDDEF_GC
 *          Gabage Collection
 * 
 * --------------------------------------------------------------------
 */

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  newself->shp_info_c = GD_SELF->shp_info_c;
  GD_COPY_KL1_TERM_TO_NEWGEN(GD_SELF->shp_info_klic, newself->shp_info_klic);
  GD_RETURN_FROM_GC(newself);
}

GDDEF_DEALLOCATE()
{
  G_STD_DECL;

  free(GD_SELF->shp_info_c);
  return 0; /* GD_RETURN_FROM_DEALLOCTE; */
}

/* Generic Method (Body Predicate) */

/* --------------------------------------------------------------------
 *	GDDEF_METHOD(get_schema_info_c_1)
 *          ݻø쥹޾Ф
 * 
 * --------------------------------------------------------------------
 */

GDDEF_METHOD(get__schema__info__c_1)
{
    G_STD_DECL;
    q pointer_obj;        /* ꥿ѥݥ󥿥֥ */

    pointer_obj = gd_new_pointer(GD_SELF->shp_info_c, g_allocp);
        /* ø쥹޾ؤΥݥ󥿤ĥݥ󥿥֥Ȥ */
    g_allocp = heapp;
    GD_UNIFY(GD_ARGV[0], pointer_obj);
/*    GD_ARGV[0] = pointer_obj; */
        /* ݥ󥿥֥Ȥ֤ */
    GD_RETURN;
}


/* --------------------------------------------------------------------
 *	GDDEF_METHOD(get_schema_info_klic_1)
 *          ݻKLIC޾Ф
 * 
 * --------------------------------------------------------------------
 */

GDDEF_METHOD(get__schema__info__klic_1)
{
    G_STD_DECL;
    GD_UNIFY(GD_ARGV[0], GD_SELF->shp_info_klic);
    GD_RETURN;
}



/* Generic Method Table */

/* --------------------------------------------------------------------
 *	GDDEF_GENERIC()
 *          ᥽å̾ơ֥
 * 
 * --------------------------------------------------------------------
 */

GDDEF_GENERIC()
{
    G_STD_DECL;

    GD_SWITCH_ON_METHOD{
	GD_METHOD_CASE(get__schema__info__c_1);
	GD_METHOD_CASE(get__schema__info__klic_1);
	GD_METHOD_CASE_DEFAULT;
    }
    GD_RETURN;
}


/* Guard Generic Method Table */

/* --------------------------------------------------------------------
 *	GDDEF_PRINT()
 *          ֥ư̤ݡȡ
 * 
 * --------------------------------------------------------------------
 */

GDDEF_PRINT()
{
    G_STD_DECL;
    GD_PRINT("kappa_shp:");
    shp_CDataPrint(GD_SELF->shp_info_c, g_fp);
    GD_RETURN_FROM_PRINT;
}

#define GDUSE_MY_PRINT
#define GDUSE_MY_GC
#define GDUSE_MY_GENERIC
#define GDUSE_MY_DEALLOCATE
/* 
/* #define GDUSE_MY_GUNIFY
/* #define GDUSE_MY_UNIFY
/* #define GDUSE_MY_GGENERIC
/* #define GDUSE_MY_COMPARE
/* #define GDUSE_MY_HASH
 */

/* define the method table structure of the schema_process */

#include <klic/gd_methtab.h>

/* --------------------------------------------------------------------
 *	GDDEF_NEW
 *          ޥץѥͥå֥
 * 
 * --------------------------------------------------------------------
 */

GDDEF_NEW()
{
    GD_STD_DECL_FOR_NEW;
    GD_OBJ_TYPE *new_shp_info;
    struct shp_SchemaInfo *c_info;          /* ޾ʣø*/
    q klic_info;                /* ޾KLIC*/ 
    
    if (GD_ARGC != 1) {
	GD_ERROR_IN_NEW("Too few or too many arguments");
    }
    klic_info = GD_ARGV[0];
    GD_DEREF_FOR_NEW(klic_info);    /* ޾󤬥ХɤޤԤ */
    GDSET_NEWOBJ_FOR_NEW(new_shp_info, G_SIZE_IN_Q(GD_OBJ_TYPE));
    if ( G_ISGOBJ(klic_info) ) {
	c_info =
	    (struct shp_SchemaInfo *) malloc(sizeof(struct shp_SchemaInfo));
	/* ޾ʣøˤΥΰդ */
	if ( shp_ConvertKLIC2C(klic_info, c_info) == ABNORMAL ) {
	    GD_ERROR_IN_NEW("Illegal Schema Info of KLIC");
	}
	/* ޾(KLIC)øǡѴ */
    } else {
	GD_ERROR_IN_NEW("Illegal parameter"); /* Ϳ줿ǡ */
    }
    new_shp_info->shp_info_c = c_info;        /* øǡ¤ΤSET */
    new_shp_info->shp_info_klic = klic_info;  /* KLICǡ¤ΤSET */
    GD_RETURN_FROM_NEW(new_shp_info);         /* Object֤ */
}
