/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *      term_encode.c
 *   DESCRIPTION
 *      򥨥󥳡ɤơΰ˳Ǽ롣
 *   INTERFACE ROUTINES
 *      term_Encode  - 򥨥󥳡ɤƻꤵ줿ΰ˳Ǽ롣
 *                     ͤȤơǼλɥ쥹֤
 *   NOTES
 *
 *$  EDITOR : Toru Kawamura
 *$  CREATE : '94-04-28
 *$  UPDATE : '94-06-24
 *$               09-05   change structures of  string, atom data
 *$               09-14
 *$               09-27
 ***********************************************************************/
#include "term.h"

static char *SetInt(q term, char *sp);
static char *SetList(q term, char *sp);
static char *SetTag(int kind, int info, char *sp);
static char *SetGobj(q term, char *sp);
static char *SetFloat(q term, char *sp);
static char *SetVector(q term, char *sp);
static char *SetString(q term, char *sp);
static char *SetString16(q term, char *sp);
static char *SetFunctor(q term, char *sp);
static char *SetSymbol(q term, char *sp);


/*-----------------------------------------------------------------------
 *   term_Encode
 *
 *     Klicǡˤ򥨥󥳡ɤƻΰ˳ǼǼλ
 *     ɥ쥹֤
 *
 *     ARGUMENT: term  - Klicǡ
 *               sp    - ǼΰؤΥݥ
 *
 *     RETURN: Ǽλɥ쥹
 *
 *     NOTE:
 *-----------------------------------------------------------------------
 */
char *
term_Encode(q term, char *sp) 
{
    deref_and_switch(term, var, atomic, cons, composite);
 atomic:
    switch (atagof(term)) {
    case INT:
	return SetInt(term, sp);
    case SYM:
	return SetSymbol(term, sp);
    }
 cons:
    return SetList(term, sp);
 var:
    printf("term is var \n");
 composite:
  {
    int i;
    q f = G_FUNCTOR_OF(term);
    if (G_ISATOMIC(f))
	return SetFunctor(term, sp);
    else if(G_ISREF(f))
	return SetGobj(term, sp);
    else {
	printf("Invalid functor \n");
    }
  }
}


/*-----------------------------------------------------------------------
 *   SetTag
 *
 *     ǡʥǡ̤ȥǡͭξݻ룲ХȤξ
 *
 *     ARGUMENT: kind  - ǡ                 term.h
 *               info  - ǡͭξ       term.h
 *               sp    - ǼΰؤΥݥ
 *
 *     RETURN: Ǽλɥ쥹
 *
 *     NOTE:  Ǽ¤
 *      +------+---------------+
 *      |  |           |
 *      +------+---------------+
 *         4         12      (bit)
 *
 *-------------------------------------------------------------------
 */
static char *
SetTag(int kind, int info, char *sp)
{
    SET_SHORT_INTEGER((kind << 12) | info, sp);
    return sp;
}


/*-----------------------------------------------------------------------
 *   SetSybmol
 *
 *     ȥǡ򥨥󥳡ɤơΰ˳Ǽ롣
 *
 *     ARGUMENT: term  - ȥǡ...0110
 *               sp    - ǼΰؤΥݥ
 *
 *     RETURN: Ǽλɥ쥹
 *
 *     NOTE:  Ǽ¤
 *      ĹϣХñ̤ǳǼ롣
 *        2                        (byte)
 *    +--------+---------------------+
 *    | Tag    |   ATOM String       |
 *    +--------+---------------------+
 *    Tag  0-3  bits : ǡ    1
 *           4    bit  : ե饰    0--, 1--
 *           5-15 bits : Ĺ          2047ޤ, 4094 byteΥǡ
 *-------------------------------------------------------------------
 */
static char *
SetSymbol(q term, char *sp)
{
    char *atomstr;
    int byte_size, size;
    int tag_info;

    if (term == NILATOM)                                 /* [] */
	return SetTag(TAG_SPECIAL_ATOM, TAG_EMPTY_LIST, sp);
    atomstr = namestringof(term);
    if(!strcmp(atomstr,"nil"))
	return SetTag(TAG_SPECIAL_ATOM, TAG_NIL, sp);    /* nil */
    byte_size = strlen(atomstr);
    size = (byte_size + 1) / 2;
#ifndef OLD_TYPE_TBD
    if (byte_size % 2)                            /* Ĺ */
	tag_info = size | 0x800;
    else
	tag_info = size;
#else
    tag_info = size;                 /*  For Old Type Term      */
#endif
    sp = SetTag(TAG_ATOM, tag_info, sp);
    BCOPY(atomstr, sp, byte_size);
#ifdef OLD_TYPE_TBD                  /*                         */
    if (byte_size % 2)               /*  For Old Type Term      */
        *(sp + byte_size) = '\0';    /*                         */
#endif                               /*                         */
    return sp + size * 2;
}


/*-----------------------------------------------------------------------
 *   SetInt
 *
 *     ǡ򥨥󥳡ɤơΰ˳Ǽ롣
 *
 *     ARGUMENT: term  - ǡ..0010
 *               sp    - ǼΰؤΥݥ
 *
 *     RETURN: Ǽλɥ쥹
 *
 *     NOTE:  Ǽ¤ -- 礭ˤäƳǼ¤Ѥ롣
 *      (1)
 *      +--------+
 *      |  Tag   |                    TagInfo(12bit) => 
 *      +--------+
 *          2  (byte)
 *      (2)
 *      +--------+--------+
 *      |  Tag   |    |           TagInfo(12bit) => 
 *      +--------+--------+
 *          2        2  (byte)
 *      (3)
 *      +--------+--------+--------+
 *      |  Tag   |             |  TagInfo(12bit) => Ѥ
 *      +--------+--------+--------+
 *          2             4      (byte)
 *
 *-------------------------------------------------------------------
 */
static char *
SetInt(q term, char *sp)
{
    int val;
    
    val = G_INTVAL(term);
    if (val >= 0 && val <= 0x7FF) {                      /*  12bit plus */
	sp = SetTag(TAG_INTEGER12, val, sp);
    }
    else if (val >= 0xFFFFF800 && val < 0) {             /*  12bit minus */
	sp = SetTag(TAG_INTEGER12, val & 0xFFF, sp);
    }
    else if (val > 0x7FF && val <= 0x7FFFFFF) {          /*  28bit plus */
	sp = SetTag(TAG_INTEGER28, val >> 16, sp);
	SET_SHORT_INTEGER(val & 0xFFFF, sp);
    } 
    else if (val >= 0xF8000000 && val < 0xFFFFF800) {    /*  28bit minus */
	sp = SetTag(TAG_INTEGER28, (val >> 16) & 0xFFF, sp);
	SET_SHORT_INTEGER(val & 0xFFFF, sp);
    }
    else {                                               /*  32bit */
	sp = SetTag(TAG_INTEGER32, 0, sp);
	SET_INTEGER(val, sp);
    }
    return sp;
}


/*-----------------------------------------------------------------------
 *   SetVector
 *
 *     ٥ǡ򥨥󥳡ɤơΰ˳Ǽ롣
 *
 *     ARGUMENT: term  - ٥ǡ
 *               sp    - ǼΰؤΥݥ
 *
 *     RETURN: Ǽλɥ쥹
 *
 *     NOTE:  Ǽ¤
 *      +--------+------+------+-----+------+
 *      |  Tag   | Elm1 | Elm2 | ... | ElmN |
 *      +--------+------+------+-----+------+
 *          2                             (byte)
 *
 *        TagInfo(12bit) => ǿ
 *-------------------------------------------------------------------
 */
static char *
SetVector(q term, char *sp)
{
    long size, k;
    char *cp;

    size = G_INTVAL(size_of_vector(term));
    cp = sp  + TAG_SIZE;
    for(k=0; k < size; k++)
	cp = term_Encode(element_of_vector(term, G_MAKEINT(k)), cp);
    SetTag(TAG_VECTOR, size, sp);
    return cp;
}

/*-----------------------------------------------------------------------
 *   SetFloat
 *
 *     ưǡ򥨥󥳡ɤơΰ˳Ǽ롣
 *
 *     ARGUMENT: term  - ư
 *               sp    - ǼΰؤΥݥ
 *
 *     RETURN: Ǽλɥ쥹
 *
 *     NOTE:  Ǽ¤
 *      +--------+------+------+-----+------+
 *      |  Tag   | Elm1 | Elm2 | ... | ElmN |
 *      +--------+------+------+-----+------+
 *          2                             (byte)
 *
 *        TagInfo(12bit) => ǿ
 *-------------------------------------------------------------------
 */
static char *
SetFloat(q term, char *sp)
{
    long size, k;
    char *cp;

    size = G_INTVAL(size_of_vector(term));
    cp = sp  + TAG_SIZE;
    for(k=0; k < size; k++)
	cp = term_Encode(element_of_vector(term, G_MAKEINT(k)), cp);
    SetTag(TAG_FLOATING, size, sp);
    return cp;
}


/*-----------------------------------------------------------------------
 *   SetList
 *
 *    ꥹȥǡ򥨥󥳡ɤơΰ˳Ǽ롣
 *
 *     ARGUMENT: term  - ꥹȥǡ...01
 *               sp    - ǼΰؤΥݥ
 *
 *     RETURN: Ǽλɥ쥹
 *
 *     NOTE:  Ǽ¤
 *      +--------+------+------+-----+------+
 *      |  Tag   | Elm1 | Elm2 | ... | ElmN |
 *      +--------+------+------+-----+------+
 *          2                             (byte)
 *
 *        TagInfo => ǿ
 *       [1,2,3]  [1,2,3|[]] ȸ路ǿ4ǡ1,2,3,[]Ǽ롣
 *-------------------------------------------------------------------
 */
static char *
SetList(q term, char *sp)
{   
    int cnt;
    char *cp;

    cp = sp + TAG_SIZE;
    for(cnt = 1; ; cnt++) {
        cp = term_Encode(G_CAR_OF(term), cp);
        term = G_CDR_OF(term);
        deref_and_switch(term, othercdr, atomiccdr, conscdr, othercdr);
    conscdr:
    }
 atomiccdr:
 othercdr:
    cp = term_Encode(term, cp);
 listtail:
    SetTag(TAG_LIST, ++cnt, sp);
    return cp;
}


/*-----------------------------------------------------------------------
 *   SetString
 *
 *    ȥ󥰥ǡ򥨥󥳡ɤơΰ˳Ǽ롣
 *
 *     ARGUMENT: term  - ȥ󥰥ǡ
 *               sp    - ǼΰؤΥݥ
 *
 *     RETURN: Ǽλɥ쥹
 *
 *     NOTE:  Ǽ¤
 *     Ĺϡ٤ƣХȤñ̤Ȥ롣
 *
 *     (1) ǡ 2046 byteʲξ
 *         2                        (byte)
 *      +--------+---------------------+
 *      | Tag    |   String            |
 *      +--------+---------------------+
 *     Tag  0-3  bits : ǡ    8
 *            4    bit  : ǡĹե饰0--1023ʲ
 *            5    bit  : ե饰    0--, 1--
 *            6-15 bits : Ĺ          1023ޤ, 2046 byteΥǡ
 *
 *     (2) ǡ 2047 byteʾξ
 *         2        4                    (byte)
 *      +--------+------+--------------------+
 *      | Tag    | Size |  String            |
 *      +--------+------+--------------------+
 *     Tag  0-3  bits : ǡ    8
 *            4    bit  : ǡĹե饰1--1024ʾ
 *            5    bit  : ե饰    0--, 1--
 *            6-15 bits : ̤
 *     Size 4 byte ˥ȥ󥰤ĹǼ롣
 *-------------------------------------------------------------------
 */
static char *
SetString(q term, char *sp)
{
    int byte_size, size;
    int tag_info = 0;

    byte_size = G_INTVAL(size_of_string(term));
    size = (byte_size + 1) / 2;
#ifndef OLD_TYPE_TBD
    if (byte_size % 2)                            /* Ĺ */
	tag_info |= 0x400;
#endif
    if (size < 1024) {
#ifndef OLD_TYPE_TBD
	tag_info |= size;
#else
	tag_info |= byte_size;         /* OLD_TYPE_TBD */
#endif
	sp = SetTag(TAG_STRING8, tag_info, sp);
    }
    else {
	tag_info |= 0x800;
	sp = SetTag(TAG_STRING8, tag_info, sp);
	SET_INTEGER(size, sp);
    }
    BCOPY(generic_string_body(STRING_OBJ(term)), sp, byte_size);
#ifdef OLD_TYPE_TBD                  /*                         */
    if (byte_size % 2)               /*  For Old Type Term      */
	*(sp + byte_size) = '\0';    /*                         */
#endif                               /*                         */
    return sp + size * 2;
}

/*-----------------------------------------------------------------------
 *   SetString16
 *
 *    Хȥȥ󥰥ǡ򥨥󥳡ɤơΰ˳Ǽ롣
 *
 *     ARGUMENT: term  - ȥ󥰥ǡ
 *               sp    - ǼΰؤΥݥ
 *
 *     RETURN: Ǽλɥ쥹
 *
 *     NOTE:  Ǽ¤
 *     Ĺϡ٤ƣХȤñ̤Ȥ롣
 *     (a) ǡ 2047 Ȱʲξ
 *          2                        (byte)
 *      +--------+---------------------+
 *      | Tag    |   String            |
 *      +--------+---------------------+
 *     Tag  0-3  bits : ǡ    9
 *            4    bit  : ǡĹե饰0--2047ʲ
 *            5-15 bits : Ĺ          2047ޤ, 4094 byteΥǡ
 *
 *      (b) ǡ 2048 byteʾξ
 *          2        4                    (byte)
 *      +--------+------+--------------------+
 *      | Tag    | Size |  String            |
 *      +--------+------+--------------------+
 *     Tag  0-3  bits : ǡ    9
 *            4    bit  : ǡĹե饰1--2048ʾ
 *            5-15 bits : ̤
 *     Size 4 byte ˥ȥ󥰤ĹǼ롣
 *-------------------------------------------------------------------
 */
static char *
SetString16(q term, char *sp)
{
    int size, byte_size;

    size = G_INTVAL(size_of_string16(term));
    byte_size = size * 2;
    if (size < 2048)
	sp = SetTag(TAG_STRING16, size, sp);
    else {
	sp = SetTag(TAG_STRING16, 0x800, sp);
	SET_INTEGER(size, sp);
    }
    BCOPY((char *)generic_string16_body(STRING16_OBJ(term)), sp, byte_size);
    return sp + byte_size;
}

/*-----------------------------------------------------------------------
 *   SetFunctor
 *
 *     ե󥯥ǡ򥨥󥳡ɤơΰ˳Ǽ롣
 *
 *     ARGUMENT: term  - ե󥯥ǡ...11
 *               sp    - ǼΰؤΥݥ
 *
 *     RETURN: Ǽλɥ쥹
 *
 *     NOTE:  Ǽ¤
 *      +--------+----+--------------+------+------+-----+------+
 *      |  Tag   |Size|FuncNameString| Elm1 | Elm2 | ... | ElmN |
 *      +--------+----+--------------+------+------+-----+------+
 *         2       2   (8bit string)                         (byte)
 *
 *    Tag  0-3  bits : ǡ    10
 *           4-15 bits : ǿ
 *    Size 0-3  bits : ̤
 *           4    bit  : ե饰0--, 1--
 *           5-15 bits : ե󥯥̾ΥХñ̤ǳǼ롣
 *                      SizeեɤĹϴޤޤʤ
 *-------------------------------------------------------------------
 */
static char *
SetFunctor(q term, char *sp)
{
    char *funcname, *cp;
    int byte_size, size, size_info, i;
    q f;

    f = G_FUNCTOR_OF(term);
    funcname = functoratomname(f);
    byte_size = strlen(funcname);
    size = (byte_size + 1) / 2;
    cp = sp + TAG_SIZE;
    if (byte_size % 2)
	size_info = size | 0x800;
    else
	size_info = size;
    SET_SHORT_INTEGER(size_info, cp);
    BCOPY(funcname, cp, byte_size);
    cp += size * 2;
    for (i = 0; i < arityof(f); i++)
	cp = term_Encode(G_ARG(term,i), cp);
    SetTag(TAG_FUNCTOR, i, sp);
    return cp;
}


/*-----------------------------------------------------------------------
 *   SetGobj
 *
 *     ͥå֥ȤμȽ̤줾ΥǼ
 *     δؿƤӽФ
 *
 *     ARGUMENT: term  - ͥå֥ȡʥե󥯥ǡ
 *               sp    - ǼΰؤΥݥ
 *
 *     RETURN: Ǽλɥ쥹
 *
 *     NOTE:  
 *-------------------------------------------------------------------
 */
static char *
SetGobj(q term, char *sp)
{
    struct data_object_method_table *mtbp;

    mtbp = (struct data_object_method_table *) G_REFP(G_FUNCTOR_OF(term));
    if (mtbp == &vector_g_data_method_table)
	return SetVector(term, sp);
    else if (mtbp == &byte__string_g_data_method_table)
	return SetString(term, sp);
    else if (mtbp == &dbyte__string_g_data_method_table)
	return SetString16(term, sp);
/*    else if (mtbp == &float_g_data_method_table)
/*	return SetFloat(term, sp);
 */
    else {
	printf("unregistered gobj\n");
	return sp;
    }
}


