/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *	rec_read_tb.c
 *   DESCRIPTION
 *	쥳ɤΥơ֥ɤߤԤʤ
 *   INTERFACE ROUTINES
 *	rec_ReadAllTable - ơ֥ɤߡʥդޤˤԤʤ
 *      
 *   NOTES       
 *	
 *$  EDITOR : Tooru Shida
 *$           (MITSUBISHI ELECTRIC COMPUTER SYSTEMS (TOKYO) CORPORATION)
 *$  CREATE : '94-01-25
 *$  UPDATE : '94-04-25~ by Shida(MTC) for Kappa version Q02
 *$           '95-03-23 modified for linux (rec_StrnCpy)
 *$
 ***********************************************************************/

#include <stdio.h>
#include <string.h>
#include "rec_read_tb.h"

/* --------------------------------------------------------------------
 *	rec_ReadAllTable
 *        쥳ɥȥ󥰤ơ֥ɤߤԤʤ
 *        ͥꥹȤѴƤӽФ¦֤
 *      
 *      ARGUMENT: internal_format : եޥåȤؤΥݥ
 *                                  (¤TBPեޥå)
 *                rec_sri         : ֥쥳ɾؤΥݥ(KLICǡ)
 *                record          : 쥳ɥȥ󥰤ؤΥݥ
 *                str_cnt         : 쥳ɥȥ󥰿
 *                page_size       : ڡΥ(Хñ)
 *                record_length   : 쥳Ĺ
 *                value_list      : 쥳ɥȥ󥰤Ѵ줿
 *                                  ͥꥹ(KLICǡ)
 * 
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
rec_ReadAllTable(struct ifmt_IFormat *internal_format, q *rec_sri,
		 char **record, int str_cnt, int page_size, int record_length,
		 q *value_list, q *g_allocp)
{
    struct shp_ChildInfo *child_attr_info;   /* ޾°ꥹ */
    int child_cnt;                           /* ơ֥ľ° */
    short null_flag;                         /* ͥե饰 */
    
    struct shp_TableSchemaInfo *table_info;  /* ơ֥륹޾ */
    struct shp_AccessPath *key_access_path;  /* °ؤΥѥ */
    struct shp_AttrInfo2 *key_schema_info;   /* °Υ޾ */
    q all_value_list;                        /* ơ֥Τͥꥹ */
    q key_attr_value;                        /* ° */
    q argv[1];                               /* ͥꥹȥ٥Ѱ */

    q vector_g_new();                        /* ͥꥹȥ٥ */
    declare_globals;

    if ( str_cnt > NOT_SPAND ) {    /* ѥɥ쥳ɤξ̤ݡȡ */
	return (g_allocp);
/*
        child_attr_info 
	    = internal_format->i_format.table_schema_info->child_attr_info;
	child_cnt 
	    = internal_format->i_format.table_schema_info->child_attr_cnt;
	g_allocp
	    = ReadSpandRecord(child_info, rec_sri, record, str_cnt, rid,
	                      page_size, record_length, child_cnt,
			      value_list, g_allocp);
 */
    } else {                         /* 󥹥ѥɥ쥳ɤξ */
	if ( internal_format->format_kind == All ) { /* λʥʤ*/
	    child_attr_info =
		internal_format->i_format.table_schema_info->child_attr_info;
	    child_cnt
		= internal_format->i_format.table_schema_info->child_attr_cnt;
	    if ( record_length == ALL_NULL_VALUE ) {
		/* ơ֥Τͤξ */
		REC_GetShortInt(null_flag, record[FIRST_RECORD]);
		if ( null_flag == ALL_NIL_VALUE ) {
		    *value_list = G_MAKESYM(G_atom(nil));
		} else {
		    *value_list = G_MAKESYM(G_atom(bottom));
		}
	    } else {
		g_allocp
		    = ReadGroup(child_attr_info, rec_sri,
				record[FIRST_RECORD], str_cnt,
				record_length, child_cnt, value_list,
				g_allocp);
	    }
	} else {                                     /* λʥդ*/
	    child_cnt = 2;
	    argv[0] = G_MAKEINT((long) child_cnt);
	    *value_list = vector_g_new(1, argv, g_allocp);
	        /* °դͥꥹȥ٥ */
	    g_allocp = heapp;

	    table_info = internal_format->i_format.all_wk->table_schema_info;
	    key_access_path
		= internal_format->i_format.all_wk->key_access_path;
	    key_schema_info
		= internal_format->i_format.all_wk->key_schema_info;

	    if ( record_length == ALL_NULL_VALUE ) {
		/* ơ֥Τͤξ */
		REC_GetShortInt(null_flag, record[FIRST_RECORD]);
		if ( null_flag == ALL_NIL_VALUE ) {
		    all_value_list = G_MAKESYM(G_atom(nil));
		} else {
		    all_value_list = G_MAKESYM(G_atom(bottom));
		}
	    } else {
		g_allocp = ReadGroup(table_info->child_attr_info,
				     rec_sri, record[FIRST_RECORD],
				     str_cnt, record_length,
				     table_info->child_attr_cnt,
				     &all_value_list, g_allocp);
	    }
	    g_allocp = ReadKey(key_access_path, key_schema_info,
			       &all_value_list, &key_attr_value,
			       g_allocp);
	    *(((struct vector_object *)G_FUNCTORP(*value_list))->body)
		= key_attr_value;
	    *(((struct vector_object *)G_FUNCTORP(*value_list))->body
	      + 1) = all_value_list;
	}
	return (g_allocp);
    }
}


/* --------------------------------------------------------------------
 *	ReadGroup
 *        롼°γƻ°ͤ쥳ɥȥ󥰤ڤ
 *        ͥꥹȤѴƤӽФ¦֤
 *      
 *      ARGUMENT: group_info      : оݽ°λ°
 *                                  (shp_ChildInfoι¤)
 *                rec_sri         : ֥쥳ɾؤΥݥ(KLICǡ)
 *                record          : 쥳ɥȥ󥰤ؤΥݥ
 *                str_cnt         : 쥳ɥȥ󥰿
 *                field_length    : о°ΥեĹ
 *                attr_cnt        : оݽ°λ°
 *                value_list      : 쥳ɥȥ󥰤Ѵ줿
 *                                  ͥꥹ(KLICǡ)
 * 
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
ReadGroup(struct shp_ChildInfo *group_info, q *rec_sri, char *record,
	  int str_cnt, int field_length, int attr_cnt, q *value_list,
	  q *g_allocp)
{
    int i;             /* FOR LOOP */
    short real_attr_cnt;/* ºݤ˥쥳ɤ˳ǼƤ° */
    int offset;        /* оݽ°Υեå */
    int next_offset;   /* INTEGERñ°Υեå */
    int next_nint_posi;/* INTEGERñ° */
    int work;          /* ΰ */
    int nil_flag;      /* ͥե饰ʥեåȥեɤƬӥåȡ */
    int gk_flag;       /* EUCȥѶե饰 */
                       /*ʥեåȥեɤƬ飳ӥåܡ */
    struct shp_AccessPath *acc_path;        /* ѥ */
    struct shp_ChildInfo *child_info;       /* Ļ° */
    int child_attr_cnt;                     /* Ļ° */
    enum shp_DataType child_data_type;      /* о°Υǡ */
    q sri_ele;                              /* ֥쥳ɾ */

    struct cons *consp;                     /* ꥹȥǡ */
    q argv[1];                              /* ͥꥹȥ٥Ѱ */

    q work_value_list;                     /* ͥꥹȺΰ */
    q *attr_value;                          /* ƻ° */
    q *tmp;                                 /* KLIC ꥹȥǡ */
    int null_list_cnt = 1;                  /* ꥹΰ */
    int null_only_flag = 3;                 /* ͤΤ߽°Ƚ */
    
    q vector_g_new();                       /* ͥꥹȥ٥ */
    declare_globals;


    argv[0] = G_MAKEINT((long) attr_cnt);
    work_value_list = vector_g_new(1, argv, g_allocp);
        /* ͥꥹѥ٥ */
    g_allocp = heapp;
    
    REC_GetShortInt(real_attr_cnt, record);
        /* ° */
    for( i = 0; i < real_attr_cnt && i < attr_cnt; i++ ) {
	attr_value
	    = (((struct vector_object *)G_FUNCTORP(work_value_list))->body + i);
	REC_GetInt(work, (record + (i * FOUR_BYTE) + TWO_BYTE));
	    /* եå or INTEGER°ͼ */
	nil_flag = (work & NIL_FLAG_MASK) >> NIL_FLAG_SHIFT;
	gk_flag = work & GKFLAG_MASK;
	offset = work & OFFSET_MASK;
	sri_ele = GetSRI(*rec_sri, i);
	KP_GD_TDDEREF(sri_ele);
	if ( nil_flag ==  NIL_FIELD ) {           /* оݻ°Nil */
	    if ( null_only_flag == 3 || null_only_flag == 1 ) {
		null_only_flag = 1;
	    }
	    *attr_value = G_MAKESYM(G_atom(nil));
	} else if ( nil_flag == BOTTOM_FIELD ) {  /* оݻ°Bottom */
	    if ( null_only_flag == 3 || null_only_flag == 2 ) {
		null_only_flag = 2;
	    }
	    if ( group_info->type == Repeat_Simple
		|| group_info->type == Repeat_Group ) {
		/* °ͤ[] */
		*attr_value = NILATOM;
	    } else {
		/* °ͤbottom */
		*attr_value = G_MAKESYM(G_atom(bottom));
	    }
	} else {                                  /* оݻ°° */
	    null_only_flag = 0;
	    switch( group_info->type ) {
	    case Simple:          /* ñ°(INTEGER°) */
		next_nint_posi
		    = group_info->attr_info.info2->next_nint_posi;
		work = (int)GetNextOffset(offset, record,
					  next_nint_posi, field_length);
		next_offset = work & OFFSET_MASK;
		/* INTEGER°Υեåȥեɤͼ */
		g_allocp = ReadSimple(offset, next_offset,
				      group_info->attr_info.info2->data_type,
				      gk_flag, (record + (offset * 2)),
				      attr_value, g_allocp);
		break;
	    case Repeat_Simple:   /* ֤ñ° */
		next_nint_posi
		    = group_info->attr_info.info2->next_nint_posi;
		work = (int)GetNextOffset(offset, record,
					  next_nint_posi, field_length);
		next_offset = work & OFFSET_MASK;
		g_allocp
		    = ReadRepeatSimple((next_offset - offset), gk_flag,
				       (record + (offset * 2)), &sri_ele,
				       group_info->attr_info.info2->data_type,
				       attr_value, g_allocp);
		break;
	    case Group:           /* ° */
		next_nint_posi
		    = group_info->attr_info.info1->next_nint_posi;
		child_info
		    = group_info->attr_info.info1->child_attr_info;
		child_attr_cnt
		    = group_info->attr_info.info1->child_attr_cnt;
	        work = (int)GetNextOffset(offset, record, next_nint_posi,
					  field_length);
		next_offset = work & OFFSET_MASK;
		g_allocp
		    = ReadGroup(child_info, &sri_ele, (record + (offset * 2)),
				str_cnt, (next_offset - offset),
				child_attr_cnt, attr_value, g_allocp);
		break;
	    case Repeat_Group:    /* ֤° */
		next_nint_posi
		    = group_info->attr_info.info1->next_nint_posi;
		child_info
		    = group_info->attr_info.info1->child_attr_info;
		child_attr_cnt
		    = group_info->attr_info.info1->child_attr_cnt;
		work = (int)GetNextOffset(offset, record, next_nint_posi,
					  field_length);
		next_offset = work & OFFSET_MASK;
		g_allocp
		    = ReadRepeatGroup(child_info, &sri_ele,
				      (record + (offset * 2)), str_cnt,
				      (next_offset - offset), child_attr_cnt,
				      attr_value, g_allocp);
		break;
	    default:              /* ¾ʥ顼 */
		return (g_allocp);
	    }
	}
	group_info = group_info->next;
    }
    for( ; i < attr_cnt; i++ ) {  /* Ĥλ°ƤnilǼ */
	*(((struct vector_object *)G_FUNCTORP(work_value_list))->body + i)
	    = G_MAKESYM(G_atom(nil));
    }
    if ( null_only_flag ==  1 ) {
	/* °Nil */
	*value_list = G_MAKESYM(G_atom(nil));
    } else if ( null_only_flag == 2 ) { 
	/* °Bottom */
	*value_list = G_MAKESYM(G_atom(bottom));
    } else {
	/* 嵭ʳ */
	*value_list = work_value_list;
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	ReadSimple
 *	  ñ°եɤͥꥹȤڤФ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
ReadSimple(int offset, int next_offset, enum shp_DataType data_type,
	   int gk_flag, char *record, q *value_list, q *g_allocp)
{
    struct term_StringList *spand_string_list;
                                       /* ѥ Term °Ф */
    q old_string;                      /* ° decode ѥꥢ */
    declare_globals;

    int attr_length = (((next_offset & OFFSET_MASK) << FOUR_BYTE)
		       >> FOUR_BYTE) - (((offset) << FOUR_BYTE) >> FOUR_BYTE);
        /* о°Ĺ  INTEGER°  о° */
    char *tmp;                      /* ° decode ѥꥢ */
    int conv_str_len;

    switch( data_type ) {
    case Integer:                   /* INTEGER° */
	*value_list = G_MAKEINT(offset);
	break;
    case String:                    /* STRING° */
	CONVERT_BINARY_C_STRING_TO_KLIC_STRING(record,
		       ((attr_length * 2) - ( gk_flag ? 1:0)), *value_list);
	break;
#if FLOATING            /* ưǽ̤ݡȤΤᥳѥ޻ */
    case Float:                     /* FLOATING° */
	break;
    case Double:                    /* ¿ĹFLOATING°̤ݡȡ */
	break;
#endif
    case Term:                      /* TERM° */
	g_allocp = term_Decode(record, (attr_length * 2), spand_string_list,
			       value_list, g_allocp);
	break;
    case Psi_String:                /* PSI_STRING° */
	tmp = (char *)malloc(attr_length * 2);
	conv_str_len = Psi2Euc(attr_length, record, tmp);
	CONVERT_BINARY_C_STRING_TO_KLIC_STRING(tmp, conv_str_len,*value_list);
	free(tmp);
	break;
    default:                        /* 嵭ʳʥ顼 */
	break;
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	ReadRepeatSimple
 *	  ñ㷫֤°եɤͥꥹȤڤФ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
ReadRepeatSimple(int field_length, int gk_flag, char *record, q *rec_sri,
		 enum shp_DataType data_type, q *value_list, q *g_allocp)
{
    int i, j;            /* FOR LOOP */
    int empty_cnt;       /* ͤο */
    short occ_cnt;       /* оݷ֤ñ°Υ󥹿 */
    short empty;         /* оݷ֤ñ°ζͥե饰 */
    int offset;          /* ȥեå */
    int next_offset;     /* INTEGER°եå */
    int work;            /* ΰ */
    q sri_ele;           /* SRI */
    q *tmp;              /* KLICꥹȥǡ */
    struct cons *consp;  /* KLICꥹȥǡ */

    REC_GetShortInt(occ_cnt, record);
        /* 󥹿 */
    REC_GetShortInt(empty, record + TWO_BYTE);
        /* ͥեɼ */
    tmp = value_list;

    if ( empty == NIL_FIELD || empty == BOTTOM_FIELD ) {
	empty_cnt = 1;
    } else if ( empty == NIL_BOTTOM ) {
	empty_cnt = 2;
    } else {
	empty_cnt = 0;
    }

    if ( occ_cnt != 0 ) {
	G_HEAPALLOC((q)consp,
		    G_SIZE_IN_Q(struct cons)*(occ_cnt + empty_cnt),
		    (q));
        /* 󥹿ʬΥꥹȥǡΰ */

	for( i = 0; i < occ_cnt; i++ ) {
	    /* 󥹤ФɤߤԤʤSRIλ꤬礽˽ */
	    REC_GetInt(work, record + (i * FOUR_BYTE) + FOUR_BYTE);
            /* 󥹥եͼ */
	    offset = work & OFFSET_MASK;    /* եåͼ */
	    g_allocp
		= GetSimpleValueSRI(i, offset, rec_sri, data_type,
				    occ_cnt, field_length, work & GKFLAG_MASK,
				    record, &consp->car,
				    g_allocp);
	    if ( consp->car != NILATOM ) {     /* SRIˤ°ͤ */
		*tmp = G_MAKECONS(consp);      /* ɤ  */
		tmp = &consp->cdr;
		consp++;
	    }
	}
	switch( empty ) {
	case NIL_FIELD:                 /* ͥե饰 Nil Τ */
	    consp->car = G_MAKESYM(G_atom(nil));
	    *tmp = G_MAKECONS(consp);
	    tmp = &consp->cdr;
	    consp++;
	    break;	    
	case BOTTOM_FIELD:              /* ͥե饰 Bottom Τ */
	    consp->car = G_MAKESYM(G_atom(bottom));
	    *tmp = G_MAKECONS(consp);
	    tmp = &consp->cdr;
	    consp++;
	    break;	    
	case NIL_BOTTOM:                /* ͥե饰 Nil & Bottom */
	    consp->car = G_MAKESYM(G_atom(nil));
	    *tmp = G_MAKECONS(consp);
	    tmp = &consp->cdr;
	    consp++;
	    consp->car = G_MAKESYM(G_atom(bottom));
	    *tmp = G_MAKECONS(consp);
	    tmp = &consp->cdr;
	    consp++;
	    break;
	default:
	    break;
	}
	if ( tmp == value_list ) {      /* ͤڤФʤä */
	    *value_list = NILATOM;
	} else {
	    (--consp)->cdr = NILATOM;
	}
    } else {
	switch( empty ) {
	case NIL_FIELD:                 /* ͥե饰 Nil Τ */
	    *value_list = G_MAKESYM(G_atom(nil));
	    break;	    
	case BOTTOM_FIELD:              /* ͥե饰 Bottom Τ */
	    *value_list = NILATOM;
	    break;	    
	case NIL_BOTTOM:                /* ͥե饰 Nil & Bottom */
	    G_HEAPALLOC((q)consp,
			G_SIZE_IN_Q(struct cons)*(occ_cnt + empty_cnt),
			(q));
	    /* 󥹿ʬΥꥹȥǡΰ */
	    consp->car = G_MAKESYM(G_atom(nil));
	    *tmp = G_MAKECONS(consp);
	    tmp = &consp->cdr;
	    consp++;
	    consp->car = G_MAKESYM(G_atom(bottom));
	    *tmp = G_MAKECONS(consp);
	    tmp = &consp->cdr;
	    consp->cdr = NILATOM;
	    break;
	default:
	    break;
	}
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	ReadRepeatGroup
 *	  ķ֤°եɤͥꥹȤڤФ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
ReadRepeatGroup(struct shp_ChildInfo *attr_info, q *rec_sri, char *record,
		int str_cnt, int field_length, int child_attr_cnt,
		q *value_list, q *g_allocp)
{
    int i, j;         /* FOR LOOP */
    short occ_cnt;    /* оݷ֤ñ°Υ󥹿 */
    short empty;      /* оݷ֤ñ°ζͥե饰 */
    int work;         /* ΰ */
    int offset;       /* ȥեå */
    int next_offset;  /* եå */
    int next_offset_posi;  /* եåȰ */

    q sri_ele;           /* SRI */
    q *tmp;              /* KLICꥹȥǡ */
    struct cons *consp;  /* KLICꥹȥǡ */
 

    REC_GetShortInt(occ_cnt, record);
        /* 󥹿 */
    tmp = value_list;

    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*occ_cnt, (q));
        /* 󥹿ʬΥꥹȥǡΰ */

    for( i = 0; i < occ_cnt; i++ ) {
	REC_GetInt(work, (record + (i*FOUR_BYTE) + TWO_BYTE));
            /* եåͼФ */
	offset = work & OFFSET_MASK;
	empty = (work & NIL_FLAG_MASK) >> NIL_FLAG_SHIFT;
	if ( ( i + 1 ) == occ_cnt ) {
	    next_offset_posi = NULL;    /* ΥեåȤ̵Τ */
	                                /* ǽǤ򼨤NULLǼ */
	} else {
	    next_offset_posi = i + 1;
	        /* ΥեåȰ֤ϸߤΥ󥹰֤μ */
	}
	work = (int)GetNextOffset(offset, record,
				  next_offset_posi, field_length);
            /* INTEGERեåͼФ */
	next_offset = work & OFFSET_MASK;
	if ( !( next_offset - offset ) ) {
	    break;                      /* ȥեåȤȼեåȤ*/
                                        /*   ͤ¸ߤ */
	}
	g_allocp
	    = GetGroupValueSRI(i, occ_cnt, attr_info, rec_sri,
			       (record + (offset * 2)), str_cnt,
			       (next_offset - offset),
			       child_attr_cnt, &consp->car, g_allocp);
/*	if ( !(G_ISREF(consp->car)) ) {    /* SRIˤ꽸° */
	if ( consp->car != NILATOM ) {     /* SRIˤ꽸° */
	    *tmp = G_MAKECONS(consp);      /* ɤޤʤä  */
	    tmp = &consp->cdr;
	    consp++;
	}
    }
    switch( empty ) {
    case NIL_FIELD:                 /* ͥե饰 Nil Τ */
	consp->car = G_MAKESYM(G_atom(nil));
	*tmp = G_MAKECONS(consp);
	tmp = &consp->cdr;
	consp++;
	break;	    
    case BOTTOM_FIELD:              /* ͥե饰 Bottom Τ */
	consp->car = G_MAKESYM(G_atom(bottom));
	*tmp = G_MAKECONS(consp);
	tmp = &consp->cdr;
	consp++;
	break;	    
    case NIL_BOTTOM:                /* ͥե饰 Nil & Bottom */
	consp->car = G_MAKESYM(G_atom(nil));
	*tmp = G_MAKECONS(consp);
	tmp = &consp->cdr;
	consp++;
	consp->car = G_MAKESYM(G_atom(bottom));
	*tmp = G_MAKECONS(consp);
	tmp = &consp->cdr;
	consp++;
	break;
    default:
	break;
    }
/*
    if ( value_list == (q *)((consp - 1)->cdr) ) {
	consp->cdr = NILATOM;
 */
    if ( tmp == value_list ) {      /* ͤڤФʤä */
	*value_list = NILATOM;
    } else {
	(--consp)->cdr = NILATOM;
    }
    return (g_allocp);
}
    

/* --------------------------------------------------------------------
 *	ReadKey
 *	  ͥꥹȤ饭°°ͤФ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
ReadKey(struct shp_AccessPath *key_acc_path,
	struct shp_AttrInfo2 *key_schema_info,
	q *value_list, q *key_attr_value, q *g_allocp)
{
    int i;               /* FOR LOOP */
    q child_attr_value;  /* °ͥꥹ¸ */
    q occ_value;         /* ֤°ΰ */
    q occ_value_ele;     /* ֤°ΰ */
    q *tmp;              /* ꥹȥǡ */
    struct cons *consp;  /* ꥹȥǡ */
    int cnt = 1;         /* ꥹȥǡ */

    if ( key_acc_path == LAST ) {    /* ѥ̵ */
	*key_attr_value = *value_list;
    } else {                                  /* ѥͭ */
	if( key_acc_path->repeat == SingleNode ) {  /* °פSingle */
	    child_attr_value
		= shp_DerefOne(ELEMENT(*value_list,
				       key_acc_path->position));
	    g_allocp = ReadKey(key_acc_path->next, key_schema_info,
			       &child_attr_value, key_attr_value, g_allocp);
	} else {                                    /* °פ Set   */
	    tmp = key_attr_value;
	    occ_value = *value_list;
	    KP_GD_TDDEREF(occ_value);
	    for( i = ZERO; occ_value != NILATOM ; i++, consp++) {
		occ_value_ele = G_CAR_OF(occ_value);
		KP_GD_TDDEREF(occ_value_ele);
		G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*cnt, (q));
		child_attr_value
		    = ELEMENT(occ_value_ele, key_acc_path->position);
		KP_GD_TDDEREF(child_attr_value);
		g_allocp
		    = ReadKey(key_acc_path->next, key_schema_info,
			      &child_attr_value, &consp->car, g_allocp);
		*tmp = G_MAKECONS(consp);
		tmp = &consp->cdr;
		occ_value = G_CDR_OF(occ_value);
		KP_GD_TDDEREF(occ_value);
	    }
	    if ( tmp == key_attr_value ) {          /* ͤڤФ     */
		*key_attr_value = NILATOM;          /*         ʤä */
	    } else {                                /* ͤĤǤ         */
		(--consp)->cdr = NILATOM;           /*     ڤФ   */
	    }
	}
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	rec_ReadNil
 *        쥳ɥȥ󥰤ͻɤߤԤʤ
 *        ͥꥹȤѴƤӽФ¦֤
 *      
 *      ARGUMENT: internal_format : եޥåȤؤΥݥ
 *                                  (¤TBPեޥå)
 *                rec_sri         : ֥쥳ɾؤΥݥ(KLICǡ)
 *                record          : 쥳ɥȥ󥰤ؤΥݥ
 *                str_cnt         : 쥳ɥȥ󥰿
 *                record_length   : 쥳Ĺ
 *                value_list      : 쥳ɥȥ󥰤Ѵ줿
 *                                  ͥꥹ
 * 
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
rec_ReadNil(struct ifmt_IFormat *internal_format, q *rec_sri,
	    char *record[], int str_cnt, int page_size, int record_length,
	    q *value_list, q *g_allocp)
{
    q argv[1];        /* ٥ */
    int cnt;          /* ٥ */
    q vector_g_new();
    declare_globals;
    q *attr_value;    /* °Ͱ¸ */

    if( internal_format->format_kind == Nil ) { /* եޥåȤ
						   nil(nil)ξ */
	*value_list = G_MAKESYM(G_atom(nil));
    } else {                                    /* եޥåȤ
						   nil({AccPath, SchInfo})
						   ξ */
	if ( str_cnt > NOT_SPAND ) {/* ѥɥ쥳ɤξ̤ݡȡ */
	    return (g_allocp);
	} else {
	    cnt = 2;
	    argv[0] = G_MAKEINT((long) cnt);
	    *value_list = vector_g_new(1, argv, g_allocp);
	    g_allocp = heapp;
	    attr_value
		= (((struct vector_object *)G_FUNCTORP(*value_list))->body);
	    g_allocp
		= ReadKeyField(internal_format, rec_sri, record[FIRST_RECORD],
			       record_length, attr_value, g_allocp);
	    /* ͤɤ߽Ф */
	}
	*(((struct vector_object *)G_FUNCTORP(*value_list))->body + 1)
	    = G_MAKESYM(G_atom(nil));
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	GetNextOffset
 *        ΥեåͤФ
 * 
 *      RETURN: եå
 *
 * --------------------------------------------------------------------
 */

int
GetNextOffset(int offset, char *record, int next_nint_posi, int field_length)
{
    int return_next_offset;
        /* INTEGER°ΥեåͤؤΥݥ */

    if ( next_nint_posi != LAST ) {
	REC_GetInt(return_next_offset,record+(next_nint_posi*FOUR_BYTE)+TWO_BYTE);
                              /* ChildCnt */
            /* INTEGER°Υեåͼ */
    } else {
	return_next_offset = field_length;
	    /* о°ǽ°ξ */
    }
    return return_next_offset;
}


/* --------------------------------------------------------------------
 *	GetNextOffset
 *        ΥեåͤФ
 * 
 *      RETURN: եå
 *
 * --------------------------------------------------------------------
 */

int
GetRepeatNextOffset(int offset, char *record,
		    int next_nint_posi, int field_length)
{
    int return_next_offset;
        /* INTEGER°ΥեåͤؤΥݥ */

    if ( next_nint_posi != LAST ) {
	REC_GetInt(return_next_offset,
		   record+(next_nint_posi*FOUR_BYTE)+TWO_BYTE+TWO_BYTE);
                              /* OccCnt     Empty */
            /* INTEGER°Υեåͼ */
    } else {
	return_next_offset = field_length;
	    /* о°ǽ°ξ */
    }
    return (return_next_offset);
}


/* --------------------------------------------------------------------
 *	ReadKeyField
 *        եޥåȤ˻ꤵ줿°ͤɤ߹
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
ReadKeyField(struct ifmt_IFormat *internal_format,
	     q *rec_sri, char *record, int field_length,
	     q *value_list, q *g_allocp)
{
    struct shp_AccessPath *access_path /* °ޤǤΥѥ */
	= internal_format->i_format.nil_wk->key_access_path;
    int work;                          /* ΰ */
    int offset;                        /* եå */
    int next_offset;                   /* INTEGER°Υեå */
    int nil_flag;                      /* ͥե饰 */
    int gk_flag;         /* EUCȥѶե饰 */
                         /*ʥեåȥեɤƬ飳ӥåܡ */
/*
    key_schema_info
	= (struct shp_ChildInfo *)malloc(sizeof(struct shp_ChildInfo));
 */

    REC_GetInt(work, record+(access_path->position*FOUR_BYTE)+TWO_BYTE);
    offset = work & OFFSET_MASK;
    nil_flag = (work & NIL_FLAG_MASK) >> NIL_FLAG_SHIFT;
    gk_flag = work & GKFLAG_MASK;
/*
    key_schema_info->type
	= internal_format->i_format.nil_wk->key_schema_info->type;
    key_schema_info->attr_info.info2
	= (struct shp_AttrInfo2 *)malloc(sizeof(struct shp_AttrInfo2));
    key_schema_info->attr_info.info2
	= internal_format->i_format.nil_wk->key_schema_info;
    key_schema_info->next = LAST;
 */
    g_allocp
	= ReadKeyFieldLoop(access_path,
			   internal_format->i_format.nil_wk->key_schema_info->data_type, 
			   internal_format->i_format.nil_wk->key_schema_info->next_nint_posi, 
			   rec_sri, offset, nil_flag, gk_flag, record,
			   field_length, value_list, g_allocp);
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	ReadKeyFieldLoop
 *        եޥåȤ˻ꤵ줿ѥ˽
 *        쥳ɤéꡢ°ͤФ
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
ReadKeyFieldLoop(struct shp_AccessPath *access_path,
		 enum shp_DataType data_type, int next_nint_posi,
		 q *rec_sri, int offset, int nil_flag, int gk_flag,
		 char *record, int field_length, q *value_list,
		 q *g_allocp)
{
    int i;              /* FOR LOOP */
    int next_offset;    /* եå */
    int work;           /* ΰ */
    q *tmp;             /* KLICꥹȥǡ */
    struct cons *consp; /* KLICꥹȥǡ */

    switch ( nil_flag ) {
    case NIL_FIELD:
	*value_list = G_MAKESYM(G_atom(nil));
	break;
    case BOTTOM_FIELD:
	*value_list = G_MAKESYM(G_atom(bottom));
	break;
    default:
	if ( access_path->next == LAST ) {
	    /* ѥǽǤΤޤãݤν */
	    REC_GetInt(work,record+(access_path->position*FOUR_BYTE)+TWO_BYTE);
	    offset = work & OFFSET_MASK;
	    if ( next_nint_posi == LAST ) {
		/* ǽ°ξ */
		next_offset = field_length;
	    } else {                             /* ǽ°ξ */
		REC_GetInt(work, record+(next_nint_posi*FOUR_BYTE));
		next_offset = work & OFFSET_MASK;
		/* INTEGER°եåͤڤФ */
	    }
	    g_allocp = ReadSimple(offset, next_offset, data_type,
				  gk_flag, record + (offset * 2),
				  value_list, g_allocp);
	} else {  /* ѥӾ */
	    access_path = access_path->next;
	    if ( access_path->next_nint_posi == LAST ) {/* ǽ°ξ */
		next_offset = field_length;
	    } else {                                    /* ǽ°ξ */
		REC_GetInt(work, record+(access_path->position*FOUR_BYTE));
		next_offset = work & OFFSET_MASK;
		nil_flag = (work & NIL_FLAG_MASK) >> NIL_FLAG_SHIFT;
	        /* INTEGER°եåͤڤФ */
	    }
	    record = record + (offset * 2);
	    if ( access_path->repeat == Set ) {    /* ֤°ξ */
		short occ_cnt;    /* 󥹿 */
		
		REC_GetShortInt(occ_cnt, record);
		tmp = value_list;
		G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*occ_cnt, (q));
		for( i = ZERO; i < occ_cnt ; i++, consp++ ) {
		    REC_GetInt(work, record+(i*FOUR_BYTE)+TWO_BYTE);
		    offset = work & OFFSET_MASK;
		    if ( (i + 1) == occ_cnt ) {
			next_offset = field_length;
		    } else {
			REC_GetInt(work, record+((i+1)*FOUR_BYTE)+TWO_BYTE);
			next_offset = work & OFFSET_MASK;		    
		    }
		    g_allocp
			= ReadKeyFieldLoop(access_path, data_type,
					   next_nint_posi, rec_sri,
					   next_offset, nil_flag,
					   gk_flag, (record + (offset * 2)),
					   (next_offset - offset), &consp->car,
					   g_allocp);
		    *tmp = G_MAKECONS(consp);
		    tmp = &consp->cdr;
		}
		if ( tmp == value_list ) {         /* ͤڤФ     */
		    *value_list = NILATOM;         /*         ʤä */
		} else {                           /* ͤĤǤ         */
		    (--consp)->cdr = NILATOM;      /*     ڤФ   */
		}
	    } else {                               /* ñ㽸°ξ */
		g_allocp
		    = ReadKeyFieldLoop(access_path, data_type, next_nint_posi,
				       rec_sri, next_offset, nil_flag, gk_flag,
				       (record + (offset * 2)), field_length,
				       value_list, g_allocp);
	    }
	}
	break;
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	GetSimpleValueSRI
 *        ֥쥳ɾ˽֤ñ°ͤɤ
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
GetSimpleValueSRI(int current_occ, int offset, q *rec_sri,
		  enum shp_DataType data_type, int occ_cnt,
		  int field_length, int gk_flag, char *record,
		  q *value_list, q *g_allocp)
{
    int i;            /* FOR LOOP */
    int work;         /* ΰ */
    q work_sri;       /* ѥ֥쥳ɾ */
    q sri_ele;        /* ֥쥳ɾ롼 */
    q occ_list;
    q occ_list_ele;
    q tmp;
    int next_offset_posi;     /* եåȰ */

    *value_list = NILATOM;

    if ( ( current_occ + 1 ) == occ_cnt ) {
	next_offset_posi = NULL;    /* ΥեåȤ̵Τ */
                                    /* ǽǤ򼨤NULLǼ */
    } else {
	next_offset_posi = current_occ + 1;
	    /* ΥեåȰ֤ϸߤΥ󥹰֤μ */
    }
    
    if ( *rec_sri == NILATOM )  {        /* SRIꥹ */
	work = (int)GetRepeatNextOffset(offset, record, next_offset_posi,
					field_length);
	g_allocp
	    = ReadSimple(offset, (work & OFFSET_MASK), data_type,
			 gk_flag, (record + (offset * 2)), value_list,
			 g_allocp);
    } else if ( G_ISATOMIC(*rec_sri) ) { /* SRI == '*', 'nil' */
	work = (int)GetRepeatNextOffset(offset, record, next_offset_posi,
					field_length);
	g_allocp
	    = ReadSimple(offset, (work & OFFSET_MASK), data_type,
			 gk_flag, (record + (offset * 2)), value_list,
			 g_allocp);
    } else if ( G_ISFUNCTOR(*rec_sri) ) {
	/* Leaf Select Info. (Negative) = nega(OccNumList) */
	occ_list = arg(*rec_sri, SECOND);
	KP_GD_TDDEREF(occ_list);
	if ( occ_list == NILATOM ) {
	    work = (int)GetRepeatNextOffset(offset, record, 
					    next_offset_posi,
					    field_length);
	    g_allocp
		= ReadSimple(offset, (work & OFFSET_MASK), data_type,
			     gk_flag, (record + (offset * 2)),
			     value_list, g_allocp);
	} else {
	    occ_list_ele = G_CAR_OF(occ_list);
	    KP_GD_TDDEREF(occ_list_ele);
	    while( occ_list != NILATOM ) {
		if ( current_occ == (G_INTVAL(occ_list_ele) - 1) ) {
		    break;
/*              } else if ( current_occ < (G_INTVAL(occ_list_ele) - 1) ) { */
		} else {
		    work = (int)GetRepeatNextOffset(offset, record, 
						    next_offset_posi,
						    field_length);
		    g_allocp
			= ReadSimple(offset, (work & OFFSET_MASK), data_type,
				     gk_flag, (record + (offset * 2)),
				     value_list, g_allocp);
		    break;
		}
		occ_list = G_CDR_OF(occ_list);
		KP_GD_TDDEREF(occ_list);
	    }
	}
    } else if ( G_ISCONS(*rec_sri) ) {
	/* Leaf Select Info. (Positive) = INTEGER */
	work_sri = *rec_sri;
	KP_GD_TDDEREF(work_sri);
	while( work_sri != NILATOM ) {
	    sri_ele = G_CAR_OF(work_sri);
	    KP_GD_TDDEREF(sri_ele);
	    if ( G_ISINT(sri_ele) ) {
		if ( current_occ == (G_INTVAL(sri_ele) - 1) ) {
		    work = (int)GetRepeatNextOffset(offset, record,
						    next_offset_posi,
						    field_length);
		    g_allocp
			= ReadSimple(offset, (work & OFFSET_MASK),
				     data_type, gk_flag,
				     (record + (offset * 2)),
				     value_list, g_allocp);
		}
	    } 
	    work_sri = G_CDR_OF(work_sri);
	    KP_GD_TDDEREF(work_sri);
	}
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	GetGroupValueSRI
 *        ֥쥳ɾ˽֤°ͤɤ
 *
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
GetGroupValueSRI(int current_occ, short occ_cnt,
		 struct shp_ChildInfo *child_attr_info, q *rec_sri,
		 char *record, int str_cnt, int field_length,
		 int child_attr_cnt, q *value_list, q *g_allocp)
{
    int i;            /* FOR LOOP */
    int work;         /* ΰ */
    int offset;       /* INTEGER°ؤΥեå */
    int next_offset;  /* INTEGER°ؤΥեå */
    q work_sri;       /* ѥ֥쥳ɾ */
    q sri_ele;        /* ֥쥳ɾ롼 */
    q occ_list;       /* SRI⥪ֹꥹ */
    q occ_list_ele;   /* SRI⥪ֹꥹ */
    q tmp;            /* SRI */

    *value_list = NILATOM;
    
    REC_GetInt(work, (record+(current_occ*FOUR_BYTE)+TWO_BYTE));
    offset = work & OFFSET_MASK;
    work = (int)GetNextOffset(offset, record, current_occ,
			      field_length);
    next_offset = work & OFFSET_MASK;
    KP_GD_TDDEREF(*rec_sri);
    if ( *rec_sri == NILATOM )  {        /* SRIꥹ */
	g_allocp
	    = ReadGroup(child_attr_info, rec_sri, record, str_cnt,
			field_length, child_attr_cnt, value_list, g_allocp);
    } else if ( G_ISATOMIC(*rec_sri) ) { /* SRI == '*', 'nil' */
	g_allocp
	    = ReadGroup(child_attr_info, rec_sri, record, str_cnt,
			field_length, child_attr_cnt, value_list, g_allocp);
    } else if ( G_ISFUNCTOR(*rec_sri) ) {
	/* Leaf Select Info. (Negative) = nega(OccNumList) */
	occ_list = arg(*rec_sri, SECOND);
	KP_GD_TDDEREF(occ_list);
	if ( occ_list == NILATOM ) {
	    tmp = NILATOM;
	    g_allocp
		= ReadGroup(child_attr_info, &tmp, record, str_cnt,
			    field_length, child_attr_cnt, value_list,
			    g_allocp);
	} else {
	    occ_list_ele = G_CAR_OF(occ_list);
	    KP_GD_TDDEREF(occ_list_ele);
	    while( occ_list != NILATOM ) {
		if ( current_occ == (G_INTVAL(occ_list_ele) - 1) ) {
		    break;
/*              } else if ( current_occ < (G_INTVAL(occ_list_ele) - 1) ) { */
		} else {
		    tmp = NILATOM;
		    g_allocp
			= ReadGroup(child_attr_info, &tmp, record, str_cnt,
				    field_length, child_attr_cnt, value_list,
				    g_allocp);
		    break;
		}
		occ_list = G_CDR_OF(occ_list);
		KP_GD_TDDEREF(occ_list);
	    }
	}
    } else if ( G_ISCONS(*rec_sri) ) {
	/* Leaf Select Info. (Positive) = INTEGER */
	work_sri = *rec_sri;
	KP_GD_TDDEREF(work_sri);
	while( work_sri != NILATOM ) {
	    sri_ele = G_CAR_OF(work_sri);
	    KP_GD_TDDEREF(sri_ele);
	    if ( G_ISINT(sri_ele) ) {
		if ( current_occ == (G_INTVAL(sri_ele) - 1) ) {
		    tmp = NILATOM;
		    g_allocp
			= ReadGroup(child_attr_info, &tmp, record, str_cnt,
				    field_length, child_attr_cnt, value_list,
				    g_allocp);
		    break;
		} else if ( current_occ < G_INTVAL(sri_ele) ) {
		    break;
		}
	    } else if ( G_ISGOBJ(sri_ele) ) {
		/* Node Select Info. (Positive or Negative) */
		if ( G_ISINT(shp_DerefOne(ELEMENT(sri_ele, FIRST))) ) {
		    /* Positive = {OccNum, SRI} */
		    if ( current_occ
			== (G_INTVAL(shp_DerefOne(ELEMENT(sri_ele,
							  FIRST))) - 1) ) {
			tmp = shp_DerefOne(ELEMENT(sri_ele, SECOND));
			g_allocp
			    = ReadGroup(child_attr_info, &tmp, record,
					str_cnt, field_length, child_attr_cnt,
					value_list, g_allocp);
		    }
		} else if ( G_ISFUNCTOR(shp_DerefOne(ELEMENT(sri_ele,
							     FIRST))) ) {
		    /* Negative = {nega(OccNumList), SRI} */
		    occ_list
			= arg(shp_DerefOne(ELEMENT(sri_ele, FIRST)), SECOND);
		    KP_GD_TDDEREF(occ_list);
		    if ( occ_list == NILATOM ) {
			tmp = NILATOM;
			g_allocp
			    = ReadGroup(child_attr_info, &tmp, record,
					str_cnt, field_length,
					child_attr_cnt, value_list,
					g_allocp);
		    } else {
			occ_list_ele = G_CAR_OF(occ_list);
			KP_GD_TDDEREF(occ_list_ele);
			while( occ_list != NILATOM ) {
			    if ( current_occ
				== (G_INTVAL(occ_list_ele) - 1) ) {
				break;
			    } else if ( current_occ < 
				       (G_INTVAL(occ_list_ele) - 1) ) {
				tmp = shp_DerefOne(ELEMENT(sri_ele, SECOND));
				g_allocp
				    = ReadGroup(child_attr_info, &tmp, record,
						str_cnt, field_length,
						child_attr_cnt, value_list,
						g_allocp);
				break;
			    }
			    occ_list = G_CDR_OF(occ_list);
			    KP_GD_TDDEREF(occ_list);
			}
		    }
		}
	    }
	    work_sri = G_CDR_OF(work_sri);
	    KP_GD_TDDEREF(work_sri);
	}
    }
    return (g_allocp);
}
