/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *	rec_read_oc.c
 *   DESCRIPTION
 *	󥹷ɤߤԤʤ
 *   INTERFACE ROUTINES
 *	rec_ReadOccCnt - եޥåȤλꥪ󥹤Υ
 *                       ɤ߹
 *   NOTES       
 *	
 *$  EDITOR : Tooru Shida
 *$           (MITSUBISHI ELECTRIC COMPUTER SYSTEMS (TOKYO) CORPORATION)
 *$  CREATE : '94-01-28 Friday
 *$  UPDATE : '94-04-20~22 by Shida(MTC) for Kappa ver.Q02
 *$         : '94-07-28    by Shida(MTC) for Kappa ver.Q02
 *$           '95-03-23 modified for linux (rec_StrnCpy)
 *$
 ***********************************************************************/

#include <stdio.h>
#include <string.h>
#include "rec_read_oc.h"


/* --------------------------------------------------------------------
 *	rec_ReadOccCount
 *        եޥåȤ˽󥹥եɤ˳Ǽ
 *        륪󥹿Ф
 *      
 *      ARGUMENT: internal_format : եޥåȤؤΥݥ
 *                                  (¤TBPեޥå)
 *                rec_sri         : ֥쥳ɾؤΥݥ(KLICǡ)
 *                record          : 쥳ɥȥ󥰤ؤΥݥ
 *                str_cnt         : 쥳ɥȥ󥰿
 *                rid             : 쥳ID
 *                page_size       : ڡΥ(Хñ)
 *                record_length   : 쥳ĹʥХñ̡
 *                value_list      : 쥳ɥȥ󥰤Ѵ줿
 *                                  ͥꥹ(KLICǡ)
 * 
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
rec_ReadOccCount(struct ifmt_IFormat *internal_format, q *rec_sri,
		 char **record, int str_cnt, int page_size, int record_length,
		 q *value_list, q *g_allocp)
{
    struct ifmt_OccCount *occ_format = internal_format->i_format.occ_count;
        /* 󥹷ɤߥեޥå */
    q rec_sri_ele;       /* ֥쥳ɾ */
    q *tmp;              /* ͥꥹȥƥݥѿ */
    struct cons *consp;  /* KLICǡʥꥹȡ˷ */
    int cnt;             /* ꡼ѥꥹȥ */
    int offset;          /* եå */
    int next_offset;     /* INTEGER°եå */
    int nil_flag;        /* ͥե饰 */
    int gk_flag;         /* ե饰 */

    tmp = value_list;
    if ( str_cnt > NOT_SPAND ) { /* ѥɥ쥳ɤξ̤ݡȡ */
	return (g_allocp);
    } else {
	cnt = GetReturnListSize(occ_format);
	G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*cnt, (q));
	while ( occ_format ) {   /* 󥹥ѥɥ쥳ɤξ */
	    rec_sri_ele = GetSRI(*rec_sri, occ_format->access_path->position);
	    GetOffsetAndNextOffset(occ_format->access_path->position,
				   occ_format->access_path->next_nint_posi,
				   record[FIRST_RECORD], record_length,
				   &offset, &next_offset, &nil_flag,
				   &gk_flag);
	    g_allocp = GetOccCount(occ_format->access_path->next,
				   occ_format->schema_info, &rec_sri_ele,
				   (record[FIRST_RECORD] 
				    + (offset * TWO_BYTE)),
				   record_length, &consp->car, g_allocp);
	    *tmp = G_MAKECONS(consp);
	    tmp = &consp->cdr;
	    consp++;
	    occ_format = occ_format->next;
	}
	if ( tmp == value_list ) {
	    *value_list = NILATOM;
	} else {
	    (--consp)->cdr = NILATOM;
	}
    }
    return (g_allocp);
}
	
	
/* --------------------------------------------------------------------
 *	GetOccCount
 *        ѥéꡢ°Υ󥹿Ф
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
GetOccCount(struct shp_AccessPath *access_path,
	    struct shp_SchemaInfo *schema_info,
	    q *rec_sri, char *record, int field_length,
	    q *occ_cnt_list, q *g_allocp)
{
    int offset;        /* եå */
    int next_offset;   /* INTEGER°Υեå */
    int nil_flag;      /* ͥե饰 */
    int gk_flag;       /* ե饰 */
    short occ_cnt;      /* 󥹿 */
    q   *tmp;           /* ͥꥹȥƥݥѿ */
    q   rec_sri_ele;    /* ֥쥳ɾ */
    struct cons *consp; /* KLICǡʥꥹȡ˷ */
    int i;              /* FORLOOP */
    char *occ_child;    /* 󥹥եɺΰ */

    if ( access_path == LAST ) {    /* ѥλ */
	if ( schema_info->type == Simple ) {  /* ñ° */
	    *occ_cnt_list = G_MAKEINT(1);
	} else {                              /* ֤° */
	    REC_GetShortInt(occ_cnt, record);
	    *occ_cnt_list = GetRepeatSingleOccCount(*rec_sri, occ_cnt);
	}
    } else {                        /* ѥӾ */
	switch ( access_path->repeat ) {
	case SingleNode:                           /* ° */
	    record
		= GetOffsetAndNextOffset(access_path->position,
					 access_path->next_nint_posi,
					 record, field_length, &offset,
					 &next_offset, &nil_flag, &gk_flag);
	    nil_flag = (nil_flag & NIL_FLAG_MASK) >> NIL_FLAG_SHIFT;
	    if ( nil_flag == ATTR_FIELD ) {   /* °ͤͤǤʤ */
/*		rec_sri_ele = GetSRI(*rec_sri, access_path->position); */
		g_allocp = GetOccCount(access_path->next, schema_info,
				       rec_sri, record,
				       (next_offset - offset),
				       occ_cnt_list, g_allocp);
	    } else {                          /* °ͤͤǤ */
		g_allocp = MakeReturnNilValueList(access_path, schema_info,
						  occ_cnt_list, g_allocp);
	    }
	    break;
	case Set:                                  /* ֤° */
	    REC_GetShortInt(occ_cnt, record);
	    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*(occ_cnt), (q));
	    g_allocp
		= GetRepeatGroupOccCount(access_path, schema_info, *rec_sri,
					 record, occ_cnt, field_length,
					 occ_cnt_list, consp, g_allocp);
	    (--consp)->cdr = NILATOM;
	    break;
	default:
	    return (g_allocp);
	}
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	MakeReturnNilValueList
 *        °ͤͤǤͥꥹȤκ
 *      
 *      RETURN:  g_allocp    : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
MakeReturnNilValueList(struct shp_AccessPath *access_path,
		       struct shp_SchemaInfo *schema_info, 
		       q *value_list, q *g_allocp)
{
    int cnt = 1;    /* KLICꥹȥǡѡʥꥹǿ */
    q *tmp;         /* KLICꥹȥǡƥݥѿ     */
    struct cons *consp; /* KLICꥹȥǡѥǡ     */

    if ( access_path == LAST ) {                   /* ѥ */
	*value_list = G_MAKEINT(1);
    } else {                                       /* ѥӾ */
	if ( access_path->repeat == SingleNode ) { /* ° */
	    g_allocp = MakeReturnNilValueList(access_path->next, schema_info,
					      value_list, g_allocp);
	} else {                                   /* ֤° */
	    tmp = value_list;
	    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*cnt, (q));
	    *tmp = G_MAKECONS(consp);
	    tmp  = &consp->cdr;
	    consp->cdr = NILATOM;
	    g_allocp = MakeReturnNilValueList(access_path->next, schema_info,
					      &consp->car, g_allocp);
	}
    }
    return (g_allocp);
}
	

/* --------------------------------------------------------------------
 *	GetSRI
 *        ֥쥳ɾ°֤Ȼ°֤ǤФ
 *      
 *      RETURN: ֥쥳ɾ(KLICǡ)
 *
 * --------------------------------------------------------------------
 */

q 
GetSRI(q rec_sri, int attr_posi)
{
    q rec_sri_ele;                      /* SRI */
    q rec_sri_tail;                     /* SRI */
    
    KP_GD_TDDEREF(rec_sri);
    if ( rec_sri == NILATOM )  {        /* SRIꥹ */
	return (rec_sri);
    } else if ( G_ISATOMIC(rec_sri) ) { /* SRI == '*', 'nil' */
	return (rec_sri);
    } else if ( G_ISCONS(rec_sri) ) {   /* SRIꥹ */
	rec_sri_ele = G_CAR_OF(rec_sri);
	KP_GD_TDDEREF(rec_sri_ele);
	if ( attr_posi == G_INTVAL(shp_DerefOne(ELEMENT(rec_sri_ele, FIRST))) ) {
	    if ( size_of_vector(rec_sri_ele) == 2 ) {
		return ((q)(shp_DerefOne(ELEMENT(rec_sri_ele, SECOND))));
	    } else {
		return ((q)(shp_DerefOne(ELEMENT(rec_sri_ele, THIRD))));
	    }
	} else {
	    rec_sri_tail = G_CDR_OF(rec_sri);
	    KP_GD_TDDEREF(rec_sri_tail);
	    return (GetSRI(rec_sri_tail, attr_posi));
	}
    }
}


/* --------------------------------------------------------------------
 *	GetRepeatSingleOccCount
 *        ֥쥳ɾ򻲾Ȥ֤ñ°Υ󥹷
 *        ꤹ
 *      
 *      RETURN:  󥹷(KLICǡ)
 *      NOTE  :  Ϥrec_sri(KLICǡ)ϰʲη򤷤Ƥ
 *               rec_sri    ::=  LeafInfo | NodeInfo | SRI
 *               LeafInfo   ::=  OccNumList | "nega("OccNumList")" | *
 *               NodeInfo   ::=  OccNum | "nega("OccNumList")" | *
 *               SRI        ::=  [{AttrPosi, ID, LeafInfo}|SRI]
 *                              |[{AttrPosi, ID, NodeInfo}|SRI]
 *                              |[{AttrPosi, SRI}|SRI]
 *               OccNumList ::=  [OccNum|OccNumList]
 *               OccNum     ::=  INTEGER (1 origin)
 *
 * --------------------------------------------------------------------
 */

q 
GetRepeatSingleOccCount(q rec_sri, short occ_cnt)
{
    int i, j;                 /* FOR LOOP */
    int tmp_occ_cnt = 0;      /* ꥪ󥹿夲 */
    q sri_ele;                /* ֥쥳ɾ */
    q occ_list;               /* ֹꥹ */
    q occ_list_ele;           /* ֹꥹ */

    KP_GD_TDDEREF(rec_sri);
    for( i = 1; i <= occ_cnt && rec_sri != NILATOM; i++ ) {
	if ( G_ISATOMIC(rec_sri) ) { 
	    /* SRI == '*', 'nil' */
	    return (G_MAKEINT(occ_cnt));
	} else if ( G_ISFUNCTOR(rec_sri) ) {
	    /* Leaf Select Info. (Negative) */
	    occ_list = arg(rec_sri, SECOND);
	    KP_GD_TDDEREF(occ_list);
	    occ_list_ele = G_CAR_OF(occ_list);
	    KP_GD_TDDEREF(occ_list_ele);
	    for( j = 1; j <= occ_cnt; j++ ) {
		if ( occ_list == NILATOM ) {
		    tmp_occ_cnt++;
		} else if ( G_INTVAL(occ_list_ele) != j ) {
		    tmp_occ_cnt++;
		} else {
		    occ_list = G_CDR_OF(occ_list);
		    KP_GD_TDDEREF(occ_list);
		}
	    }
	    return (G_MAKEINT(tmp_occ_cnt));
	} else if ( G_ISCONS(rec_sri) ) {   /* SRIꥹ */
	    sri_ele = G_CAR_OF(rec_sri);
	    KP_GD_TDDEREF(sri_ele);
	    if ( G_ISINT(sri_ele) ) {
		/* Leaf Select Info. (Positive) */
		if ( G_INTVAL(sri_ele) == i ) {
		    tmp_occ_cnt++;
		    rec_sri = G_CDR_OF(rec_sri);          /* SRIǤ */
		    KP_GD_TDDEREF(rec_sri);
		} else if ( G_INTVAL(sri_ele) < i ) {
		    i = 0;    /* ֹκǽ餫饵 */
		}
	    } else if ( G_ISGOBJ(sri_ele) ) {
		/* Node Select Info. (Positive or Negative) */
		if ( G_ISINT(shp_DerefOne(ELEMENT(sri_ele, FIRST))) ) {
		    /* Positive */
		    if ( G_INTVAL(shp_DerefOne(ELEMENT(sri_ele, FIRST)))
			== i ) {
			tmp_occ_cnt++;
			rec_sri = G_CDR_OF(rec_sri);
			KP_GD_TDDEREF(rec_sri);
		    } else if ( G_INTVAL(shp_DerefOne(ELEMENT(sri_ele, FIRST)))
			       < i ) {
			i = 0;    /* ֹκǽ餫饵 */
		    }
		} else if ( G_ISFUNCTOR(shp_DerefOne(ELEMENT(sri_ele,
							     FIRST))) ) {
		    /* Negative */
		    occ_list
			= arg(shp_DerefOne(ELEMENT(sri_ele, FIRST)), SECOND);
		    KP_GD_TDDEREF(occ_list);
		    occ_list_ele = G_CAR_OF(occ_list);
		    KP_GD_TDDEREF(occ_list_ele);
		    for( j = 1; j <= occ_cnt; j++ ) {
			if ( occ_list == NILATOM ) {
			    tmp_occ_cnt++;
			} else if ( G_INTVAL(occ_list_ele) != j ) {
			    tmp_occ_cnt++;
			} else {
   			    occ_list = G_CDR_OF(occ_list);
			    KP_GD_TDDEREF(occ_list);
			}

		    }
		    i = 0;    /* ֹκǽ餫饵ľ */
		    rec_sri = G_CDR_OF(rec_sri);          /* SRIǤ */
		    KP_GD_TDDEREF(rec_sri);
		} else {                                  /* Almigty  */
		    return (G_MAKEINT(occ_cnt));
		}
	    }
	}
    }
    return (G_MAKEINT(tmp_occ_cnt));
}
	

/* --------------------------------------------------------------------
 *	GetRepeatGroupOccCount
 *        ֥쥳ɾ򻲾Ȥ֤°Υ󥹷
 *        ꤹ
 *      
 *      RETURN:  g_allocp    : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
GetRepeatGroupOccCount(struct shp_AccessPath *access_path,
		       struct shp_SchemaInfo *schema_info,
		       q rec_sri, char *record, short occ_cnt,
		       int field_length, q *occ_cnt_list,
		       struct cons *consp,
		       q *g_allocp)
{
    int i, j;                 /* FOR LOOP */
    int tmp_occ_cnt = 0;      /* ꥪ󥹿夲 */
    q sri_ele;                /* ֥쥳ɾ */
    q occ_list;               /* ֹꥹ */
    q occ_list_ele;           /* ֹꥹ */

    KP_GD_TDDEREF(rec_sri);
    for( i = 1; i <= occ_cnt && rec_sri != NILATOM; i++ ) {
	if ( G_ISATOMIC(rec_sri) ) {
	    /* SRI == '*', 'nil' */
	    g_allocp = GetRGElementOccCnt(access_path, schema_info,
					  i, rec_sri, record, occ_cnt, 
					  field_length, access_path->position,
					  &consp->car, g_allocp);
	    *occ_cnt_list = G_MAKECONS(consp);
	    occ_cnt_list = &consp->cdr;
	    consp++;
	} else if ( G_ISFUNCTOR(rec_sri) ) {
	    /* Leaf Select Info. (Negative) = nega(OccNumList) */
	    occ_list = arg(rec_sri, SECOND);
	    KP_GD_TDDEREF(occ_list);
	    occ_list_ele = G_CAR_OF(occ_list);
	    KP_GD_TDDEREF(occ_list_ele);
	    for( j = 1; j <= occ_cnt; j++, consp++ ) {
		if ( occ_list == NILATOM ) {
		    g_allocp = GetRGElementOccCnt(access_path,
						  schema_info, j, NILATOM, 
						  record, occ_cnt,
						  field_length,
						  access_path->position,
						  &consp->car,
						  g_allocp);
		    *occ_cnt_list = G_MAKECONS(consp);
		    occ_cnt_list = &consp->cdr;
		    consp++;
		} else if ( G_INTVAL(occ_list_ele) != j ) {
		    g_allocp = GetRGElementOccCnt(access_path,
						  schema_info, j, ASTAR, 
						  record, occ_cnt,
						  field_length,
						  access_path->position,
						  &consp->car,
						  g_allocp);
		    *occ_cnt_list = G_MAKECONS(consp);
		    occ_cnt_list = &consp->cdr;
		    consp++;
		}
	    occ_list = G_CDR_OF(occ_list);
	    KP_GD_TDDEREF(occ_list);
	    }
	} else if ( G_ISCONS(rec_sri) ) {   /* SRIꥹ */
	    sri_ele = G_CAR_OF(rec_sri);
	    KP_GD_TDDEREF(sri_ele);
	    if ( G_ISINT(sri_ele) ) {
		/* Leaf Select Info. (Positive) = INTEGER */
		if ( G_INTVAL(sri_ele) == i ) {
		    g_allocp = GetRGElementOccCnt(access_path,
						  schema_info, i, ASTAR, 
						  record, occ_cnt,
						  field_length,
						  access_path->position,
						  &consp->car,
						  g_allocp);
		    *occ_cnt_list = G_MAKECONS(consp);
		    occ_cnt_list = &consp->cdr;
		    consp++;
		    rec_sri = G_CDR_OF(rec_sri);
		    KP_GD_TDDEREF(rec_sri);
		}
	    } else if ( G_ISGOBJ(sri_ele) ) {
		/* Node Select Info. (Positive or Negative) */
		if ( G_ISINT(shp_DerefOne(ELEMENT(sri_ele, FIRST))) ) {
		    /* Positive = {OccNum, SRI} */
		    if ( G_INTVAL(shp_DerefOne(ELEMENT(sri_ele, FIRST)))
			== i ) {
			g_allocp 
			    = GetRGElementOccCnt(access_path,
						 schema_info, i, 
						 (q)(shp_DerefOne(ELEMENT(sri_ele,
							    SECOND))), 
						 record, occ_cnt,
						 field_length,
						 access_path->position,
						 &consp->car,
						 g_allocp);
			*occ_cnt_list = G_MAKECONS(consp);
			occ_cnt_list = &consp->cdr;
			consp++;
			rec_sri = G_CDR_OF(rec_sri);
			KP_GD_TDDEREF(rec_sri);
		    }
		} else if ( G_ISFUNCTOR(shp_DerefOne(ELEMENT(sri_ele,
							     FIRST))) ) {
		    /* Negative = {nega(OccNumList), SRI} */
		    occ_list = arg(shp_DerefOne(ELEMENT(sri_ele, FIRST)),
				   SECOND);
		    KP_GD_TDDEREF(occ_list);
		    occ_list_ele = G_CAR_OF(occ_list);
		    KP_GD_TDDEREF(occ_list_ele);
		    for( j = 1; j <= occ_cnt; j++, consp++ ) {
			if ( occ_list == NILATOM ) {
			    g_allocp
				= GetRGElementOccCnt(access_path,
						     schema_info, j,
						     (q)(shp_DerefOne(ELEMENT(sri_ele,
								SECOND))),
						     record, occ_cnt,
						     field_length,
						     access_path->position,
						     &consp->car,
						     g_allocp);
			    *occ_cnt_list = G_MAKECONS(consp);
			    occ_cnt_list = &consp->cdr;
			    consp++;
			} else if ( G_INTVAL(occ_list_ele) != j ) {
			    g_allocp 
				= GetRGElementOccCnt(access_path,
						     schema_info, j, 
						     (q)(shp_DerefOne(ELEMENT(sri_ele,
								SECOND))), 
						     record, occ_cnt, 
						     field_length,
						     access_path->position,
						     &consp->car,
						     g_allocp);
			    *occ_cnt_list = G_MAKECONS(consp);
			    occ_cnt_list = &consp->cdr;
			    consp++;
			}
			occ_list = G_CDR_OF(occ_list);
			KP_GD_TDDEREF(occ_list);
			}
		    rec_sri = G_CDR_OF(rec_sri);
		    KP_GD_TDDEREF(rec_sri);
		}
	    }
	}
    }
    (--consp)->cdr = NILATOM;
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	GetRGElemetnOccCount
 *        ֤°λꥪֹν°Υ
 *        Ф
 *      
 *      RETURN:  g_allocp    : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
GetRGElementOccCnt(struct shp_AccessPath *access_path,
		   struct shp_SchemaInfo *schema_info, int occ_num,
		   q rec_sri, char *record, int max_occ, int field_length,
		   int attr_posi, q *occ_cnt_list_ele, q *g_allocp)
{
    int offset;             /* եå */
    int next_offset;        /* INTEGER°Υեå */
    int nil_flag;           /* ͥե饰 */
    int gk_flag;            /* ե饰 */
    int next_occ_num;       /* ֹ */
    char *occ_child;        /* 󥹥եɺΰ */
    q sri_ele;              /* ֥쥳ɾ */

    if ( occ_num == max_occ ) {
	next_occ_num = LAST;
    } else {
	next_occ_num = occ_num;
    }
    sri_ele = GetSRI(rec_sri, attr_posi);
    occ_child
	= GetOffsetAndNextOffset((occ_num - NEXT_OFF_POSI), next_occ_num,
				 record, field_length, &offset,
				 &next_offset, &nil_flag, &gk_flag);
    occ_child
	= GetOffsetAndNextOffset(access_path->position,
				 access_path->next_nint_posi,
				 occ_child, field_length, &offset,
				 &next_offset, &nil_flag, &gk_flag);
    g_allocp = GetOccCount(access_path->next, schema_info, &sri_ele,
			   occ_child, (next_offset - offset),
			   occ_cnt_list_ele, g_allocp);
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	GetReturnListSize
 *        ͥꥹȤȤֵѤꥹȥեޥåȤФ
 *      
 *      RETURN:  ꥹȥ(INTEGER)
 *
 * --------------------------------------------------------------------
 */

int
GetReturnListSize(struct ifmt_OccCount *occ_format)
{
    int list_size;        /* returnѥꥹȥ */
    
    for ( list_size = 0; occ_format != NULL; list_size++ ) {
	/* ꥹȥȽ */
	occ_format = occ_format->next;
    }
    return (list_size);
}
