/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *	rec_read.c
 *   DESCRIPTION
 *	եޥåȤ˻ꤵ줿ƥ쥳ɤ߽
 *      ޥȯԤԤʤ
 *   INTERFACE ROUTINES
 *	rec_ReadRecord - եޥåȤ˻ꤵ줿ɤ߽
 *                       ޥɤȯԤ롣
 *      
 *   NOTES       
 *	
 *$  EDITOR : Tooru Shida
 *$           (MITSUBISHI ELECTRIC COMPUTER SYSTEMS (TOKYO) CORPORATION)
 *$  CREATE : '93-12-15
 *$  UPDATE : '95-03-23 modified for linux (rec_StrnCpy)
 ***********************************************************************/

#include <stdio.h>
#include "rec_read.h"

/* --------------------------------------------------------------------
 *	rec_ReadRecord
 *        쥳ɰ쥳ɥȥ󥰤
 *        ͥꥹȤѴƤӽФ¦֤
 *      
 *      ARGUMENT: internal_format : եޥåȤؤΥݥ
 *                                  (¤TBPեޥå)
 *                rec_sri         : ֥쥳ɾؤΥݥ(KLICǡ)
 *                record          : 쥳ɥȥ󥰤ؤΥݥ
 *                str_cnt         : 쥳ɥȥ󥰿
 *                page_size       : ڡΥ(Хñ)
 *                value_list      : 쥳ɥȥ󥰤Ѵ줿
 *                                  ͥꥹ(KLICǡ)
 * 
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
rec_ReadRecord(struct ifmt_IFormat *internal_format, q *rec_sri,
	       char **record, int str_cnt, int page_size, q *value_list,
	       q *g_allocp)
{
    int record_length;            /* 쥳Ĺ */
    declare_globals;

    if ( str_cnt == NOT_SPAND ) {
	REC_GetInt(record_length, record[FIRST_RECORD]);
            /* 쥳Ĺ */
	record[FIRST_RECORD] = record[FIRST_RECORD] + FOUR_BYTE + FOUR_BYTE;
            /* 쥳ĹRIDǼΰΥå */
    } else {
	REC_GetInt(record_length, record[FIRST_RECORD] + TWO_BYTE);
            /* 쥳Ĺ */
	record[FIRST_RECORD]
	    = record[FIRST_RECORD] + TWO_BYTE + FOUR_BYTE + FOUR_BYTE;
            /* 쥳ĹRIDǼΰΥå */
	str_cnt = 0;    /* ѥɥ쥳ɻн */
    }
    record_length = record_length - 4;
            /* 쥳ĹRIDǼΰʬĹ򸺻 */
    switch( internal_format->format_kind ) {
    case All:
	/* FALL THROUGH */
    case All_wk:
	g_allocp = rec_ReadAllTable(internal_format, rec_sri, record, 
				    str_cnt, page_size, record_length,
				    value_list, g_allocp);
	return (g_allocp);
    case Nil:
	/* FALL THROUGH */
    case Nil_wk:
	g_allocp = rec_ReadNil(internal_format, rec_sri, record, 
			       str_cnt, page_size, record_length,
			       value_list, g_allocp);
	return (g_allocp);
    case Grouping:
	g_allocp = rec_ReadGrouping(internal_format, rec_sri, record, 
				    str_cnt, page_size, record_length,
				    value_list, g_allocp);
	return (g_allocp);
    case Occ_count:
	g_allocp = rec_ReadOccCount(internal_format, rec_sri, record, 
				    str_cnt, page_size, record_length,
				    value_list, g_allocp);
	return (g_allocp);
    default:
	return (g_allocp);
    }
}


/*/* --------------------------------------------------------------------
/* *	rec_StrnCpy
/* *        Kappa쥳ɽrec_StrnCpy
/* *        ʸNULLɤޤƻʸԡ
/* *
/* *      RETURN:   ԡʸؤΥݥ
/* *
/* * --------------------------------------------------------------------
/* */
/*
/*char *
/*rec_StrnCpy(int *intp, char *string,  int size)
/*{
/*    int i;
/*
/*    if (size == FOUR_BYTE) {
/*	GET_INTEGER_NM(*intp, string);
/*    }
/*    else if (size == TWO_BYTE) {
/*	GET_SHORT_INTEGER_NM(*(short *)intp, string);
/*    }
/*
/*    return (string);
/*}
 */
