/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *	rec_add.c
 *   DESCRIPTION
 *	ͥꥹȤΥ쥳ɤؤγǼԤʤ
 *   INTERFACE ROUTINES
 *      rec_AddRecord         - ͥꥹȰ򥹥ȥ󥰤Ѵ
 *      
 *   NOTES       
 *	
 *$  EDITOR : Tooru Shida
 *$           (MITSUBISHI ELECTRIC COMPUTER SYSTEMS (TOKYO) CORPORATION)
 *$  CREATE : '94-07-15
 *$  UPDATE : '95-01-13 Fri for Kappa IFS version
 *$               03-23 Tue for linux
 *$
 ***********************************************************************/

#include <stdio.h>
#include <string.h>
#include "rec_add.h"


/* --------------------------------------------------------------------
 *	rec_AddRecord
 *        ꤵ줿ͥꥹȤ쥳ɥȥ󥰤˳Ǽ
 *      
 *      ARGUMENT: value_list      : 桼ꤵͥꥹ
 *                internal_format : եޥåȤؤΥݥ
 *                                  (¤TBPեޥå)
 *                page_size       : ڡΥ(Хñ)
 *                record          : 쥳ɥȥ󥰤ؤΥݥ
 *                str_cnt         : ɲå쥳ɥȥ󥰿
 *                idx_add_strm    : ǥåɲþ(KLICǡ)
 * 
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
rec_AddRecord(q *value_list, struct ifmt_IFormat *internal_format, int rid,
       int page_size,char **record,int *rec_length,q *idx_add_strm,q *g_allocp)
{
  int posi;                              /* 쥳ɳǼ߰ */
  int child_attr_cnt;                    /* ° */
  struct shp_ChildInfo *child_attr_info; /* °ꥹ */
  struct cons *consp;                    /* 󥹥ꥹ([]) */
  q occ_list = NILATOM;

  posi = BL_AREA_LENGTH + RL_AREA_LENGTH; /* ֥åĹǼΰΥå */
  if ( G_ISSYM(*value_list) ) { /* ValueListATOM -> nil or bottom */
    posi = Put4Byte(record, posi, rid, page_size);/* RIDrecordƬ˳Ǽ */
    posi = Put2Byte(record, posi,
		    (*value_list==G_MAKESYM(ATOM_nil))?EMPTY_NIL:EMPTY_BOTTOM,
		    page_size);
    child_attr_info =
      internal_format->i_format.table_schema_info->child_attr_info;
    child_attr_cnt =
      internal_format->i_format.table_schema_info->child_attr_cnt;
    g_allocp =
      CreateEmptyValueAddIndexInfo(child_attr_cnt, child_attr_info,*value_list,
				   idx_add_strm, &occ_list, g_allocp);
    *rec_length = NULL_VALUE_LENGTH;
  } else { /* ValueListATOMʳ */
    g_allocp = PutValueList(value_list, internal_format, rid, page_size,
			    record, &posi, rec_length, idx_add_strm, g_allocp);
  }

  Put4Byte(record, BL_AREA_LENGTH, *rec_length, page_size);
                                                   /* 쥳Ĺ񤭹 */
  return g_allocp;
}

/* --------------------------------------------------------------------
 *	PutValueList
 *        ꤵ줿ͥꥹȤ쥳ɥȥ󥰤˳Ǽ
 *      
 *      ARGUMENT: value_list      : 桼ꤵͥꥹ
 *                internal_format : եޥåȤؤΥݥ
 *                                  (¤TBPեޥå)
 *                page_size       : ڡΥ(Хñ)
 *                record          : 쥳ɥȥ󥰤ؤΥݥ
 *                str_cnt         : ɲå쥳ɥȥ󥰿
 *                idx_add_strm    : ǥåɲþ(KLICǡ)
 * 
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
PutValueList(q *value_list, struct ifmt_IFormat *internal_format,
	     int rid, int page_size, char **record, int *posi,
	     int *rec_length, q *idx_add_strm, q *g_allocp)
{
    struct shp_ChildInfo *child_attr_info;          /* °ꥹ */
    int child_attr_cnt;                     /* ° */
    int ofp;                        /* եåȥեƬ */
    int dfp;                            /* ǡեƬ */
    q occ_list = NILATOM;

    ofp = Put4Byte(record, *posi, rid, page_size);/* RIDrecordƬ˳Ǽ */
    child_attr_info =
	internal_format->i_format.table_schema_info->child_attr_info;
    child_attr_cnt =
	internal_format->i_format.table_schema_info->child_attr_cnt;
    dfp = ofp;

    g_allocp = 
	PutGroupValue(value_list, child_attr_info, child_attr_cnt, page_size,
		      record, &ofp, &dfp, idx_add_strm, &occ_list, g_allocp);
    *rec_length = dfp - BL_AREA_LENGTH;
        /* оݥ롼°γǼեĹλ */
    return g_allocp;
}

/* --------------------------------------------------------------------
 *	PutGroupValue
 *        ꤵ줿ͥꥹȤ쥳ɥȥ󥰤˳Ǽ
 *      
 *      Return:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
PutGroupValue(q *value_list, struct shp_ChildInfo *attr_info,
	      int attr_cnt, int page_size, char **record,
	      int *ofp, int *dfp, q *idx_add_strm,
	      q *occ_list, q *g_allocp)
{
  declare_globals;

  int value_size;            /* ͥꥹȥ٥ */
  int head_posi;             /* եƬ */
  int i;                     /* FOR LOOP */
  q attr_value;              /* ° */
  q work_idx_add_strm;       /* ǥåɲþΰ */
  q *work_idx_add_strm_body; /* ǥåɲþΰ */
  q idx_add_strm_ele;        /* ǥåɲþ */
  q argv[1];                 /* ٥ */
  q vector_g_new();
    
  KP_GD_TDDEREF(*value_list);
  head_posi = *ofp;
  if ( G_ISSYM(*value_list) ) {	/* ValueListATOM -> nil or bottom */
    if(*value_list == G_MAKESYM(ATOM_nil)) /* ValueList = nil */
       *dfp = PutNilValue(record, head_posi, page_size);
    else if(*value_list == G_MAKESYM(ATOM_bottom)) /* ValueList = bottom */
       *dfp = PutBottomValue(record, head_posi, page_size);
    g_allocp =
      CreateEmptyValueAddIndexInfo(attr_cnt, attr_info, *value_list,
				   idx_add_strm, occ_list, g_allocp);
  } else { /* ValueListATOMʳ(Group°) */
    *ofp = Put2Byte(record, *ofp, attr_cnt, page_size);
	    /* °°Ǽΰ˳Ǽ */
    *dfp = ( *ofp + ( attr_cnt * TWO_ELEMENT ) );
            /* ǡեɰ֤°˱ƥåȤ */

    value_size = G_INTVAL( size_of_vector(*value_list) );
	    /* ºݤ˻ꤵ줿°ͤΥ٥ǿ */
    NEW_VECTOR(attr_cnt, work_idx_add_strm);
	    /* ǥåɲþ󥹥ȥ꡼°֤ʬ */
    work_idx_add_strm_body =
      ((struct vector_object *)G_FUNCTORP(work_idx_add_strm))->body;
    for ( i = 0; i < value_size || i < attr_cnt; i++ ) {
	    /* °ͤ޾˽Ǽ */
      attr_value = element_of_vector(*value_list, G_MAKEINT(i));
      g_allocp = PutOneAttr(&attr_value, attr_info, page_size, record, ofp,dfp,
			    head_posi, &idx_add_strm_ele, occ_list, g_allocp);
      work_idx_add_strm_body[i] = idx_add_strm_ele;
      attr_info = attr_info->next;
    }

    for ( ; i < attr_cnt; i++ ) {
	    /* °ͤ°꾯ʤΤbottomǼ */
      *ofp = PutBottomValue(record, *ofp, page_size);
      work_idx_add_strm_body[i] = NILATOM;
    }
    *idx_add_strm = work_idx_add_strm;
  }
  return g_allocp;
}

/* --------------------------------------------------------------------
 *	PutNilValue
 *        °ΤNilγǼ
 *      
 *      RETURN:   Ǽ(INTEGER)
 *
 * --------------------------------------------------------------------
 */

int
PutNilValue(char **record, int posi, int page_size)
{
    posi = Put2Byte(record, posi, ONE_ATTR, page_size);
        /* °ǼΰˣǼ(ͰĤΤߤ) */
    posi = Put4Byte(record, posi, NIL_IDENTIFY, page_size);
        /* եåȥեɤnil̻(0x40000000)Ǽ */
    return (posi);
}


/* --------------------------------------------------------------------
 *	PutBottomValue
 *        °ΤBottomγǼ
 *      
 *      RETURN:   Ǽ(INTEGER)
 *
 * --------------------------------------------------------------------
 */

int
PutBottomValue(char **record, int posi, int page_size)
{
    posi = Put2Byte(record, posi, ONE_ATTR, page_size);
        /* °ǼΰˣǼ(ͰĤΤߤ) */
    posi = Put4Byte(record, posi, BOTTOM_IDENTIFY, page_size);
        /* եåȥեɤbottom̻(0x80000000)Ǽ */
    return (posi);
}


/* --------------------------------------------------------------------
 *	PutOneAttr
 *        °ͤγǼ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
PutOneAttr(q *attr_value, struct shp_ChildInfo *attr_info,
	   int page_size, char **record, int *ofp, int *dfp, 
	   int head_posi, q *idx_add_strm,
	   q *occ_list, q *g_allocp)
{
    int child_ofp;        /* °եåȥեɰ */
    int child_dfp;        /* °ǡեɰ */
    int child_cnt;        /* ° */
    struct shp_ChildInfo *child_info;
                          /* ° */

    switch ( attr_info->type ) {
    case Simple:          /* ñINTEGER° */
	g_allocp =
	    PutSimpleValue(attr_value, attr_info->attr_info.info2, page_size,
			   record, head_posi, ofp, dfp, idx_add_strm,
			   occ_list, g_allocp);
	break;
    case Repeat_Simple:   /* ֤ñ° */
	*ofp = Put4Byte(record, *ofp, ( *dfp - head_posi ), page_size);
	    /* ֤ñ°եɤΥեåȰֽ񤭹 */
	child_ofp = *dfp;
	child_dfp = *dfp;
	g_allocp = 
	    PutRSimpleValue(attr_value, attr_info->attr_info.info2, page_size,
			    record, &child_ofp, &child_dfp, idx_add_strm,
			    occ_list, g_allocp);
	*dfp = child_dfp;
	break;
    case Group:           /* ° */
	*ofp = Put4Byte(record, *ofp, ( *dfp - head_posi ), page_size);	
	    /* °եɤΥեåȰֽ񤭹 */
	child_ofp = *dfp;
	child_dfp = *dfp;
	child_cnt = attr_info->attr_info.info1->child_attr_cnt;
	child_info = attr_info->attr_info.info1->child_attr_info;
	g_allocp =
	    PutGroupValue(attr_value, child_info, child_cnt,
			  page_size, record, &child_ofp, &child_dfp,
			  idx_add_strm, occ_list, g_allocp);
	*dfp = child_dfp;
	break;
    case Repeat_Group:    /* ֤° */
	*ofp = Put4Byte(record, *ofp, ( *dfp - head_posi ), page_size);	
	    /* ֤°եɤΥեåȰֽ񤭹 */
	child_ofp = *dfp;
	child_dfp = *dfp;
	g_allocp =
	    PutRGroupValue(attr_value, attr_info->attr_info.info1, page_size,
			   record, &child_ofp, &child_dfp, occ_list,
			   idx_add_strm, g_allocp);
	*dfp = child_dfp;
	break;
    default:
	break;
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	PutSimpleValue
 *        INTEGERñ°ͤγǼ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
PutSimpleValue(q *attr_value, struct shp_AttrInfo2 *simple_info, int page_size,
	       char **record, int head_posi, int *ofp, int *dfp,
	       q *idx_add_strm, q *occ_list, q *g_allocp)
{
  q return_attr_value;         /* ǥåɲþ° */
  int identify;

  KP_GD_TDDEREF(*attr_value);
  if ( G_ISSYM(*attr_value) ) {	/* ValueListATOM -> nil or bottom */
    identify = (*attr_value==G_MAKESYM(ATOM_nil))?NIL_IDENTIFY:BOTTOM_IDENTIFY;
    *ofp = Put4Byte(record, *ofp, (identify|(*dfp-head_posi)), page_size);
                /* եåȥեɤnil̻(0x4xxxxxxx)Ǽ */
                /* եåȥեɤbottom̻(0x8xxxxxxx)Ǽ */
    return_attr_value = *attr_value;
  } else { /* ValueListATOMʳ */
    g_allocp =
      PutAttrValue(attr_value, simple_info, page_size, record, head_posi,
		   ofp, dfp, &return_attr_value, g_allocp);
  }
  return
    CreateIndexAddInfo(simple_info->attr_name, simple_info->key_request,
		       simple_info->acc_request, simple_info->nil_request,
		       &return_attr_value, occ_list, idx_add_strm, g_allocp);
}

/* --------------------------------------------------------------------
 *	PutAttrValue
 *        ñ°ͤγǼ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

#define STRING_OBJ(x)	(G_FUNCTORP(x))

q *
PutAttrValue(q *attr_value, struct shp_AttrInfo2 *simple_info,
	     int page_size, char **record, int head_posi, int *ofp,
	     int *dfp, q *return_attr_value, q *g_allocp)
{
    char *string_body;
    int string_size;         /* ȥ󥰤Ĺ */
    char *tmp_string, *tmp_string1;
    q index_attr_value;
    int control_area_length; /* °ΰĹ */

    declare_globals;

    q size_of_string();
    char *generic_string_body();

    KP_GD_TDDEREF(*attr_value);
    switch ( simple_info->data_type ) {
    case Integer:  /* ñINTEGER° */
	*ofp = Put4Byte(record, *ofp, G_INTVAL(*attr_value), page_size);
	*return_attr_value = *attr_value;
	break;
    case String:
	index_attr_value = *attr_value;
	string_size = (int) G_INTVAL(size_of_string(*attr_value));
	string_body = generic_string_body(STRING_OBJ(*attr_value));
	if ( simple_info->max_length != MAX_LENGTH_UNDEFINED ) {
	    /* °ĹꤵƤ */
	    if(simple_info->max_length < string_size)
		CONVERT_BINARY_C_STRING_TO_KLIC_STRING(string_body, simple_info->max_length, index_attr_value);
	    string_size = simple_info->max_length;
	    string_body = generic_string_body(index_attr_value);
	}
	*ofp = Put4Byte(record, *ofp,
			((string_size % 2 ) ?
		 	    /* ȥ󥰥ξ : ξ */
			    ((*dfp - head_posi) | KISUU_IDENTIFY ) : (*dfp - head_posi)),
			    page_size);
	*dfp = PutAttribute(record, *dfp, string_body, string_size, page_size);
	*return_attr_value = index_attr_value;
	break;
    case Psi_String:
	string_size = (int) G_INTVAL(size_of_string(*attr_value));
	tmp_string = convert_klic_string_to_c_string(*attr_value);
	tmp_string1 = (char *)malloc(string_size * 2 + 2);
	if ( simple_info->max_length != MAX_LENGTH_UNDEFINED ) {
	    /* °ĹꤵƤ */
	    tmp_string[simple_info->max_length] = 0;
	    string_size = simple_info->max_length;
	}
	Euc2Psi(string_size, tmp_string, tmp_string1);
	*ofp = Put4Byte(record, *ofp, (*dfp - head_posi), page_size);
	*dfp = PutAttribute(record, *dfp, tmp_string1,
			    (string_size * 2), page_size);
	CONVERT_C_STRING_TO_KLIC_STRING(tmp_string, *return_attr_value);
	free(tmp_string1);
	free(tmp_string);
	break;
#if FLOATING            /* ưǽ̤ݡȤΤᥳѥ޻ */
    case Float:
	*ofp = Put4Byte(record, *ofp, *dfp, page_size);	
	*dfp = PutAttribute(record, *dfp, tmp_string, page_size);
	break;
#endif
    case Term:
	tmp_string = (char *)malloc(page_size);
	tmp_string1 = term_Encode(*attr_value, tmp_string);
	    /* फ饹ȥ󥰤Ѵ */
	string_size = (int)(tmp_string1 - tmp_string);
	*ofp = Put4Byte(record, *ofp, (*dfp - head_posi), page_size);	
	*dfp = PutAttribute(record, *dfp, tmp_string,
			    string_size, page_size);
	*return_attr_value = *attr_value;
	free(tmp_string);
	break;
    default:
	break;
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	PutRSimpleValue
 *        ֤ñ°ͤγǼ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */ /**********/

q *
PutRSimpleValue(q *attr_value, struct shp_AttrInfo2 *rsimple_info,
		int page_size, char **record, int *ofp, int *dfp,
		q *idx_add_strm, q *occ_list, q *g_allocp)
{
  declare_globals;

  int occ_num;                   /* оݥֹ */
  q fix_occ_list;                /* ꥪ󥹥ꥹ */
  int empty_cnt;                 /* ΰ񤭹Ѽ̻ */
  q attr_value_tmp;              /* 󥹿 */
  q attr_value_tmp_ele;          /* 󥹿 */
  q attr_value_ele;              /* ֤° */
  q return_attr_value;           /* ǥåɲþ° */
  int occ_cnt_no_empty;          /* ͤ󥹿 */
  int occ_cnt;                   /* ͤޤ४󥹿 */
  int field_head_posi;           /* °եɤƬ */
  q work_idx_add_strm;           /* ǥåɲþΰ */
  q work_attr_value;             /* ǥåɲþΰ */
  q idx_add_strm_ele;            /* ǥåɲþ */
  q argv[1];                     /* ٥ */
  q vector_g_new();

  field_head_posi = *ofp;

  KP_GD_TDDEREF(*attr_value);
  if ( *attr_value == NILATOM || *attr_value == G_MAKESYM(ATOM_bottom)) {
                                        /* attr_value = []ξ */
    work_attr_value = G_MAKESYM(ATOM_bottom);
    fix_occ_list = GetFixOccList(occ_list, ONE_ATTR, g_allocp);
    g_allocp = heapp;
    g_allocp =
      CreateIndexAddInfo(rsimple_info->attr_name, rsimple_info->key_request,
			 rsimple_info->acc_request, rsimple_info->nil_request,
			 &work_attr_value,&fix_occ_list,idx_add_strm,g_allocp);
    *ofp = Put2Byte(record, *ofp, 0, page_size);
    *ofp = Put2Byte(record, *ofp, REP_BOTTOM, page_size);
    *dfp = *ofp;
  } else if ( G_ISSYM(*attr_value) ) { /* attr_value = nilξ */
    fix_occ_list = GetFixOccList(occ_list, ONE_ATTR, g_allocp);
    g_allocp = heapp;
    g_allocp =
      CreateIndexAddInfo(rsimple_info->attr_name, rsimple_info->key_request,
			 rsimple_info->acc_request, rsimple_info->nil_request,
			 attr_value, &fix_occ_list, idx_add_strm, g_allocp);
    *ofp = Put2Byte(record, *ofp, 0, page_size);
    *ofp = Put2Byte(record, *ofp, REP_NIL, page_size);
    *dfp = *ofp;
  } else if ( G_ISCONS(*attr_value) ) {	/* attr_value = ꥹȤξ */
    attr_value_tmp = *attr_value;
	    /* 󥹥ѤͥꥹȤ򥳥ԡ */
    KP_GD_TDDEREF(attr_value_tmp);
    attr_value_tmp_ele = G_CAR_OF(attr_value_tmp);
    KP_GD_TDDEREF(attr_value_tmp_ele);
    for ( occ_cnt = 0, occ_cnt_no_empty = 0, empty_cnt = 0;
	 attr_value_tmp != NILATOM; occ_cnt++ ) {
	    /* 󥹿Υ(̵ͭĴޤ) */
      attr_value_tmp_ele = G_CAR_OF(attr_value_tmp);
      KP_GD_TDDEREF(attr_value_tmp_ele);
      if ( G_ISSYM(attr_value_tmp_ele) ) { /* ꥹǤ Nil ޤ Bottom */
	empty_cnt |=
	  (attr_value_tmp_ele==G_MAKESYM(ATOM_nil)) ? REP_NIL : REP_BOTTOM;
      } else { /* ꥹǤ嵭ʳ */
	occ_cnt_no_empty++;
      }
      attr_value_tmp = G_CDR_OF(attr_value_tmp);
      KP_GD_TDDEREF(attr_value_tmp);
    }

    *ofp = Put2Byte(record, *ofp, occ_cnt_no_empty, page_size);
	    /* 󥹿γǼ */
    *ofp = Put2Byte(record, *ofp, empty_cnt, page_size);
	    /* ΰ(Empty)ضͼ̻ҳǼ */
    *dfp = *ofp + ( occ_cnt_no_empty * TWO_ELEMENT );
	    /* ǡեɥݥ󥿤Υå */

    NEW_VECTOR(occ_cnt, work_idx_add_strm);

    for ( occ_num = 1; occ_num <= occ_cnt; occ_num++ ) {
	    /* ƥꥹǤγǼ(ͤϳǼоݳ) */
      attr_value_ele = G_CAR_OF(*attr_value);
      KP_GD_TDDEREF(attr_value_ele);
      fix_occ_list = GetFixOccList(occ_list, occ_num, g_allocp);
      g_allocp = heapp;
      if(!(G_ISSYM(attr_value_ele))) {/* ꥹǤ Nil ޤ Bottom ʳ */
	if ( rsimple_info->data_type == Integer ) {
	  *ofp = Put4Byte(record,*ofp,(int)G_INTVAL(attr_value_ele),page_size);
	  return_attr_value = attr_value_ele;
	} else {
	  g_allocp =
	    PutAttrValue(&(attr_value_ele), rsimple_info, page_size, record,
		       field_head_posi, ofp, dfp, &return_attr_value,g_allocp);
	}
	g_allocp =
	  CreateIndexAddInfo(rsimple_info->attr_name,rsimple_info->key_request,
			     rsimple_info->acc_request,
			     rsimple_info->nil_request, &return_attr_value,
			     &fix_occ_list, &idx_add_strm_ele, g_allocp);
	*(((struct vector_object *)G_FUNCTORP(work_idx_add_strm))->body
	  + (occ_num - 1)) = idx_add_strm_ele;
      } else { /* ꥹǤ Nil ޤ Bottom */		
	g_allocp =
	  CreateIndexAddInfo(rsimple_info->attr_name,rsimple_info->key_request,
			     rsimple_info->acc_request,
			     rsimple_info->nil_request, &attr_value_ele,
			     &fix_occ_list, &idx_add_strm_ele, g_allocp);
	*(((struct vector_object *)G_FUNCTORP(work_idx_add_strm))->body
	  + (occ_num - 1)) = idx_add_strm_ele;
      }
      *attr_value = G_CDR_OF(*attr_value);
      KP_GD_TDDEREF(*attr_value);
    }
    *idx_add_strm = work_idx_add_strm;
  } else { /* 嵭ʳξ(бʤ) */
  }
  return g_allocp;
}

/* --------------------------------------------------------------------
 *	GetFixOccList
 *        ꥪ󥹥ꥹȤ֤
 *      
 *      RETURN:   ꥪ󥹥ꥹ
 *
 * --------------------------------------------------------------------
 */

q 
GetFixOccList(q *occ_list, int occ_num, q *g_allocp)
{
    declare_globals;

    q work_occ_list;                /* 󥹥ꥹȺΰ */
    q occ_list_ele;                 /* 󥹥ꥹ */
    q fix_occ_list;                 /* ꥪ󥹥ꥹ(return) */
    q *tmp;                         /* ꥪ󥹥ꥹ(¸) */
    struct cons *consp;             /* 󥹥ꥹѹ¤ */

    work_occ_list = *occ_list;      /* ꥪ󥹥ꥹȤ */
    KP_GD_TDDEREF(work_occ_list);   /*       ΰ˥ԡ */

    tmp = &fix_occ_list;
    for ( ; work_occ_list != NILATOM; ) {
	G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons), (q));
	consp->car = G_CAR_OF(work_occ_list);
	*tmp = G_MAKECONS(consp);
	tmp = &consp->cdr;
	consp++;
	work_occ_list = G_CDR_OF(work_occ_list);
	KP_GD_TDDEREF(work_occ_list);
    }
    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons), (q));
    consp->car = G_MAKEINT(occ_num);
    *tmp = G_MAKECONS(consp);
    consp->cdr = NILATOM;
    heapp = g_allocp;

    return (fix_occ_list);
}

/* --------------------------------------------------------------------
 *	PutRGroupValue
 *        ֤ñ°ͤγǼ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
PutRGroupValue(q *attr_value, struct shp_AttrInfo1 *rgroup_info,
	       int page_size, char **record, int *ofp, int *dfp,
	       q *occ_list, q *idx_add_strm, q *g_allocp)
{
    declare_globals;

    int child_ofp;         /* °եåȥեɥݥ */
    int child_dfp;         /* °ǡեɥݥ */
    q attr_value_ele;      /* ° */
    q attr_value_tmp;      /* 󥹿 */
    int occ_cnt;
    int occ_num;           /* оݥֹ */
    int head_posi;         /* եƬ */
    q fix_occ_list;        /* ꥪ󥹥ꥹ */
    q work_idx_add_strm;   /* ǥåɲþΰ */
    q idx_add_strm_ele;    /* ǥåɲþ */
    q argv[1];             /* ٥ */
    q vector_g_new();

    head_posi = *ofp;      /* եƬ֥å */

    KP_GD_TDDEREF(*attr_value);
    if ( *attr_value == NILATOM ) {
	/* attr_value = []ξ */
	fix_occ_list = GetFixOccList(occ_list, ONE_ATTR, g_allocp);
	g_allocp = heapp;
	*ofp = Put2Byte(record, *ofp, 0, page_size);
	*dfp = *ofp + TWO_ELEMENT;
	*ofp = Put4Byte(record, *ofp, ( *dfp - head_posi ), page_size);
	child_ofp = *ofp;
	child_dfp = *ofp;
	g_allocp =
	    PutGroupValue(attr_value, rgroup_info->child_attr_info,
			  rgroup_info->child_attr_cnt, page_size,
			  record, &child_ofp, &child_dfp, idx_add_strm,
			  &fix_occ_list, g_allocp);
	*dfp = child_dfp;
    } else if ( G_ISSYM(*attr_value) ) {
	/* attr_value = nilξ */
	fix_occ_list = GetFixOccList(occ_list, ONE_ATTR, g_allocp);
	g_allocp = heapp;
	*ofp = Put2Byte(record, *ofp, 0, page_size);
	*dfp = *ofp + TWO_ELEMENT;
	*ofp = Put4Byte(record, *ofp, ( *dfp - head_posi ), page_size);
	child_ofp = *ofp;
	child_dfp = *ofp;
	g_allocp =
	    PutGroupValue(attr_value, rgroup_info->child_attr_info,
			  rgroup_info->child_attr_cnt, page_size,
			  record, &child_ofp, &child_dfp, idx_add_strm,
			  &fix_occ_list, g_allocp);
	*dfp = child_dfp;
    } else if ( G_ISCONS(*attr_value) ) {
	/* attr_value = ꥹȤξ */

	attr_value_tmp = *attr_value;
	    /* 󥹥ѤͥꥹȤ򥳥ԡ */
	KP_GD_TDDEREF(attr_value_tmp);
	for ( occ_cnt = 0; attr_value_tmp != NILATOM; occ_cnt++ ) {
	    /* 󥹿Υ(̵ͭĴޤޤ) */
	    attr_value_tmp = G_CDR_OF(attr_value_tmp);
	    KP_GD_TDDEREF(attr_value_tmp);
	}

	*ofp = Put2Byte(record, *ofp, occ_cnt, page_size);
	*dfp = head_posi + ( occ_cnt * TWO_ELEMENT ) + OCCCNT_AREA_LENGTH;

	NEW_VECTOR(occ_cnt, work_idx_add_strm);

	for ( occ_num = 1; occ_num <= occ_cnt; occ_num++ ) {
	    *ofp = Put4Byte(record, *ofp, ( *dfp - head_posi ), page_size);
	    child_ofp = *dfp;
	    child_dfp = *dfp;
	    fix_occ_list = GetFixOccList(occ_list, occ_num, g_allocp);
	    g_allocp = heapp;
	    attr_value_ele = G_CAR_OF(*attr_value);
	    KP_GD_TDDEREF(attr_value_ele);
	    g_allocp =
		PutGroupValue(&(attr_value_ele),
			      rgroup_info->child_attr_info,
			      rgroup_info->child_attr_cnt,
			      page_size, record, &child_ofp,
			      &child_dfp, &idx_add_strm_ele,
			      &fix_occ_list, g_allocp);
	    *(((struct vector_object *)G_FUNCTORP(work_idx_add_strm))->body
	      + (occ_num - 1)) = idx_add_strm_ele;
	    *attr_value = G_CDR_OF(*attr_value);
	    KP_GD_TDDEREF(*attr_value);
	    *dfp = child_dfp;
	}
	*idx_add_strm = work_idx_add_strm;
    }
    return (g_allocp);
}


/* --------------------------------------------------------------------
 *	CreateIndexAddInfo
 *        ǥå°ɲþ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
CreateIndexAddInfo(char *attr_name, enum shp_KeyRequest key_request,
		   struct shp_AccessRequest *acc_request,
		   enum shp_NilRequest nil_request, q *attr_value,
		   q *occ_list, q *idx_add_strm, q *g_allocp)
{
    declare_globals;

    q unique_flag;            /* ˡե饰 */
    struct cons *consp;       /* ǥåɲþꥹ */
    q tmp;                    /* ǥåɲþꥹȺΰ */
    q idx_add_info;           /* ǥåɲþƬ */
    q idx_add_strm_tail;      /* ǥåɲþ³ */
    q work_idx_add_strm;      /* ǥåɲþΰ */
    q argv[1];                /* ٥ */
    q vector_g_new();

    switch ( key_request ) {
    case Non_Key:
    case Set_Key:
	unique_flag = ATOM_NOT_UNIQUE;
	break;
    case Primary_Key:
    case Table_Key:
	unique_flag = ATOM_UNIQUE;
	break;
    default:
	break;
    }

    if ( acc_request->index_id == NOT_INDEXED ) {
	/* ǥåʤ° */
	g_allocp =
	    CreateOnlyIndexAddInfo(attr_name, acc_request->ia_list, attr_value,
				   occ_list, idx_add_strm, g_allocp);
    } else {
	/* ǥå° */
	
	NEW_VECTOR(ADD_IDX_INFO_SIZE, idx_add_info);
	*(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
	  + IDX_INFO_FIRST) = G_MAKESYM(enter_atom_cstring(attr_name));
	*(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
	  + IDX_INFO_SECOND) = G_MAKESYM(unique_flag);
	*(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
	  + IDX_INFO_THIRD) = *occ_list;
	*(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
	  + IDX_INFO_FOURTH) = *attr_value;

	g_allocp =
	    CreateOnlyIndexAddInfo(attr_name, acc_request->ia_list, attr_value,
				   occ_list, &idx_add_strm_tail, g_allocp);

	G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*(ONE_ATTR), (q));
	consp->car = idx_add_info;
	consp->cdr = idx_add_strm_tail;
	*idx_add_strm = G_MAKECONS(consp);
    }
    return g_allocp;
}


/* --------------------------------------------------------------------
 *	CreateOnlyIndexAddInfo
 *        ǥåΤ°ɲþ
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 *$  UPDATE : '95-01-13 Fri for Kappa IFS version
 * --------------------------------------------------------------------
 */

q *
CreateOnlyIndexAddInfo(char *attr_name, struct shp_IndexAttrList *ia_list,
		       q *attr_value, q *occ_list, q *idx_add_strm, q *g_allocp)
{
    declare_globals;
    char *generic_string_body();

    char *work;               /* KLIC -> C ʸ¸ */
    char *work_str;           /* ʸùѺΰ */
    char *work_work;          /* ʸùѺΰ */
    char *index_str;          /* ǥåɲʸ */
    char *index_str2;         /* ǥåɲʸ */
    int position;             /* ʸڤ */
    int length;               /* ʸڤĹ */
    int string_size;          /* °ͤĹ */
    q *tmp;                   /* ǥåɲþ */
    struct cons *consp;       /* ǥåɲþꥹ */
    q idx_add_info;           /* ǥå°Υ٥ȥ */
    q sub_info;               /* SubString, ScanStringѥ٥ΰ */
    q work_attr;              /* Ȥ߹ߴؿˤ뽤° */
    q argv[1];                /* ٥ */
    q vector_g_new();

/*    if ( ia_list->id == NULL ) {  /* ǥåΤ°ʤ */
    if ( ia_list == NULL ) {  /* ǥåΤ°ʤ */
	*idx_add_strm = NILATOM;
	return (g_allocp);        /* λ */
    }

    KP_GD_TDDEREF(*attr_value);
    if ( *attr_value == NILATOM ) {
	/* attr_value = []ξ */
	*idx_add_strm = NILATOM;
    } else if ( G_ISSYM(*attr_value) ) {
	/* attr_value = nil or bottomξ */
	*idx_add_strm = NILATOM;
    } else {
	/* attr_value嵭ʳξ */
	tmp = idx_add_strm;

	work_str = generic_string_body(STRING_OBJ(*attr_value));
	string_size = generic_string_size(STRING_OBJ(*attr_value));

	while ( ia_list != NULL ) {
	    NEW_VECTOR(ADD_IDX_INFO_SIZE, idx_add_info);
	    *(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
	      + IDX_INFO_FIRST)
		= G_MAKESYM(enter_atom_cstring(ia_list->attr_name));
	    *(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
	      + IDX_INFO_SECOND) = G_MAKESYM(ATOM_NOT_UNIQUE);
	    *(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
	      + IDX_INFO_THIRD) = *occ_list;

	    /* ƤΥǥåΤ°Фɲþ */
	    switch ( ia_list->id ) {
	    case Substr:        /* substring */
		NEW_VECTOR(ADD_SUBSTR_INFO_SIZE, sub_info);
		*(((struct vector_object *)G_FUNCTORP(sub_info))->body
		  + IDX_INFO_FIRST) = *attr_value;
		*(((struct vector_object *)G_FUNCTORP(sub_info))->body
		  + IDX_INFO_SECOND)
		    = G_MAKEINT(ia_list->index_attr->substr->position);
		*(((struct vector_object *)G_FUNCTORP(sub_info))->body
		  + IDX_INFO_THIRD)
		    = G_MAKEINT(ia_list->index_attr->substr->length);
		*(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
		  + IDX_INFO_FOURTH) = sub_info;
		break;
	    case Concat1:       /* concatenate 1 (tail) */
		index_str
		    = (char *) malloc(string_size + strlen(ia_list->index_attr->string_list) + 1);
		index_str[0] = 0;
		index_str = strncat(index_str, work_str, string_size);
		index_str = strcat(index_str,ia_list->index_attr->string_list);
		CONVERT_C_STRING_TO_KLIC_STRING(index_str, work_attr);
		*(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
		  + IDX_INFO_FOURTH) = work_attr;
		free(index_str);
		break;
	    case Concat2:       /* concatenate 2 (head) */
		index_str
		    = malloc(string_size
			     + strlen(ia_list->index_attr->string_list) + 1);
		index_str[0] = 0;
		index_str = strcat(index_str,ia_list->index_attr->string_list);
		index_str = strncat(index_str, work_str, string_size);
		CONVERT_C_STRING_TO_KLIC_STRING(index_str, work_attr);
		*(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
		  + IDX_INFO_FOURTH) = work_attr;
		free(index_str);
		break;
	    case Concat3:       /* concatenate 3 (head & tail) */
		index_str
		    = malloc(string_size + 1
			     + strlen(ia_list->index_attr->concat3->string1)
			     + strlen(ia_list->index_attr->concat3->string2));
		index_str[0] = 0;
		index_str = strcat(index_str,ia_list->index_attr->concat3->string1);
		index_str = strncat(index_str, work_str, string_size);
		index_str = strcat(index_str,ia_list->index_attr->concat3->string2);
		CONVERT_C_STRING_TO_KLIC_STRING(index_str, work_attr);
		*(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
		  + IDX_INFO_FOURTH) = work_attr;
		free(index_str);
		break;
	    case Reverse:       /* reverse string */
		index_str = ReverseNString(work_str, string_size);
		CONVERT_BINARY_C_STRING_TO_KLIC_STRING(index_str, string_size, work_attr);
		*(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
		  + IDX_INFO_FOURTH) = work_attr;
		free(index_str); 
		break;
	    case Scan:          /* scan string */
		NEW_VECTOR(ADD_SCAN_INFO_SIZE, sub_info);
		*(((struct vector_object *)G_FUNCTORP(sub_info))->body
		  + IDX_INFO_FIRST) = *attr_value;
		*(((struct vector_object *)G_FUNCTORP(sub_info))->body
		  + IDX_INFO_SECOND)
		    = G_MAKEINT(ia_list->index_attr->length);
		*(((struct vector_object *)G_FUNCTORP(idx_add_info))->body
		  + IDX_INFO_FOURTH) = sub_info;
		break;
	    default:
		/* defaultʤ */
		break;
	    }
	    G_HEAPALLOC((q)consp, G_SIZE_IN_Q(struct cons)*(ONE_ATTR), (q));
	    consp->car = idx_add_info;
	    *tmp = G_MAKECONS(consp);
	    tmp = &consp->cdr;
	    consp++;
	    ia_list = ia_list->next;
	}
	(--consp)->cdr = NILATOM;
    }

    return (g_allocp);
}

/* --------------------------------------------------------------------
 *	Put4Byte
 *        ͤ4byte(2element)ΰ˳Ǽ
 *      
 *      RETURN:   Ǽ(INTEGER)
 *
 * --------------------------------------------------------------------
 */

int
Put4Byte(char **record, int posi, int integer, int page_size)
{
/*    char work_string[4]; */   /* ͳǼѺΰ */
    int string_posi;        /* Ǽ쥳ɥȥֹ */
    int extent_remainder;   /* Ǽ٤쥳ΰ;ꥵ */
    int offset_position;    /* Ǽ٤쥳ΰǤа */

    extent_remainder = page_size - ((posi * TWO_BYTE) % page_size);
    offset_position = (posi * TWO_BYTE) % page_size;

/*    *work_string                = (integer & 0xFF000000) >> FOUR_BYTE_FIRST;
/*    *(work_string + STR_SECOND) = (integer & 0x00FF0000) >> FOUR_BYTE_SECOND;
/*    *(work_string + STR_THIRD)  = (integer & 0x0000FF00) >> FOUR_BYTE_THIRD;
/*    *(work_string + STR_FOURTH) = integer & 0x000000FF;
 */
    string_posi = GetStringNumber(posi, page_size);

    if ( extent_remainder == TWO_BYTE ) {
	/* ꤵ줿ͤ򣲤ĤΥȥ󥰤ʬ䤷ƳǼ */
	SET_SHORT_INTEGER_NM(integer >> 16, 
                             record[string_posi] + offset_position);
	SET_SHORT_INTEGER_NM(0x0000FFFF & integer, 
                             record[string_posi + 1]);
/*	BCOPY(work_string, (record[string_posi] + offset_position), TWO_BYTE);
/*	BCOPY((work_string + TWO_BYTE), record[string_posi + 1], TWO_BYTE);
 */
    } else {
	/* ꤵ줿ͤ򣱤ĤΥȥ󥰤˳Ǽ */
	char *ptr;
	ptr = record[string_posi] + offset_position;
	SET_INTEGER_NM(integer, ptr);
/*	BCOPY(work_string, (record[string_posi] + offset_position), FOUR_BYTE);
 */
    }
    return (posi + TWO_ELEMENT);
}


/* --------------------------------------------------------------------
 *	Put2Byte
 *        ͤ2byte(1element)ΰ˳Ǽ
 *      
 *      RETURN:   Ǽ(INTEGER)
 *
 * --------------------------------------------------------------------
 */

int
Put2Byte(char **record, int posi, int integer, int page_size)
{
/*    char work_string[2];  */  /* ͳǼѺΰ */
    int string_posi;        /* Ǽ쥳ɥȥֹ */
    int offset_position;    /* Ǽ٤쥳ΰǤа */

    offset_position = (posi * TWO_BYTE) % page_size;

/*    *work_string                = (integer & 0xFF00) >> FOUR_BYTE_THIRD;
/*    *(work_string + STR_SECOND) = integer & 0x00FF;
 */
    string_posi = GetStringNumber(posi, page_size);
    SET_SHORT_INTEGER_NM(integer, record[string_posi] + offset_position);
/*    BCOPY(work_string, (record[string_posi] + offset_position), TWO_BYTE);
 */

    return (posi + ONE_ELEMENT);
}


/* --------------------------------------------------------------------
 *	PutAttribute
 *        °ͤ쥳ɤλ֤˳Ǽ
 *      
 *      RETURN:   Ǽ(INTEGER)
 *
 * --------------------------------------------------------------------
 */

int
PutAttribute(char **record, int posi, char *attr_value,
	     int string_size, int page_size)
{
    int string_posi;        /* Ǽ쥳ɥȥֹ */
    int extent_remainder;   /* Ǽ٤쥳ΰ;ꥵ */
    int offset_position;    /* Ǽ٤쥳ΰǤа */

    extent_remainder = page_size - ((posi * TWO_BYTE) % page_size);
    offset_position = (posi * TWO_BYTE) % page_size;

    string_posi = GetStringNumber(posi, page_size);

    if ( extent_remainder < string_size ) {
	/* °ͤʣʬ䤷ƳǼ */
	BCOPY(attr_value, (record[string_posi] + offset_position),
	      extent_remainder);
	PutAttribute(record, (posi + (extent_remainder / 2)),
		     (attr_value + extent_remainder),
		     (string_size - extent_remainder),
		     page_size);
    } else {
	/* °ͤ򣱤ĤΥȥ󥰤˳Ǽ */
	BCOPY(attr_value, (record[string_posi] + offset_position),
	      string_size);
    }
    if ( (string_size % TWO_BYTE) == ZERO ) {
	return (posi + (string_size / 2));       /*  */
    } else {
	return (posi + (string_size / 2) + 1);   /*  */
    }
}



/* --------------------------------------------------------------------
 *	GetStringNumber
 *        Ǽ٤ȥֹǼ֤
 *      
 *      RETURN:   Ǽȥֹ
 *
 * --------------------------------------------------------------------
 */

int
GetStringNumber(int posi, int page_size)
{
    if ( ( posi * TWO_BYTE ) < page_size ) {
	/* Ǽ֤ڡΥ꾮  Ƭȥ󥰤˳Ǽ */
	return (FIRST_RECORD);
    } else {
	/* Ǽ֤ڡΥ礭
	    Ǽȥֹ滻С */
	return ( (int)(( posi * TWO_BYTE ) / page_size) );
    }
}


/* --------------------------------------------------------------------
 *	ReverseString
 *        ʸž
 *      
 *      RETURN:   žȥ󥰤Υݥ
 *
 * --------------------------------------------------------------------
 */
char *
ReverseNString(char *string, int size)
{
    char *work_string;      /* ʸžΰ */
    int posi;

    work_string = (char *)malloc(size + 1);
    work_string[size--] = 0;

    while (size >= 0) {
	work_string[size--] = *string++;
    }

    return work_string;
}

char *
ReverseString(char *string)
{

    return ReverseNString(string, strlen(string));

}

/* --------------------------------------------------------------------
 *	CreateEmptyValueAddIndexInfo
 *        ơ֥Ρ°֤°ͤͤξ
 *        ɲ°
 *      
 *      RETURN:   g_allocp        : KLICǡĥҡΰ賫ϥɥ쥹
 *
 * --------------------------------------------------------------------
 */

q *
CreateEmptyValueAddIndexInfo(int cnt, struct shp_ChildInfo *info, 
			     q value, q *idx_add_strm, q *occ_list,
			     q *g_allocp)
{
    declare_globals;

    int i;                   /* FOR LOOP */
    int child_attr_cnt;      /* ° */
    struct shp_ChildInfo *child_attr_info;
                             /* °ꥹ */
    q work_idx_add_strm;     /* ǥåɲþΰ */
    q idx_add_strm_ele;      /* ǥåɲþ */
    q fix_occ_list;          /* ꥪ󥹥ꥹ */

    q argv[1];                               /* ٥ */
    q vector_g_new();

    NEW_VECTOR(cnt, work_idx_add_strm);      /* MergerȤʬ */

    for ( i = 0; i < cnt; i++ ) {
	switch ( info->type ) {
	case Simple_Integer:  /* ñINTEGER° */
	    /* FALL THROUGH */
	case Simple:          /* ñINTEGER° */
	    g_allocp =
		CreateIndexAddInfo(info->attr_info.info2->attr_name,
				   info->attr_info.info2->key_request,
				   info->attr_info.info2->acc_request, 
				   info->attr_info.info2->nil_request,
				   &value, occ_list, &idx_add_strm_ele,
				   g_allocp);
	    break;
	case Repeat_Simple:   /* ֤ñ° */
	    fix_occ_list = GetFixOccList(occ_list, ONE_ATTR, g_allocp);
	    g_allocp = heapp;
	    g_allocp =
		CreateIndexAddInfo(info->attr_info.info2->attr_name,
				   info->attr_info.info2->key_request,
				   info->attr_info.info2->acc_request, 
				   info->attr_info.info2->nil_request,
				   &value, &fix_occ_list,
				   &idx_add_strm_ele, g_allocp);
	    break;
	case Group:           /* ° */
	    child_attr_cnt = info->attr_info.info1->child_attr_cnt;
	    child_attr_info = info->attr_info.info1->child_attr_info;
	    g_allocp =
		CreateEmptyValueAddIndexInfo(child_attr_cnt,
					     child_attr_info,
					     value, &idx_add_strm_ele,
					     occ_list,
					     g_allocp);
	    break;
	case Repeat_Group:    /* ֤° */
	    fix_occ_list = GetFixOccList(occ_list, ONE_ATTR, g_allocp);
	    g_allocp = heapp;
	    child_attr_cnt = info->attr_info.info1->child_attr_cnt;
	    child_attr_info = info->attr_info.info1->child_attr_info;
	    g_allocp =
		CreateEmptyValueAddIndexInfo(child_attr_cnt,
					     child_attr_info,
					     value, &idx_add_strm_ele,
					     &fix_occ_list,
					     g_allocp);
	    break;
	default:
	    break;
	}
	*(((struct vector_object *)G_FUNCTORP(work_idx_add_strm))->body
	  + i) = idx_add_strm_ele;
	info = info->next;
    }
    *idx_add_strm = work_idx_add_strm;

    return (g_allocp);
}
