/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/***********************************************************************
 *   FILE NAME
 *	lib.c
 *   DESCRIPTION
 *	KappaǶ̤˻ѤŪʽ򽸤᤿⥸塼
 *   INTERFACE ROUTINES
 *      lib_SetInteger   - ꥹȥ󥰤λ֤飴ǤǼ
 *      lib_GetInteger   - ꥹȥ󥰤λ֤飴Ǥ˳ǼƤ
 *                        Ф
 *      lib_DeleteNull   - ʸNULLɤ֤
 *      lib_SetBit       - ꥹȥ󥰤λ֤ΥӥåONޤOFF
 *      lib_GetAndSetBit - ꥹȥ󥰤λ֤ΥӥåȤ򻲾ȤƱˡ
 *                        ONޤOFF
 *      lib_PsiToEuc     - PSIɤʸEUCɤʸѴ
 *      lib_EucToPsi     - EUCɤʸPSIɤʸѴ
 *
 *$   UPDATE : '95-03-24   modified  SetInteger,GetInteger  
 *
 ***********************************************************************/

#include <stdio.h>
#if KLIC
#include <klic/struct.h>
#endif
#include "lib.h"
#include "libstring.h"

/* --------------------------------------------------------------------
 *	lib_SetInteger
 *
 *      ꤵ줿ʸλ֤ͤǼ롣
 *      
 *      ARGUMENT: str     - ǼʸؤΥݥ
 *                posi    - Ǽ (KLIC int)
 *                integer - Ǽ (KLIC int)
 * 
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */

#if KLIC
int
lib_SetInteger(char *str, int posi, int integer)
{                                 /* KLICǡѴ */
    int position, c_integer;

    if(!isint(posi)) {            /* posiͥå */
	return (-1);
    }
    position = intval(posi);
    if(position < 0 & strlen(str) < position) {
	return (-1);              /* Ǽå */
    }

    if(!isint(integer)) {         /* integerͥå */
	return (-1);
    }
    c_integer = intval(integer);
    return(SetInteger(str, position, c_integer));
}
#endif

int
SetInteger(char *string, int position, int c_integer)
{                                        /* Ǽᥤ롼 */
    char *ptr;

/*    ptr = string + position * 4;
/*    SET_INTEGER_NM(c_integer, ptr);
 */    return 0;

/*    char work_str[4];                    /* Ѵΰ */
/*
/*    string = string + (position * 4);
/*    *work_str = ((c_integer & 0x03000000) |
/*	    ((c_integer & 0x0C000000) << 2)) >> 24;
/*        /* ͺǾ̥ХȼФ
/*        /* ͤξ̣ӥåܤΤߤ򺸤ˣӥåȥեȤ
/*        /* Ǿ̥ХȤФ
/*         */
/*    *(work_str + STR_SECOND) =
/*	(c_integer >> 16) & 0x000000FF;  /* ̥ХȼФ */
/*    *(work_str + STR_THIRD) =
/*	(c_integer >> 8) & 0x000000FF;   /* 軰̥ХȼФ */
/*
/*    *(work_str + STR_FOURTH) =
/*	c_integer & 0x000000FF;          /* Ͱ̥ХȼФ */
/*
/*    *string = work_str[STR_FIRST];
/*    *(string + STR_SECOND) = work_str[STR_SECOND];
/*    *(string + STR_THIRD) = work_str[STR_THIRD];
/*    *(string + STR_FOURTH) = work_str[STR_FOURTH];
/*    return (0);
 */
}


/* --------------------------------------------------------------------
 *	lib_GetInteger
 *
 *      ꤵ줿ʸλ֤ˤͤФ
 *      
 *      ARGUMENT: string  - ФǼƤʸؤΥݥ
 *                posi    - Ǽ (KLIC int)
 *                integer - Ф줿 (KLIC int)
 * 
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */

#if KLIC
int
lib_GetInteger(char *string, int posi, int integer)
{
    int position, *c_integer, r_value;

    if(!isint(posi)) {            /* posiͥå */
	return (-1);
    }
    position = intval(posi);
    if(position < 0 & strlen(string) < position) {
	return (-1);              /* Ǽå */
    }
    r_value = GetInteger(string, position, c_integer);
    unify(integer, makeint(*c_integer));
        /* ФͤKLICͤѴunify */
    return(r_value);
}
#endif

int
GetInteger(char *string, int position, int *c_integer)
{
    int  i;
    char *ptr;
    
    ptr = string + position * 2;
    GET_INTEGER_NM(i, ptr);
    *c_integer = (((i & 0x30000000) << 2) >> 4) | (i & 0x03FFFFFF);
    return 0;

/*    unsigned int work[4];                    /* Ѵΰ */
/*
/*    string = string + (position * 2);
/*
/*    work[0] = ((*string & 0x0F) | ((*string & 0x30) >> 2)) << 24;
/*        /* ǾǼФ
/*        /* ̣ӥåܤΤ߱ˣӥåȥեȤ
/*        /* Τ򣲣ӥåȺե
/*         */
/*    work[1] = (*(string + STR_SECOND) & 0x0FF) << 16;
/*        /* ̼Ф */
/*    work[2] = (*(string + STR_THIRD) & 0x0FF) << 8;
/*        /* 軰̼Ф */
/*    work[3] = *(string + STR_FOURTH) & 0x0FF;
/*        /* Ͱ̼Ф */
/*    *c_integer = work[0] | work[1] | work[2] | work[3];
/*        /* Ǥ¤ꡢͤ */
/*    return (0);
 */
}


/* --------------------------------------------------------------------
 *	lib_DeleteNull
 *
 *      ꤵ줿ʸNULLɤ
 *      
 *      ARGUMENT: string         - NULLɤʸؤΥݥ
 *                deleted_string - NULLɤʸǼ
 *                                 ΰؤΥݥ
 * 
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */


int
lib_DeleteNull(char *string, char *deleted_string)
{
    while (*string) {
	*deleted_string = *string;
	deleted_string++;
	string++;
    }
    return (0);
}


/* --------------------------------------------------------------------
 *	lib_SetBit
 *
 *      ꤵ줿ʸλӥåȤONޤOFF
 *      
 *      ARGUMENT: str    - ӥåȤΥåȡꥻåȤԤʤʸؤΥݥ
 *                posi   - ӥåȰ (KLIC int)
 *                on_off - ӥåȤΥåȡꥻåȻ(KLIC int)
 * 
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */

#if KLIC
int
lib_SetBit(char *str, int posi, int on_off)
{
    int ele_posi, bit_posi, c_on_off;

    ele_posi = intval(posi) / STR_SIZE;
    bit_posi = intval(posi) % STR_SIZE;
    c_on_off = intval(on_off);
    retrurn(SetBit(str, ele_posi, bit_posi, c_on_off));
}
#endif

int
SetBit(char *str, int ele_posi, int bit_posi, int on_off)
{
    str = str + ele_posi;

    if ( on_off == OFF ) {
	*str = *str & (~(1 << (STR_SIZE - bit_posi - 1)));
        /* ӥåȰ֤ΥӥåȤꥻå */
    } else {
	*str = *str | (1 << (STR_SIZE - bit_posi - 1));
        /* ӥåȰ֤ΥӥåȤ򥻥å */
    }
    return (0);
}


/* --------------------------------------------------------------------
 *	lib_GetAndSetBit
 *
 *      ꤵ줿ʸλӥåȤ򻲾ȤƱ֤ΥӥåȤ
 *      ONޤOFF
 *      
 *      ARGUMENT: str        - ӥåȤΥåȡꥻåȤԤʤʸؤ
 *                             ݥ
 *                posi       - ӥåȰ (KLIC int)
 *                new_on_off - ӥåȤΥåȡꥻåȻ(KLIC int)
 *                old_on_off - ӥåȰ֤˳ǼƤ(KLIC int)
 * 
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */

#if KLIC
int
lib_GetAndSetBit(char *str, int posi, int new_on_off, int old_on_off)
{
    int ele_posi, bit_posi, c_new_on_off, *c_old_on_off, r_value;

    ele_posi = intval(posi) / STR_SIZE;
    bit_posi = intval(posi) % STR_SIZE;
    c_new_on_off = intval(new_on_off);
    r_value = GetAndSetBit(str, ele_posi,
			      bit_posi, c_new_on_off, c_old_on_off);
    unify(old_on_off, makeint(c_old_on_off));
            /* old_on_off˼Фͤunify */
    return(r_value);
}
#endif

int
GetAndSetBit(char *str, int ele_posi,
		int bit_posi, int new_on_off, int *old_on_off)
{
    str = str + ele_posi;

    *old_on_off = (*str & (1 << bit_posi )) >> bit_posi;
            /* ӥåȰ֤ͤ */

    if ( new_on_off == OFF ) {
	*str = *str & ( ~(1 << (STR_SIZE - bit_posi - 1)));
            /* ӥåȰ֤ΥӥåȤꥻå */
    } else {
	*str = *str | (1 << (STR_SIZE - bit_posi - 1));
            /* ӥåȰ֤ΥӥåȤ򥻥å */
    }
    return (0);
}

/* --------------------------------------------------------------------
 *	lib_Psi2Euc
 *
 *      PSIɤʸEUCɤʸѴ롣
 *      
 *      ARGUMENT: psi_str  :  PSIʸؤΥݥ
 *                euc_str  :  EUCɤѴʸǼΰؤ
 *                         :  ݥ
 * 
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */

#if KLIC
int
lib_Psi2Euc(int len, char *psi_str, char *euc_str)
{
    char *psi_string = functorp(psi_str);
    char *euc_string = functorp(euc_str);
    Psi2Euc(len, psi_string, euc_string);
    return(0);
}
#endif

int
Psi2Euc(int len, char *psi_string, char *euc_string)
{
    int c0, c1, cs;
    char *euc_string_st = euc_string;

    while(len-- > 0) {
	c0 = *psi_string++;
	c1 = *psi_string++;

	switch(c0) {
	case 0:            /* ʸ */
	    *euc_string++ = c1;
	    break;
	case 0x21:         /* üʸ (ϰϳɤǤ\000) */
	    if (0x20 <= c1 && c1 <= 0x7F) {
		if(cs = lib_SpecialChar[c1 - 0x20]) {
		    *euc_string++ = cs;
		} else {
		    *euc_string++ = c0 | 0x80;
		    *euc_string++   = c1 | 0x80;
		}
	    } else {
		*euc_string++ = '\0';
	    }
	    break;
	case 0x23:         /* ѿ (ϰϳɤǤ\000) */
            if (0x20 <= c1 && c1 <= 0x7F) {
                cs = lib_AlphaNumeric[c1 - 0x20];
                *euc_string++ = cs;
            } else {
                *euc_string++ = '\0';
            }
	    break;
	default:           /* ¾(ʤɣХȥʸ) */
	    *euc_string++ = c0 | 0x80;
	    *euc_string++ = c1 | 0x80;
	    break;
	}
    }
    return euc_string - euc_string_st;
}

/* --------------------------------------------------------------------
 *	lib_Euc2Psi
 *
 *      EUCɤʸPSIɤʸѴ롣
 *      
 *      ARGUMENT: euc_str  :  EUCʸؤΥݥ
 *                psi_str  :  PSIɤѴʸǼΰؤ
 *                         :  ݥ
 * 
 *      RETURN:  0 : 
 *              -1 : 顼
 *
 * --------------------------------------------------------------------
 */

#if KLIC
int
lib_Euc2Psi(int len, char *euc_str, char *psi_str)
{
    char *psi_string = functorp(psi_str);
    char *euc_string = functorp(euc_str);
    Euc2Psi(len, euc_string, psi_string);
    return(0);
}
#endif

int
Euc2Psi(int len, char *euc_string, char *psi_string)
{
    unsigned int c;
    char *cp, *psi_string_st = psi_string;

    while(len-- > 0) {
	c = *euc_string++;
	if(0 <= c && c <= 0x7F) {    /* ѿüʸ */
	    cp = lib_KanjiTable[c];
	    *psi_string++ = cp[0];
	    *psi_string++ = cp[1];
	} else {                     /* ¾(ʤɣХȥʸ) */
	    *psi_string++ = c & 0x7F;
	    if((c = *euc_string++) > 0) {
		*psi_string++ = c & 0x7F;
	    }
	}
    }
    return (psi_string - psi_string_st)/2;
}
