/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */
/*--------------------------------------------------------------
 *  Add For Index Access.
 *$               Added by Sugizaki
 *--------------------------------------------------------------
 */


/*--------------------------------------------------------------
 * get_integer(Position, ^Integer) 
 *    ȥ󥰤λ֤ͤФ
 *--------------------------------------------------------------
 */
GDDEF_METHOD(get__kappa__integer_2)
{
  G_STD_DECL;
  long position, output_int;
  ELEMCTYPE *body;
  Shallow(GD_SELF);
  body = GD_SELF->body;
  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->index);
  output_int = body[position] ;
  output_int = ((output_int & 0x03FF) | ((output_int & 0x3000) >> 2)) << 16;
  /* ǾǤФợӥåܤΤ߱ˣӥå
   * եȤθΤ򣱣ӥåȺեȤ         */
  output_int = output_int | body[position + 1];
  GD_UNIFY( GD_ARGV[1],G_MAKEINT((unsigned long)(output_int)));
  GD_RETURN;
}


/*--------------------------------------------------------------
 *  set_integer(Position, Integer, ^New_String)
 *      ȥ󥰤λ֤˻Ǽ
 *--------------------------------------------------------------
 */

GDDEF_METHOD(set__kappa__integer_3)
{
  G_STD_DECL;
  long position, input_int, work_int;
  GD_OBJ_TYPE *newstr, *newstr0; 
  ELEMCTYPE *body, uper_val, lower_val;
  int iscnst;
  long size;

  Shallow(GD_SELF);
  size = GD_SELF->index;
  iscnst = GD_SELF->iscnst;
  body = GD_SELF->body;
  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,size);
  GDSET_INTARG_WITHIN_RANGE(input_int,GD_ARGV[1], MININT, MAXINT); 
  GDSET_NEWOBJ(newstr);

  uper_val = ((input_int & 0x03FF0000) |
	       ((input_int & 0x0C000000) << 2)) >> 16;
  lower_val = input_int & 0x0000FFFF;

  if (!iscnst) {
    /* 16bitγǼ */
    ELEMCTYPE olddata1 = body[position];
    ELEMCTYPE olddata2 = body[position + 1];

    GDSET_NEWOBJ(newstr0);

    GD_SELF->index = position;
    GD_SELF->body = (ELEMCTYPE *)(unsigned long)olddata1;
    body[position] = uper_val;
    GD_SELF->next = GD_OBJ(newstr0);

    /* 16bitγǼ */
/*    Shallow(GD_SELF); */

    newstr0->index = position + 1;
    newstr0->body = (ELEMCTYPE *)(unsigned long)olddata2;
    newstr0->iscnst = iscnst;
    body[position + 1] = lower_val;
    newstr0->next = GD_OBJ(newstr);
    newstr->body = body;

  } else {
    ELEMCTYPE *newbody;
    unsigned long qsize = ROUND_UP(size);
    GD_ALLOC_AREA(newbody, (ELEMCTYPE *), qsize);
    BCOPY(body, newbody, qsize*sizeof(q));
    newbody[position] = uper_val;
    newbody[position + 1] = lower_val;
    newstr->body = newbody;
}
  newstr->next = STRING16_SHALLOW_MARK;
  newstr->index = size;
  newstr->iscnst = 0;
  GD_UNIFY_VALUE(GD_ARGV[2], GD_OBJ(newstr)); 
  GD_RETURN;
}



/*--------------------------------------------------------------
 * binary_search_from_leaf_int(Str, IntKey
 *                   Access, ^RDataPosi, ^SInfoPosi)
 *      Type1ǥåȥλγǼ֤
 *      դΰ֤֤ͤ
 *--------------------------------------------------------------
 */

GDDEF_METHOD(binary__search__from__leaf__int_5)
{
  G_STD_DECL;
  int IntKey, Access;
  int plength; /*$ For Kappa Q03.01 */
  int RDataPosi, SInfoPosi;
  extern *ixp_BinalySearch1_int();


  ELEMCTYPE *body;
  Shallow(GD_SELF);
  body = GD_SELF->body; 

  GDSET_INTARG_WITHIN_RANGE(IntKey,GD_ARGV[0],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(Access,GD_ARGV[1],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(plength,GD_ARGV[2],MININT, MAXINT);

  ixp_BinarySearch1_int(body, IntKey, Access, plength, &RDataPosi, &SInfoPosi);

  GD_UNIFY( GD_ARGV[3],G_MAKEINT(RDataPosi)); 
  GD_UNIFY( GD_ARGV[4],G_MAKEINT(SInfoPosi)); 
  GD_RETURN;
}


/*--------------------------------------------------------------
 * Binary Search From Leaf String
 *    binary_search_from_leaf_str(Str, DType, 
 *                   StrKey, Access, ^RDataPosi, ^SInfoPosi)
 *
 *      Type1ǥåȥλꥹȥ󥰥γǼ֤
 *      դΰ֤֤ͤ
 *--------------------------------------------------------------
 */

GDDEF_METHOD(binary__search__from__leaf__str_6)
{
  G_STD_DECL;
  int DType, Access;
  int plength; /*$ For Kappa Q03.01 */
  int RDataPosi, SInfoPosi;
  q Keyq;
  GD_OBJ_TYPE *Key;
  int KeySize;
  char key_area[IDX_KEY_MAX];

  extern *ixp_BinalySearch1_str();

  ELEMCTYPE *body;
  Shallow(GD_SELF);
  body = GD_SELF->body;

  Keyq = GD_ARGV[0];
  GD_DEREF(Keyq);
  Key = (GD_OBJ_TYPE *)G_FUNCTORP(Keyq);

  GDSET_INTARG_WITHIN_RANGE(DType,GD_ARGV[1],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(Access,GD_ARGV[2],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(plength,GD_ARGV[3],MININT, MAXINT);

  Shallow(Key);
  /* Data Type is string */
  if(DType == 1){
      KeySize = Key->index;
      BCOPY((char *) Key->body, key_area, KeySize);
      key_area[KeySize] = 0;
  }
  /* Data Type is psi_string */
  else{
      KeySize = Key->index*(ELEMSIZE/8);
      BCOPY((char *) Key->body, key_area, KeySize);
      key_area[KeySize] = 0;
  };

  ixp_BinarySearch1_str(body, key_area,
                    Access, DType, plength, &RDataPosi, &SInfoPosi);

  GD_UNIFY( GD_ARGV[4],G_MAKEINT(RDataPosi));
  GD_UNIFY( GD_ARGV[5],G_MAKEINT(SInfoPosi));
  GD_RETURN;
}


/*--------------------------------------------------------------
 * Binary Search From Node  Integer
 *    binary_search_from_node_int(Str, IntKey, Access, ^LPN, ^SinfoPosi)
 *
 *      դΥǥåȥλγǼ֤
 *      դΰ֤֤ͤ
 *--------------------------------------------------------------
 */


GDDEF_METHOD(binary__search__from__node__int_5)
{
  G_STD_DECL;
  int IntKey, Access;
  int plength; /*$ For Kappa Q03.01 */
  int LPN, SinfoPosi;
  extern *ixp_BinalySearch2_int(); 

  ELEMCTYPE *body;
  Shallow(GD_SELF);
  body = GD_SELF->body; 

  GDSET_INTARG_WITHIN_RANGE(IntKey,GD_ARGV[0],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(Access,GD_ARGV[1],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(plength,GD_ARGV[2],MININT, MAXINT);

  ixp_BinarySearch2_int(body, IntKey, Access, plength, &LPN, &SinfoPosi);

  GD_UNIFY( GD_ARGV[3],G_MAKEINT(LPN)); 
  GD_UNIFY( GD_ARGV[4],G_MAKEINT(SinfoPosi)); 
  GD_RETURN;
}


/*--------------------------------------------------------------
 * Binary Search From Node  String
 *    binary_search_from_node_str(Str, StrKey, DType, Access, ^LPN, ^SinfoPosi)
 *
 *      դΥǥåȥλꥹȥ󥰥γǼ֤
 *      դΰ֤֤ͤ
 *--------------------------------------------------------------
 */

GDDEF_METHOD(binary__search__from__node__str_6)
{
  G_STD_DECL;
  int DType, Access;
  int plength; /*$ For Kappa Q03.01 */
  int LPN, SinfoPosi;
  q Keyq;
  GD_OBJ_TYPE *Key;
  int KeySize;
  char key_area[IDX_KEY_MAX];

  extern *ixp_BinalySearch2_str(); 

  ELEMCTYPE *body;
  Shallow(GD_SELF);
  body = GD_SELF->body; 

  Keyq = GD_ARGV[0];
  GD_DEREF(Keyq);
  Key = (GD_OBJ_TYPE *)G_FUNCTORP(Keyq);

  GDSET_INTARG_WITHIN_RANGE(DType,GD_ARGV[1],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(Access,GD_ARGV[2],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(plength,GD_ARGV[3],MININT, MAXINT);

  Shallow(Key);
  /* Data Type is string */
  if(DType == 1){
      KeySize = Key->index;
      BCOPY((char *) Key->body, key_area, KeySize);
      key_area[KeySize] = 0;
  }
  /* Data Type is psi_string */
  else{
      KeySize = Key->index*(ELEMSIZE/8);
      BCOPY((char *) Key->body, key_area, KeySize);
      key_area[KeySize] = 0;
  };

  ixp_BinarySearch2_str(body, key_area, 
                        Access, DType, plength, &LPN, &SinfoPosi);

  GD_UNIFY( GD_ARGV[4],G_MAKEINT(LPN)); 
  GD_UNIFY( GD_ARGV[5],G_MAKEINT(SinfoPosi)); 
  GD_RETURN;
}


/*--------------------------------------------------------------
 * Get Search Result From Type1 Leaf(Integer) 
 *
 *   get_from_type1_int(Str, LowKey, LowRange, HighKey, 
 *		    HighRange,Scan, RDataPosi, SInfoPosi, Nest,
 *		    ^HitFlag, ^PageFlag, ^NextFlag, ^Result)
 *
 *      Type1դ饭ǻꤵ륤ǥå˴ؤ븡̤
 *      Ф֤ΤȤKLICꥹȹ¤֤
 *      ǡ 
 *
 *--------------------------------------------------------------
 */

GDDEF_METHOD(get__from__type1__int_13)
{
  G_STD_DECL;
  int LowKey, LowRange, HighKey, HighRange, Scan, RDataPosi, SInfoPosi, Nest;
  int plength; /*$ For Kappa Q03.01 */
  int HitFlag, PageFlag, NextFlag;
  q Result, *current_gallocp;
  q *ixp_SearchInt(); 

  ELEMCTYPE *body;
  Shallow(GD_SELF);
  body = GD_SELF->body; 

  GDSET_INTARG_WITHIN_RANGE(LowKey,GD_ARGV[0],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(LowRange,GD_ARGV[1],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(HighKey,GD_ARGV[2],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(HighRange,GD_ARGV[3],MININT, MAXINT)
  GDSET_INTARG_WITHIN_RANGE(Scan,GD_ARGV[4],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(RDataPosi,GD_ARGV[5],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(SInfoPosi,GD_ARGV[6],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(Nest,GD_ARGV[7],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(plength,GD_ARGV[8],MININT, MAXINT);

  current_gallocp = g_allocp;
  GD_ALLOC_AREA(Result, (q), IDX_TYPE1_MAX); 

  g_allocp = ixp_SearchInt(body, LowKey, LowRange, HighKey, 
			   HighRange, Scan, RDataPosi, SInfoPosi, Nest,
			   plength, &HitFlag, &PageFlag, &NextFlag, 
			   &Result, current_gallocp);

  GD_UNIFY( GD_ARGV[9],G_MAKEINT(HitFlag)); 
  GD_UNIFY( GD_ARGV[10],G_MAKEINT(PageFlag)); 
  GD_UNIFY( GD_ARGV[11],G_MAKEINT(NextFlag)); 
  GD_UNIFY_VALUE(GD_ARGV[12],Result); 
  GD_RETURN;
}


/*--------------------------------------------------------------
 * Get Search Result From Type1 Leaf(String)
 *
 *   get_from_type1_str(Str, LowKey, LowRange, HighKey, HighRange,
 *		    Scan, RDataPosi, SInfoPosi, Type, Nest,
 *		    ^HitFlag, ^PageFlag, ^NextFlag, ^Result)
 *
 *      Type1դ饭ǻꤵ륤ǥå˴ؤ븡̤
 *      Ф֤ΤȤKLICꥹȹ¤֤
 *      ǡ string / psi_string
 *
 *--------------------------------------------------------------
 */

GDDEF_METHOD(get__from__type1__str_14)
{
  G_STD_DECL;
  int LowRange, HighRange, Scan, RDataPosi, SInfoPosi, DType, Nest;
  int plength; /*$ For Kappa Q03.01 */
  int HitFlag, PageFlag, NextFlag;
  q Result, *current_gallocp;
  q LowKeyq, HighKeyq;
  GD_OBJ_TYPE *LowKey, *HighKey;
  int LKeySize, HKeySize;
  char low_key_area[IDX_KEY_MAX];
  char high_key_area[IDX_KEY_MAX];

  q *ixp_SearchStr(); 

  ELEMCTYPE *body;
  Shallow(GD_SELF);
  body = GD_SELF->body; 

  LowKeyq = GD_ARGV[0];
  GD_DEREF(LowKeyq);
  LowKey = (GD_OBJ_TYPE *)G_FUNCTORP(LowKeyq);
  GDSET_INTARG_WITHIN_RANGE(LowRange,GD_ARGV[1],MININT, MAXINT);
  HighKeyq = GD_ARGV[2];
  GD_DEREF(HighKeyq);
  HighKey = (GD_OBJ_TYPE *)G_FUNCTORP(HighKeyq);
  GDSET_INTARG_WITHIN_RANGE(HighRange,GD_ARGV[3],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(Scan,GD_ARGV[4],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(RDataPosi,GD_ARGV[5],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(SInfoPosi,GD_ARGV[6],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(DType,GD_ARGV[7],MININT, MAXINT)
  GDSET_INTARG_WITHIN_RANGE(Nest,GD_ARGV[8],MININT, MAXINT)
  GDSET_INTARG_WITHIN_RANGE(plength,GD_ARGV[9],MININT, MAXINT)
  
  Shallow(LowKey);
  /* Data Type is string */
  if(DType == 1){
      LKeySize = LowKey->index;
      BCOPY((char *) LowKey->body, low_key_area, LKeySize);
      low_key_area[LKeySize] = 0;
  }
  /* Data Type is psi_string */
  else{
      LKeySize = LowKey->index*(ELEMSIZE/8);
      BCOPY((char *) LowKey->body, low_key_area, LKeySize);
      low_key_area[LKeySize] = 0;
  };

  Shallow(HighKey);
  /* Data Type is string */
  if(DType == 1){
      HKeySize = HighKey->index;
      BCOPY((char *) HighKey->body, high_key_area, HKeySize);
      high_key_area[HKeySize] = 0;
  }
  /* Data Type is psi_string */
  else{
      HKeySize = HighKey->index*(ELEMSIZE/8);
      BCOPY((char *) HighKey->body, high_key_area, HKeySize);
      high_key_area[HKeySize] = 0;
  };

  current_gallocp = g_allocp;
  GD_ALLOC_AREA(Result, (q), IDX_TYPE1_MAX); 

  g_allocp = ixp_SearchStr(body, low_key_area, LowRange, high_key_area, 
			   HighRange, Scan, RDataPosi, SInfoPosi, 
			   DType, Nest, plength, &HitFlag, &PageFlag, 
                           &NextFlag, &Result, current_gallocp);

  GD_UNIFY( GD_ARGV[10],G_MAKEINT(HitFlag)); 
  GD_UNIFY( GD_ARGV[11],G_MAKEINT(PageFlag)); 
  GD_UNIFY( GD_ARGV[12],G_MAKEINT(NextFlag)); 
  GD_UNIFY_VALUE(GD_ARGV[13],Result); 
  GD_RETURN;
}



/*--------------------------------------------------------------
 * Get Search Result From Type2 Leaf 
 *     get_from_type2(Str, Scan, Nest, ^PageFlag, ^Result)
 *
 *      Type2դ饭ǻꤵ륤ǥå˴ؤ븡̤
 *      Ф֤ΤȤKLICꥹȹ¤֤
 *
 *--------------------------------------------------------------
 */
GDDEF_METHOD(get__from__type2_5)
{
  G_STD_DECL;
  int scan, nest, page_flag;
  int plength; /*$ For Kappa Q03.01 */
  q result, *current_gallocp;
  q *ixp_GetSubRIDs(); 
  
  ELEMCTYPE *body;
  Shallow(GD_SELF);
  body = GD_SELF->body; 

  GDSET_INTARG_WITHIN_RANGE(scan,GD_ARGV[0], MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(nest,GD_ARGV[1], MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(plength,GD_ARGV[2], MININT, MAXINT);

  current_gallocp = g_allocp;
  GD_ALLOC_AREA(result, (q), IDX_TYPE2_MAX); 

  g_allocp = ixp_GetSubRIDs(body, scan, nest, plength,
			    &page_flag, &result, current_gallocp);

  GD_UNIFY( GD_ARGV[3],G_MAKEINT(page_flag)); 
  GD_UNIFY_VALUE(GD_ARGV[4],result); 
  GD_RETURN;

}


/*--------------------------------------------------------------
 * Get Search Result From Type3 Leaf 
 *     get_from_type3(Str, Scan, ^PageFlag, ^Result) 
 *
 *      Type3դ饭ǻꤵ륤ǥå˴ؤ븡̤
 *      Ф֤ΤȤKLICꥹȹ¤֤
 *
 *--------------------------------------------------------------
 */
GDDEF_METHOD(get__from__type3_5)
{
  G_STD_DECL;
  int scan, nest, page_flag;
  int plength; /*$ For Kappa Q03.01 */
  q result, *current_gallocp;
  q *ixp_GetOccInfo(); 
  
  ELEMCTYPE *body;
  Shallow(GD_SELF);
  body = GD_SELF->body; 

  GDSET_INTARG_WITHIN_RANGE(scan,GD_ARGV[0],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(nest,GD_ARGV[1],MININT, MAXINT);
  GDSET_INTARG_WITHIN_RANGE(plength,GD_ARGV[2],MININT, MAXINT);

  current_gallocp = g_allocp;
  GD_ALLOC_AREA(result, (q), IDX_TYPE3_MAX); 

  g_allocp = ixp_GetOccInfo(body, scan, nest, plength, 
			    &page_flag, &result, current_gallocp);

  GD_UNIFY( GD_ARGV[3],G_MAKEINT(page_flag)); 
  GD_UNIFY_VALUE(GD_ARGV[4],result); 
  GD_RETURN;

}


/*--------------------------------------------------------------
 * ixp_set_key(Str, DType, Key, Posi, Data_posi, N_str, Status)
 * 
 * ǽ:Str ǻꤵ줿16bitȥ󥰤 Key ǻꤵ줿
 *          ͤ Posi ǻꤵ줿֤Ǽ롣
 * 
 * Argument: Str   ::= 16bit Page String  % body ʬ
 *           DType ::= 1  % string °
 *                  |  2  % psi_string °
 *           Key   ::= string  % Ǽ٤DType ѴѤ
 *           Posi  ::= integer % Ǽϰ
 *           Data_posi ::= integer % Ǽϰ  ǼĹ
 *           N_str ::= string
 *           Status ::= 0  % ｪλ
 *                      -1 % ۾ｪλ
 *
 *--------------------------------------------------------------
 */

GDDEF_METHOD(ixp__set__key_7)
{
  G_STD_DECL;
  /* input & output */
  long dtype;
  long position;
  int plength; /*$ For Kappa Q03.01 */
  long data_posi;
  long status ;
  q    keyq;
  GD_OBJ_TYPE *Key;
  int key_len;

  /* static Function */
   static int Get_Key_Len(); 

  /* use in function */
  GD_OBJ_TYPE *newstr;
  ELEMCTYPE *body;
  ELEMCTYPE olddata;
  ELEMCTYPE HighElement;
  ELEMCTYPE LowElement;
  int iscnst;
/*  int kisuu; */
  int h_key_len;
  int flaged_key_len;
  int keyposi = 0;
  long size;

  Shallow(GD_SELF);
  size   = GD_SELF->index;
  iscnst = GD_SELF->iscnst;
  body   = GD_SELF->body;

  GDSET_NEWOBJ(newstr);

  /*  ϥǡμ  */
  GDSET_INTARG_WITHIN_RANGE(dtype, GD_ARGV[0], 0, 3);    /* Data Type */
  keyq = GD_ARGV[1];                                     /* Ǽ  */
  GD_DEREF(keyq);
  Key = (GD_OBJ_TYPE *)G_FUNCTORP(keyq);
  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[2],0,size); /* Ǽ  */
/*  GDSET_INTARG_WITHIN_RANGE(plength, GD_ARGV[3], MININT, MAXINT); */

  Shallow(Key);
  key_len = Key->index;

  /* ͤγǼ */
  if (!iscnst) {
    olddata = body[position];
    GD_SELF->index = position;
    GD_SELF->body = (ELEMCTYPE *)(unsigned long)olddata;
    if(dtype == 1) {    /* °Υǡ string ξ */
      h_key_len = Get_Key_Len(key_len, &flaged_key_len); 
      body[position++] = flaged_key_len;
      data_posi = position + h_key_len;
      BCOPY((char *) Key->body, (char *) &body[position], key_len);
    } else { /* °Υǡ psi_string ξ */
      body[position++] = key_len;
      data_posi = position + key_len;
      BCOPY((char *)Key->body, (char *) &body[position], key_len*(ELEMSIZE/8));
    }
    newstr->body = body;
  } else {
    long k;
    ELEMCTYPE *newbody;
    long qsize = ROUND_UP(size);
    GD_ALLOC_AREA(newbody, (ELEMCTYPE *), qsize);
    BCOPY(body, newbody, qsize*sizeof(q));

    if(dtype == 1){
      h_key_len = Get_Key_Len(key_len, &flaged_key_len);  
      newbody[position++] = flaged_key_len;
      data_posi = position + h_key_len;
      BCOPY((char *) Key->body, (char *) &newbody[position], key_len);
    } else {
      newbody[position++] = key_len;
      data_posi = position + key_len;
      BCOPY((char *)Key->body, (char *) &newbody[position], key_len*(ELEMSIZE/8));
    }
    newstr->body = newbody;
  }
  newstr->next = STRING16_SHALLOW_MARK;
  newstr->index = size;
  newstr->iscnst = 0;
  GD_UNIFY_VALUE(GD_ARGV[4], G_MAKEINT(data_posi)); 
  GD_UNIFY_VALUE(GD_ARGV[5], GD_OBJ(newstr)); 
  GD_UNIFY_VALUE(GD_ARGV[6], G_MAKEINT(0));
  GD_RETURN;
}


/*--------------------------------------------------------------
 * Get_Key_Len(int key_len, int *flaged_key_len)
 * 
 * ǽ:key_len Ϳ 8bit ȥ󥰤Ĺ
 *          16bit ȥ󥰤˳ǼĹ׻롣
 *          碌ƴե饰ΩƤĹ֤
 * 
 * ꥿:16bit ȥ󥰳ǼĹ
 * Argument: key_len ::= integer % 8bit string length
 *           flaged_key_len ::= key_len ˥ե饰ΩƤ
 *
 *--------------------------------------------------------------
 */
static int Get_Key_Len(int key_len, int *flaged_key_len)
{
    int h_key_len;

    h_key_len = key_len / 2;
    if(key_len & 1) {
	h_key_len = h_key_len + 1;
	*flaged_key_len = h_key_len | IDX_KISUU_FLAG;
    } else {
	*flaged_key_len = h_key_len;
    }
    return h_key_len;
}
