/*
/*	(C)1992, 1993, 1995 Institute for New Generation Computer Technology
/*		ۤ¾COPYRIGHTե򻲾ȤƲ
/*		(Read COPYRIGHT for detailed information.)
 */

/************************************************************
 *
 *  FILE NAME
 *    ixp_point.c
 *  DESCLIPTION
 *    ǥåץΥ⥸塼롣ȥǤΥ
 *    Ǽ֤ؤΰդԤʤ
 *  INTERFACE ROUTINES
 *    binary_search1 - Type1 դΤʤ RData ΰ֤֤
 *    binary_search2 - Type2,3 դҶ LPN ֤
 *  NOTES
 *
 *$ EDITOR : Sugizaki Gen
 *$ CREATE : 93.12.21 Tue
 *$ UPDATE :
 *
 ************************************************************/

#include <stdio.h>
#include <string.h>
#include "ixp.h"
#include "ixp_PntNod.h"



/*------------------------------------------------------------
 *  ixp_BinarySearch2_int
 *   ǥåΡɤ椫ꥭ ҥڡֹФ
 *   ΰդ
 *  ARGUMENT
 *    STRING ::= ڡȥ󥰡ʤ
 *    IntKey ::= ͡
 *    Access ::= 0  % =  euqal
 *               1  % <  ascend
 *               2  % =< asecnd_equal
 *               3  % >  descend
 *               4  % >= descend_equal
 *    LPN    ::= integer % ҥڡڡֹ
 *                  -1      % Υڡ¸ߤ
 *  Return
 *    0  ::= 
 *    -1 ::= ۾
 *
 *------------------------------------------------------------
 */

/* Хʥꥵ */

int
ixp_BinarySearch2_int(char *String, int IntKey, 
		      int Access, int plength, int *LPN, int *SinfoPosi)

/* int 
/* ixp_BinalySearch2_Int(char *String, int IntKey, int Access, int *LPN)
 */

{
/*    int   SinfoPosi;  /* Not In Use */

    switch(Access) {
    /* Equal */
    case equal_idx :
	equ_b_search(String, IntKey, NULL, 
		     TYP_INT, plength, LPN, SinfoPosi);
	break;
    /* Ascend */
    case ascend :
	ascend_b_search(String, IntKey, NULL, 
			Access, TYP_INT, plength, LPN, SinfoPosi);
	break;
    /* Ascend_Equal */
    case ascend_e :
	ascend_b_search(String, IntKey, NULL,
			Access, TYP_INT, plength, LPN, SinfoPosi);
	break;
    /* Descend, Descend_Equal */
    default:
	descend_b_search(String, IntKey, NULL,
			 Access, TYP_INT, plength, LPN, SinfoPosi);
    }
    return Normal;
}


/*------------------------------------------------------------
 *  ixp_BinarySearch2_Str
 *   ǥåΡɤ椫ꥭλҥڡֹФ
 *   ΰդ
 *  ARGUMENT
 *    STRING ::= ڡȥ󥰡ʤ
 *    Key    ::= ͡ʥȥ󥰡
 *    DType  ::= 0  % integer    ǡ
 *               1  % string
 *               2  % psi_string
 *    Access ::= 0  % =  euqal
 *               1  % <  ascend
 *               2  % =< asecnd_equal
 *               3  % >  descend
 *               4  % >= descend_equal
 *    LPN    ::= integer % ҥڡڡֹ
 *                  -1      % Υڡ¸ߤ
 *  Return
 *    0  ::= 
 *    -1 ::= ۾
 *
 *------------------------------------------------------------
 */
/* Хʥꥵ */


int 
ixp_BinarySearch2_str(char *String, char *StrKey, int Access, 
 			  int DType, int plength, int *LPN, int *SinfoPosi)

/* int 
/* ixp_BinalySearch2_Str(char *String, char *StrKey,
/* 			  int Access, int DType, int *LPN)
 */
{
/*    int   SinfoPosi;  /* Not In Use */

    switch(Access) {
    case equal_idx :    /* Equal */
	equ_b_search(String, NULL, StrKey, DType, plength, LPN, SinfoPosi);
	break;
    case ascend :    /* Ascend */
    case ascend_e :  /* Ascend_Equal */
	ascend_b_search(String, NULL, StrKey, 
			Access, DType, plength, LPN, SinfoPosi);
	break;
    /* Descend, Descend_Equal */
    default:
	descend_b_search(String, NULL, StrKey, 
			 Access, DType, plength, LPN, SinfoPosi);
    }
    return Normal;
}


/*---------------------------------------------------------------
 * equ_b_search
 * ΡɤΥڡҶ CData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф硣
 * ڡ CData οǽʬʣΤȤʣΤȤˡ
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *    DType  ::= 0  % integer    ǡ
 *               1  % string
 *               2  % psi_string
 *            CDataPosi ::= CData γǼ֡ʥ꥿͡
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */

/* Equal ΥХʥꥵ */

static void 
equ_b_search(char *String, int IntKey, char *StrKey, 
	     int DType, int plength, int *LPN, int *SinfoPosi)
{
    int SinfoN;       /* Search Info ο */
    int Quotient;     /* SinfoN / 2 ξ  */
    int CurrentPosi;  /* ߥݥȤƤ Sinfo  */
    int Left_rest;    /* Хʥ긡ͤκȾʬ */
    int Right_rest;   /* Хʥ긡ͤαȾʬ */
    int LastPosi;     /* Хʥꥵκǽ  Sinfoκü */

    SinfoN = ixp_get_int(String, 2); /* 2 is Search Info Count Posi */

    /* ǥåΤȤ */
    if(SinfoN == 1) {
/*	CurrentPosi = PLENGTH - 2; */
	CurrentPosi = plength - 2;
	compare_one_info(String, IntKey, StrKey, equal_idx, 
			 DType, CurrentPosi, plength, LPN, SinfoPosi);
    }
    /* ǥåʾΤȤ */
    else{
/*	LastPosi = PLENGTH - SinfoN * 2; */
	LastPosi = plength - SinfoN * 2;
	ixp_get_quotient(SinfoN, &Quotient, &Left_rest, &Right_rest);
/*	CurrentPosi = PLENGTH - 2 - Quotient * 2; */
/*	CurrentPosi = PLENGTH - 2 - Right_rest * 2; */
	CurrentPosi = plength - 2 - Right_rest * 2;
	equ_binary_search(String, IntKey, StrKey, DType, 
			  LastPosi, CurrentPosi, Quotient, 
			  Left_rest, Right_rest, plength, LPN, SinfoPosi);
/*	equ_binary_search(String, IntKey, StrKey, DType, 
 *			  LastPosi, CurrentPosi, SinfoN, 
 *			  Left_rest, Right_rest, plength, LPN, SinfoPosi);
 */
    }
}
    


/*---------------------------------------------------------------
 * equ_binaly_search
 * ΡɤΥڡҶ CData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф硣
 * ڡʣ CData ǼƤν
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            DType  ::= 0  % integer    ǡ
 *                       1  % string
 *                       2  % psi_string
 *            CurrenrPosi ::= Bynaly_SearchΤθߤSinfoΰ
 *            SinfoN      ::= Bynaly_SearchΤλĤSinfo
 *            Left_rest ::= Sinfoΰ֤κλĤ
 *            Right_rest ::= Sinfoΰ֤αλĤ
 *            LPN       ::= integer % ҥڡڡֹ
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */

/* ȥ CData İʾ¸ߤȤ  Хʥꥵ */

static void 
equ_binary_search(char *String, int IntKey, 
		  char *StrKey, int DType, int LastPosi, 
		  int CurrentPosi, int SinfoN, int Left_rest, 
		  int Right_rest, int plength, int *LPN, int *SinfoPosi)
{
    int   RDP;       /* ȤSearchInfoݥȤCData ΰ */
    int   CData;     /*  */
    int   RD_Key;    /* CData  ǼƤ륭 */
    int   Quotient;  /* Хʥꥵξ */
    int   NewCurPosi;     /* Ȱ */
    int   New_Left_rest;  /* Bynery_Search οʤޤ */
    int   New_Right_rest; /* Binary_Search οʤޤ */
    int   CDataPosi;      /* ҶΥǡǼ */


    RDP = ixp_get_int(String, CurrentPosi);
    RDP = RDP * 2;  /* 16bit Position to 8bit Position */

    switch(ixp_compare_key(String, IntKey, StrKey, DType, RDP)) {

    /* CData ΥͤȻꥭͤƱȤ */
    case Same :
	*SinfoPosi = CurrentPosi / 2 ;
	*LPN = get_child_LPN(String, DType, plength, RDP);
	break;

    /*  CData õˤ */
    /* ǼƤ륭ꥭ꾮Ȥ */
    case Small :
	/* դΰֺʺˤͤꥭ礭 */
	if(CurrentPosi == LastPosi){
	    *SinfoPosi = CurrentPosi / 2;
	    CDataPosi = ixp_get_int(String, CurrentPosi);
	    *LPN = get_child_LPN(String, DType, plength, CDataPosi * 2); 
	}
	/* ʳ */
	else{
	    if(SinfoN == 1){
		/* ǸSinfo  */
		*SinfoPosi = CurrentPosi / 2;
		CDataPosi = ixp_get_int(String, CurrentPosi);
		*LPN = get_child_LPN(String, DType, plength, CDataPosi * 2); 
		/* Sinfo ξüǤϤʤ */
	    }
	    /* Хʥꥵ */
	    else{
		ixp_get_quotient(Left_rest, &Quotient, 
				 &New_Left_rest, &New_Right_rest);
		NewCurPosi = CurrentPosi -2 - New_Right_rest * 2; 
		/* -2  Left_rest κǱüؤΰդ */
		equ_binary_search(String, IntKey, 
				  StrKey, DType, LastPosi,
				  NewCurPosi, Quotient, New_Left_rest, 
				  New_Right_rest, plength, LPN, SinfoPosi);
		}
	}
	break;


    /* ǼƤ륭ꥭ礭Ȥ */
    default :
	if(SinfoN == 1){    /* Ǻü Sinfo  ˳ */
                            /* ΤȤդˤäƤ̵̤ɡ */ 
                            /* ǤȤ褦ˡ               */
    	    if(Right_rest == 0){
/*		if(CurrentPosi == PLENGTH - 2) { */
		if(CurrentPosi == plength - 2) {
		    *SinfoPosi = CurrentPosi / 2;
		    *LPN = get_child_LPN(String, DType, plength, RDP); 
		}
		else{
		    *SinfoPosi = (CurrentPosi + 2) / 2;
		    CDataPosi = ixp_get_int(String, CurrentPosi + 2);
		    *LPN = get_child_LPN(String, 
                                         DType, plength, CDataPosi * 2); 
		}
	    }
	    else{
		ixp_get_quotient(Right_rest, 
				 &Quotient, &New_Left_rest, &New_Right_rest);
		NewCurPosi = CurrentPosi + Quotient * 2; 
		equ_binary_search(String, IntKey, 
				  StrKey, DType, LastPosi,
				  NewCurPosi, Quotient, New_Left_rest, 
				  New_Right_rest, plength, LPN, SinfoPosi);
	    }
	}
	else{
	    ixp_get_quotient(Right_rest, 
			     &Quotient, &New_Left_rest, &New_Right_rest);
	    NewCurPosi = CurrentPosi + Quotient * 2; 
	    equ_binary_search(String, IntKey, 
			      StrKey, DType, LastPosi,
			      NewCurPosi, Quotient, New_Left_rest, 
			      New_Right_rest, plength, LPN, SinfoPosi);
	}
	break;
    }
}



/*---------------------------------------------------------------
 * ascend_b_search
 * ΡɤΥڡҶ CData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф硣
 * ڡ CData οǽʬʣΤȤʣΤȤˡ
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            Access ::= ׼̻ҡ
 *                       1 = ascend, 2 = asecnd_equal
 *                       3 = descend, 4 = descend_equal
 *    DType  ::= 0  % integer    ǡ
 *               1  % string
 *               2  % psi_string
 *            CDataPosi ::= CData γǼ֡ʥ꥿͡
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */

/* Ascend ϤΥХʥꥵ */

static void 
ascend_b_search(char *String, int IntKey, char *StrKey, 
		int Access, int DType, int plength, int *LPN, int *SinfoPosi)
{
    int SinfoN;       /* Search Info ο */
    int Quotient;     /* SinfoN / 2 ξ  */
    int CurrentPosi;  /* ߥݥȤƤ Sinfo  */
    int Left_rest;    /* Хʥ긡ͤκȾʬ */
    int Right_rest;   /* Хʥ긡ͤαȾʬ */
    int LastPosi;     /* Хʥꥵκǽ  Sinfoκü */

    SinfoN = ixp_get_int(String, 2); /* 2 is Search Info Count Posi */

    /* ǥåΤȤ */
    if(SinfoN == 1) {
/*	CurrentPosi = PLENGTH - 2; */
	CurrentPosi = plength - 2;
	compare_one_info(String, IntKey, StrKey, Access, DType, 
			 CurrentPosi, plength, LPN, SinfoPosi);
    } else { /* ǥåʾΤȤ */
/*	LastPosi = PLENGTH - SinfoN * 2; */
	LastPosi = plength - SinfoN * 2;
	ixp_get_quotient(SinfoN, &Quotient, &Left_rest, &Right_rest);
/*	CurrentPosi = PLENGTH - 2 - Right_rest * 2; */
	CurrentPosi = plength - 2 - Right_rest * 2;
	ascend_binary_search(String, IntKey, StrKey, Access, DType, LastPosi,
			     CurrentPosi, Quotient, Left_rest, Right_rest, 
			     plength, LPN, SinfoPosi);
/*	ascend_binary_search(String, IntKey, StrKey, Access, DType, LastPosi,
 *			     CurrentPosi, SinfoN, Left_rest, Right_rest, 
 *			     plength, LPN, SinfoPosi);
 */
    }
}
    


/*---------------------------------------------------------------
 * ascend_binaly_search
 * ΡɤΥڡҶ CData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф硣
 * ڡʣ CData ǼƤν
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            Access ::= ׼̻ҡ
 *                       1 = ascend, 2 = asecnd_equal
 *                       3 = descend, 4 = descend_equal
 *            DType  ::= 0  % integer    ǡ
 *                       1  % string
 *                       2  % psi_string
 *            CurrenrPosi ::= Bynaly_SearchΤθߤSinfoΰ
 *            SinfoN      ::= Bynaly_SearchΤλĤSinfo
 *            Left_rest ::= Sinfoΰ֤κλĤ
 *            Right_rest ::= Sinfoΰ֤αλĤ
 *            LPN       ::= integer % ҥڡڡֹ
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */

/* ȥ CData İʾ¸ߤȤ  Хʥꥵ */

static void 
ascend_binary_search(char *String, int IntKey, char *StrKey,
		     int Access, int DType, int LastPosi, 
		     int CurrentPosi, int SinfoN, 
		     int Left_rest, int Right_rest,
		     int plength, int *LPN, int *SinfoPosi)
{
    int   RDP;       /* ȤSearchInfoݥȤCData ΰ */
    int   CData;     /*  */
    int   RD_Key;    /* CData  ǼƤ륭 */
    int   Quotient;  /* Хʥꥵξ */
    int   NewCurPosi;     /* Ȱ */
    int   New_Left_rest;  /* Bynery_Search οʤޤ */
    int   New_Right_rest; /* Binary_Search οʤޤ */
    int   CDataPosi;      /* ҶΥǡǼ */


    RDP = ixp_get_int(String, CurrentPosi);
    RDP = RDP * 2;  /* 16bit Position to 8bit Position */

    switch(ixp_compare_key(String, IntKey, StrKey, DType, RDP)) {
    case Same: /* CData ΥͤȻꥭͤƱȤ */
	*SinfoPosi = CurrentPosi / 2;
	*LPN = get_child_LPN(String, DType, plength, RDP);
	break;

    /*  CData õˤ */
    case Small: /* CData ΥΤۤ */
	if(SinfoN == 1){ 
	    *SinfoPosi = CurrentPosi / 2;
	    CDataPosi = ixp_get_int(String, CurrentPosi);
	    *LPN = get_child_LPN(String, DType, plength, CDataPosi * 2); 
	} else {
	    ixp_get_quotient(Left_rest, 
			     &Quotient, &New_Left_rest, &New_Right_rest);
	    NewCurPosi = CurrentPosi - 2 - New_Right_rest * 2;
	    /* -2  Left_rest κǱüؤΰդ */
	    ascend_binary_search(String, IntKey, 
				 StrKey, Access, DType, LastPosi,
				 NewCurPosi, Quotient, New_Left_rest, 
				 New_Right_rest, plength, LPN, SinfoPosi);
	}
	break;
    default: /* CData ΥΤۤ礭 */
	if(SinfoN == 0){ 
/*	    if(Right_rest == 0){ */
	    if(CurrentPosi == plength - 2){
		*SinfoPosi = CurrentPosi / 2;
		*LPN = get_child_LPN(String, DType, plength, RDP);
		/* ꥭڤˤʤ                   */
		/* ǻȤդ˰֤Ĥɬפ     */
		break;
	    } else {
		*SinfoPosi = (CurrentPosi + 2) / 2;
		CDataPosi = ixp_get_int(String, CurrentPosi + 2);
		*LPN = get_child_LPN(String, DType, plength, CDataPosi * 2); 
	    }
	} else {
	    ixp_get_quotient(Right_rest, 
			     &Quotient, &New_Left_rest, &New_Right_rest);
	    NewCurPosi = CurrentPosi +  Quotient * 2; 
	    /* +2  Right_rest κǺüؤΰդ */
	    ascend_binary_search(String, IntKey, 
				 StrKey, Access, DType, LastPosi,
				 NewCurPosi, Quotient, New_Left_rest, 
				 New_Right_rest, plength, LPN, SinfoPosi);
	}
	break;
    }
}




/*---------------------------------------------------------------
 * descend_b_search
 * ΡɤΥڡҶ CData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф߽硣
 * ڡ CData οǽʬʣΤȤʣΤȤˡ
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            Access ::= ׼̻ҡ
 *                       1 = ascend, 2 = asecnd_equal
 *                       3 = descend, 4 = descend_equal
 *            DType  ::= 0  % integer    ǡ
 *                       1  % string
 *                       2  % psi_string
 *            CDataPosi ::= CData γǼ֡ʥ꥿͡
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */


/* Desend ϤΥХʥꥵ */

static void 
descend_b_search(char *String, int IntKey, char *StrKey,
		 int Access, int DType, int plength, int *LPN, int *SinfoPosi)
{
    int SinfoN;       /* Search Info ο */
    int Quotient;     /* SinfoN / 2 ξ  */
    int CurrentPosi;  /* ߥݥȤƤ Sinfo  */
    int Left_rest;    /* Хʥ긡ͤκȾʬ */
    int Right_rest;   /* Хʥ긡ͤαȾʬ */
    int LastPosi;     /* Хʥꥵκǽ  Sinfoκü */


    SinfoN = ixp_get_int(String, 2); /* 2 is Search Info Count Posi */

    /* ǥåΤȤ */
    if(SinfoN == 1) {
/*	CurrentPosi = PLENGTH - 2; */
	CurrentPosi = plength - 2;
	compare_one_info(String, IntKey, StrKey, Access, DType, 
			 CurrentPosi, plength, LPN, SinfoPosi);
    }
    /* ǥåʾΤȤ */
    else{
/*	LastPosi = PLENGTH - SinfoN * 2; */
	LastPosi = plength - SinfoN * 2;
	ixp_get_quotient(SinfoN, &Quotient, &Left_rest, &Right_rest);
/*	CurrentPosi = PLENGTH - 2 - Right_rest * 2; */
	CurrentPosi = plength - 2 - Right_rest * 2;
	descend_binary_search(String, IntKey, StrKey, Access, DType, 
			      LastPosi, CurrentPosi, Quotient, Left_rest, 
			      Right_rest, plength, LPN, SinfoPosi);
/*	descend_binary_search(String, IntKey, StrKey, Access, DType, 
 *			      LastPosi, CurrentPosi, SinfoN, Left_rest, 
 *			      Right_rest, plength, LPN, SinfoPosi);
 */

    }
}
    

/*---------------------------------------------------------------
 * descend_binaly_search
 * ΡɤΥڡҶ CData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф߽硣
 * ڡʣ CData ǼƤν
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            Access ::= ׼̻ҡ
 *                       1 = ascend, 2 = asecnd_equal
 *                       3 = descend, 4 = descend_equal
 *            DType  ::= 0  % integer    ǡ
 *                       1  % string
 *                       2  % psi_string
 *            CurrenrPosi ::= Bynaly_SearchΤθߤSinfoΰ
 *            SinfoN      ::= Bynaly_SearchΤλĤSinfo
 *            Left_rest ::= Sinfoΰ֤κλĤ
 *            Right_rest ::= Sinfoΰ֤αλĤ
 *            CDataPosi ::= CData γǼ֡ʥ꥿͡
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */

/* ȥ CData İʾ¸ߤȤ  Хʥꥵ */

static void 
descend_binary_search(char *String, int IntKey, char *StrKey,
		      int Access, int DType, int LastPosi, 
		      int CurrentPosi,  int SinfoN, 
		      int Left_rest, int Right_rest,
		      int plength, int *LPN, int *SinfoPosi)
{
    int   RDP;       /* ȤSearchInfoݥȤCData ΰ */
    int   CData;     /*  */
    int   RD_Key;    /* CData  ǼƤ륭 */
    int   Quotient;  /* Хʥꥵξ */
    int   New_Left_rest;  /* Bynery_Search οʤޤ */
    int   New_Right_rest; /* Binary_Search οʤޤ */
    int   NewCurPosi;     /* ΥȰ */
    int   CDataPosi;    /* ҶΥǡǼ */

    RDP = ixp_get_int(String, CurrentPosi);
    RDP = RDP * 2;  /* 16bit Position to 8bit Position */

    switch(ixp_compare_key(String, IntKey, StrKey, DType, RDP)) {

    /* CData ΥͤȻꥭͤƱȤ */
    /* CData λؤڡ˻ꥭ꾮Τǽ */
    case Same :
	if(Access == descend){
/* 	    if(CurrentPosi == PLENGTH - 2){ */
	    if(CurrentPosi == plength - 2){
		*SinfoPosi = CurrentPosi / 2;
		*LPN = get_child_LPN(String, DType, plength, RDP);
		/* ǻȤդ˰֤Ĥɬפ     */
		/* ꥭ꾮ͤϤ⤦ʤΤǡ֤ */
	    }
	    else{
		*SinfoPosi = (CurrentPosi + 2) / 2;
		RDP = ixp_get_int(String, CurrentPosi + 2);
		*LPN = get_child_LPN(String, DType, plength, RDP * 2);
	    }	    
	}
	else{
	    /* descend_e ΤȤ */
	    *SinfoPosi = CurrentPosi / 2;
	    *LPN = get_child_LPN(String, DType, plength, RDP);
	}
	break;

    /*  CData õˤ */
    /* CData Υꥭ꾮 */
    case Small :
	if(CurrentPosi == LastPosi){
	    *SinfoPosi = CurrentPosi / 2;
	    *LPN = get_child_LPN(String, DType, plength, RDP);
	    /* ꥭ礭ͤϤ⤦ʤΤǡ֤ */
	}
	else{
	    if(SinfoN == 1){
		if(Right_rest == 0){
		    *SinfoPosi = CurrentPosi / 2;
		    *LPN = get_child_LPN(String, DType, plength, RDP);
		}
		else{
		    *SinfoPosi = (CurrentPosi + 2) / 2;
		    RDP = ixp_get_int(String, CurrentPosi + 2);
		    *LPN = get_child_LPN(String, DType, plength, RDP * 2);
		}
	    }
	    else {
		ixp_get_quotient(Left_rest, 
				 &Quotient, &New_Left_rest, &New_Right_rest);
		NewCurPosi = CurrentPosi - 2 - New_Right_rest * 2;
		/* -2  Left_rest κǱüؤΰդ */
		descend_binary_search(String, IntKey, StrKey, Access, 
				      DType, LastPosi, NewCurPosi, 
				      Quotient, New_Left_rest, 
				      New_Right_rest, plength, LPN, SinfoPosi);
	    }
	}
	break;

    /* CData Υꥭ礭 */
    default :
	if(SinfoN == 1){
/*	    if(CurrentPosi == PLENGTH - 2){ */
	    if(CurrentPosi == plength - 2){
		*SinfoPosi = CurrentPosi / 2;
		*LPN = get_child_LPN(String, DType, plength, RDP);
		/* Ǿͤ꾮ͤ򥭡Ȥƻꤷ */
		/* ǻȤդ˰֤Ĥɬפ     */
	    }
	    else{
		*SinfoPosi = (CurrentPosi  + 2) / 2;
		RDP = ixp_get_int(String, CurrentPosi + 2);
		*LPN = get_child_LPN(String, DType, plength, RDP * 2);
	    }
	    /* ꥭϥǥå¸ߤʤ  */
	    /* ǻȤդ˰֤Ĥɬפ     */
	}
	else{
	    ixp_get_quotient(Right_rest, 
			     &Quotient, &New_Left_rest, &New_Right_rest);
	    NewCurPosi = CurrentPosi + 2 + New_Left_rest * 2;
	    /* +2  Right_rest κǺüؤΰդ */
	    descend_binary_search(String, IntKey, StrKey, Access, 
				  DType, LastPosi, NewCurPosi, 
				  Quotient, New_Left_rest, 
				  New_Right_rest, plength, LPN, SinfoPosi);
	}
	break;
    }
}


/*---------------------------------------------------------------
 * compare_one_info
 * ΡɤΥڡҶ CData ǼƤ֤ȡSinfo 
 * ǼƤ֤Ф硿߽硣
 * ڡ CData ҤȤĳǼƤν
 *
 * ARGUMENT : String ::= ڡȥؤΥݥ
 *            Key    ::= ͡
 *            Access ::= ׼̻ҡ
 *                       1 = ascend, 2 = asecnd_equal
 *                       3 = descend, 4 = descend_equal
 *           DType  ::= 0  % integer    ǡ
 *                      1  % string
 *                      2  % psi_string
 *            CurrenrPosi ::= Bynaly_SearchΤθߤSinfoΰ
 *            LPN       ::= integer  % ҶΥڡΥڡֹ
 *            SinfoPosi ::= Sinfo γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */
/* Search Info Ĥʤ */

static void 
compare_one_info(char *String, int IntKey, char *StrKey,
		 int Access, int DType, int CurrentPosi,
		 int plength, int *LPN, int *SinfoPosi)
{
    int   RDP;     /* ȤSearchInfoݥȤCData ΰ */
    int   CData;   /*  */
    int   RD_Key;  /* CData  ǼƤ륭 */
    int   CDataPosi;  /* ҶΥǡǼ */

    RDP = ixp_get_int(String, CurrentPosi);
    RDP = RDP * 2;  /* 16bit Position to 8bit Position */

    switch(ixp_compare_key(String, IntKey, StrKey, DType, RDP)) {

    /* CData ΥͤȻꥭͤƱȤ */
    case Same : 
	switch(Access) {
	/* ascend ΤȤ */
	case ascend :
	    *LPN       = -1;
	    *SinfoPosi = -1;
	    break;
	/* equal, ascend_equal, descend_equal, descend ΤȤ */
	default :
	    *LPN = get_child_LPN(String, DType, plength, RDP);
	    *SinfoPosi = CurrentPosi / 2;
	    break;
	}
/*	return Normal; */
	break;
    /* CData Υͤꥭ礭Ȥ */
    /* Access ǥåƤ뤬¤Ϥ٤ƤCDataLPN֤ */
    case Large :
	switch(Access) {
	/* descend */
	case descend :
	    *LPN = get_child_LPN(String, DType, plength, RDP);
	    *SinfoPosi = CurrentPosi / 2;
/*     	    return Normal; */
	    break;
	/* desend_e */
	case descend_e :
	    *LPN = get_child_LPN(String, DType, plength, RDP);
	    *SinfoPosi = CurrentPosi / 2;
/*          return Normal;  */
	    break;
	/* equal */
	case equal_idx :
	    *LPN = get_child_LPN(String, DType, plength, RDP);
	    *SinfoPosi = CurrentPosi / 2;
/*     	    return Normal; */
	    break;
	/* ascend or ascend_e */
	default :
	    *LPN = get_child_LPN(String, DType, plength, RDP);
	    *SinfoPosi = CurrentPosi;
/*	    return Normal; */
	    break;
	}
    /* CData Υͤꥭ꾮Ȥ */
    case Small :
	switch(Access) {
	/* ascend */
	case ascend :
	    *LPN       = -1;
	    *SinfoPosi = -1;
/*     	    return Normal; */
/*	    printf("Error Occurd in IXP Positioning, Asend Point error");
	    return ERROR;
*/
	    break;
	/* ascend_e */
	case ascend_e :
	    *LPN       = -1;
	    *SinfoPosi = -1;
/*     	    return Normal; */
/*	    printf("Error Occurd in IXP Positioning, Asend Point error");
	    return ERROR;
*/
	    break;
	/* equal */
	case equal_idx :
	    *LPN = -1;
	    *SinfoPosi = -1;
/*     	    return Normal; */
	    break;
	/* desecend or descend_e */
	default :
	    *LPN = get_child_LPN(String, DType, plength, RDP);
	    *SinfoPosi = CurrentPosi / 2;
/*	    return Normal; */
	    break;
	}
    }
}



/*---------------------------------------------------------------
 * get_child_LPN
 *   ΡɤΥڡˤ CData ҶΥΡɥڡLPN
 *   
 *
 * ARGUMENT : 
 *    String    ::= ڡȥؤΥݥ
 *    CDataPosi ::= CData γǼ֡ʥ꥿͡
 *
 *---------------------------------------------------------------
 */

static int 
get_child_LPN(char *String, int DType, int plength, int CDataPosi)
{
    int KeyLength; 
    int LpnPosi; 
    int LPN;

    if(DType == TYP_INT)
	LpnPosi = CDataPosi + 4;
    else{
	KeyLength = ixp_get_int(String, CDataPosi);
	KeyLength = ODD_MASK & KeyLength;
	LpnPosi   = CDataPosi + KeyLength * 2 + 2;
    }
    LPN = ixp_get_4byte_int(String, LpnPosi);
    return LPN;
}
