/* ------------------------------------------------------------
   (C)1994 Institute for New Generation Computer Technology 
       (Read COPYRIGHT for detailed information.) 
--------------------------------------------------------------- */

/* Predicates

     <Number> ::= <Bignum> | <Integer>
     <Result> ::= <Bignum>
     <Init>   ::= <String> | <Integer>

   (1) Guard Predicates

       bignum            bignum(<Bignum>)
       less_than         less_than(<Bignum>,<Number>)
       equal             equal(<Bignum>,<Number>)
       greater_than      greater_than(<Bignum>,<Number>)

   (2) Body Predicates

       new               new(bignum,<Bignum>,<Init>)
       add               add(<Bignum>,<Number>,<Result>)
       subtract          subtract(<Bignum>,<Number>,<Result>)
       multiply          multiply(<Bignum>,<Number>,<Result>)
       divide            divide(<Bignum>,<Number>,<Result>)
       modulo            modulo(<Bignum>,<Number>,<Result>)
       gcd               gcd(<Bignum1>,<Bignum2>,<Result>)
       power             power(<Bignum>,<Non-Negative Integer>,<Result>)
                  <Bignum> ** <Non-Negative Integer> = <Result>
       compare           compare(<Bignum>,<Number>,<Integer>)
              if <Integer> '>' 0  then <Bignum> '>' <Number>
              if <Integer> '==' 0 then <Bignum> '=' <Number>
              if <Integer> '<' 0  then <Bignum> '<' <Number>
       absolute          absolute(<Bignum>,<Result>)
       negate            negate(<Bignum>,<Result>)
       copy              copy(<Bignum>,<Result>)
       portray           portray(<Bignum>,<String>)
              convert <Bignum> to <String> 
*/

#include <math.h>
#include <stdio.h>
#include <klic/gdobject.h>
#include <klic/gd_macro.h>

#include <gmp.h>
#include <gmp-impl.h>
#include <longlong.h>

#ifdef DIST
#include <klic/interpe.h>
#include <klic/traceio.h>
#endif

#include "atom.h"
#include "funct.h"

#ifdef USESTRCHR
#define Strchr strchr
#else
#define Strchr index
#endif

MP_INT temp;
int    t_fg = 0;
signed long inte;

#define GD_CLASS_NAME() bignum
#define GD_OBJ_TYPE struct bignum_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))

GD_USE_CLASS(byte__string);
GD_USE_CLASS(bignum);

GD_OBJ_TYPE {
  struct data_object_method_table *method_table;
  unsigned long index;
  q *body;
};

#include <klic/gd_macro.h>

#define ROUND_UP(size)        (((size)+sizeof(q)-1)/sizeof(q))
#define BIGNUM_OBJ(x)         ((GD_OBJ_TYPE *)(G_FUNCTORP(x)))
#define LIMB_SZ(s)            ((s*BYTES_PER_MP_LIMB+sizeof(q)-1) /sizeof(q))
#define MPINT_SZ()            ((sizeof(MP_INT)+sizeof(q)-1)/sizeof(q))


/* basic method definitions */

GDDEF_GUNIFY()
{
  G_STD_DECL;

  if (GD_SELF->method_table != GD_OTHER->method_table ||
      !mpz_cmp((MP_INT *)(GD_SELF->body),(MP_INT *)(GD_OTHER->body)))
    GD_GUNIFY_FAIL;
  GD_GSUCCEED;
}


GDDEF_UNIFY()
{
  G_STD_DECL;

  if (GD_SELF->method_table != GD_OTHER->method_table ||
      !mpz_cmp((MP_INT *)(GD_SELF->body),(MP_INT *)(GD_OTHER->body))) 
    GD_UNIFY_FAIL;
  GD_RETURN;
}


GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;
  long qsize;
  mp_size i, abs_size;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  qsize = GD_SELF->index;

  if ((g_allocp+qsize) > real_heaplimit) 
          fatal("Not enough space collected");

  newself->body   = g_allocp;
  ((mp_ptr)((MP_INT*)(newself->body))->d) = g_allocp + MPINT_SZ();
  g_allocp += qsize;
  newself->index = qsize;
  ((MP_INT*)(newself->body))->alloc = ((MP_INT*)(GD_SELF->body))->alloc;
  ((MP_INT*)(newself->body))->size  = ((MP_INT*)(GD_SELF->body))->size;

  abs_size = ABS(((MP_INT*)(newself->body))->size);
  for (i = 0; i < abs_size; i++)
      (((mp_ptr)((MP_INT*)(newself->body))->d))[i] = 
      (((mp_ptr)((MP_INT*)(GD_SELF->body))->d))[i];
  
  GD_RETURN_FROM_GC(newself);
}

#ifdef DIST

q *decode_bignum();

GDDEF_ENCODE()
{
  G_STD_DECL;
  long size;
  int *int_buf; 
  MP_INT *self;
  mp_size i, abs_size;

  size = GD_SELF->index;
  self = (MP_INT *)GD_SELF->body;
  abs_size  = ABS(self->size);
  PUT_BUFFER(node, decode_bignum);
  PUT_BUFFER(node, size);
  
  PUT_BUFFER(node, self->alloc);
  PUT_BUFFER(node, self->size);

  for(i=0; i<abs_size; i++) {
    PUT_BUFFER(node, ((mp_ptr)(self->d))[i]);
  }

  return(GENERIC_SUCCEEDED);
}
#endif
 
  
/*  Generic Method Table */
GDDEF_GENERIC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newobj;
  long     size;
  extern q convert_c_string_to_klic_string();
  int      result_int;
  size_t   strSize;
  MP_INT   *self, *result;
  unsigned long result_index;
  long     s;
  char     *buf;
  q        str;

  self = (MP_INT *)(GD_SELF->body);

  GD_SWITCH_ON_METHOD {
   default:

    GDSET_NEWOBJ(newobj);

    GD_SWITCH_ON_ARITY {
            
    case 1: {
      result_index = 0;
      
      GD_SWITCH_ON_METHOD {

      /* PORTRAY */
      GD_METHOD_CASE_DIRECT(portray_1):
        strSize = mpz_sizeinbase(self,10);
        GD_ALLOC_AREA(buf,(char *),ROUND_UP(strSize)); 
        mpz_get_str(buf,10,self);
        str = convert_c_string_to_klic_string(buf,g_allocp);
	g_allocp = heapp;
	GD_UNIFY(GD_ARGV[result_index], str);
	GD_RETURN;

      /* NEGATE */
      GD_METHOD_CASE_DIRECT(negate_1):
        mpz_neg(&temp,self);
	goto apply_2;          

      /* ABSOLUTE */
      GD_METHOD_CASE_DIRECT(absolute_1):
        mpz_abs(&temp,self);
	goto apply_2;          

      /* CONVERT to INTEGER */
      GD_METHOD_CASE_DIRECT(cvint_1):
        inte = mpz_get_si(self);
        GD_UNIFY(GD_ARGV[result_index],
                 G_MAKEINT(inte));
        GD_RETURN;

      /* COPY */
      GD_METHOD_CASE_DIRECT(copy_1):
	s = ABS(self->size);
	goto apply_3;

	GD_METHOD_CASE_DEFAULT;
      }
    }

    case 2: {

      signed long c_int;
      q another = GD_ARGV[0];
      MP_INT    *another_body;
      GD_DEREF(another);

      result_index = 1;

      if (!isfunctor(another)) {
	    GDSET_INTARG(c_int,another);
            GD_SWITCH_ON_METHOD {

              /* POWER */ 
 	      GD_METHOD_CASE_DIRECT(power_2):
                if (c_int < 0) 
        	  GD_FAIL("Illegal argument in bignum object method (power).");
                mpz_pow_ui(&temp,self,(unsigned long)c_int);
	        goto apply_2;

             /* ADD */
	     GD_METHOD_CASE_DIRECT(add_2):
                if (c_int < 0) {
		  mpz_sub_ui(&temp,self,(unsigned long)(c_int * -1));
	        } else {
                  mpz_add_ui(&temp,self,(unsigned long)c_int);
		}
	        goto apply_2;

             /* SUBTRACT */
	     GD_METHOD_CASE_DIRECT(subtract_2):
                if (c_int < 0) {
                  mpz_add_ui(&temp,self,(unsigned long)(c_int * -1));
	        } else {
                  mpz_sub_ui(&temp,self,(unsigned long)c_int);
		}
	        goto apply_2;

             /* MULTIPLY */
	     GD_METHOD_CASE_DIRECT(multiply_2):
                if (c_int < 0) {
		  mpz_mul_ui(&temp,self,(unsigned long)(c_int * -1));
	          mpz_neg(&temp,&temp);
                } else {
                  mpz_mul_ui(&temp,self,(unsigned long)c_int);
	        }
	        goto apply_2;

             /* DIVIDE */
	     GD_METHOD_CASE_DIRECT(divide_2):
                if (c_int < 0) {
                  mpz_div_ui(&temp,self,(unsigned long)(c_int * -1));
		  mpz_neg(&temp,&temp);
		} else {
                  mpz_div_ui(&temp,self,(unsigned long)c_int);
		}
	        goto apply_2;

             /* MODULO */
	     GD_METHOD_CASE_DIRECT(modulo_2):
                if (c_int < 0) {
                  mpz_mod_ui(&temp,self,(unsigned long)(c_int * -1));
  	        } else {
                  mpz_mod_ui(&temp,self,(unsigned long)c_int);
		}
	        goto apply_2;

             /* COMPARE */
	     GD_METHOD_CASE_DIRECT(compare_2):
	        result_int = mpz_cmp_si(self,c_int);
	        GD_UNIFY(GD_ARGV[result_index], 
                G_MAKEINT((unsigned long)result_int));  
	        GD_RETURN;

              GD_METHOD_CASE_DEFAULT;
	    }
      }

      if (!isfunctor(another) ||
	  ((GD_OBJ_TYPE*)functorp(another))->method_table !=
 	  GD_SELF->method_table) {
	GD_FAIL("Illegal argument in bignum object method.");
      }

      another_body = (MP_INT *)(((GD_OBJ_TYPE *)functorp(another))->body);

      GD_SWITCH_ON_METHOD {

        /* ADD */
	GD_METHOD_CASE_DIRECT(add_2):
          mpz_add(&temp,self,another_body);
	  goto apply_2;

        /* SUBTRACT */
	GD_METHOD_CASE_DIRECT(subtract_2):
          mpz_sub(&temp,self,another_body);
	  goto apply_2;

        /* MULTIPLY */
	GD_METHOD_CASE_DIRECT(multiply_2):
          mpz_mul(&temp,self,another_body);
	  goto apply_2;

        /* DIVIDE */
	GD_METHOD_CASE_DIRECT(divide_2):
          mpz_div(&temp,self,another_body);
	  goto apply_2;

        /* MODULO */
	GD_METHOD_CASE_DIRECT(modulo_2):
          mpz_mod(&temp,self,another_body);
	  goto apply_2;

        /* GCD */
	GD_METHOD_CASE_DIRECT(gcd_2):
          mpz_gcd(&temp,self,another_body);
	  goto apply_2;

        /* COMPARE */
	GD_METHOD_CASE_DIRECT(compare_2):
	  result_int = mpz_cmp(self,another_body);
	  GD_UNIFY(GD_ARGV[result_index], 
                G_MAKEINT((unsigned long)result_int));  

	GD_METHOD_CASE_DEFAULT;
      }
      break;
    }
      GD_METHOD_CASE_DEFAULT;
    }
  }

  GD_RETURN;

apply_2:
  s = ABS(temp.size);

apply_3:
  GD_ALLOC_AREA(result,(MP_INT*),MPINT_SZ());
  GD_ALLOC_AREA(result->d,(mp_ptr),LIMB_SZ(s));
  mpz_set_klic(result,&temp);
  size = MPINT_SZ() + LIMB_SZ(s);
  newobj->body = (q *)result;
  newobj->index = size;
  GD_UNIFY(GD_ARGV[result_index], makefunctor(newobj));
  GD_RETURN;

}


/* guard generic methods */
GDDEF_GMETHOD(bignum_0)
{
  G_STD_DECL;
  GD_GSUCCEED;          
}


#define COMPARE_METHOD(comparison)                               \
{                                                                \
  G_STD_DECL;                                                    \
  q otherq   = GD_ARGV[0];                                       \
  GD_OBJ_TYPE   *other;                                          \
  MP_INT *self, *theother;                                       \
  signed long int thelong;                                       \
  int  flag;                                                     \
                                                                 \
  if (G_ISGOBJ(otherq)) {                                        \
								 \
    other = (GD_OBJ_TYPE *)G_FUNCTORP(otherq);                   \
    if (other->method_table != GD_SELF->method_table) GD_GFAIL;  \
    self = (MP_INT *)(GD_SELF->body);                            \
    theother = (MP_INT *)(other->body);                          \
    flag = mpz_cmp(self,theother);                               \
    if (comparison) GD_GSUCCEED;                                 \
    GD_GFAIL;                                                    \
                                                                 \
  } else if (G_ISINT(otherq)) {                                  \
								 \
    thelong = (signed long int)G_INTVAL(otherq);                 \
    self = (MP_INT *)(GD_SELF->body);                            \
    flag = mpz_cmp_si(self,thelong);                             \
    if (comparison) GD_GSUCCEED;                                 \
    GD_GFAIL;                                                    \
                                                                 \
  } else {                                                       \
    GD_GFAIL;                                                    \
  }                                                              \
}


GDDEF_GMETHOD(less__than_1)
{ COMPARE_METHOD((flag < 0)); }

GDDEF_GMETHOD(greater__than_1)
{ COMPARE_METHOD((flag > 0)); }

GDDEF_GMETHOD(equal_1)
{ COMPARE_METHOD((flag == 0)); }


GDDEF_GGENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(less__than_1);
    GD_GMETHOD_CASE(greater__than_1);
    GD_GMETHOD_CASE(equal_1);
    GD_GMETHOD_CASE(bignum_0);
    GD_GMETHOD_CASE_DEFAULT;
  }
}


GDDEF_PRINT()
{
  G_STD_DECL;

  mpz_out_str(g_fp,10,(MP_INT *)(GD_SELF->body));
  GD_RETURN_FROM_PRINT;
}


#define GDUSE_MY_GUNIFY
#define GDUSE_MY_UNIFY
#define GDUSE_MY_PRINT
#define GDUSE_MY_GC
#define GDUSE_MY_GENERIC
#define GDUSE_MY_GGENERIC
#ifdef DIST
#define GDUSE_MY_ENCODE
#endif

#include <klic/gd_methtab.h>

/*  new_bignum function */
GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  GD_OBJ_TYPE *newobj;

  q      init = GD_ARGV[0];
  MP_INT *integ;
  long   size;
  long   input_int;

  temp_init();

  GD_DEREF_FOR_NEW(init);
  GDSET_NEWOBJ_FOR_NEW(newobj,G_SIZE_IN_Q(GD_OBJ_TYPE));

  if ( G_ISGOBJ(init) &&
      (struct data_object_method_table *) G_FUNCTOR_OF(init)
      == &byte__string_g_data_method_table ) {

    extern unsigned char *generic_string_body();
    mpz_set_str(&temp,generic_string_body(G_FUNCTORP(init)),10);

  } else if (G_ISINT(init)) { 
    GDSET_INTARG_FOR_NEW(input_int, init);
    mpz_set_si(&temp,(signed long int)input_int);

  } else {
    GD_ERROR_IN_NEW("Bignum: Byte string or integer"); 
  }   

  size = ABS(temp.size);
  GD_ALLOC_AREA_FOR_NEW(integ,(MP_INT*),MPINT_SZ());
  GD_ALLOC_AREA_FOR_NEW(integ->d,(mp_ptr),LIMB_SZ(size));
  mpz_set_klic(integ,&temp);
  newobj->index = MPINT_SZ() + LIMB_SZ(size) ;
  newobj->body = (q *)integ;

  GD_RETURN_FROM_NEW(newobj);
}

int mpz_set_klic(to,from)
MP_INT *to, *from;
{
  mp_size i, abs_size;

  abs_size  = ABS(from->size);
  to->alloc = from->alloc;
  to->size  = from->size;

  for (i = 0; i < abs_size; i++)
      ((mp_ptr)(to->d))[i] = ((mp_ptr)(from->d))[i];
}


int temp_init()
{
  if (t_fg == 1) return;
  mpz_init(&temp);
/*
  mp_set_memory_functions(&_mp_klic_allocate,
                          &_mp_klic_reallocate,
                          _mp_klic_free);
*/
  t_fg = 1;
}


#ifdef DIST
q *decode_bignum(inbuf, g_allocp)
     long inbuf[];
     q *g_allocp;
{
  G_STD_DECL;
  GD_OBJ_TYPE *newbignum;
  MP_INT      *body;
  mp_size     abs_size, k;

  G_HEAPALLOC(newbignum, G_SIZE_IN_Q(GD_OBJ_TYPE), (GD_OBJ_TYPE *));
  newbignum->method_table = &GD_method_table;
  newbignum->index = (unsigned long)inbuf[inbuf_index++];

  G_HEAPALLOC(body,MPINT_SZ(),(MP_INT *));
  body->alloc = (long int)inbuf[inbuf_index++];
  body->size  = (long int)inbuf[inbuf_index++];
  abs_size = ABS(body->size);

  G_HEAPALLOC(body->d,LIMB_SZ(abs_size),(mp_ptr));
  for(k=0; k<abs_size; k++) {
    ((mp_ptr)(body->d))[k] = (mp_limb)inbuf[inbuf_index++];
  }
  
  newbignum->body = (q*)body;
  decode_data = (q)makefunctor(newbignum);
  return(g_allocp);
}
#endif


/* for Klic allocation functions. */

void *
#if __STDC__
_mp_klic_allocate (size_t size)
#else
_mp_klic_allocate (size)
     size_t size;
#endif
{
  void *ret;

  ret = malloc (size);
  if (ret == 0)
    {
      perror ("cannot allocate in libmp");
      exit(-1);
    }

  return ret;    
}


void *
#if __STDC__
_mp_klic_reallocate (void *oldptr, size_t old_size, size_t new_size)
#else
_mp_klic_reallocate (oldptr, old_size, new_size)
     void *oldptr;
     size_t old_size;
     size_t new_size;
#endif
{
  void *ret;

  ret = realloc (oldptr, new_size);
  if (ret == 0)
    {
      perror ("cannot allocate in libmp");
      abort ();
    }

  return ret;             
}


void
#if __STDC__
_mp_klic_free (void *blk_ptr, size_t blk_size)
#else
_mp_klic_free (blk_ptr, blk_size)
     void *blk_ptr;
     size_t blk_size;
#endif
{

}
