/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*------------------------------------------------------------

      HMM Specification
          hmnet.node[].pos_depth : hmnsteps()
	  hmnet.node[].pos_width : 
	  hmnet.arc[].link       : count_arcs()
	  hmnet.node[].arcsOutNum:

------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "defs.h"
#include "e_struct.h"

/* #define DEBUG_nodepos */
/* #define DEBUG_arcA */
/* #define DEBUG_arcB */
/* #define DEBUG_serialA */
/* #define DEBUG_arc */
/* #define DEBUG_trace */

watchhmn()
{
  check_selfloop();
  count_arcs();     /* node[].arcsIn/Out, serial_arc[].from/to (temporal), 
                       arcnum */
  trace_arcs();     /* arc[][].pos_width */
  count_steps_a();
  count_steps_b();
  solve_node_depth();

  set_arc_pos();    /* depth, arc[][].pos_depth, serial_arc[].from/to */
  set_node_pos();   /* node[].pos_depth/width */
}

/*==============================================================*/
count_arcs()
{
  int i,j;

  for(i=0;i<hmnet.nodenum;i++) {
    hmnet.node[i].arcsInNum = 0;
    hmnet.node[i].arcsOutNum = 0;
  }

  hmnet.arcnum = 0;
  for(i=0;i<hmnet.nodenum;i++) {
    for(j=0;j<hmnet.nodenum;j++) {
      if (hmnet.arc[i][j].link==LINK) {
	hmnet.serial_arc[hmnet.arcnum].from = i;
	hmnet.serial_arc[hmnet.arcnum].to = j;
	hmnet.arcnum++;
	hmnet.node[i].arcsOutNum++;
	hmnet.node[j].arcsInNum++;
      }
    }
  }
}

/*==============================================================*/
count_steps_a()
{
  int qs,startN,i,j,num,p;
  int processedArc;

  /* Clear */
  for(i=0;i<hmnet.nodenum;i++)
    hmnet.node[i].steps_a = NOASSIGNED;
  for(i=0;i<hmnet.nodenum;i++) {
    for(j=0;j<hmnet.nodenum;j++) {
      hmnet.arc[i][j].steps_a = NOASSIGNED;
    }
  }

  /* Initial Arcs */
  processedArc = 0;
  num = 0;
  for(qs=0;qs<hmnet.initStateNumber;qs++) {
    startN = hmnet.initialState[qs];
    hmnet.node[startN].steps_a = num;
    for(j=0;j<hmnet.nodenum;j++) {
      if(hmnet.arc[startN][j].link == LINK) {
	hmnet.arc[startN][j].steps_a = num+1;
	processedArc++;
	hmnet.node[j].steps_a = num+1;
      }
    }
  }

  /* Transient Arcs */  
  while(processedArc < hmnet.arcnum && num <= hmnet.nodenum) {
    if (num++ > hmnet.nodenum) {
      printf("Perhaps several nodes are out of connection.\n");
      exit(0);
    }
    for(i=0;i<hmnet.nodenum;i++) {
      for(j=0;j<hmnet.nodenum;j++) {
	if(hmnet.arc[i][j].link == LINK) {
	  if(i==j||hmnet.node[i].steps_a != num-1) continue;
	  if(hmnet.arc[i][j].steps_a == NOASSIGNED) {
	    hmnet.arc[i][j].steps_a = num;
	    hmnet.node[j].steps_a = num;
	    processedArc++;
	  }
	} /* if-link */
      } /* j-Loop */
    } /* i-Loop */
  } /* num-Loop */

#ifdef DEBUG_arcA
  printf("DBARCA Total = %d\n",hmnet.arcnum);
  for(p=0;p<hmnet.arcnum;p++) {
    i=hmnet.serial_arc[p].from;
    j=hmnet.serial_arc[p].to;
    if(i == j) continue;
    printf("DBARCA           %d-%d: %d\n",i,j,hmnet.arc[i][j].steps_a);
  }
#endif
}

count_steps_b()
{
  int qs,i,j,num,p;
  int processedArc;

  /* Clear */
  for(i=0;i<hmnet.nodenum;i++)
    hmnet.node[i].steps_b = NOASSIGNED;
  for(i=0;i<hmnet.nodenum;i++) {
    for(j=0;j<hmnet.nodenum;j++) {
      hmnet.arc[i][j].steps_b = NOASSIGNED;
    }
  }

  /* Terminal Node */
  num = 0;
  processedArc = 0;
  hmnet.node[TERMINALSTATE].steps_b = num;

  /* Transient Arcs */  
  while(processedArc < hmnet.arcnum && num <= hmnet.nodenum) {
    if (num++ > hmnet.nodenum) {
      printf("Perhaps several nodes are out of connection.\n");
      exit(0);
    }
    for(j=0;j<hmnet.nodenum;j++) {
      for(i=0;i<hmnet.nodenum;i++) {
	if(hmnet.arc[i][j].link == LINK) {
	  if(i==j||hmnet.node[j].steps_b != num-1) continue;
	  if(hmnet.arc[i][j].steps_b == NOASSIGNED) {
	    hmnet.arc[i][j].steps_b = num;
	    processedArc++;
	    hmnet.node[i].steps_b = num;
	  }
	} /* if-link */
      } /* i-Loop */
    } /* j-Loop */
  } /* num-Loop */

#ifdef DEBUG_arcB
  printf("DBARCB Total = %d\n",hmnet.arcnum);
  for(p=0;p<hmnet.arcnum;p++) {
    i=hmnet.serial_arc[p].from;
    j=hmnet.serial_arc[p].to;
    if(i == j) continue;
    printf("DBARCB           %d-%d: %d\n",i,j,hmnet.arc[i][j].steps_b);
  }
#endif
}

/*==============================================================*/
solve_node_depth()
{
  int i,j,p,qs;
  int num,idepth;

  /* measure (max) depth */
  hmnet.depth = 0;
  for(p=0;p<hmnet.arcnum;p++) {
    i = hmnet.serial_arc[p].from;
    j = hmnet.serial_arc[p].to;
    if(i != j) {
      idepth = hmnet.arc[i][j].steps_a + hmnet.arc[i][j].steps_b;
      if(idepth > hmnet.depth) hmnet.depth = idepth;
    }
  }

  num = 1;
  /* Clear */
  for(p=0;p<hmnet.arcnum;p++) {
    hmnet.serial_arc[p].from_pos_f = NOASSIGNED;
    hmnet.serial_arc[p].from_pos_t = NOASSIGNED;
    hmnet.serial_arc[p].to_pos_f = NOASSIGNED;
    hmnet.serial_arc[p].to_pos_t = NOASSIGNED;
  }

  /* Initial Nodes */
  for(qs=0;qs<hmnet.initStateNumber;qs++) {
    for(p=0;p<hmnet.arcnum;p++) {
      i=hmnet.serial_arc[p].from;
      j=hmnet.serial_arc[p].to;
      if(i == j) continue;
      if(hmnet.serial_arc[p].from == hmnet.initialState[qs]) {
	hmnet.serial_arc[p].from_pos_f = num;
	hmnet.serial_arc[p].from_pos_t = num;
      }
    }
  }

  /* Terminal Node */
  for(p=0;p<hmnet.arcnum;p++) {
    i=hmnet.serial_arc[p].from;
    j=hmnet.serial_arc[p].to;
    if(i == j) continue;
    if(hmnet.serial_arc[p].to == TERMINALSTATE) {
      hmnet.serial_arc[p].to_pos_t = hmnet.depth;
    }
  }

  /* Transient: steps */
  for(p=0;p<hmnet.arcnum;p++) {
    i=hmnet.serial_arc[p].from;
    j=hmnet.serial_arc[p].to;
    if(i == j) continue;
    if(hmnet.serial_arc[p].from_pos_f == NOASSIGNED ||
       hmnet.serial_arc[p].from_pos_f < hmnet.arc[i][j].steps_a) 
       hmnet.serial_arc[p].from_pos_f = hmnet.arc[i][j].steps_a;
    if(hmnet.serial_arc[p].to_pos_f  == NOASSIGNED ||
       hmnet.serial_arc[p].to_pos_f < hmnet.arc[i][j].steps_a +1) 
       hmnet.serial_arc[p].to_pos_f = hmnet.arc[i][j].steps_a +1;
    if(hmnet.serial_arc[p].from_pos_t == NOASSIGNED ||
       hmnet.serial_arc[p].from_pos_t > hmnet.depth - hmnet.arc[i][j].steps_b) 
       hmnet.serial_arc[p].from_pos_t = hmnet.depth - hmnet.arc[i][j].steps_b;
    if(hmnet.serial_arc[p].to_pos_t == NOASSIGNED ||
       hmnet.serial_arc[p].to_pos_t > hmnet.depth - hmnet.arc[i][j].steps_b+1) 
       hmnet.serial_arc[p].to_pos_t = hmnet.depth - hmnet.arc[i][j].steps_b+1;
  }

#ifdef DEBUG_serialA
  for(p=0;p<hmnet.arcnum;p++) {
    i=hmnet.serial_arc[p].from;
    j=hmnet.serial_arc[p].to;
    if(i == j) continue;
    printf("DBSA %d-%d: (%d-%d, %d-%d)\n",i,j,
	   hmnet.serial_arc[p].from_pos_f,
	   hmnet.serial_arc[p].from_pos_t,
	   hmnet.serial_arc[p].to_pos_f,
	   hmnet.serial_arc[p].to_pos_t);
  }
#endif
}

/*==============================================================*/
set_arc_pos()
{
  int i,j,p,q,it,jt;
  int num;
  int node_in[NODEMAX],node_out[NODEMAX];

  /* set arc pos_depth */
  for(p=0;p<hmnet.arcnum;p++) {
    i = hmnet.serial_arc[p].from;
    j = hmnet.serial_arc[p].to;
    if(hmnet.arc[i][j].steps_a < hmnet.arc[i][j].steps_b)
      hmnet.arc[i][j].pos_depth = hmnet.arc[i][j].steps_a;
    else if(hmnet.arc[i][j].steps_a == hmnet.arc[i][j].steps_b)
      hmnet.arc[i][j].pos_depth = (hmnet.depth+1)/2;
    else if(i == j)
      hmnet.arc[i][j].pos_depth = hmnet.depth - hmnet.arc[i][j].steps_b +1;
    else 
      hmnet.arc[i][j].pos_depth = hmnet.depth - hmnet.arc[i][j].steps_b;
  }

  /* sort arc queue */ /* tentative */
  for(p=0;p<hmnet.arcnum-1;p++) {
    i = hmnet.serial_arc[p].from;
    j = hmnet.serial_arc[p].to;
    for(q=p+1;q<hmnet.arcnum;q++) {
      it = hmnet.serial_arc[q].from;
      jt = hmnet.serial_arc[q].to;

      if(hmnet.arc[i][j].pos_depth > hmnet.arc[it][jt].pos_depth) 
	sp_swap(p,q);
    }
  }

  /* write arcs in/out */
  for(i=0;i<hmnet.nodenum;i++) node_out[i] = 0;
  for(i=0;i<hmnet.nodenum;i++) node_in[i] = 0;
  for(p=0;p<hmnet.arcnum;p++) {
    i = hmnet.serial_arc[p].from;
    j = hmnet.serial_arc[p].to;

    hmnet.node[i].arcsOut[node_out[i]++] = p;
    hmnet.node[j].arcsIn[node_in[j]++] = p;
  }

#ifdef DEBUG_arc /* sorted numbering */
  for(p=0;p<hmnet.arcnum;p++) {
    if(hmnet.serial_arc[p].from != hmnet.serial_arc[p].to)
    printf("DBAC %d: %d-%d (%d)\n",p,hmnet.serial_arc[p].from,
	hmnet.serial_arc[p].to,
	hmnet.arc[hmnet.serial_arc[p].from][hmnet.serial_arc[p].to].pos_depth);
  }
  for(i=0;i<hmnet.nodenum;i++) {
    printf("DBACN %d: IN: ",i);
    for(j=0;j<hmnet.node[i].arcsInNum;j++)
      printf("%d ",hmnet.node[i].arcsIn[j]);
    printf("OUT: ");
    for(j=0;j<hmnet.node[i].arcsOutNum;j++)
      printf("%d ",hmnet.node[i].arcsOut[j]);
    printf("\n");
  }
#endif

}

/*==============================================================*/
set_node_pos()
{
  int i,j,p,q,r,idepth,iwidth,qs,d,w;
  struct {
    int from;
    int to;
  } fpos[NODEMAX],tpos[NODEMAX];

  /* ================== */
  /* clear              */
  /* ================== */
  for(i=0;i<hmnet.nodenum;i++) {
    hmnet.node[i].pos_depth = NOASSIGNED;
    hmnet.node[i].pos_width = NOASSIGNED;
    fpos[i].from = NOASSIGNED;
    fpos[i].to   = NOASSIGNED;
    tpos[i].from = NOASSIGNED;
    tpos[i].to   = NOASSIGNED;
  }
  for(i=1;i<hmnet.depth;i++) {
    hmndisp.depth[i].width = 1;
    for(j=1;j<hmnet.nodenum;j++)
      hmndisp.depth[i].node[j] = NOASSIGNED;
  }

  /* ================== */
  /* set node pos_depth */
  /* ================== */
  for(qs=0;qs<hmnet.initStateNumber;qs++) {
    i = hmnet.initialState[qs];
    fpos[i].from = 1;
    fpos[i].to   = 1;
  }
  for(i=0;i<hmnet.nodenum;i++) {
    for(p=0;p<hmnet.arcnum;p++) {
      if(hmnet.serial_arc[p].from == i) {
	if(fpos[i].from == NOASSIGNED ||
	   (fpos[i].from <= hmnet.serial_arc[p].from_pos_f &&
	    fpos[i].to   >= hmnet.serial_arc[p].from_pos_t)) {
	  fpos[i].from = hmnet.serial_arc[p].from_pos_f;
	  fpos[i].to   = hmnet.serial_arc[p].from_pos_t;
	}
      }
    } /* loop p end */
  } /* loop i end (1-f)*/
  for(i=0;i<hmnet.nodenum;i++) {
    for(p=0;p<hmnet.arcnum;p++) {
      if(hmnet.serial_arc[p].to == i) {
	if(tpos[i].from == NOASSIGNED ||
	   (tpos[i].from <= hmnet.serial_arc[p].to_pos_f &&
	    tpos[i].to   >= hmnet.serial_arc[p].to_pos_t)) {
	  tpos[i].from = hmnet.serial_arc[p].to_pos_f;
	  tpos[i].to   = hmnet.serial_arc[p].to_pos_t;
	}
      }
    } /* loop p end */
  } /* loop i end (1-t)*/

#ifdef DEBUG_nodepos
  for(i=0;i<hmnet.nodenum;i++) {
    printf("DBNDP %d: %d-%d / %d-%d\n",i,
	   fpos[i].from,fpos[i].to,tpos[i].from,tpos[i].to);
  }
#endif

  for(i=0;i<hmnet.nodenum;i++) {
    if(i == TERMINALSTATE) continue;
    if(fpos[i].from <= tpos[i].from && tpos[i].to <= fpos[i].to)
      hmnet.node[i].pos_depth = tpos[i].from;
    else 
      hmnet.node[i].pos_depth = fpos[i].from;
  } /* loop i end (2)*/

  /* ============== */
  /* estimate width */
  /* ============== */
  for(i=0;i<hmnet.nodenum;i++) {
    if(i == TERMINALSTATE) continue;
    idepth = hmnet.node[i].pos_depth;
    iwidth = hmndisp.depth[idepth].width++;
    hmndisp.depth[idepth].node[iwidth] = i;
  }
  hmndisp.maxdepth = 0;
  for(i=0;i<hmnet.nodenum;i++) {
    if(i == TERMINALSTATE) continue;
    if(hmndisp.maxdepth < hmnet.node[i].pos_depth)
      hmndisp.maxdepth = hmnet.node[i].pos_depth;
  }
  hmndisp.maxdepth++;

  /* ================== */
  /* put terminal state */
  /* ================== */
  hmnet.node[TERMINALSTATE].pos_depth = hmndisp.maxdepth;
  hmnet.node[TERMINALSTATE].pos_width = 1;
  hmndisp.depth[hmndisp.maxdepth].node[1] = TERMINALSTATE;
  hmndisp.depth[hmndisp.maxdepth].width = 2;

#ifdef DEBUG_nodepos
  for(d=1;d<=hmndisp.maxdepth;d++) {
    printf("DBNWD %d",d);
    for(w=1;w<hmndisp.depth[d].width;w++)
      printf(" %d:%d,",w,hmndisp.depth[d].node[w]);
    printf("\n");
  }
#endif

  /* ================== */
  /* set node pos_width */
  /* ================== */
  for(d=1;d<hmnet.depth;d++) {
    for(w=1;w<hmndisp.depth[d].width;w++) {
      i = hmndisp.depth[d].node[w];
      hmnet.node[i].pos_width = w;
    }
  }

  for(p=0;p<hmnet.arcnum;p++) {
    i=hmnet.serial_arc[p].from;
    j=hmnet.serial_arc[p].to;
    if(hmnet.node[i].pos_depth +1 < hmnet.node[j].pos_depth) {
      d = hmnet.node[j].pos_depth;
      w = hmnet.node[j].pos_width;
      hmndisp.depth[d].node[w] = NOASSIGNED; 
      hmnet.node[j].pos_width = hmndisp.depth[d].width++;
    }
  }

  /* ========= */
  /* set width */
  /* ========= */
  for(d=1;d<hmndisp.maxdepth;d++) {
    if(hmnet.width < hmndisp.depth[d].width)
      hmnet.width = hmndisp.depth[d].width;
  }
}

/*==============================================================*/
static int routenum;

trace_arcs()
{
  int i,j,qs;

  for(i=0;i<hmnet.nodenum;i++) {
    for(j=0;j<hmnet.nodenum;j++) {
      hmnet.arc[i][j].pos_width = NOASSIGNED;
    }
  }

  /* Initial Nodes */
  routenum = hmnet.initStateNumber+1;
  for(qs=0;qs<hmnet.initStateNumber;qs++) {
    in_trace_arcs(hmnet.initialState[qs],qs+1);
  }
  hmnet.width = routenum-1;
}

in_trace_arcs(node, routemain)
int node, routemain;
{
  int i,j,flag;

  flag = OFF;
  for(j=0;j<hmnet.nodenum;j++) {
    if(hmnet.arc[node][j].link == LINK && node != j) {
      if(hmnet.arc[node][j].pos_width == NOASSIGNED) {
	if(flag == OFF) {
#ifdef DEBUG_trace
	  printf("DBTR %d-%d, %d\n", node, j, routemain);
#endif
	  hmnet.arc[node][j].pos_width = routemain;
	  in_trace_arcs(j,routemain);
	  flag = ON;
	} else {
#ifdef DEBUG_trace
	  printf("DBTR %d-%d, %d\n", node, j, routenum);
#endif
	  hmnet.arc[node][j].pos_width = routenum;
	  in_trace_arcs(j,routenum);
	  routenum++;
	}
      } else {
	return;
      }
    }
  }
}

sp_swap(p,q)
int p,q;
{
  int temp;

  temp = hmnet.serial_arc[p].from;
  hmnet.serial_arc[p].from = hmnet.serial_arc[q].from;
  hmnet.serial_arc[q].from = temp;

  temp = hmnet.serial_arc[p].from_pos_f;
  hmnet.serial_arc[p].from_pos_f = hmnet.serial_arc[q].from_pos_f;
  hmnet.serial_arc[q].from_pos_f = temp;

  temp = hmnet.serial_arc[p].from_pos_t;
  hmnet.serial_arc[p].from_pos_t = hmnet.serial_arc[q].from_pos_t;
  hmnet.serial_arc[q].from_pos_t = temp;
	
  temp = hmnet.serial_arc[p].to;
  hmnet.serial_arc[p].to = hmnet.serial_arc[q].to;
  hmnet.serial_arc[q].to = temp;

  temp = hmnet.serial_arc[p].to_pos_f;
  hmnet.serial_arc[p].to_pos_f = hmnet.serial_arc[q].to_pos_f;
  hmnet.serial_arc[q].to_pos_f = temp;

  temp = hmnet.serial_arc[p].to_pos_t;
  hmnet.serial_arc[p].to_pos_t = hmnet.serial_arc[q].to_pos_t;
  hmnet.serial_arc[q].to_pos_t = temp;
}

check_selfloop()
{
  int i;

  for(i=0;i<hmnet.nodenum;i++) {
    if(hmnet.arc[i][i].link == LINK)
      hmnet.node[i].selfloop = ON;
    else
      hmnet.node[i].selfloop = OFF;
  }
}

/* end of file */

