/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* HMM Parameters */

struct {
       int trans[NODEMAX][NODEMAX];   /* a_ij: i->j transition probability */
       int output[NODEMAX][NODEMAX][AMINOS];
               /*  b_ij(f(X))={work_log.b_output[][][X]|X in amino acids}   */
       int alpha[SAMPLEMAX][NODEMAX][TIMEMAX]; /* alpha_it: forward path   */
       int beta[SAMPLEMAX][NODEMAX][TIMEMAX];  /* beta_it: backward path   */
       } work_log;
/* 
(Forward-Backward (Baum-Welch)$BMQ(B)
alpha[s][i][t]: $B%5%s%W%kNs(B s $B$K$*$$$F;~9o(B 0 $B$+$i(B t $B$^$G$K3+;O>uBV$+$i(B
                y_1y_2y_3...y_t $B$r=PNO$7$F>uBV(B i $B$KC#$9$k3NN((B

beta[s][i][t]:  $BD9$5(B T $B$N%5%s%W%kNs(B s $B$K$*$$$F!">uBV(B i $B$+$i%9%?!<%H$7$F(B
                $B;~9o(B t $B$+$i(B T $B$^$G$K(B y_t+1....y_T $B$r=PNO$7$F:G=*>uBV$K(B
                $BC#$9$k3NN((B
*/

/* Network Properties */
char hmnfilename[256];
char savefilename[256];
struct {
  int nodenum;                            /* Node $BAm?t(B */
  int arcnum;                              /* Arc $BAm?t(B */
  int initStateNumber;              /* Start Node $BAm?t(B */
  int initialState[NODEMAX];             /* Start Node */
  float initialProb[NODEMAX];          /* $B=i4|0LCV3NN((B */
  int depth;                           /* $B%M%C%H1|9T$-(B */
  int width;                               /* $B%M%C%HI}(B */
  struct {
    int arcsOutNum;          /* $B%N!<%I$+$i=P$k%j%s%/?t(B */
    int arcsOut[NODEMAX];
    int arcsInNum;             /* $B%N!<%I$KF~$k%j%s%/?t(B */
    int arcsIn[NODEMAX];
    int steps_a;          /* $B%N!<%I$N(B start $B$+$i$N5wN%(B */
    int steps_b;            /* $B%N!<%I$N(B end $B$+$i$N5wN%(B */
    int selfloop;                  /* $B<+8J%k!<%W$NM-L5(B */
    int pos_depth;                 /* $B%N!<%I0LCV(B($B1|9T(B) */
    int pos_width;                 /* $B%N!<%I0LCV(B ($BI}(B)  */
    int usage;                   /* $B3F%N!<%I$NMxMQ2s?t(B */
    int profile[AMINOS];   /* $B3F%N!<%I$G$N%"%_%N;@J,I[(B */
  } node[NODEMAX];
  struct {
    int link;                     /* HMNet Link/Nolink */
    int steps_a;          /* $B%"!<%/$N(B start $B$+$i$N5wN%(B */
    int steps_b;            /* $B%"!<%/$N(B end $B$+$i$N5wN%(B */
    int pos_depth;                 /* $B%"!<%/0LCV(B($B1|9T(B) */
    int pos_width;                   /* $B%"!<%/0LCV(B($BI}(B) */
    int queue;                         /* $B%"!<%/$N=gHV(B */
    int usage;                   /* $B3F%"!<%/$NMxMQ2s?t(B */
    int profile[AMINOS];   /* $B3F%"!<%/$G$N%"%_%N;@J,I[(B */
  } arc[NODEMAX][NODEMAX];
  struct {
    int from;
    int to;
    int from_pos_f;  /* $B%"!<%/$N;OE@$N8uJdHO0O(B */
    int from_pos_t;
    int to_pos_f;    /* $B%"!<%/$N=*E@$N8uJdHO0O(B */
    int to_pos_t;
  } serial_arc[NODEMAX*NODEMAX]; /* $B%"!<%/$N=gHV5U0z$-(B */
} hmnet;

/* Display Positions */
struct{
  int maxdepth;
  struct {
    int width;
    int node[NODEMAX]; /* pos_width -> node */
  } depth[NODEMAX];
} hmndisp;

/* Defined in the tool routines */
extern int log_near1();
extern double exp_near1();

/* Initialized in the main routine */
double log_of_near1;

/* Samples */
char read_buf[READBUFSIZE];
char samplefilename[256];
struct {
    int number;
    int length[SAMPLEMAX];
    int usage[AMINOS];        /* $BIQEY(B */
    int usage_log[AMINOS];    /* $B3NN((B(log_near1) */
    char seq[SAMPLEMAX][SAMPLE_LENGTH];          /* '$B%5%s%W%kJ8;z(B'-'A' */
    int path_log[SAMPLEMAX];  /* HMM $B$K$*$1$k3F%5%s%W%k$NDL2a3NN((B(log) */
    int beststates[SAMPLEMAX][TIMEMAX];  /* $B3F%5%s%W%k$N:GL`=PNO>uBVNs(B */
} sample;

int displayNode=1;
int displayArc;

/* Judgement of Splitting */
int splitState;                      /* $BJ,3d%N!<%I(B */
int serial12D, serial21D, parallelD; /* $BJ,3dJ}8~I>2ACM(B */
int splitMode;

/* $B%"%k%4%j%:%`=*N;H=DjMQ(B */
int sumeval;
int split_after = -1;
int maxlength;  /* $BIA2hMQ(B */

int bar_flag = OFF;
int tied_switch = ON;
int statseq_flag = OFF;
int split_flag = OFF;
