/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*------------------------------------------------------------
     Output Distribution Display (Profile/Probability)
     1994.10.18
------------------------------------------------------------*/
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xutil.h>
#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/SeparatoG.h>
#include <Xm/PushBG.h>
#include <Xm/DrawingA.h>

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "defs.h"
#include "e_struct.h"

void redraw2CB();

Widget bb2, wdpile[AMINOS], nmpile[AMINOS], barBody, barFrame, barScore;
Widget stateDisplay, arcDisplay, transDisplay;
XmString stateLabel;
GC gc2;

outputdisplay(top2)
Widget top2;
{
  Arg args[20];
  char name[20], tempLabel[20];
  XmString tempLabelX;
  int i,j,posy,n,s,t,d,a;

   /* Base Window */
   n=0;
   XtSetArg(args[n], XmNwidth, 330);n++;
   XtSetArg(args[n], XmNheight, 360);n++;
   XtSetArg(args[n], XmNresizePolicy, XmRESIZE_GROW);n++;
   bb2 = XmCreateDrawingArea(top2, "bb2", args, n); /* test */
   XtManageChild(bb2);

   /* Graph Names */
   for(a=0,posy=0;a<AMINOS;a++) { 
       if (a==1||a==9||a==14||a==20||a==23||a>24) continue;
       sprintf(name, "pilename%d", posy);
       n=0;
       XtSetArg(args[n], XmNx, posy*15+15);n++;
       XtSetArg(args[n], XmNy, 90);n++;
       XtSetArg(args[n], XmNwidth, 14);n++;
       XtSetArg(args[n], XmNheight, 20);n++;
         sprintf(tempLabel,"%c",'A'+a);
         stateLabel = XmStringCreate(tempLabel,XmSTRING_DEFAULT_CHARSET);
       XtSetArg(args[n], XmNlabelString, stateLabel);n++;
       nmpile[posy] = XmCreateLabel (bb2, name, args, n);
       XtManageChild(nmpile[posy]);
       posy++;
   }

   /* Graph Piles */
  for(displayArc=0;displayArc<hmnet.nodenum;displayArc++)
    if(hmnet.arc[displayNode][displayArc].link==LINK) break;
  make_piles();

  /* State Display */
  n=0;
  XtSetArg(args[n], XmNx, 100);n++;
  XtSetArg(args[n], XmNy, 50);n++;
  XtSetArg(args[n], XmNheight, 24);n++;
  XtSetArg(args[n], XmNwidth, 50);n++;
  sprintf(tempLabel,"%4d",displayNode);
  stateLabel = XmStringCreate(tempLabel,XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, stateLabel);n++;
  stateDisplay = XmCreateLabel (bb2, "stateDisplay", args, n);
  XtManageChild(stateDisplay);

  /* Arc Display */
  n=0;
  XtSetArg(args[n], XmNx, 257);n++;
  XtSetArg(args[n], XmNy, 50);n++;
  XtSetArg(args[n], XmNheight, 24);n++;
  XtSetArg(args[n], XmNwidth, 50);n++;
  sprintf(tempLabel,"%4d",displayArc);
  stateLabel = XmStringCreate(tempLabel,XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, stateLabel);n++;
  arcDisplay = XmCreateLabel (bb2, "arcDisplay", args, n);
  XtManageChild(arcDisplay);

  /* Trans Display */
  n=0;
  XtSetArg(args[n], XmNx, 155);n++;
  XtSetArg(args[n], XmNy, 25);n++;
  XtSetArg(args[n], XmNheight, 24);n++;
  XtSetArg(args[n], XmNwidth, 100);n++;
  if(exp_near1(work_log.trans[displayNode][displayArc])<0.000001)
    sprintf(tempLabel,"     0.0");
  else
    sprintf(tempLabel,"%8f",
	    exp_near1(work_log.trans[displayNode][displayArc]));
  stateLabel = XmStringCreate(tempLabel,XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, stateLabel);n++;
  transDisplay = XmCreateLabel (bb2, "transDisplay", args, n);
  XtManageChild(transDisplay);

  /* Bar Score Display */
  n=0;
  XtSetArg(args[n], XmNx, 10);n++;
  XtSetArg(args[n], XmNy, 115+WDHEIGHT+10);n++;
  XtSetArg(args[n], XmNheight, 19);n++;
  XtSetArg(args[n], XmNwidth, 75);n++;
  sprintf(tempLabel,"%6d",sumeval);
  stateLabel = XmStringCreate(tempLabel,XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, stateLabel);n++;
  barScore = XmCreateLabel (bb2, "stateDisplay", args, n);

  /* Bar Display */
  n=0;
  XtSetArg(args[n], XmNx, 100);n++;
  XtSetArg(args[n], XmNy, 115+WDHEIGHT+15);n++;
  XtSetArg(args[n], XmNheight, 15);n++;
  XtSetArg(args[n], XmNwidth, 10);n++;
  stateLabel = XmStringCreate(" ",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, stateLabel);n++;
  barBody = XmCreateLabel (bb2, "barBody", args, n);

  n=0;
  XtSetArg(args[n], XmNx, 95);n++;
  XtSetArg(args[n], XmNy, 115+WDHEIGHT+10);n++;
  XtSetArg(args[n], XmNheight, 19);n++;
  XtSetArg(args[n], XmNwidth, (XtArgVal) BARWIDTH+6);n++;
  stateLabel = XmStringCreate(" ",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, stateLabel);n++;
  barFrame = XmCreateLabel (bb2, "barFrame", args, n);

  split_after = 0;

  XtRealizeWidget(top2);  
  gc2 = XCreateGC(XtDisplay(bb2), XtWindow(bb2), 0, 0);

  arrow_redraw();
  XtAddCallback(bb2,XmNexposeCallback, redraw2CB, gc2);
}

make_piles()
{
  Arg args[20];
  char name[20];
  int i,j,posy,n,a,iMax_log,iHeight,pilelength;

  /* Check Highest */
  for(iMax_log=0,a=0;a<AMINOS;a++) { 
    if (a==1||a==9||a==14||a==20||a==23||a>24) continue;
    iHeight = work_log.output[displayNode][displayArc][a];
    if(iHeight > iMax_log) iMax_log = iHeight;
  }

  for(a=0,posy=0;a<AMINOS;a++) { 
    if (a==1||a==9||a==14||a==20||a==23||a>24) continue;
    sprintf(name, "pile%d", posy);
    n=0;
    XtSetArg(args[n], XmNx, posy*15+15);n++;
    XtSetArg(args[n], XmNy, 115);n++;
    XtSetArg(args[n], XmNwidth, 14);n++;

    pilelength = exp_near1(minus(work_log.output[displayNode][displayArc][a],
				 iMax_log))*(double)WDHEIGHT;
    XtSetArg(args[n], XmNheight, (XtArgVal) pilelength+3);n++;
    stateLabel = XmStringCreate(" ",XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, stateLabel);n++;
    wdpile[posy] = XmCreateLabel (bb2, name, args, n);
    XtManageChild(wdpile[posy]);
    posy++;
  } 
}

resize_piles(w)
Widget w;
{
  Arg args[10];
  int i, j, n, a, pilelength, iMax_log, iHeight, posy;
  char tempLabel[20];
  XmString stateLabel;

  /* Arc Display */
  sprintf(tempLabel,"%4d",displayArc);
  n=0;
  stateLabel = XmStringCreate(tempLabel,XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, stateLabel);n++;
  XtSetValues (arcDisplay, args, n);

  /* Trans Display */
  if(exp_near1(work_log.trans[displayNode][displayArc])<0.000001)
    sprintf(tempLabel,"     0.0");
  else
    sprintf(tempLabel,"%8f",
	    exp_near1(work_log.trans[displayNode][displayArc]));
  n=0;
  stateLabel = XmStringCreate(tempLabel,XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, stateLabel);n++;
  XtSetValues (transDisplay, args, n);

  /* Check Highest */
  for(iMax_log=0,a=0,posy=0;a<AMINOS;a++) { 
    if (a==1||a==9||a==14||a==20||a==23||a>24) continue;
    iHeight = work_log.output[displayNode][displayArc][a];
    if(iHeight > iMax_log) iMax_log = iHeight;
  }

  /* Graph Piles */
  for(a=0,posy=0;a<AMINOS;a++) { 
    if (a==1||a==9||a==14||a==20||a==23||a>24) continue;
    pilelength = exp_near1(minus(work_log.output[displayNode][displayArc][a],
				 iMax_log))*(double)WDHEIGHT;
    n=0;
    XtSetArg(args[n], XmNheight, (XtArgVal) pilelength+3);n++;
    XtSetValues (wdpile[posy], args, n);
    posy++;
  } 
  XFlush(XtDisplay(w));
}

void redraw2CB(wd,gc2,cdata)
Widget  wd;
GC      gc2;
XmDrawingAreaCallbackStruct *cdata;
{
  int i,j;

  if(cdata->reason == XmCR_EXPOSE){
    arrow_redraw(wd, gc2);
  }
}

arrow_redraw()
{
  XSetForeground(XtDisplay(bb2),gc2,MyColor(XtDisplay(bb2),"red"));
  XSetLineAttributes(XtDisplay(bb2),gc2,2,LineSolid,CapButt,JoinMiter);
  XDrawLine(XtDisplay(bb2), XtWindow(bb2), gc2, 245, 61, 254, 64);
  XDrawLine(XtDisplay(bb2), XtWindow(bb2), gc2, 245, 67, 254, 64);
  XSetLineAttributes(XtDisplay(bb2),gc2,3,LineSolid,CapButt,JoinMiter);
  XDrawLine(XtDisplay(bb2), XtWindow(bb2), gc2, 153, 64, 254, 64);
}

bar_draw()
{
  int n,length;
  Arg args[20];
  XmString temp;
  char tempLabel[20];

  if(bar_flag == OFF) {
    XtUnmanageChild(barBody);
    XtUnmanageChild(barFrame);
    XtUnmanageChild(barScore);
    XFlush(XtDisplay(bb2));
    return;
  } else {
    XtManageChild(barBody);
    XtManageChild(barFrame);
    XtManageChild(barScore);
    XFlush(XtDisplay(bb2));
  }
  if(split_after == 0) maxlength = sumeval;
  length = exp_near1(minus(sumeval,maxlength))*(double)BARWIDTH;
  length = BARWIDTH-length;
  if(length <= 0) length = 1;
  n=0;
  XtSetArg(args[n], XmNwidth, (XtArgVal) length);n++;
  XtSetValues (barBody, args, n);

  n=0;
  sprintf(tempLabel,"%6d",sumeval);
  stateLabel = XmStringCreate(tempLabel,XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, stateLabel);n++;
  XtSetValues (barScore, args, n);

  XFlush(XtDisplay(bb2));
}
