/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include  <stdio.h>
#include  <math.h>
#define   NEAR1  1.0001
#define   TableMAX   100000

main(argc,argv)
int argc;
char **argv;
{
    int     i, value;
    double  x, log_near1;

    if(argc != 2) {
      printf("Please set plus/minus: mklogtbl plus [or minus]\n");
      exit(0);
    }

    log_near1 = log((double)NEAR1);

    if(argv[1][0] == 'm') {
      printf("int lm1[] = {\n");
      for (i=1; i<=TableMAX; i++) {
	x = exp( (double)(i) * log_near1 );
	value = (int)(log(x-1.0) / log_near1 + 0.5);
	printf("%6d",value);
	if (i == TableMAX) printf("};\n");
	else if (i%10 == 0) printf(",\n");
	else printf(",");
      }
    } else if(argv[1][0] == 'p') {
      printf("int lp1[] = { ");
      for (i=0; i<=TableMAX; i++) {
	x = exp( (double)(i) * log_near1 );
	value = (int)(log(x+1.0) / log_near1 + 0.5);
	printf("%6d",value);
	if (i == TableMAX) printf("};\n");
	else if (i%10 == 0) printf(",\n");
	else printf(",");
      }
    }
    exit(0);
}

/* end of file */
