/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* --------------------------------------------------------------

        Log Calculation Tools: logplus, logminus, plus, minus
            Ver 1.0 1993. 6.20 by HTanaka
              (Originally by NEC Fujiwara)
	        plus(X,Y)       | X * Y
		minus(X,Y)      | X / Y
		logplus(X,Y)    | X + Y
		logminus(X,Y)   | X - Y

		log_near1(X)
		double exp_near1(X)
		ftoi_del4in5(X)
		swap(px,py)
--------------------------------------------------------------- */

/*  long = int = 20 0000 0000; short = 32000 */

#include  <stdio.h>
#include  <string.h>
#include  <math.h>

#include "defs.h"

extern double log_of_near1;

/* -------------------- DRIVER --------------------------------- */
#ifdef SINGLE
static double log_of_near1;

main()
{
    char readbuf[READBUFSIZE];
    int  cal1, cal2;
    double dcal1, dcal2;
    double exp_near1();

    log_of_near1 = log(NEAR1); /* necessary initialization */

    while(gets(readbuf)!=NULL) {
	sscanf(readbuf, "%d%d%s", &cal1, &cal2);

	printf("plus  = %d\n",plus(cal1,cal2));
	printf("minus = %d\n",minus(cal1,cal2));

	dcal1=cal1; dcal2=cal2;
	cal1=log_near1(dcal1); cal2=log_near1(dcal2);
	printf("logplus  = %g\n",exp_near1(logplus(cal1,cal2)));
	printf("logminus = %g\n",exp_near1(logminus(cal1,cal2)));
    }
}
#endif
/* -------------------------------------------------------------- */

plus(X,Y)
int      X, Y;
{
  int    XpY;

  XpY = X + Y;
  if (X <= mRANGE || Y <= mRANGE || XpY <= mRANGE) {
    if (X > 0 && Y > 0) {
	fprintf(stderr,"Warning: upper range over in %d plus %d\n",X,Y);
	return(pRANGE);  /* plus range over */
    }
    return(mRANGE);
  }
  if (X >= pRANGE || Y >= pRANGE || XpY >= pRANGE) {
    if (X < 0 && Y < 0) return(mRANGE);  /* minus range over */
    fprintf(stderr,"Warning: upper range over in %d plus %d\n",X,Y);
    return(pRANGE);
  }
  return(XpY);
}

minus(X,Y)
int      X, Y;
{
  int    XmY;

  XmY = X - Y;
  if (Y <= mRANGE) {
    fprintf(stderr,"Warning: devide zero in %d minus %d\n",X,Y);
    return(mRANGE);
  }
  if (XmY <= mRANGE) {
    fprintf(stderr,"Warning: lower range violation in %d minus %d\n",X,Y);
    return(mRANGE);
  }
  if (XmY >= pRANGE) {
    if(X < 0 && Y > 0) return(mRANGE);   /* minus range over */
    fprintf(stderr,"Warning: upper range over in %d minus %d\n",X,Y);
    return(pRANGE);
  }
  return(XmY);
}

minus_II(IX,IY)
int      IX, IY;
{
  if(IX == 0) return(mRANGE);            /* 0 $B$r3d$k(B */
  if(IY == 0) {
    fprintf(stderr,"Warning: devide INT zero in %d minus %d\n",IX,IY);
    return(pRANGE);
  }
  else return(minus(log_near1((double)IX),log_near1((double)IY)));
}

logplus(X, Y)
int    X, Y;
{
  extern int lp1[];

  if (X < Y) swap(&Y,&X);
  if (X/2 - Y/2 > pRANGE/2) {
    if(Y < 0) return(X);
    else {
      fprintf(stderr,"Warning: upper range over in %d logplus %d\n",X,Y);
      return(pRANGE);
    }
  } 
  if (Y <= mRANGE || X-Y > TableMAX) 
    return(X);
  else
    return(Y + lp1[X-Y]);
}

logminus(X, Y)
int    X, Y;
{
  extern int lm1[];

  if (X < Y)
    swap(&X,&Y);
  if (X-Y > pRANGE) {
    fprintf(stderr,"Warning: upper range over in %d logminus %d\n",X,Y);
    return(pRANGE);
  }
  if (Y <= mRANGE || X-Y > TableMAX) 
    return(X);
  else
    return(Y + lm1[X-Y]);
}

log_near1(X)
double   X;
{
  if (X<0) {
    printf("log_error  X=%f\n",X);
    exit(0);
  }
  if (0 == X)
    return(mRANGE);
  else
    return( ftoi_del4in5(log(X)/log_of_near1) );
}

double exp_near1(X)
int      X;
{
  return( exp((double)X*log_of_near1) );
}

ftoi_del4in5(X)
double X;
{
  if (X - (int)X >= 0.5)
    return((int)X + 1);
  else
    return((int)X);
}

swap(px,py)
int    *px, *py;
{
  int    temp;

  temp = *px;
  *px = *py;
  *py = temp;
}

/* end of file */
