/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*-----------------------------------------------------------------
    HMM Initialize
    1994.9.16
-----------------------------------------------------------------*/
#include "defs.h"
#include "e_struct.h"

/* #define DEBUG_init */

inithmn()
{
  int i,j,s,ss,t,a;
  int ini_unit,ibegin;

  /* ---------------- */
  /* $BA+0\3NN($N=i4|CM(B */
  /* ---------------- */
  for(i=0;i<hmnet.nodenum;i++)
    for(j=0;j<hmnet.nodenum;j++)
      work_log.trans[i][j] = (-1)*log_near1((double)hmnet.node[i].arcsOutNum);

  /* ---------------- */
  /* $B=PNOIQEY$N=i4|CM(B */
  /* ---------------- */
  clear_statistics();
  for(s=0;s<sample.number;s++) {
    ini_unit = sample.length[s]/hmnet.node[TERMINALSTATE].pos_depth;
    if(ini_unit == 0)ini_unit = 1;

    for(i=0;i<hmnet.nodenum;i++){
      if(i==TERMINALSTATE) continue;
      for(j=0;j<hmnet.nodenum;j++) {
	if(s + hmnet.node[j].pos_width < sample.number) continue;
	if(i == j) { 
	  ibegin = ini_unit * hmnet.node[i].pos_depth;
	  for(t=ibegin;t<ibegin+ini_unit;t++) {
	    hmnet.arc[i][j].profile[sample.seq[s][t]]++;
	    hmnet.arc[i][j].usage++;
	    hmnet.node[i].profile[sample.seq[s][t]]++;
	    hmnet.node[i].usage++;
	  }
	} else if(hmnet.arc[i][j].link == LINK) {
	  t = ini_unit * hmnet.node[i].pos_depth + ini_unit;
	  hmnet.arc[i][j].profile[sample.seq[s][t]]++;
	  hmnet.arc[i][j].usage++;
	  hmnet.node[i].profile[sample.seq[s][t]]++;
	  hmnet.node[i].usage++;
	}
      } /* j */
    } /* i */
  } /* s */

  /* ---------------- */
  /* $B=PNO3NN($N=i4|CM(B */
  /* ---------------- */
  if(tied_switch==OFF) {
    for(i=0;i<hmnet.nodenum;i++) {
      if(i==TERMINALSTATE) continue;
      for(j=0;j<hmnet.nodenum;j++){
	if(hmnet.arc[i][j].link == LINK) {
	  for(a=0;a<AMINOS;a++) {
	    work_log.output[i][j][a]=logplus(sample.usage_log[a],
	      minus_II(hmnet.arc[i][j].profile[a],hmnet.arc[i][j].usage));
	    work_log.output[i][j][a]=minus(work_log.output[i][j][a],
					   log_near1((double)2));
	  } /* a */
	}
      } /* j */
    } /* i */
  } else {
    for(i=0;i<hmnet.nodenum;i++) {
      if(i==TERMINALSTATE) continue;
      for(j=0;j<hmnet.nodenum;j++){
	for(a=0;a<AMINOS;a++) {
	  work_log.output[i][j][a]=logplus(sample.usage_log[a],
	    minus_II(hmnet.node[i].profile[a],hmnet.node[i].usage));
	  work_log.output[i][j][a]=minus(work_log.output[i][j][a],
					 log_near1((double)2));
	} /* a */
      } /* j */
    } /* i */
  }

#ifdef TRIAL1
  /* ------------ */
  /* $B=i4|=PNO3NN((B */
  /* ------------ */
  for(i=0;i<hmnet.nodenum;i++)
    for(j=0;j<hmnet.nodenum;j++)
      for(a=0;a<AMINOS;a++)
	work_log.output[i][j][a] = sample.usage_log[a];
#endif

#ifdef DEBUG_init
  for(i=0;i<hmnet.nodenum;i++) {
    if(i==TERMINALSTATE) continue;
    printf("DBTRANS%d",i);
    for(j=0;j<hmnet.nodenum;j++) 
      if(hmnet.arc[i][j].link == LINK)
	printf(" %d %10d",j,work_log.trans[i][j]);
    printf("\n");
  }

  for(i=0;i<hmnet.nodenum;i++) {
    if(i==TERMINALSTATE) continue;
    for(j=0;j<hmnet.nodenum;j++){
      if(hmnet.arc[i][j].link == LINK){
	printf("DBOUT%d%d",i,j);
	for(a=0;a<AMINOS;a++) {
	  if(a==6||a==12||a==18) printf("\nDBOUT%d%d",i,j);
	  if(a==1||a==9||a==14||a==20||a==23||a==25)continue;
	  printf(" %c %10d",a+'a',work_log.output[i][j][a]);
	}
	printf("\n");
      }
    }
    printf("\n");
  }
#endif
}

/* end of file */
