/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -------------------------------------------------
     HMM display
     1995.1.27 updated
------------------------------------------------- */
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xutil.h>
#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/SeparatoG.h>
#include <Xm/PushBG.h>
#include <Xm/DrawingA.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <Xm/ToggleB.h>
#include <Xm/FileSB.h>
#include <Xm/SelectioB.h>

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "defs.h"
#include "e_struct.h"

/* Window CallBack Definitions */

/* Callback for the PushButton */
void quitCB(), nodeCB(), stepCB(), execCB(), splitCB(); 
void sequenceCB(), redrawCB();
void sampleloadCB(), sampleloadOkCB(), sampleloadQuitCB();
void hmnloadCB(), hmnloadOkCB(), hmnloadQuitCB();
void netsaveCB(), netsaveOkCB(), netsaveQuitCB();


extern Widget stateDisplay;

Widget base, sw, bb, hsb, vsb, bartb, statseqtb;
Widget quitpb, steppb, execpb, splitSApb, splitSBpb, splitPpb;
Widget sequencepb, sampleloadpb, hmnloadpb, fsbox, hmnfsbox, prbox;
Widget netsavepb;
Widget nodelabel[NODEMAX];
Widget dnodelabel[NODEMAX];
XmString nodeName;
unsigned long MyColor();
GC gc;
static int mid;
static XtArgVal GetPixel();
static char *filename=NULL;

hmmdisplay(top1)
Widget top1;
{
  int n;
  Arg args[20];

  mid = (hmnet.width-1)/2+1;

  /* Base Window */
  n=0;
  XtSetArg(args[n], XmNwidth, 700);n++;
  XtSetArg(args[n], XmNheight, 700);n++;
  base = XmCreateForm(top1,"base",args,n);
  XtManageChild(base);

  /* Quit Button */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 10);n++;
  XtSetArg(args[n], XmNtopOffset, 10);n++;
  XtSetArg(args[n], XmNwidth, 80);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  quitpb = XtCreateManagedWidget ("quit", xmPushButtonWidgetClass,
				  base, args, n); 
  XtManageChild(quitpb);
  XtAddCallback (quitpb, XmNactivateCallback, quitCB, NULL);

  /* Sample Load Button */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 100);n++;
  XtSetArg(args[n], XmNtopOffset, 10);n++;
  XtSetArg(args[n], XmNwidth, 80);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  sampleloadpb = XtCreateManagedWidget ("samples", xmPushButtonWidgetClass,
				   base, args, n); 
  XtManageChild(sampleloadpb);
  XtAddCallback (sampleloadpb, XmNactivateCallback, sampleloadCB, NULL);

  /* HMNet Load Button */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 190);n++;
  XtSetArg(args[n], XmNtopOffset, 10);n++;
  XtSetArg(args[n], XmNwidth, 80);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  hmnloadpb = XtCreateManagedWidget ("hmnet", xmPushButtonWidgetClass,
				   base, args, n); 
  XtManageChild(hmnloadpb);
  XtAddCallback (hmnloadpb, XmNactivateCallback, hmnloadCB, NULL);

  /* Full Execution Button */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 280);n++;
  XtSetArg(args[n], XmNtopOffset, 10);n++;
  XtSetArg(args[n], XmNwidth, 80);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  execpb = XtCreateManagedWidget ("exec", xmPushButtonWidgetClass,
				  base, args, n); 
  XtManageChild(execpb);
  XtAddCallback (execpb, XmNactivateCallback, execCB, NULL);

  /* printout sequence/states  */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 370);n++;
  XtSetArg(args[n], XmNtopOffset,  10);n++;
  XtSetArg(args[n], XmNwidth, 80);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  sequencepb = XtCreateManagedWidget ("seqdump", xmPushButtonWidgetClass,
				      base, args, n); 
  XtManageChild(sequencepb);
  XtAddCallback (sequencepb, XmNactivateCallback, sequenceCB, NULL);

  /* save hmnet */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 460);n++;
  XtSetArg(args[n], XmNtopOffset,  10);n++;
  XtSetArg(args[n], XmNwidth, 80);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  netsavepb = XtCreateManagedWidget ("netsave", xmPushButtonWidgetClass,
				      base, args, n); 
  XtManageChild(netsavepb);
  XtAddCallback (netsavepb, XmNactivateCallback, netsaveCB, NULL);

  /* Step Execution Button */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 10);n++;
  XtSetArg(args[n], XmNtopOffset, 50);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  steppb = XtCreateManagedWidget ("step", xmPushButtonWidgetClass,
				  base, args, n); 
  XtManageChild(steppb);
  XtAddCallback (steppb, XmNactivateCallback, stepCB, NULL);

  /* State Split Button */
  /* serial split new-after (1-2) */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 60);n++;
  XtSetArg(args[n], XmNtopOffset, 50);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  splitSApb = XtCreateManagedWidget ("split>", xmPushButtonWidgetClass,
				     base, args, n); 
  XtManageChild(splitSApb);
  XtAddCallback (splitSApb, XmNactivateCallback,splitCB,(caddr_t *)SERIAL12);

  /* serial split new-before (2-1) */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 110);n++;
  XtSetArg(args[n], XmNtopOffset,  50);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  splitSBpb = XtCreateManagedWidget ("split<", xmPushButtonWidgetClass,
				     base, args, n); 
  XtManageChild(splitSBpb);
  XtAddCallback (splitSBpb, XmNactivateCallback,splitCB,(caddr_t *)SERIAL21);

  /* parallel split */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 160);n++;
  XtSetArg(args[n], XmNtopOffset,  50);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  splitPpb = XtCreateManagedWidget ("split=", xmPushButtonWidgetClass,
				    base, args, n); 
  XtManageChild(splitPpb);
  XtAddCallback (splitPpb, XmNactivateCallback, splitCB,(caddr_t *)PARALLEL);

  /* bar toggle */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 220);n++;
  XtSetArg(args[n], XmNtopOffset, 50);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  bartb = XmCreateToggleButton(base, "bar", args, n);
  XtManageChild(bartb);

  /* stat seq toggle */
  n=0;
  XtSetArg(args[n], XmNleftOffset, 270);n++;
  XtSetArg(args[n], XmNtopOffset, 50);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNheight, 30);n++;
  statseqtb = XmCreateToggleButton(base, "statseq", args, n);
  XtManageChild(statseqtb);

  /* Scroll Window */
  n=0;
  XtSetArg(args[n], XmNtopOffset, 120);n++;
  XtSetArg(args[n], XmNleftOffset, 10);n++;
  XtSetArg(args[n], XmNrightOffset, 10);n++;
  XtSetArg(args[n], XmNbottomOffset, 20);n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
  XtSetArg(args[n], XmNwidth, 500);n++; 
  XtSetArg(args[n], XmNheight, 500);n++;
  XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmSTATIC);n++;
  sw = XmCreateScrolledWindow(base,"sw",args,n);
  XtManageChild(sw);

  n=0;
  XtSetArg(args[n], XmNhorizontalScrollBar, &hsb);n++;
  XtSetArg(args[n], XmNverticalScrollBar, &vsb);n++;
  XtGetValues(sw,args,n);
  n=0;
  XtSetArg(args[n], XmNwidth, 25);n++;
  XtSetValues(vsb,args,n);

  n=0;
  XtSetArg(args[n], XmNheight, 25);n++;
  XtSetValues(hsb,args,n);
  n=0;
  XtSetArg(args[n], XmNwidth, 2000);n++;
  XtSetArg(args[n], XmNheight,2000);n++;
  XtSetArg(args[n], XmNresizePolicy, XmRESIZE_GROW);n++;
  bb = XmCreateDrawingArea(sw,"bb", args, n);
  XtManageChild(bb);

  XmScrolledWindowSetAreas(sw,NULL,NULL,bb);

  XtRealizeWidget(top1);

  gc = XCreateGC(XtDisplay(bb), XtWindow(bb), 0, 0);

  /* Draw HMNet */
  watchhmn();
  inithmn();
  draw_hmnet();
}

/* ====================================================================== */
#define STARTX 10
#define STARTY 300
#define START_AX (STARTX+20)
#define START_AY (STARTY+20)

draw_hmnet()
{
  int i,j,depth,n,p,m,d,w;
  Arg args[20];
  char name[20],tempLabel[20];
  int display_pos_width;

  XtDestroyWidget(bb);
  n=0;
  XtSetArg(args[n], XmNwidth, 2000);n++;
  XtSetArg(args[n], XmNheight,2000);n++;
  XtSetArg(args[n], XmNresizePolicy, XmRESIZE_GROW);n++;
  bb = XmCreateDrawingArea(sw,"bb", args, n);
  XtManageChild(bb);

  for(i=0;i<hmnet.nodenum;i++) {
    n=0;
     if(hmnet.node[i].selfloop == ON) {
       XtSetArg(args[n], XmNbackground, GetPixel("Lightsalmon"));n++;
     } else {
       XtSetArg(args[n], XmNbackground, GetPixel("Lightgoldenrod1"));n++;
     }
     XtSetArg(args[n], XmNx, hmnet.node[i].pos_depth * 40+STARTX);n++;
     XtSetArg(args[n], XmNy, ytrans(hmnet.node[i].pos_width) * 40+STARTY);n++;
     XtSetArg(args[n], XmNwidth, 30);n++;
     XtSetArg(args[n], XmNheight, 30);n++;
       sprintf(name,"node%d",i);
       sprintf(tempLabel,"%d",i);
       nodeName = XmStringCreate(tempLabel,XmSTRING_DEFAULT_CHARSET);
     XtSetArg(args[n], XmNlabelString, nodeName);n++;
     nodelabel[i] = XtCreateManagedWidget (name, xmPushButtonWidgetClass,
					   bb, args, n); 
     XtManageChild(nodelabel[i]);
     XtAddCallback(nodelabel[i], XmNactivateCallback, nodeCB, (caddr_t *)i);
   }

   /* branch */
   /* display_pos_width = hmnet.width+1; */
   for(p=0,m=0;p<hmnet.arcnum;p++) {
     i = hmnet.serial_arc[p].from;
     j = hmnet.serial_arc[p].to;
     if(i == j) continue;
     if(hmnet.node[i].pos_depth < hmnet.node[j].pos_depth) 
       continue;

     d = hmnet.node[i].pos_depth+1;
     w = hmndisp.depth[d].width++;
     hmndisp.depth[d].node[w] = j;
     n=0;
     XtSetArg(args[n], XmNx, d * 40+STARTX);n++;
     XtSetArg(args[n], XmNy, ytrans(w) * 40+STARTY);n++;
     XtSetArg(args[n], XmNwidth, 30);n++;
     XtSetArg(args[n], XmNheight, 30);n++;
        sprintf(name,"dnode%d-%d-%d",d,w,j);
        sprintf(tempLabel,"%d",j);
     nodeName = XmStringCreate(tempLabel,XmSTRING_DEFAULT_CHARSET);
     XtSetArg(args[n], XmNlabelString, nodeName);n++;
     dnodelabel[m] = XtCreateManagedWidget (name, xmPushButtonWidgetClass,
					   bb, args, n); 
     XtManageChild(dnodelabel[m]);
     XtAddCallback(dnodelabel[m], XmNactivateCallback, nodeCB, (caddr_t *)j);
     m++;
   }

  draw_directedLine();

  XtAddCallback(bb,XmNexposeCallback, redrawCB, gc);

}
/* ====================================================================== */
void quitCB (w, client_data, call_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
caddr_t     call_data;/*  data from widget class  */
{ 
/*  print message, free compound string memory, and terminate program */ 
      printf ("Quit\n");
      exit (0); 
} 

void redrawCB(wd,gc,cdata)
Widget  wd;
GC      gc;
XmDrawingAreaCallbackStruct *cdata;
{
  if(cdata->reason == XmCR_EXPOSE){
    draw_directedLine();
  }
}

void nodeCB (w, node, call_data) 
Widget      w;    /*  widget id*/ 
int         node;/*  data from application  */ 
caddr_t     call_data;/*  data from widget class  */
{ 
  Arg args[10];
  int n;
  char tempLabel[20];
  XmString stateLabel;

  int s,it,t;
  char subseq[SAMPLEMAX][TIMEMAX];
  int subseqLength[SAMPLEMAX];

  displayNode = node;
  if(node == TERMINALSTATE) return;

  for(displayArc++;;displayArc++){
    if(displayArc >= hmnet.nodenum)
      displayArc = 0;
    if(hmnet.arc[displayNode][displayArc].link==LINK)
      break;
  }

  /* State Display */
  sprintf(tempLabel,"%4d",displayNode);
  n=0;
  stateLabel = XmStringCreate(tempLabel,XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, stateLabel);n++;
  XtSetValues (stateDisplay, args, n);

  resize_piles(w);

  stat_seq_call();

  if(statseq_flag == ON) {
    /* -------------------------------------------- */
    /* $B%5%s%W%k$+$i$=$N%N!<%I$K4X$o$kItJ,$rH4$-=P$9(B */
    /* -------------------------------------------- */
    for(s=0;s<sample.number;s++) {
      for(it=0,t=0;t<sample.length[s];t++) {
	if(sample.beststates[s][t]==displayNode)
	  subseq[s][it++] = sample.seq[s][t];
      }
      subseqLength[s]=it;
    }

    printf("====== Subsequences State %d ======\n",displayNode);
    for(s=0;s<sample.number;s++) {
      printf("%d (L=%d/%d): ",s,subseqLength[s],sample.length[s]);
      for(it=0;it<subseqLength[s];it++) {
	printf("%c",subseq[s][it]+'a');
      }
      printf("\n");
    }
  }
} 

void stepCB (w, client_data, call_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
caddr_t     call_data;/*  data from widget class  */
{ 
  disc_viterbi();

  bar_draw_call();
  resize_piles(w);

  set_splitState();
} 

void execCB (w, client_data, call_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
caddr_t     call_data;/*  data from widget class  */
{ 
  if(split_flag == ON && splitState > 0) {
    node_split(splitState,splitMode);
    watchhmn();
    inithmn(); 
    draw_hmnet();
  }

  split_after = 0;
  while(disc_viterbi()==V_CONTINUE) {
    bar_draw_call();
  }
  resize_piles(w);

  set_splitState();
  split_flag = ON;
} 

void splitCB (w, s_or_p, call_data) 
Widget      w;    /*  widget id*/ 
int s_or_p;
caddr_t     call_data;/*  data from widget class  */
{ 
  node_split(displayNode,s_or_p);
  watchhmn();
  inithmn(); 
  draw_hmnet();
  split_flag = OFF;
} 

void sequenceCB (w, client_data, call_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
caddr_t     call_data;/*  data from widget class  */
{ 
#define ONELINE 30

  int s,t,u;

  for(s=0;s<sample.number;s++){
    printf("Sequence Number %d: length %d\n",s,sample.length[s]);
    for(t=0,u=0;t<sample.length[s];u++) {
      printf(" ");
      for(t=u*ONELINE;(t+1)%ONELINE!=0&&t<sample.length[s];t++) {
	printf(" %c",sample.seq[s][t]+'a');
      }
      printf("\n");
      for(t=u*ONELINE;(t+1)%ONELINE!=0&&t<sample.length[s];t++) {
	printf("%2d",sample.beststates[s][t]);
      }
      printf("\n");
    }
  }

} 

#define SAVEFILE "hmn.new"

void netsaveCB(w, client_data, call_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
caddr_t     call_data;/*  data from widget class  */
{ 
  int n;
  Arg args[20];

  n=0;
  XtSetArg(args[n], XmNselectionLabelString, 
	   XmStringCreateSimple("Saving File"));n++;
  XtSetArg(args[n], XmNokLabelString, XmStringCreateSimple("Save"));n++;
  XtSetArg(args[n], XmNcancelLabelString, XmStringCreateSimple("Cancel"));n++;
  XtSetArg(args[n], XmNhelpLabelString, XmStringCreateSimple("Help"));n++;
  prbox = XmCreatePromptDialog(base,"savefileN",args,n);
  XtManageChild(prbox);

  XtAddCallback(prbox,XmNokCallback,(XtCallbackProc)netsaveOkCB,NULL);
  XtAddCallback(prbox,XmNcancelCallback,(XtCallbackProc)netsaveQuitCB,NULL);
}

void netsaveQuitCB (w, client_data, call_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
caddr_t     call_data;/*  data from widget class  */
{
  XtUnmanageChild(prbox);
}

void netsaveOkCB (w, client_data, select_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
XmFileSelectionBoxCallbackStruct *select_data;
{ 
  FILE *fp,*fopen();
  int i,j,n;

  switch(select_data -> reason)
    {
    case XmCR_OK:
      XmStringGetLtoR(select_data -> value, 
		      XmSTRING_DEFAULT_CHARSET, &filename);
      strcpy(savefilename,filename);
      XtUnmanageChild(prbox);

      /* file */
      if(savefilename[0] == NULL) {
	fp=fopen(SAVEFILE,"w"); 
	printf("Saving in a default file \n");
      } else {
	printf("Saving in %s \n",savefilename);
	fp=fopen(savefilename,"w");
      }

      fprintf(fp,"## hmnet saved configuration\n");
      fprintf(fp,"S ");
      for(i=0;i<hmnet.nodenum;i++){
	fprintf(fp,"%f ",hmnet.initialProb[i]);
      }
      fprintf(fp,"\n");

      for(i=1;i<hmnet.nodenum;i++){
	fprintf(fp,"M ");
	for(j=0;j<hmnet.nodenum;j++) {
	  fprintf(fp,"%4d",hmnet.arc[i][j].link);
	}
	fprintf(fp,"\n");
      }
      fclose(fp);
      printf("saved.\n");
      break;
    case XmCR_NO_MATCH:
      printf("NO Match!\n");
      break;
    }
} 

/* ====================================================================== */
void sampleloadCB (w, client_data, call_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
caddr_t     call_data;/*  data from widget class  */
{ 
  Arg args[20];
  int n;

  n=0;
  XtSetArg(args[n], XmNokLabelString, XmStringCreateSimple("Load"));n++;
  XtSetArg(args[n], XmNapplyLabelString, XmStringCreateSimple("Filter"));n++;
  XtSetArg(args[n], XmNselectionLabelString, 
	   XmStringCreateSimple("Loading File"));n++;
  XtSetArg(args[n], XmNcancelLabelString, XmStringCreateSimple("Cancel"));n++;
  XtSetArg(args[n], XmNdirListLabelString, 
	   XmStringCreateSimple("Directory"));n++;
  XtSetArg(args[n], XmNfileListLabelString, XmStringCreateSimple("File"));n++;
  XtSetArg(args[n], XmNfilterLabelString, XmStringCreateSimple("Filter"));n++;
  XtSetArg(args[n], XmNhelpLabelString, XmStringCreateSimple("Help"));n++;

  fsbox = XmCreateFileSelectionDialog(base,"sampleload",args,n);
  XtManageChild(fsbox);
  XtAddCallback(fsbox,XmNokCallback,(XtCallbackProc)sampleloadOkCB,NULL);
  XtAddCallback(fsbox,XmNnoMatchCallback,(XtCallbackProc)sampleloadOkCB,NULL);
  XtAddCallback(fsbox,XmNcancelCallback,(XtCallbackProc)sampleloadQuitCB,NULL);

  split_flag = OFF;
} 

void sampleloadQuitCB (w, client_data, call_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
caddr_t     call_data;/*  data from widget class  */
{
  XtUnmanageChild(fsbox);
}

void sampleloadOkCB (w, client_data, select_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
XmFileSelectionBoxCallbackStruct *select_data;
{ 
  switch(select_data -> reason)
    {
    case XmCR_OK:
      XmStringGetLtoR(select_data -> value, 
		      XmSTRING_DEFAULT_CHARSET, &filename);
      strcpy(samplefilename,filename);
      XtUnmanageChild(fsbox);
      getsample(filename);
      break;
    case XmCR_NO_MATCH:
      printf("NO Match!\n");
      break;
    }
} 

/* ====================================================================== */
void hmnloadCB (w, client_data, call_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
caddr_t     call_data;/*  data from widget class  */
{ 
  Arg args[20];
  int n;

  n=0;
  XtSetArg(args[n], XmNokLabelString, XmStringCreateSimple("Load"));n++;
  XtSetArg(args[n], XmNapplyLabelString, XmStringCreateSimple("Filter"));n++;
  XtSetArg(args[n], XmNselectionLabelString, 
	   XmStringCreateSimple("Loading File"));n++;
  XtSetArg(args[n], XmNcancelLabelString, XmStringCreateSimple("Cancel"));n++;
  XtSetArg(args[n], XmNdirListLabelString, 
	   XmStringCreateSimple("Directory"));n++;
  XtSetArg(args[n], XmNfileListLabelString, XmStringCreateSimple("File"));n++;
  XtSetArg(args[n], XmNfilterLabelString, XmStringCreateSimple("Filter"));n++;
  XtSetArg(args[n], XmNhelpLabelString, XmStringCreateSimple("Help"));n++;

  hmnfsbox = XmCreateFileSelectionDialog(base,"hmnload",args,n);
  XtManageChild(hmnfsbox);
  XtAddCallback(hmnfsbox,XmNokCallback,(XtCallbackProc)hmnloadOkCB,NULL);
  XtAddCallback(hmnfsbox,XmNnoMatchCallback,(XtCallbackProc)hmnloadOkCB,NULL);
  XtAddCallback(hmnfsbox,XmNcancelCallback,(XtCallbackProc)hmnloadQuitCB,NULL);

  split_flag = OFF;
} 

void hmnloadQuitCB (w, client_data, call_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
caddr_t     call_data;/*  data from widget class  */
{
  XtUnmanageChild(hmnfsbox);
}

void hmnloadOkCB (w, client_data, select_data) 
Widget      w;    /*  widget id*/ 
caddr_t     client_data;/*  data from application  */ 
XmFileSelectionBoxCallbackStruct *select_data;
{ 
  switch(select_data -> reason)
    {
    case XmCR_OK:
      XmStringGetLtoR(select_data -> value, 
		      XmSTRING_DEFAULT_CHARSET, &filename);
      strcpy(hmnfilename,filename);
      XtUnmanageChild(hmnfsbox);
      gethmn_file(filename);
      watchhmn();
      inithmn();
      draw_hmnet();
      break;
    case XmCR_NO_MATCH:
      printf("NO Match!\n");
      break;
    }
} 

/* ====================================================================== */
draw_directedLine()
{
  int i,j,p,d,w;
  int mid_d, mid_w;

  /* before half */
  XSetForeground(XtDisplay(bb),gc,MyColor(XtDisplay(bb),"orange"));
  XSetLineAttributes(XtDisplay(bb),gc,4,LineSolid,CapButt,JoinMiter);
  for(p=0;p<hmnet.arcnum;p++) {
    i = hmnet.serial_arc[p].from;
    j = hmnet.serial_arc[p].to;
    if(i == j) continue;
    if(hmnet.node[i].pos_depth >= hmnet.node[j].pos_depth)
      continue;
    mid_d = hmnet.node[i].pos_depth*5 + hmnet.node[j].pos_depth*3;
    mid_w = ytrans(hmnet.node[i].pos_width)*5 
          + ytrans(hmnet.node[j].pos_width)*3;
    XDrawLine(XtDisplay(bb), XtWindow(bb), gc,
	      hmnet.node[i].pos_depth * 40+START_AX,
	      ytrans(hmnet.node[i].pos_width) * 40+START_AY,
	      mid_d * 5+START_AX,
	      mid_w * 5+START_AY);
  }
  /* after half */
  XSetForeground(XtDisplay(bb),gc,MyColor(XtDisplay(bb),"darkgreen"));
  XSetLineAttributes(XtDisplay(bb),gc,4,LineSolid,CapButt,JoinMiter);
  for(p=0;p<hmnet.arcnum;p++) {
    i = hmnet.serial_arc[p].from;
    j = hmnet.serial_arc[p].to;
    if(i == j) continue;
    if(hmnet.node[i].pos_depth >= hmnet.node[j].pos_depth) 
      continue;
    mid_d = hmnet.node[i].pos_depth*5 + hmnet.node[j].pos_depth*3;
    mid_w = ytrans(hmnet.node[i].pos_width)*5 
          + ytrans(hmnet.node[j].pos_width)*3;
    XDrawLine(XtDisplay(bb), XtWindow(bb), gc,
	      mid_d * 5+START_AX,
	      mid_w * 5+START_AY,
	      hmnet.node[j].pos_depth * 40+START_AX,
	      ytrans(hmnet.node[j].pos_width) * 40+START_AY);
  }

  /* branch */
  XSetForeground(XtDisplay(bb),gc,MyColor(XtDisplay(bb),"purple"));
  XSetLineAttributes(XtDisplay(bb),gc,4,LineSolid,CapButt,JoinMiter);
  for(p=0;p<hmnet.arcnum;p++) {
    i = hmnet.serial_arc[p].from;
    j = hmnet.serial_arc[p].to;
    if(i == j) continue;
    if(hmnet.node[i].pos_depth < hmnet.node[j].pos_depth) 
      continue;
    d = hmnet.node[i].pos_depth+1;
    for(w=1;w<hmndisp.depth[d].width;w++)
      if(hmndisp.depth[d].node[w] == j) break;

    XDrawLine(XtDisplay(bb), XtWindow(bb), gc,
	      (d-1) * 40+START_AX,
	      ytrans(hmnet.node[i].pos_width) * 40+START_AY,
	      d * 40+START_AX,
	      ytrans(w) * 40+START_AY);
  }
}
/*==============================================================*/
bar_draw_call()
{
  if(XmToggleButtonGetState(bartb)==True){
    bar_flag = ON;
  } else {
    bar_flag = OFF;
  }
  bar_draw();
}

stat_seq_call()
{
  if(XmToggleButtonGetState(statseqtb)==True){
    statseq_flag = ON;
  } else {
    statseq_flag = OFF;
  }
}

unsigned long MyColor(d,color)
Display *d;
char *color;
{
  Colormap cmap;
  XColor c0,c1;

  cmap = DefaultColormap(d,0);
  XAllocNamedColor(d,cmap,color,&c1,&c0);
  return(c1.pixel);
}

static XtArgVal GetPixel(colorstr)
char *colorstr;
{
  XrmValue from,to;

  from.size = strlen(colorstr)+1;
  if(from.size < sizeof(String)) from.size = sizeof(String);
  from.addr = colorstr;
  to.addr = NULL;
  XtConvert(bb, XmRString, &from, XmRPixel, &to);
  return((XtArgVal) *((XtArgVal *) to.addr));
}

/*==============================================================*/
int ytrans(y)
int y;
{
  if(y==1) return(mid);
  else if(y%2==0) return(mid+y/2);
  else if(y%2==1) return(mid-y/2);
}
/*==============================================================*/
/* end of file */
