/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*-----------------------------------------------------------------
    Read Sample Data

                               94.9.14

    int number;
    int length[SAMPLEMAX];
    int usage[AMINOS];
    char seq[SAMPLEMAX][SAMPLE_LENGTH];

-----------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "defs.h"
#include "e_struct.h"

#define COMMENT_SAMPLE ' '  /* == aedit */
/* #define DEBUG_sample */

getsample(samplefilename)
char samplefilename[];
{
    FILE *fp,*fopen();
    int s,t;
    int a;
    int total;

    fp=fopen(samplefilename,"r");

    s=0;
    while(fgets(read_buf, READBUFSIZE, fp)!=NULL) {
	if(read_buf[0] == COMMENT_SAMPLE) continue;
	strcpy(sample.seq[s],read_buf);
	sample.length[s]=strlen(sample.seq[s]);
	s++;
    }
    sample.number = s;
    fclose(fp);

    for(s=0;s<sample.number;s++) {
      for(t=0;t<sample.length[s];t++) {
	if(sample.seq[s][t]=='\n') {
	  sample.seq[s][t]=NULL;
	  sample.length[s]=t;
	  break;
	}
	sample.seq[s][t]=sample.seq[s][t]-'A';
      }
    }

#ifdef DEBUG_sample
    for(s=0;s<sample.number;s++) {
      for(t=0;t<sample.length[s];t++)
	printf("%3d",sample.seq[s][t]);
      printf("\n");
    }
#endif

    /* ---------------------------------- */
    /* $B%"%_%N;@;HMQIQEYE}7W(B               */
    /* ($B=i4|=PNO3NN(J,I[$X$N;HMQ$N2DG=@-(B) */
    /* ---------------------------------- */
    for(total=0,s=0;s<sample.number;s++)
      for(t=0;t<sample.length[s];t++) {
	sample.usage[sample.seq[s][t]] ++;
	total++;
	}
    for(a=0;a<AMINOS;a++) {
      if (sample.usage[a]==0)
	sample.usage_log[a] = OUTPUT_FLOOR; /* 0 $B$K$O$7$J$$(B */
      else
	sample.usage_log[a] = 
	  minus_II(sample.usage[a],total);
    }

#ifdef DEBUG_sample
    printf("total= %d\n",total);
    for(a=0;a<AMINOS;a++) 
	printf("%c: %d, %d\n",a+'A',sample.usage[a],sample.usage_log[a]);
#endif
}
