/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*-----------------------------------------------------------------
     Build up HMM Configuration from a file.

                                    94.9.12

     hmnet.nodenum                                      Node $BAm?t(B
     hmnet.initialProb[NODEMAX]                      $B=i4|0LCV3NN((B
     hmnet.initialState[NODEMAX]                       Start Node
     hmnet.initStateNumber                        Start Node $BAm?t(B

     hmnet.arc[NODEMAX][NODEMAX].link           HMNet Link/Nolink
     hmnet.node[NODEMAX].arcsOutNum        $B%N!<%I$+$i=P$k%j%s%/?t(B
     hmnet.node[NODEMAX].pos_depth
     hmnet.node[NODEMAX].pos_width


    << file >>
         0  1  2  3  4 ..
     0      S
     1      +  +
     2         +  +        (1) -> (2) -> 3 -> (4) -> E
     3               +
     4   +           +
     .

S       .0 1.0 .0 .0 .0
M        0  1  1  0  0
M        0  0  1  1  0
M        0  0  0  0  1
M        1  0  0  0  1

-----------------------------------------------------------------*/
/* #define DEBUG */

#define COMMENT_LETTER '#'
#define START_LETTER 'S'
#define MATRIX_LETTER 'M'

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "defs.h"

#ifdef SINGLE
#include "struct.h"

main()
{
  gethmn_file(CONFFILE);
}
#else
#include "e_struct.h"
#endif

gethmn_file(filename)
char filename[];
{
  int i,j;
  FILE *fp,*fopen();

  /* read from file */
  fp=fopen(filename,"r");

  if(fgets(read_buf, READBUFSIZE, fp)!=NULL) {
    if(strncmp(read_buf, "## hmnet", 8) != 0) {
      printf("It is not an hmn configuration file.\n");
      fclose(fp);
      return(0);
    }
  }

  i=0;
  while(fgets(read_buf, READBUFSIZE, fp)!=NULL) {
    if(read_buf[0] == COMMENT_LETTER) continue;
    if(read_buf[0] == START_LETTER)   parse_start();
    if(read_buf[0] == MATRIX_LETTER)  parse_matrix(i);i++;
  }
  fclose(fp);
  hmnet.nodenum = i;

#ifdef DEBUG
  printf("Nodes= %d\n",hmnet.nodenum);
  for (i=0;i<hmnet.nodenum;i++){
    if(i==TERMINALSTATE) continue;
    for (j=0;j<hmnet.nodenum;j++){
      printf("%d ",hmnet.arc[i][j].link);
    }
    printf("\n");
  }
  printf("Starts=%d\n",hmnet.initStateNumber);
  for(i=0;i<hmnet.initStateNumber;i++)
    printf("init= %d (%f)\n", hmnet.initialState[i],
	   hmnet.initialProb[hmnet.initialState[i]]);
#endif
} /* end of gethmn() */

parse_start()
{
  int i,j,n;
  char head[20];

  for(i=1,j=0,n=0; read_buf[i]!='\n';i++) {
    if(read_buf[i]=='.' || (read_buf[i]>='0' && read_buf[i]<='9')) {
      head[j++] = read_buf[i];
      if(read_buf[i+1]==' '||read_buf[i+1]=='\n') {
	head[j] = NULL;
	j=0;
	sscanf(head, "%f", &hmnet.initialProb[n++]);
      }
    }
  }
  hmnet.nodenum = n;

  hmnet.initStateNumber=0;
  for (i=0;i<hmnet.nodenum;i++) 
    if(hmnet.initialProb[i] >0) {
      hmnet.initialState[hmnet.initStateNumber]=i;
      hmnet.initStateNumber ++;
    }
}

parse_matrix(nn)
int nn;
{
  int i,j,n;
  char head[20];

  for(i=1,j=0,n=0; read_buf[i]!='\n';i++) {
    if(read_buf[i]>='0' && read_buf[i]<='9') {
      head[j++] = read_buf[i];
      if(read_buf[i+1]==' '||read_buf[i+1]=='\n') {
	head[j] = NULL;
	j=0;
	sscanf(head, "%d", &hmnet.arc[nn][n++].link);
      }
    }
  }
}
