/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#ifndef _pdb_h_
#define _pdb_h_

#ifndef _header_h_
#include "../3dview/header.h"
#endif 

#define IDSIZE 5
/* #define PI 3.1415926535897932384626433832795 */

extern unsigned modeFlag;

/* prototype */
int  Remote(char);
int  Branch(char);
char RRemote(int);
char RBranch(int);
int  ReadPdb(void);
int  Rotation(char,int,char*,char*,int);
void RamachandranPhi(char,int,double);
void RamachandranPsi(char,int,double);
void BackBone(void);
void SideChain(void);
void ConnectBackBone(void);
void TestPrint(char*);
void RePrint(char, int, int);
void ReDisplayRibbonAll(char, int);
void ReConnectHydrogen(void);
void HydrogenConnect(void);
void BondInit(char, int);
void HydrogenSearch(void);
void HelixSearch(void);
void DisplayHelix(void);
void DisplayLineResidue(char*);
void DisplayRibbonAll(char*);
int  DisplayRibbonHelix(char*);
int  DisplayRibbonSheet(char*);
int  DisplayRibbonTurn(char*);
void DisplayRibbonOther(void);
void OutPolygon(int);
void LoadMacro(char*);
void SpherePrint(char*, int, int);
void ChangeSphereDepth(char*, int, int);
void ChangeBondDivide(char*, int, int);
void GravityPoint(double*, double*, double*);
void ResidueSeqNo(void);
void DisplayOnlyCA(void);
void ReDisplayOnlyCA(void);

class coodinate
{
  double x, y, z;

  friend class secondStructure;
  friend class atom;
  friend class residue;

 public:
  coodinate(void);
  coodinate(coodinate& A);
  coodinate(double a, double b, double c);
  void print(void);
  void normalize(void);
  void Rotate(coodinate&, coodinate&, double);
  double Rotate2(coodinate&, coodinate&, coodinate&, double);
  inline void CoodinateSetX(double a){x = a;}
  inline void CoodinateSetY(double a){y = a;}
  inline void CoodinateSetZ(double a){z = a;}
  inline double CoodinateX(void){return x;}
  inline double CoodinateY(void){return y;}
  inline double CoodinateZ(void){return z;}
  void operator=(coodinate& B);
};

class secondStructure :public header
{
  coodinate begin;
  coodinate end;
  int beginID;
  int endID;
  char oligo;
  secondStructure* head;
  secondStructure* tail;

 public:
  secondStructure(void);
//  ~secondStructure(void);
  secondStructure(secondStructure& A);
  void HelixSetBegin(coodinate);
  void HelixSetEnd(coodinate);
  void append(int a, int b, char c);
  secondStructure* GetHelix(int a);
  inline void HelixSetBeginID(int a){beginID = a;}
  inline void HelixSetEndID(int a){endID = a;}
  inline void HelixSetOligo(char a){oligo = a;}
  inline coodinate Begin(void){return begin;}
  inline coodinate End(void){return end;}
  inline int BeginID(void){return beginID;}
  inline int EndID(void){return endID;}
  inline char Oligo(void){return oligo;}
  inline secondStructure* heads(void){return head;}
  inline secondStructure* tails(void){return tail;}
  void print(void);
  void print(int a){GetHelix(a)->print();}
};

class residue :public header
{
  char aminoID[4];
  int resID;
  unsigned atomSum;
  residue* head;
  residue* tail;
  atom* firstAtom;
  atom* lastAtom;

  friend class chain;

 public:
  residue(void);
  residue(residue& A);
//  ~residue(void){}
  void AtomSumSet(unsigned a);
  residue* Append(char*, int);
  void AppendAtom(char a, coodinate& b, int c, int d, int e);
  void print(void);
  inline char* aminoIDs(void){return aminoID;}
  inline int resIDs(void){return resID;}
  inline residue* heads(void){return head;}
  inline residue* tails(void){return tail;}
  inline void first(atom* a){firstAtom = a;}
  inline void last(atom* a){lastAtom = a;}
  inline atom* first(void){return firstAtom;}
  inline atom* last(void){return lastAtom;}
//  inline Append(char* a,coodinate b,int c){firstAtom->Append(a, b, c);}
};

class chain :public header
{
  char chainID;
  int num;
  int* residueTable;
  chain* top;
  chain* bottom;
  residue* firstResidue;
  residue* lastResidue;

  friend class residue;

 public:
  chain(void);
  chain(chain& A);
//  ~chain(void){}
  chain*   Append(char A);
  residue* Append(char* a, int b);      // Residue Append
  chain* GetChain(int a);
  residue* GetResidue(int a);
  inline void print(int a){GetChain(a)->print();}
  inline void chainIDs(char& A){chainID = A;}
  inline void nums(int A){num = A;}
  inline void residueTables(int* A){residueTable = A;}
  inline void residueTables(int A, int B){residueTable[A] = B;}
  inline void firstResidues(residue* A){firstResidue = A;}
  inline void lastResidues(residue* A){lastResidue = A;}
  inline char chainIDs(void){return chainID;}
  inline int nums(void){return num;}
  inline int* residueTables(void){return residueTable;}
  inline int residueTables(int A){return residueTable[A];}
  inline chain* tops(void){return top;}
  inline chain* bottoms(void){return bottom;}
  inline residue* firstResidues(void){return firstResidue;}
  inline residue* lastResidues(void){return lastResidue;}
  void print();
};

extern coodinate operator-(coodinate& A, coodinate& B);
extern coodinate operator+(coodinate& A, coodinate& B);
extern coodinate operator/(coodinate& A, double B);
extern coodinate operator*(coodinate& A, double B);
extern coodinate operator^(coodinate& A, coodinate& B);
extern double operator|(coodinate& A, coodinate& B);
extern coodinate Normalize(coodinate& A);
extern void printChain(chain* A);
extern void Sphere(char A, int C, coodinate& B);

#endif /* eof ifndef _pdb_h_ */
