/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*
  atom.c
*/
#include <stdio.h>
#include "atom.h"

atom::atom(void)
{
  name = '\0';
  //axiz.coodinate();
  atomID = 0;
  remoteness = 0;
  branch = 0;
  bond1 = NULL;
  bond2 = NULL;
  bond3 = NULL;
  bond4 = NULL;
  head  = NULL;
  tail  = NULL;
}

atom::atom(atom& A)
{
  name = A.names();
  axiz = A.axizs();
  atomID = A.atomIDs();
  remoteness = A.remotenesses();
  branch = A.branchs();
  bond1 = A.bonds(1);
  bond2 = A.bonds(2);
  bond3 = A.bonds(3);
  bond4 = A.bonds(4);
  head = A.heads();
  tail = A.tails();
}

atom* atom::GetAtom(int a)
{
  atom *newnode = head;
  for(int i=0; i<a; ++i) newnode = (atom*)newnode->Next();
  return newnode;
}


void atom::Append(char a, coodinate& b, int c, int d)
{
  atom *newnode;
  if(head){
    newnode = new atom;
    newnode->name = a;
    newnode->axiz = b;
    newnode->remoteness = c;
    newnode->branch = d;
    tail->Next(newnode); // from container
    tail = newnode;
    newnode->print();
  }else{
    head = new atom;
    tail = new atom;
    head->name = a;
    head->axiz = b;
    head->remoteness = c;
    head->branch = d;
    tail = head;
  }
}

//void atom::Location(){
//  object_location->location(axiz.CoodinateX(), CoodineteY(), CoodinateZ());
//}

void atom::print(void)
{
  atom* newnode = head;
  while(newnode != NULL){
    printf("\t%c %d %d\n", newnode->name, newnode->remoteness,newnode->branch);
    newnode = (atom*)newnode->Next();
  }
}

void printAtom(atom* A)
{
  while(A != NULL){
    printf("\t\t\t%c %d %d", A->names(), A->remotenesses(), A->branchs());
    A->axizs().print();
    putchar('\n');
    A =(atom*)A->Next();
  }
}

void printAtomSingle(atom* A)
{
  if(A != NULL){
    printf("\t\t\t%c %d %d", A->names(), A->remotenesses(), A->branchs());
    A->axizs().print();
  }
  putchar('\n');
}

void bonds(atom* A, atom* B)
{
  for(int i=2;i<=4;++i){
    if(A->bonds(i) == NULL){
      A->bonds(i,B);
      return;
    }
  }
}
