/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdlib.h>
#include <stream.h>
#include <math.h>
#include "wavelet.h"

wavelet::wavelet(int NW,int W)
{
  NumberOfWavelets = NW;
  Width            =  W;
  Wavelets         = new double[W*NW];

  
  for(int I=0;I<NumberOfWavelets;++I)
    {
      for(int J=0;J<Width;++J)
	{
	  position(I,J) =  pow(coordinate(J),float(I));
	}
    }

  for(    I=0;I<NumberOfWavelets;++I)
    {
      double Tmp[Width];
      for(int J=0;J<Width;++J)
	Tmp[J] = position(I,J);
      for(int Order=I-2;Order>=0;Order-=2)
	{
	  double Coef = product(I,Order);
	  for(int J=0;J<Width;++J)
	    {
	      Tmp[J] -= Coef*position(Order,J);
	    }
	}
      double Norm = 0;
      for(J=0;J<Width;++J)
	Norm += Tmp[J]*Tmp[J];
      for(J=0;J<Width;++J)
	position(I,J) = Tmp[J]/sqrt(Norm);
    }
}

