/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <stream.h>
#include <GetOpt.h>
#include "multivar.h"

main(int argc,char** argv)
{
  int PValFlag = 0;
  int OrigFlag = 0;
  int HistFlag = 0;
  int SmthFlag = 0;
  int POutFlag = 0;
  int QuntFlag = 0;
  GetOpt getopt (argc, argv, "pohsxq");

  int Ch;
  while((Ch=getopt())!=EOF)
    {
      switch(char(Ch))
	{
	case 'p':
	  PValFlag = 1;
	  break;
	case 'o':
	  OrigFlag = 1;
	  break;
	case 'h':
	  HistFlag = 1;
	  break;
	case 's':
	  SmthFlag = 1;
	  break;
	case 'x':
	  POutFlag = 1;
	  break;
	case 'q':
	  QuntFlag = 1;
	  break;
	default:
	  exit(1);
	}
    }

  char DataFileName[256];

  if(getopt.optind < argc)
    {
      strcpy(DataFileName,argv[getopt.optind++]);
    }
  else
    {
      cerr << "Usage\n\tmultivar DataFile Field Field Field ... -[pohsxq] \n";
      exit(0);
    }

  int FieldID[32];
  int FieldCnt = 0;

  while(getopt.optind <argc)
    {
      FieldID[FieldCnt++] = atoi(argv[getopt.optind++]);
    }
  if(FieldCnt==0)
    {
      cerr << "Usage\n\tmultivar DataFile Field Field Field ... -[po] \n";
      exit(0);
    }
  multiData* MultiData =
    new multiData(DataFileName,FieldCnt,FieldID,PValFlag,OrigFlag);
  MultiData->multivar()->print();
  if(HistFlag)
    {
      MultiData->makeHistogram();
      MultiData->printHistogram();
      if(SmthFlag)
	{
	  MultiData->smoothHistogram();
	  MultiData->printHistogramSmooth();
	}
    }
  if(POutFlag)
    {
      MultiData->printPrincipalVal();
    }
  if(QuntFlag)
    {
      char DivFileName[256];
      strcpy(DivFileName,DataFileName);
      strcat(DivFileName,".DIV");
      MultiDataList = new multiDataList;
      FILE* DivFile;
      if(NULL==(DivFile=fopen(DivFileName,"w")))
	{
	  cerr << form("Can't open div file %s\n",DivFileName);
	  exit(1);
	}
      if(MultiData->div(DataFileName,DivFile,0,1,
		     SmthFlag,FieldID,PValFlag,OrigFlag))
	{
	  MultiDataList->push(MultiData);
	  fprintf(DivFile,"No subcluster found!\n");
	}
      fclose(DivFile);
    }
}

