/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <stream.h>
#ifndef _math_h_
#include <math.h>
#define _math_h_
#endif

#ifndef _stdlib_h_
#include <stdlib.h>
#define _stdlib_h_
#endif

#ifndef _matrix_h_
#define _matrix_h_

const int    MAX_ITER = 100;
const double EPS      = 1E-6;

class eigenvalue ;
class matrix
{
 protected:
  unsigned int    Nsize;
  unsigned int    DimI;
  unsigned int    DimJ;
  double* D;
 public:
  inline          matrix(int M,int N)
    {
      if(M<=0||N<=0) { ::cerr << "wrong matix size\n"; return;}
      Nsize=M*N; DimI=M; DimJ=N; D = new double[Nsize];
      for(int I=0;I<M;++I) for(int J=0;J<N;++J) D[I*DimJ+J]=0.0;
    }
  inline          matrix(void)       { Nsize=0;D=(double*)0; DimI=0;DimJ=0;}
  inline          matrix(matrix& A)  { Nsize = 0; copy(A);}

  virtual         ~matrix(void);
  virtual void    zap   (void);
  virtual void    reset (void);

  inline  int     sizeN( void)       { return (unsigned int)Nsize;}
  inline  int     sizeI( void)       { return DimI;}
  inline  int     sizeJ( void)       { return DimJ;}
  inline  void    sizeN(int N)       { Nsize = (unsigned int)N;}
  inline  void    sizeI(int I)       { DimI = (unsigned int)I;}
  inline  void    sizeJ(int J)       { DimJ = (unsigned int)J;}
  inline  double  mat  (int I, int J){return D[I*DimJ + J];}
  inline  int     pivot(int* Q,int K)
    {
      double Max = 0.0;
      int    L   =   0;
      for(int I=K;I<DimI;I++,Q++)
	{ if(*Q == 0) if(fabs(D[I*DimJ+K])>Max) { Max=fabs(D[I*DimJ+K]);L=I;}}
      if(Max < EPS) { cerr<<form("Too Small Pivot 2\n Max %f\n",Max);exit(1);}
      return L;
    }
  inline  double& operator ()(int I, int J)
    {
      if(I<0||I>= DimI||J<0||J>=DimJ) { cerr<<"out of range. \n";exit(1);}
      return D[I*DimJ + J];
    }      

          void    copy          (matrix& A);
          void    print         (void);
          double  determinant   (void);
          matrix  tr            (void);
          matrix  inverse       (void);
          void    changeline    (int m1, int m2);
          double  innerproduct  (int n, double* u, double* v);
          double  householder   (int n, double* x);
          void    tridiagonalize(double* d, double* e);
          void    operator     =(matrix& B);
  
          eigenvalue eigen      (void);

  friend  void    operator/=(matrix& A, double B);      
  friend  void    operator*=(matrix& A, double B);
};

extern    matrix  operator-(matrix& A);
extern    matrix  operator+(matrix& A);
extern    matrix  operator+(matrix& A, matrix& B);
extern    matrix  operator-(matrix& A, matrix& B);
extern    matrix  operator*(matrix& A, matrix& B);
extern    matrix  operator*(double  K, matrix& A);
extern    matrix  operator*(matrix& A, double  K);
extern    matrix  operator/(matrix& A, double  K);

#endif /* eof ifndef _matrix_h_ */

