/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include "local.h"

wavelet  Wavelet;

d3vector localStruct::center(void)
{
  d3vector Center;
  for(int I = 0;I<Width;++I)
    {
      Center += Residues[I].coordinate();
    }
  return Center/(double)Width;
}

void localStruct::input(int R,amino& A,d3vector& C, int I)
{
  FullCnt++;
  if(StartPoint < Width-1)
    {
      StartPoint++;
    }
  else
    {
      StartPoint = 0;
    }

  InternalSum += (FullCnt > Width ? I - Residues[StartPoint].internality():I);
  Residues[StartPoint].order()       = R;
  Residues[StartPoint].amino()       = A;
  Residues[StartPoint].coordinate()  = C;
  Residues[StartPoint].internality() = I;

  if(FullCnt >= Width)
    {
      longVec();
      bendVec();
      VecK       = LongVector.normalize();
      VecJ       = VecK*BendVector.normalize();
      VecI       = VecJ*VecK;
      AngleLongBend = LongVector & BendVector;
    }
}

void localStruct::longVec(void)
{
  LongVector.init();
  for(int I = 0; I < Width; ++I)
    {
      LongVector += Wavelet(1,I)*residue(I).coordinate();
    }
}

void localStruct::bendVec(void)
{
  BendVector.init();
  for(int I = 0; I < Width; ++I)
    {
      BendVector += Wavelet(2,I)*residue(I).coordinate();
    }
}

double localStruct::elemI(d3vector& Vector)
{
  return VecI % Vector;
}

double localStruct::elemJ(d3vector& Vector)
{
  return VecJ % Vector;
}

double localStruct::elemK(d3vector& Vector)
{
  return VecK % Vector;
}

int  localStruct::parity(d3vector& Vector)
{
  return (VecJ % Vector >= 0.0? +1:-1);
}

double   localStruct::angleLong(d3vector& Vector)
{
  return LongVector & Vector;
}

double   localStruct::angleBend(d3vector& Vector)
{
  return BendVector & Vector;
}

d3vector localStruct::startVector(void)
{
  return LongVector/2.0 - BendVector;
}

d3vector localStruct::endVector(void)
{
  return BendVector + LongVector/2.0;
}

d3vector localStruct::wv3Vector(void)
{
  d3vector Wv3Vector;
  for(int I = 0; I < Width; ++I)
    {
      Wv3Vector += Wavelet(3,I)*residue(I).coordinate();
    }
  return Wv3Vector;
}

d3vector localStruct::wv4Vector(void)
{
  d3vector Wv4Vector;
  for(int I = 0; I < Width; ++I)
    {
      Wv4Vector += Wavelet(4,I)*residue(I).coordinate();
    }
  return Wv4Vector;
}

d3vector localStruct::rotVector(void)
{
  d3vector RotVector;
  for(int I=0;I<Width-2;++I)
    {
      d3vector VA,VB;
      VA = residue(I+1).coordinate()-residue(I).coordinate();
      VB = residue(I+2).coordinate()-residue(I+1).coordinate();
      d3vector PAB;
      PAB = VA*VB;
      RotVector += PAB/(PAB.length())*(VA & VB);
    }
  return RotVector;
}

d3vector localStruct::intVector(void)
{
  d3vector IntVector;
  for(int I = 0; I < Width; ++I)
    {
      IntVector += residue(I).coordinate()
	*(Wavelet(0,I)*(residue(I).internality()
		       -(float)InternalSum/(float)Width)/2.0);
    }
  return IntVector;
}

double   localStruct::int0(void)
{
  double Int0 = 0.0;
  for(int I = 0; I < Width; ++I)
    {
      Int0 += Wavelet(0,I)*residue(I).internality();
    }
  return Int0;
}
  
double   localStruct::int1(void)     
{
  double Int1 = 0.0;
  for(int I = 0; I < Width; ++I)
    {
      Int1 += Wavelet(1,I)*residue(I).internality();
    }
  return Int1;
}

double   localStruct::int2(void)
{
  double Int2 = 0.0;
  for(int I = 0; I < Width; ++I)
    {
      Int2 += Wavelet(2,I)*residue(I).internality();
    }
  return Int2;
}

void localStruct::printSeq(void)
{
  char* Seq = new char[Width+1];
  Seq[Width]  = '\0';
  for(int I=0;I<Width;++I)
    Seq[I] = residue(I).amino().single();
  printf(" %s",Seq);
  delete Seq;
}

