/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <math.h>
#include <stdlib.h>
#include <stream.h>
#include "eigenvalue.h"


eigenvalue::eigenvalue(int M) : matrix(M,M)
{

}

eigenvalue::eigenvalue(void) : matrix()
{

}

eigenvalue::~eigenvalue(void)
{
  if (DimI>0) {
    delete val;
  }
}

void eigenvalue::print()
{
  cout << "{\n";
  for (int I = 0; I < DimI; ++I) {
    cout.form("%10.4e ", val[I]);
    cout << "  {";
    for (int J = 0; J < DimJ; ++J) {
      cout.form("%10.4e ", D[I*DimJ + J]);
    }
    cout << "}\n";
  }
  cout <<  "}\n";
}

double eigenvalue::value(int d)
{
  return *(val+d);
}

eigenvalue::eigenvalue(matrix& A,double* d)
{
  if (DimI >0) {
    delete val;
  }
  copy(A);
  val = new double [DimI];
  double* wp = val;
  for (int c = 0;c<DimI;c++) {
    *wp++ = *d++;
  }
}

void eigenvalue::copy(eigenvalue& A) {
  int masize = A.sizeN();
  DimI = A.sizeI(); 
  DimJ = A.sizeJ(); 
  if (Nsize >0) {
    if (Nsize != masize) {
      delete D;
      delete val;
      D = new double [masize];
      val = new double [DimI];
    }
  } else if (Nsize == 0) {
    D = new double [masize];
    val = new double [DimI];
  }
  Nsize = masize;
  for (int I = 0; I < DimI; I++) {
    for (int J = 0; J < DimJ; J++) {
      D[I*DimJ + J] = A(I,J);
    }
    val[I] = A.value(I);
  }
}

void operator=(eigenvalue& A,eigenvalue& B)
{
  A.copy(B);
}

eigenvalue matrix::eigen(void)
{
  matrix A(DimI,DimJ);
  double* LA;
  LA = new double[DimJ];
  double* work;
  double* v;
  work = new double[DimI];
  v = new double[DimI];
  for ( int I = 0; I < DimI; ++I) {
    for ( int J = 0; J < DimJ; ++J) {
      A(I,J) = D[I*DimJ + J];
    }
  }
  A.tridiagonalize(LA,&work[1]);
  work[0] = 0;//$@HV?M(J
  double t = 0.0;
  for (int h=DimI-1; h>0; --h)
    {
      int j=h;
      while(fabs(work[j]) > EPS * (fabs(LA[j-1]) + fabs(LA[j]))) j--;
      if (j == h) continue;
      int iter = 0;
      do {
	if (++iter > MAX_ITER) {
	  cerr << "not --------\n";
	  exit(1);
	}
	double w = (LA[h-1] - LA[h]) / 2;
	t = work[h] * work[h];
	double s = sqrt(w * w + t);
	if (w < 0) {
	  s = -s;
	}
	double x = LA[j] - LA[h] + t / (w + s);
	double y = work[j+1];
	double c = 0.0;
	for (int k=j; k<h; ++k) {
	  if (fabs(x) >= fabs(y))  {
	    t = -y / x;
	    c = 1 / sqrt(t * t + 1);
	    s = t * c;
	  } else {
	    t = -x / y;
	    s = 1 / sqrt(t * t + 1);
	    c = t * s;
	  }
	  w = LA[k] - LA[k+1];
	  t = ( w * s + 2 * c * work[k+1]) * s;
	  LA[k] -= t;
	  LA[k+1] += t;
	  if (k > j) work[k] = c * work[k] - s * y;
	  work[k+1] += s * (c * w - 2 * s * work[k+1]);
	  // $@0J2<$O8GM-/7/22/92k$r5a$a$(Jk
	  for (int i=0; i<DimI; ++i) {
	    x = A(k,i);
	    y = A(k+1,i);
	    A(k,i)   = c * x - s * y;
	    A(k+1,i) = s * x + c * y;
	  } 
	  if (k < h-1) {
	    x = work[k+1];
	    y = -s * work[k+2];
	    work[k+2] *= c;
	  }
	}
      } while (fabs(work[h]) > EPS * (fabs(LA[h-1]) + fabs(LA[h])));
    }
  // $@@0Ns(J
    for (int k=0; k<DimI-1; ++k){
      h = k;
      t = LA[h];
      for (int i=k+1; i<DimI; ++i) {
	if (LA[i] > t) {
	  h = i;
	  t = LA[h];
	}
      }
      LA[h] = LA[k];
      LA[k] = t;
      A.changeline(h,k);
    }
  eigenvalue V(A,LA);
  return V;
}

