/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <math.h>
#include <stdlib.h>
#include <stream.h>
#include "d3vector.h"


d3vector::d3vector(double X,double Y,double Z):matrix(3,1)
{
  D[0] = X;
  D[1] = Y;
  D[2] = Z;
}

d3vector::d3vector(void) :matrix(3,1)
{
}

d3vector::~d3vector(void)
{
}

void d3vector::init(void)
{
  D[0] = D[1] = D[2] = 0.0;
}

void d3vector::print(void)
{
  cout << form("{\t%g,\t%g,\t%g\t}\n",D[0],D[1],D[2]);
}

void d3vector::pmPrint(void)
{
  cout << (D[0]>0?"+":"-")<< (D[1]>0?"+":"-")<< (D[2]>0?"+":"-") <<"\n";
}

double & d3vector::operator ()(int I)
{
  if (I < 0 || I >= DimI ) {
      cerr << "out of range. \n";
      exit(1);
  }
  return D[I];
}      


double d3vector::length(void)
{
  double V=0.0;
  for(int I = 0;I<3;++I)
    {
      V += D[I]*D[I];
    }
  return sqrt(V);
}

d3vector d3vector::normalize(void)
{
  d3vector N(*this);
  double Length = length();
  for(int I = 0;I<3;++I)
    N.D[I] /= Length;
  return N;
}

d3vector operator*(d3vector& A, d3vector& B)
{
  d3vector C;
  C(0) = A(1) * B(2) - A(2) * B(1);
  C(1) = A(2) * B(0) - A(0) * B(2);
  C(2) = A(0) * B(1) - A(1) * B(0);
  return C;
}

double operator%(d3vector& A, d3vector& B)
{
  double V=0.0;
  for(int I = 0;I<3;++I)
    {
      V += A(I)*B(I);
    }
  return V;
}

double operator^(d3vector& A, d3vector& B)
{
  return (A - B).length();
}

double operator&(d3vector& A, d3vector& B)
{
  double Len2 = A.length()*B.length();
  if(Len2 < 0.000000000000001)
    return 0.0;
  double X = (A % B)/Len2;
  if(X < -0.999999999999999)
    return M_PI;
  if( X > 0.999999999999999)
    return 0.0;
  return acos(X);
}

d3vector operator*(double& K,d3vector& A)
{
  d3vector C;
  for(int I = 0;I<3;++I)
    C(I) = A(I)*K;
  return C;
}

d3vector operator*(d3vector& A, double& K)
{
  d3vector C;
  for(int I = 0;I<3;++I)
    C(I) = A(I)*K;
  return C;
}

d3vector operator/(d3vector& A, double& K)
{
  d3vector C;
  for(int I = 0;I<3;++I)
    C(I) = A(I)/K;
  return C;
}

d3vector operator+(d3vector& A, d3vector& B)
{
  d3vector C;
  for(int I=0;I<3;++I)
    C(I) = A(I) + B(I);
  return C;
}

d3vector operator-(d3vector& A, d3vector& B)
{
  d3vector C;
  for(int I=0;I<3;++I)
    C(I) = A(I) - B(I);
  return C;
}

d3vector operator-(d3vector& A)
{
  d3vector C = -1.0 * A;
  return C;
}

d3vector operator=(d3vector& A, d3vector& B)
{
  A.copy(B);
  return A;
}

d3vector operator+=(d3vector& A, d3vector& B)
{
  A(0) += B(0);
  A(1) += B(1);
  A(2) += B(2);
  return A;
}


d3vector operator-=(d3vector& A, d3vector& B)
{
  A(0) -= B(0);
  A(1) -= B(1);
  A(2) -= B(2);
  return A;
}

d3vector operator*=(d3vector& A, double&   K)
{
  A(0) *= K;
  A(1) *= K;
  A(2) *= K;
  return A;
}

d3vector operator/=(d3vector& A, double&   K)
{
  A(0) /= K;
  A(1) /= K;
  A(2) /= K;
  return A;
}

