/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <math.h>
#include <gl/gl.h>
#include <gl/device.h>
#include "ui.h"

static int exitflag = FALSE;
static int activeflag = TRUE;
static int rotateflag = FALSE;
static int zoomflag = FALSE;
static int panflag = FALSE;
static int sbflag = FALSE;
static void (*user_fn)(float *, float*);
static short omx= (-1), omy = (-1), nmx = (-1), nmy = (-1);
static float t_rate = 0.00000005;
static float r_rate = 0.0000005;
static float txyz[3], rxyz[3], period;
static int have_all = 0;
static int all_zero = 0;

int ui_quiet = TRUE;
int ui_noisy = FALSE;
int mouse_noisy = FALSE;
int spaceball_noisy = FALSE;
long sizex, sizey, origx, origy;

void ui_redraw(long event,short val)
{
  reshapeviewport();
  getsize(&sizex, &sizey);
  getorigin(&origx, &origy);
}

void ui_exit(long event,short val)
{
  exitflag = 1;
}

void figure_ui_noisy(void)
{
  ui_noisy = zoomflag | panflag | rotateflag | sbflag;
  ui_quiet = !ui_noisy;
}

void ui_lmdown(long event,short val)
{
  if (activeflag) {
    if (rotateflag == TRUE) {
      zoomflag = TRUE;
      rotateflag = FALSE;
    } else {
      panflag = TRUE;
      mouse_noisy = TRUE;
      figure_ui_noisy();
    }
  }
}

void ui_lmup(long event,short val)
{
  if (activeflag) {
    if (zoomflag == TRUE) {
      zoomflag = FALSE;
      rotateflag = TRUE;
    } else {
      panflag = FALSE;
      mouse_noisy = FALSE;
      figure_ui_noisy();
      omx = omy = nmx = nmy = (-1);
    }
  }
}

void ui_mmdown(long event,short val)
{
  if (activeflag) {
    if (panflag == TRUE) {
      zoomflag = TRUE;
      panflag = FALSE;
    } else {
      rotateflag = TRUE;
      mouse_noisy = TRUE;
      figure_ui_noisy();
    }
  }
}

void ui_mmup(long event,short val)
{
  if (activeflag) {
    if (zoomflag == TRUE) {
      zoomflag = FALSE;
      panflag = TRUE;
    } else {
      rotateflag = FALSE;
      mouse_noisy = FALSE;
      figure_ui_noisy();
      omx = omy = nmx = nmy = (-1);
    }
  }
}

void ui_zoom(void)
{
  float r[4], t[3];
  vset(r,0,0,0);
  r[3] = 1.0;
  vset(t,0,0,0);
  t[2] = (float)(nmx-omx)/(float)sizex +(float)(nmy-omy)/(float)sizey;
  (*user_fn)(r, t);
}

void ui_pan(void)
{
  float r[4], t[3];
  vset(r,0,0,0);
  r[3] = 1.0;
  vset(t, (float)(nmx-omx)/(float)sizex,(float)(nmy-omy)/(float)sizey, 0.0);
  (*user_fn)(r, t);
}

void ui_to_worldspace(short sx, short sy, float * wx, float * wy)
{
  (*wx) = (2.0 * sx) / (float) sizex - 1.0;
  (*wy) = (2.0 * sy) / (float) sizey - 1.0;
}

void ui_rotate(void)
{
  float p1x, p1y, p2x, p2y ;
  float r[4], t[3] ;
  vset(t,0,0,0);
  ui_to_worldspace(omx-origx, omy-origy, &p1x, &p1y);
  ui_to_worldspace(nmx-origx, nmy-origy, &p2x, &p2y);
  /*printf ("ui_rot p1x %f p1y %f p2x %f p2y %f\n",p1x, p1y, p2x, p2y );*/
  trackball(r, p1x, p1y, p2x, p2y);
  /*printf ("ui_rot r[0] %f r[1] %f r[2] %f r[3] %f\n",r[0],r[1],r[2],r[3] );*/
  (*user_fn)(r, t);
}
void ui_mouseupdate()
{
  nmx = getvaluator(CURSORX);
  if (omx == (-1)) omx = nmx;
  nmy = getvaluator(CURSORY);
  if (omy == (-1)) omy = nmy;
  if (panflag) {
    ui_pan();
  }else if (zoomflag){
    ui_zoom();
  } else if (rotateflag) {
    ui_rotate();
  }
  omx = nmx; omy = nmy;
}

void ui_SBevent(long event, short val)
{
  int bit = 0;
  switch(event) {
  case SBTX:
    txyz[0] = (float)val;
    bit = 0x1;
    break;
  case SBTY:
    txyz[1] = (float)val;
    bit = 0x2;
    break;
  case SBTZ:
    txyz[2] = -(float)val;
    bit = 0x4;
    break;
  case SBRX:
    rxyz[0] = (float)val;
    bit = 0x8;
    break;
  case SBRY:
    rxyz[1] = (float)val;
      bit = 0x10;
    break;
  case SBRZ:
    rxyz[2] = -(float)val;
    bit = 0x20;
    break;
  case SBPERIOD:
    period = (float)val;
      bit = 0x40;
    break;
  }
  if (val == 0) {
    all_zero |= bit;
  }
  have_all |= bit;
  if (have_all == 0x7F)  {
    spaceball_noisy = TRUE;
    have_all = 0;
  }
}

void ui_active(int flag)
{
  activeflag = flag ;
  if (!flag) {
    zoomflag = panflag = rotateflag = sbflag = FALSE;
    figure_ui_noisy();
  }
}

void SBaxistoquat(float scale, float rvec[3], float q[4])
{
  float rads;
  rads = vlength(rvec);
  if (rads == 0.0) {
    q[0] = q[1] = q[2] = 0.0;
    q[3] = 1.0;
    return;
  }
  axis_to_quat(rvec, rads*scale/2.0, q);
}

void  ui_sbupdate(void)
{
  float tran[3], rot[4];
  float sup = t_rate * period;
  if (all_zero == 0x7F)  {
    sbflag = FALSE;
    figure_ui_noisy();
  }
  tran[0] = sup * txyz[0];
  tran[1] = sup * txyz[1];
  tran[2] = sup * txyz[2];
  SBaxistoquat(-r_rate * period, rxyz, rot);
  (*user_fn)(rot, tran);
  all_zero = 0;
  spaceball_noisy = FALSE;
}

void ui_init(void)
{
  long gid;
  gid = winget();
  getsize(&sizex, &sizey);
  getorigin(&origx, &origy);
  qdevice(REDRAW);
  qdevice(LEFTMOUSE);
  qdevice(MIDDLEMOUSE);
  qdevice(CURSORX);
  qdevice(CURSORY);
  qdevice(SBTX);
  qdevice(SBTY);
  qdevice(SBTZ);
  qdevice(SBRX);
  qdevice(SBRY);
  qdevice(SBRZ);
  qdevice(SBPERIOD);
  tie(LEFTMOUSE, CURSORX, CURSORY);
  tie(MIDDLEMOUSE, CURSORX, CURSORY);
  add_event(gid, REDRAW, ANY, (void(*)(void*,int))ui_redraw, 0);
  add_event(gid, LEFTMOUSE, DOWN, (void(*)(void*,int))ui_lmdown, 0);
  add_event(gid, LEFTMOUSE, UP, (void(*)(void*,int))ui_lmup, 0);
  add_event(gid, MIDDLEMOUSE, DOWN, (void(*)(void*,int))ui_mmdown, 0);
  add_event(gid, MIDDLEMOUSE, UP, (void(*)(void*,int))ui_mmup, 0);
  add_update(&mouse_noisy, ui_mouseupdate, 0);
  add_event(gid, SBTX, ANY, (void(*)(void*,int))ui_SBevent, (void *)SBTX);
  add_event(gid, SBTY, ANY, (void(*)(void*,int))ui_SBevent, (void *)SBTY);
  add_event(gid, SBTZ, ANY, (void(*)(void*,int))ui_SBevent, (void *)SBTZ);
  add_event(gid, SBRX, ANY, (void(*)(void*,int))ui_SBevent, (void *)SBRX);
  add_event(gid, SBRY, ANY, (void(*)(void*,int))ui_SBevent, (void *)SBRY);
  add_event(gid, SBRZ, ANY, (void(*)(void*,int))ui_SBevent, (void *)SBRZ);
  add_event(gid, SBPERIOD, ANY, (void(*)(void*,int))ui_SBevent, (void *)SBPERIOD);
  add_update(&spaceball_noisy, ui_sbupdate, NULL);
}

void ui(void (*fn)(float *, float *))
{
  static int initialized = 0;	/* Initialized yet? */
  user_fn = fn;
  if (!initialized) {
    ui_init();
    initialized = 1;
  }
  while (exitflag == 0) {
    event();
  }
}


