/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -*-C++-*- */

#ifndef _DISABLE_GL_
#include <gl/gl.h>
#include <gl/device.h>
#include <fmclient.h>
#endif
#include "group.h"
#include "text.h"
#include "hash.h"
#include "data.h"
#include "node.h"
#include "symbol.h"
#include "exit.h"

extern char line_buffer[BUFSIZ];
extern group* root_obj;
extern int line_number;

char* errmsg_text_material_invalid = "Fatal : \ntext member material invalid object\n";
char* errmsg_text_font_invalid = "Fatal : \ntext member font invalid object\n";
char* errmsg_text_string_invalid = "Fatal : \ntext member string invalid object\n";
char* errmsg_text_size_invalid = "Fatal : \ntext member size invalid object\n";

node* default_font_name;
node* default_font_size;

void initialize_text_font()
{
  fixed_number* default_font_size_val;
  string* default_font_name_val;
  default_font_name_val = new string[1];
  default_font_size_val = new fixed_number[1];
  default_font_name_val->Id(hash_table.wordId("Times-Bold"));
  default_font_size_val->Value(14);
  default_font_name_val->Split();
  default_font_size_val->Split();
  default_font_name = (node*)root_obj->Search_and_Create("DefaultFont");
  default_font_size = (node*)root_obj->Search_and_Create("DefaultFontSize");
  default_font_name->Value(default_font_name_val);
  default_font_size->Value(default_font_size_val);
}

 text::text()
{
  type = PR_TEXT;
  sym_id = sym_text;
  dstate = ObjectHidding;
  obj[0].Id(sym_om_string);
  obj[1].Id(sym_om_font);
  header* value;
  value = default_font_name->Value();
  value->Split();
  obj[1].Value(value);
  obj[2].Id(sym_om_size);
  value = default_font_size->Value();
  value->Split();
  obj[2].Value(value);
}

 void text::Close()
{
  ref_c--;
  if (ref_c == 0){
    header* value;
    for (int co = 0;co < TEXT_WORD_SIZE;co++) {
      value = obj[co].Value();
      if (value != (header*)0) {
	value->Close();
      }
    }
    free(this);
  }
}
 void text::CopySplitMember()
{
  object_location->Split();
  object_rotation->Split();
  int color_id = color->Id();
  header* cv = color->Value();
  cv->Split();
  color = new node[1];
  color->Split();
  color->Id(color_id);
  color->Value(cv);
  header* value;
  value = obj[0].Value();
  value->Split();
  value = obj[1].Value();
  value->Split();
  value = obj[2].Value();
  value->Split();
}

void text::Draw()
{
#ifndef _DISABLE_GL_
  if (dstate == ObjectHidding) return;
  if (scale == 0) return;
  check_material_and_bind(color->Value(),errmsg_text_material_invalid);
  PushScale();
  PushTranslation();
  char* text_str;
  text_str = string2cstr(obj[0].Value(),errmsg_text_string_invalid);
  char* fname;
  fname = string2cstr(obj[1].Value(),errmsg_text_font_invalid);
  fmfonthandle f_val;
  f_val = fmfindfont((const char*)(fname));
  if (!f_val) {
    fprintf(stderr,"Fatal :\nInvalid font name %s\n",fname);
    error_exit();
  }else{
    fmfonthandle f_val2;
    double fnt_size ;
    fnt_size = (double)numerical2float(obj[2].Value(),errmsg_text_size_invalid);
    f_val2 = fmscalefont(f_val,fnt_size);
    fmsetfont(f_val2);
    cmovs(0,0,0);
    fmprstr(text_str);
    /* fmfprstr IndigoǤѤǤ뤬¾ǤΤ */
    /* fmprstrѤƤ롣 */
  }
  PopTranslation();
  PopScale();
#endif
}

header*  text::Reference(int id)
     //{}
     //ƥȥ֥ȤΥл
     //ϥåidĥ̾ΥФ¸ߤС
     //ФΥΡɤΥɥ쥹֤ǤʤС
     //0֤
     //{}
{
  if (sym_om_color == id) {
    return (header*)(color);
  }
  int c;
  for (c = 0;c<TEXT_WORD_SIZE ;c++) {
    if ((obj[c].Id()) == id) {
      return (header*)(obj+c);
    }
  }
  return (header*)0;
}

void text::Scale(double s)
{
  scale = s;
}
