/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include "hash.h"
#include "message.h"
#include "data.h"
#include "function.h"
#include "boolean.h"
#include "parse.tab.h"
#include "token.h"

#include "group.h"
#include "light.h"
#include "color_obj.h"
#include "sphere.h"
#include "cylinder.h"
#include "primitive.h"
#include "text.h"
#include "box.h"

#ifdef _DISABLE_GL_
#include "../prtalk/bond.h"
#include "../prtalk/helix.h"
#include "../prtalk/sheet.h"
#endif

/* åο  饹ο   */
#ifdef _DISABLE_GL_
#define SIZE_OF_RESERVE_TABLE  99
#else
#define SIZE_OF_RESERVE_TABLE  88
#endif
  
string* string_obj_on;
string* string_obj_off;

header* (*new_instance[SIZE_OF_RESERVE_TABLE])(void);

reserve_word reserve_table[SIZE_OF_RESERVE_TABLE] ;
int msg_sym_table[METHOD_END];
int sym_notinit;
int sym_location, sym_integer, sym_float, sym_string, sym_list;
int sym_sphere, sym_line, sym_dot, sym_box, sym_pipe0,sym_pipe1,sym_mesh;
int sym_cylinder0, sym_cylinder1, sym_conic, sym_cone, 
  sym_pillar0;
int sym_pillar1,sym_segment, sym_light, sym_text, sym_material, sym_group,
  sym_node;
int sym_m_alpha, sym_m_value, sym_m_element, sym_m_car, sym_m_cdr,
  sym_m_insert;
int sym_m_append, sym_m_sync, sym_m_quit, sym_m_moves, sym_m_antialiases;
int sym_m_smooths, sym_m_is, sym_m_bind, sym_m_nurbs, sym_m_delete,
  sym_m_shines;
int sym_m_speculer, sym_m_colors, sym_m_rotate, sym_m_rotation, sym_m_draw;
int sym_m_hide, sym_m_wire, sym_m_scale, sym_m_location, sym_m_to, sym_m_from;
int sym_m_copy, sym_m_transform, sym_m_push, sym_m_pop, sym_m_into, sym_m_up;
int sym_m_drawall, sym_m_hideall, sym_m_wireall;

#ifdef _DISABLE_GL_
int sym_atom, sym_bond, sym_helix, sym_sheet;
int sym_m_ribbon, sym_m_divide, sym_m_globe;
int sym_m_turn, sym_m_wired, sym_m_calpha, sym_m_seqno;
#endif

int sym_f_sin, sym_f_asin, sym_f_cos, sym_f_acos, sym_f_tan, sym_f_atan,
  sym_f_log;
int sym_f_exp, sym_f_int;
int sym_om_color, sym_om_radius, sym_om_depth, sym_om_width;
int sym_om_style, sym_om_points, sym_om_top, sym_om_bottom;
int sym_om_height, sym_om_division, sym_om_string, sym_om_font;
int sym_om_size;
#ifdef _DISABLE_GL_
int sym_om_resID;
#endif
int sym_new0, sym_new1;
int sym_param_on, sym_param_off;


header* new_sphere(void)
{
  return (header*)(new sphere);
}

header* new_material(void)
{
  return (header*)(new material);
}

header* new_light(void)
{
  return (header*)(new light);
}

header* new_group(void)
{
  return (header*)(new group);
}

header* new_cylinder(void)
{
  return (header*)(new cylinder);
}

header* new_cylinder1(void)
{
  return (header*)(new cylinder1);
}

header* new_pipe0(void)
{
  return (header*)(new pipe0);
}

header* new_pipe1(void)
{
  return (header*)(new pipe1);
}

header* new_pillar0(void)
{
  return (header*)(new pillar0);
}

header* new_pillar1(void)
{
  return (header*)(new pillar1);
}

header* new_conic(void)
{
  return (header*)(new conic);
}

header* new_cone(void)
{
  return (header*)(new cone);
}

header* new_line(void)
{
  return (header*)(new line);
}

header* new_segment(void)
{
  return (header*)(new segment);
}

header* new_mesh(void)
{
  return (header*)(new mesh);
}

header* new_text(void)
{
  return (header*)(new text);
}

header* new_dot(void)
{
  return (header*)(new dot);
}

header* new_box(void)
{
  return (header*)(new box);
}

#ifdef _DISABLE_GL_
header* new_bond(void)
{
  return (header*)(new bond);
}

header* new_helix(void)
{
  return (header*)(new helix);
}

header* new_sheet(void)
{
  return (header*)(new sheet);
}
#endif


int is_reserve_string(int i)
{
  if ((i >4)&&(i<SIZE_OF_RESERVE_TABLE)) return TRUE;
  return FALSE; 
}

int reserved_word(YYSTYPE* yylv,int index)
{
  *yylv = reserve_table[index].value;
  return reserve_table[index].retvalue;
}

void set_object_type_symbol(int r_index)
{
  reserve_table[r_index].value.ival = r_index;
  reserve_table[r_index].retvalue = OBJECT_TYPE;
}
void set_object_member_symbol(int r_index)
{
  reserve_table[r_index].value.ival = r_index;
  reserve_table[r_index].retvalue = MEMBER;
}
void set_mathematics_function_symbol(int r_index,FunctionID fid)
{
  reserve_table[r_index].value.fidval = fid;
  reserve_table[r_index].retvalue = MATH_FUNC;
}
void set_symbol_message_symbol(int r_index,MethodID mid)
{
  reserve_table[r_index].value.midval = mid;
  reserve_table[r_index].retvalue = METHOD_ONLY_NAME;
}
void set_message_symbol(int r_index,MethodID mid)
{
  reserve_table[r_index].value.midval = mid;
  reserve_table[r_index].retvalue = METHOD_NAME;
}

void initialize_symbol()
{

  sym_notinit = hash_table.wordId("not initialize"); /*value = 1*/
  sym_integer = hash_table.wordId("integer");        /*value = 2*/
  sym_float = hash_table.wordId("float");            /*value = 3*/
  sym_list = hash_table.wordId("list");              /*value = 4*/
  sym_string = hash_table.wordId("string");          /*value = 5*/
  
  sym_new0 = hash_table.wordId("a");                 /*value = 6*/
  reserve_table[sym_new0].retvalue = NEW;
  sym_new1 = hash_table.wordId("an");                /*value = 7*/
  reserve_table[sym_new1].retvalue = NEW;
  
  sym_light = hash_table.wordId("light");            /*value = 8*/
  set_object_type_symbol(sym_light);
  new_instance[sym_light] = new_light;

  sym_sphere = hash_table.wordId("sphere");
  set_object_type_symbol(sym_sphere);
  new_instance[sym_sphere] = new_sphere;

  sym_line = hash_table.wordId("line");
  set_object_type_symbol(sym_line);
  new_instance[sym_line] = new_line;

  sym_dot = hash_table.wordId("dot");
  set_object_type_symbol(sym_dot);
  new_instance[sym_dot] = new_dot;

  sym_segment = hash_table.wordId("segment");
  set_object_type_symbol(sym_segment);
  new_instance[sym_segment] = new_segment;

  sym_box = hash_table.wordId("box");   
  set_object_type_symbol(sym_box);
  new_instance[sym_box] = new_box;

  sym_text = hash_table.wordId("text");
  set_object_type_symbol(sym_text);
  new_instance[sym_text] = new_text;

  sym_material = hash_table.wordId("material");
  set_object_type_symbol(sym_material);
  new_instance[sym_material] = new_material;

  sym_group = hash_table.wordId("group");
  set_object_type_symbol(sym_group);
  new_instance[sym_group] = new_group;

  sym_node = hash_table.wordId("node");
  set_object_type_symbol(sym_node);

  sym_cylinder0 = hash_table.wordId("cylinder0");
  set_object_type_symbol(sym_cylinder0);
  new_instance[sym_cylinder0] = new_cylinder;

  sym_cylinder1 = hash_table.wordId("cylinder1");
  set_object_type_symbol(sym_cylinder1);
  new_instance[sym_cylinder1] = new_cylinder1;

  sym_pipe0 = hash_table.wordId("pipe0");
  set_object_type_symbol(sym_pipe0);
  new_instance[sym_pipe0] = new_pipe0;

  sym_pipe1 = hash_table.wordId("pipe1");
  set_object_type_symbol(sym_pipe1);
  new_instance[sym_pipe1] = new_pipe1;

  sym_mesh = hash_table.wordId("mesh");
  set_object_type_symbol(sym_mesh);
  new_instance[sym_mesh] = new_mesh;

  sym_conic = hash_table.wordId("conic");
  set_object_type_symbol(sym_conic);
  new_instance[sym_conic] = new_conic;

  sym_cone = hash_table.wordId("cone");
  set_object_type_symbol(sym_cone);
  new_instance[sym_cone] = new_cone;

  sym_pillar0 = hash_table.wordId("pillar0");
  set_object_type_symbol(sym_pillar0);
  new_instance[sym_pillar0] = new_pillar0;

  sym_pillar1 = hash_table.wordId("pillar1");
  set_object_type_symbol(sym_pillar1);
  new_instance[sym_pillar1] = new_pillar1;

#ifdef _DISABLE_GL_
  sym_bond = hash_table.wordId("bond");
  set_object_type_symbol(sym_bond);
  new_instance[sym_bond] = new_bond;

  sym_helix = hash_table.wordId("helix");
  set_object_type_symbol(sym_helix);
  new_instance[sym_helix] = new_helix;

  sym_sheet = hash_table.wordId("sheet");
  set_object_type_symbol(sym_sheet);
  new_instance[sym_sheet] = new_sheet;
#endif

  sym_om_string = sym_string;
  set_object_member_symbol(sym_om_string);

  sym_om_font = hash_table.wordId("font");
  set_object_member_symbol(sym_om_font);

  sym_om_size = hash_table.wordId("size");
  set_object_member_symbol(sym_om_size);

  sym_om_radius = hash_table.wordId("radius");
  set_object_member_symbol(sym_om_radius);

  sym_om_depth = hash_table.wordId("depth");
  set_object_member_symbol(sym_om_depth);

  sym_om_top = hash_table.wordId("top");
  set_object_member_symbol(sym_om_top);

  sym_om_bottom = hash_table.wordId("bottom");
  set_object_member_symbol(sym_om_bottom);

  sym_om_height = hash_table.wordId("height");
  set_object_member_symbol(sym_om_height);

  sym_om_division = hash_table.wordId("division");
  set_object_member_symbol(sym_om_division);

  sym_om_width = hash_table.wordId("width");
  set_object_member_symbol(sym_om_width);

  sym_om_style = hash_table.wordId("style");
  set_object_member_symbol(sym_om_style);

  sym_om_points = hash_table.wordId("points");
  set_object_member_symbol(sym_om_points);

  sym_om_color = hash_table.wordId("color");
  set_object_member_symbol(sym_om_color);
#ifdef _DISABLE_GL_
  sym_om_resID = hash_table.wordId("at");
  set_object_member_symbol(sym_om_resID);
#endif
  sym_f_sin = hash_table.wordId("sin");       set_mathematics_function_symbol(sym_f_sin,FUNCTION_SIN);
  sym_f_asin = hash_table.wordId("asin");     set_mathematics_function_symbol(sym_f_asin,FUNCTION_ASIN);
  sym_f_cos = hash_table.wordId("cos");       set_mathematics_function_symbol(sym_f_cos,FUNCTION_COS);
  sym_f_acos = hash_table.wordId("acos");     set_mathematics_function_symbol(sym_f_acos,FUNCTION_ACOS);
  sym_f_tan = hash_table.wordId("tan");       set_mathematics_function_symbol(sym_f_tan,FUNCTION_TAN);
  sym_f_atan = hash_table.wordId("atan");     set_mathematics_function_symbol(sym_f_atan,FUNCTION_ATAN);
  sym_f_log = hash_table.wordId("log");       set_mathematics_function_symbol(sym_f_log,FUNCTION_LOG);
  sym_f_exp = hash_table.wordId("exp");       set_mathematics_function_symbol(sym_f_exp,FUNCTION_EXP);
  sym_f_int = hash_table.wordId("int");       set_mathematics_function_symbol(sym_f_int,FUNCTION_INT);

  int s_count = 0;

  sym_m_car = hash_table.wordId("car");
  set_symbol_message_symbol(sym_m_car,METHOD_CAR);
  msg_sym_table[s_count++]= sym_m_car;

  sym_m_cdr = hash_table.wordId("cdr");
  set_symbol_message_symbol(sym_m_cdr,METHOD_CDR);
  msg_sym_table[s_count++]= sym_m_cdr;

  sym_m_quit = hash_table.wordId("quit");
  set_symbol_message_symbol(sym_m_quit,METHOD_QUIT);
  msg_sym_table[s_count++]= sym_m_quit;

  sym_m_bind = hash_table.wordId("bind");
  set_symbol_message_symbol(sym_m_bind,METHOD_BIND);
  msg_sym_table[s_count++]= sym_m_bind;

  sym_m_delete = hash_table.wordId("delete");
  set_symbol_message_symbol(sym_m_delete,METHOD_DELETE);
  msg_sym_table[s_count++]= sym_m_delete;

  sym_m_location = hash_table.wordId("location");
  set_symbol_message_symbol(sym_m_location,METHOD_LOCATION);
  msg_sym_table[s_count++]= sym_m_location;

  sym_m_rotation = hash_table.wordId("rotation");
  set_symbol_message_symbol(sym_m_rotation,METHOD_ROTATION);
  msg_sym_table[s_count++]= sym_m_rotation;

  sym_m_draw = hash_table.wordId("draw");
  set_symbol_message_symbol(sym_m_draw,METHOD_DRAW);
  msg_sym_table[s_count++]= sym_m_draw;

  sym_m_drawall = hash_table.wordId("drawall");
  set_symbol_message_symbol(sym_m_drawall,METHOD_DRAW_ALL);
  msg_sym_table[s_count++]= sym_m_drawall;

  sym_m_hide = hash_table.wordId("hide");
  set_symbol_message_symbol(sym_m_hide,METHOD_HIDE);
  msg_sym_table[s_count++]= sym_m_hide;

  sym_m_hideall = hash_table.wordId("hideall");
  set_symbol_message_symbol(sym_m_hideall,METHOD_HIDE_ALL);
  msg_sym_table[s_count++]= sym_m_hideall;

  sym_m_wire = hash_table.wordId("wire");
  set_symbol_message_symbol(sym_m_wire,METHOD_WIRE);
  msg_sym_table[s_count++]= sym_m_wire;

  sym_m_wireall = hash_table.wordId("wireall");
  set_symbol_message_symbol(sym_m_wireall,METHOD_WIRE_ALL);
  msg_sym_table[s_count++]= sym_m_wireall;

  sym_m_up = hash_table.wordId("up");                  set_symbol_message_symbol(sym_m_up,METHOD_UP);
  msg_sym_table[s_count++]= sym_m_up;
  sym_m_sync = hash_table.wordId("sync");              set_symbol_message_symbol(sym_m_sync,METHOD_SYNC);
  msg_sym_table[s_count++]= sym_m_sync;
  sym_m_pop = hash_table.wordId("pop");                set_symbol_message_symbol(sym_m_pop,METHOD_POP);
  msg_sym_table[s_count++]= sym_m_pop;

  sym_m_alpha = hash_table.wordId("alpha");            set_message_symbol(sym_m_alpha,METHOD_ALPHA);
  msg_sym_table[s_count++]= sym_m_alpha;

  sym_m_insert = hash_table.wordId("insert");
  set_message_symbol(sym_m_insert,METHOD_INSERT);
  msg_sym_table[s_count++]= sym_m_insert;

  sym_m_element = hash_table.wordId("element");        set_message_symbol(sym_m_element,METHOD_ELEMENT);
  msg_sym_table[s_count++]= sym_m_element;
  sym_m_append = hash_table.wordId("append");          set_message_symbol(sym_m_append,METHOD_APPEND);
  msg_sym_table[s_count++]= sym_m_append;
  sym_m_value = hash_table.wordId("value");            set_message_symbol(sym_m_value,METHOD_VALUE);
  msg_sym_table[s_count++]= sym_m_value;
  sym_m_is = hash_table.wordId("is");                  set_message_symbol(sym_m_is,METHOD_IS);
  msg_sym_table[s_count++]= sym_m_is;
  sym_m_shines = hash_table.wordId("shines");          set_message_symbol(sym_m_shines,METHOD_SHINES);
  msg_sym_table[s_count++]= sym_m_shines;
  sym_m_speculer = hash_table.wordId("speculer");      set_message_symbol(sym_m_speculer,METHOD_SPECULER);
  msg_sym_table[s_count++]= sym_m_speculer;
  sym_m_colors = hash_table.wordId("colors");          set_message_symbol(sym_m_colors,METHOD_COLOR);
  msg_sym_table[s_count++]= sym_m_colors;
  sym_m_to = hash_table.wordId("to");                  set_message_symbol(sym_m_to,METHOD_TO);
  msg_sym_table[s_count++]= sym_m_to;
  sym_m_from = hash_table.wordId("from");              set_message_symbol(sym_m_from,METHOD_FROM);
  msg_sym_table[s_count++]= sym_m_from;

  sym_m_antialiases = hash_table.wordId("antialiases");
  set_message_symbol(sym_m_antialiases,METHOD_ANTIALIASES);
  msg_sym_table[s_count++]= sym_m_antialiases;

  sym_m_smooths = hash_table.wordId("smooths");        set_message_symbol(sym_m_smooths,METHOD_SMOOTHS);
  msg_sym_table[s_count++]= sym_m_smooths;
  sym_m_nurbs = hash_table.wordId("nurbs");            set_message_symbol(sym_m_nurbs,METHOD_NURBS);
  msg_sym_table[s_count++]= sym_m_nurbs;
  sym_m_moves = hash_table.wordId("moves");            set_message_symbol(sym_m_moves,METHOD_MOVE);
  msg_sym_table[s_count++]= sym_m_moves;
  sym_m_rotate = hash_table.wordId("rotate");          set_message_symbol(sym_m_rotate,METHOD_ROTATE);
  msg_sym_table[s_count++]= sym_m_rotate;
  sym_m_copy = hash_table.wordId("=");                 set_message_symbol(sym_m_copy,METHOD_COPY);
  msg_sym_table[s_count++]= sym_m_copy;

  sym_m_scale = hash_table.wordId("magnify");
  set_message_symbol(sym_m_scale,METHOD_SCALE);
  msg_sym_table[s_count++]= sym_m_scale;

  sym_m_into = hash_table.wordId("into");              set_message_symbol(sym_m_into,METHOD_INTO);
  msg_sym_table[s_count++]= sym_m_into;
  sym_m_push = hash_table.wordId("push");              set_message_symbol(sym_m_push,METHOD_PUSH);
  msg_sym_table[s_count++]= sym_m_push;

  sym_m_transform = hash_table.wordId("transform");
  set_message_symbol(sym_m_transform,METHOD_TRANSFORM);
  msg_sym_table[s_count++]= sym_m_transform;

#ifdef _DISABLE_GL_
  /* GroupObject <- Message */

  sym_m_ribbon = hash_table.wordId("ribbon");  set_symbol_message_symbol(sym_m_ribbon,METHOD_RIBBON_ALL);
  msg_sym_table[s_count++]= sym_m_ribbon;


  /* GroupObject <- Message Argument */

  sym_m_divide = hash_table.wordId("divide");  set_message_symbol(sym_m_divide,METHOD_DIVIDE);
  msg_sym_table[s_count++]= sym_m_divide;

  sym_atom = hash_table.wordId("atom");
  set_object_type_symbol(sym_atom);

//  sym_m_globe = hash_table.wordId("atom");    set_message_symbol(sym_m_globe,METHOD_GLOBE);
//  msg_sym_table[s_count++]= sym_m_globe;

//  sym_m_sheet = hash_table.wordId("sheet");    set_message_symbol(sym_m_sheet,METHOD_RIBBON_SHEET);
//  msg_sym_table[s_count++]= sym_m_sheet;

  sym_m_turn = hash_table.wordId("turn");      set_message_symbol(sym_m_turn,METHOD_RIBBON_TURN);
  msg_sym_table[s_count++]= sym_m_turn;

//  sym_m_helix = hash_table.wordId("helix");    set_message_symbol(sym_m_helix,METHOD_RIBBON_HELIX);
//  msg_sym_table[s_count++]= sym_m_helix;

  sym_m_wired = hash_table.wordId("wired");    set_message_symbol(sym_m_wired,METHOD_WIRED);
  msg_sym_table[s_count++]= sym_m_wired;

  sym_m_seqno = hash_table.wordId("seqno");    set_message_symbol(sym_m_seqno,METHOD_SEQ_NO);
  msg_sym_table[s_count++]= sym_m_seqno;

  sym_m_calpha = hash_table.wordId("calpha");  set_message_symbol(sym_m_calpha,METHOD_C_ALPHA);
  msg_sym_table[s_count++]= sym_m_calpha;
#endif

  sym_param_on = hash_table.wordId("on"); 
  string_obj_on = (string*)create_string(sym_param_on);
  reserve_table[sym_param_on].value.oval = string_obj_on;
  reserve_table[sym_param_on].retvalue = SWSYM;

  sym_param_off = hash_table.wordId("off");
  string_obj_off = (string*)create_string(sym_param_off);
  reserve_table[sym_param_off].value.oval = string_obj_off; 
  reserve_table[sym_param_off].retvalue = SWSYM; 
}
