/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -*- C++ -*- */
#ifndef _rotation_h_
#define _rotation_h_

#ifndef _header_h_
#include "header.h"
#endif

/* Begin Type Definition rotation */
class rotation : public header
{
 protected:	
  double value[3];
 public:
  inline rotation();
  inline rotation(double a,double b,double c);
  inline void X(double a);
  inline void Y(double a);
  inline void Z(double a);
  inline double X();
  inline double Y();
  inline double Z();
  inline const double* VP();
};

inline rotation::rotation()
{
  value[0] = 0;  value[1] = 0;  value[2] = 0;
}
inline rotation::rotation(double a,double b,double c)
{
  value[0] = a;  value[1] = b;  value[2] = c;
}

inline void rotation::X(double a)
{
  value[0] = a;
}

inline void rotation::Y(double a)
{
  value[1] = a;
}

inline void rotation::Z(double a)
{
  value[2] = a;
}

inline double rotation::X()
{
  return value[0];
}

inline double rotation::Y()
{
  return value[1];
}

inline double rotation::Z()
{
  return value[2];
}

inline const double* rotation::VP()
{
  return value;
}

/* End Type Definition rotation */
#endif /* _rotation_h_*/
