/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -*- C++ -*- */
#ifndef  _object_h_
#define  _object_h_

/*************************************************************************

եå֥ȤΥ١饹

Ѿط
                        |class header   |
                              |
                        |class container|
                              |
                        |class object   |

*************************************************************************/

#ifndef _header_h_
#include "header.h"
#endif /*_header_h_*/

#ifndef  _location_h_
#include "location.h"
#endif

#ifndef _rotation_h_
#include "rotation.h"
#endif

#ifndef _rotation_h_
#include "rotation.h"
#endif

/* function defined  at object.c */
/*
typedef enum {
  ObjectDrawing,
  DrawingWireFrame,
  ObjectHidding
} DrawStatus;
*/

#ifndef _color_obj_h_
#include "color_obj.h"
#endif

/* Begin Class Definition object */

class node;
class object :public header {
 protected:
  DrawStatus dstate;
  double scale;
  short obj_id;
  node* color;
  location* object_location;
  location* object_rotation;
 public:
/* Function Defined At object.c */
  object();
  inline short Id();
  DrawStatus DrawState();
  void Move(header* l);
  header* Location();
  void Location(header* l);
  void Rotate(header* r);
  header* Rotate();
  virtual header* Reference(char* name);
  virtual header* Reference(int id);
  void DrawState(DrawStatus t);
  virtual void CopySplitMember();
  void Draw();
  virtual void Scale(double s);
  double Scale();
  void PushScale();
  void PopScale();
  virtual void From(location* l);
  virtual void To(location* l);
  virtual void PushTranslation();
  virtual void PopTranslation();
  virtual void PushRotation();
  virtual void PopRotation();

  virtual void Nurbs(char* str);
  virtual void AliasState(char* str);
};

inline short object::Id()
{
  return obj_id;
}
/* End Class Definition object */

extern char* object_mem0;
extern short obj_name;

#endif
