/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -*-C++-*- */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#ifndef _DISABLE_GL_
#include <gl/gl.h>
#include <gl/device.h>
#include <gl/sphere.h>
#include <fmclient.h>
#endif
#include "exit.h"
#include "object.h"
#include "node.h"
#include "group.h"
#include "gorth.h"
#include "sphere.h"
#include "boolean.h"

#ifndef _DISABLE_GL_
extern "C" {
#include "event.h"
#include "ui.h"
  extern long origx;
  extern long origy;
};
extern int current_color_id;
extern void open_panel();
extern void drawPanel(long event,short) ;
extern void panel_event_set() ;
extern group* root_obj;
extern group* var_list;
extern graphic_orth* orth_obj;
extern void close_panel();
extern node* back_ground;

/* for -geometry */
extern int is_w_pos_set;
extern int wlx;
extern int wly;
extern int wrx;
extern int wry;

char *default_title = "3D View"; 
char* title;
short pick_buff[100];
static float spinrot[4] = {0.0, 0.0, 0.0, 1.0};
static int spin = TRUE;
static int uiflag = TRUE;
static float LightModel[] = {
  AMBIENT,     1.0, 1.0, 1.0,
  LOCALVIEWER, 1.0,
  TWOSIDE,1,
  LMNULL
  };
int sphere_depth = DEFAULT_DEPTH;
int p_open;
int p_event;
long mymenu;
long mainwin;
int is_remember = FALSE;

Matrix MatI = {
  {1.0, 0.0, 0.0, 0.0},
  {0.0, 1.0, 0.0, 0.0},
  {0.0, 0.0, 1.0, 0.0},
  {0.0, 0.0, 0.0, 1.0}
  };
int display_info_flag = FALSE;
float trans[3] = { 0.0, 0.0, 0.0};
float rvecs[4] = {0.0, 0.0, 0.0, 1.0};
float rvec[4] = {0.0, 0.0, 0.0, 1.0};
#endif

extern int user_main(int argc,char** argv);
extern void load_initial_file();
extern void initialize();
extern void interpriter();
extern int is_read_eof;

int is_not_load_initial_file;

void set_orth_graphic()
//{}
// system call ortho()ƤӽФ
//{}
{
#ifndef _DISABLE_GL_
  orth_obj->Orth();
#endif
}

void back_ground_clear()
//{}
// ѿBackGroundColorMaterial֥Ȥοطʤ򥯥ꥢ롣
//{}
{
#ifndef _DISABLE_GL_
  header* val;
  val = back_ground->Value();
  if (val->Type() == MATERIAL_OBJ) {
    unsigned long word;
    word = (unsigned long)((((material*)val)->Alpha()*255)/255);
    word <<= 8;
    word += ((material*)val)->PrBlue();
    word <<= 8;
    word += ((material*)val)->PrGreen();
    word <<= 8;
    word += ((material*)val)->PrRed();
    czclear(word, getgdesc(GD_ZMAX));
  } else {
    czclear(0x0f0f0f, getgdesc(GD_ZMAX));
  }
#endif
}

void drawObject()
//{}
// ֥Ȥ롼Ȥ褹롣
//{}
{
#ifdef DEBUG
  fprintf(stderr,"void drawObject()\n");
#endif
#ifndef _DISABLE_GL_
  winset(mainwin);
  swapbuffers();
  Matrix M;
  long height,width;
  getsize(&width,&height);
  getorigin(&origx, &origy);
  float x,y;
  x = (float)width;
  y = (float)height;
  set_orth_graphic();
  perspective(400,x/y, 0.1, 4.0);
  pushmatrix();
  translate(trans[0], trans[1], trans[2]);
  scale(0.1, 0.1, 0.1);
  build_rotmatrix(M, rvec);
  multmatrix(M);
  back_ground_clear();

  root_obj->Draw();

  current_color_id = 0;
  if (!is_remember) {
    interpriter();
  }
  popmatrix();
  gflush();
#endif
}

void ReDrawObject(long event,short val)
//{}
// REDRAW٥ȤФؿ
//{}
{
#ifdef DEBUG
  fprintf(stderr,"void ReDrawObject(long %x,short %x)\n",event,val);
#endif
#ifndef _DISABLE_GL_
  winset(mainwin);
  reshapeviewport();
  is_remember = TRUE;
  drawObject();
  is_remember = FALSE;
#endif
}

void remember_view(float *r, float *t)
//{}
// user interfaceФؿ
//{}
{
#ifdef DEBUG
  fprintf(stderr,"void remember_view(float %x, float %x)\n",(unsigned int)r,(unsigned int)t);
#endif
#ifndef _DISABLE_GL_
  vcopy(r, spinrot);
  spinrot[3] = r[3];
  add_quats(r, rvec, rvec);
  trans[0] += t[0]; trans[1] += t[1]; trans[2] += t[2];
  ReDrawObject(0,0);
#endif
}

void initialize_default_value()
//{}
// 饤ȥ֥ȡSPHERE()֥Ȥδͤꤷ
// ̾κɸϤνԤʤ
//{}
{
#ifdef DEBUG
  fprintf(stderr,"void initialize_default_value()\n");
#endif
#ifndef _DISABLE_GL_
  lmdef( DEFLMODEL, 1, 0, LightModel);
  lmbind(LMODEL,1);
  sphmode(SPH_DEPTH, sphere_depth);
  sphmode(SPH_TESS,  SPH_BARY);
  sphmode(SPH_PRIM,  SPH_MESH);
  sphmode(SPH_HEMI,  TRUE);
  sphmode(SPH_ORIENT,TRUE);
  sphrotmatrix(MatI);
  translate(0.0, 0.0, -2.0);
#endif
}

void do_menus(long event,short val)
//{}
// ݥåץåץ˥塼и롣
//{}
{
#ifdef DEBUG
  fprintf(stderr,"void do_menus(long %x,short %x)\n",event,val);
#endif
#ifndef _DISABLE_GL_
  dopup(mymenu);
#endif
}

void reset_transforms()
//{}
// ưκɸ֡٤᤹
//{}
{
#ifdef DEBUG
  fprintf(stderr,"void reset_transforms()\n");
#endif
#ifndef _DISABLE_GL_
  rvec[0] = rvecs[0]; rvec[1] = rvecs[1];
  rvec[2] = rvecs[2]; rvec[3] = rvecs[3];
  trans[0] = trans[1] = trans[2] =  0.0;
#endif
}

void toggle_spin()
//{}
// žΥե饰ȿž
//{}
{
#ifdef DEBUG
  fprintf(stderr,"void toggle_spin()\n");
#endif
#ifndef _DISABLE_GL_
  spin =  !spin;
#endif
}

void toggle_ui()
{
#ifdef DEBUG
  fprintf(stderr,"void toggle_ui()\n");
#endif
#ifndef _DISABLE_GL_
  uiflag =  !uiflag;
  ui_active(uiflag);
#endif
}

void panel_on_off()
{
#ifdef DEBUG
  fprintf(stderr,"void panel_on_off()\n");
#endif
#ifndef _DISABLE_GL_
  if (p_open)	{
    p_open = FALSE;
    close_panel();
  } else {
    open_panel();
    if (!p_event) {
      p_event = TRUE;
      panel_event_set() ;
    }
    drawPanel(0,0);
    p_open = TRUE;
  }
#endif
}

void initialize_popup_menu(void)
{
#ifdef DEBUG
  fprintf(stderr,"void initialize_popup_menu(void)\n");
#endif
#ifndef _DISABLE_GL_
  addtopup(mymenu, "Example %t");
  addtopup(mymenu, "Reset Transformations %f", reset_transforms);
  addtopup(mymenu, "Panel Open/Close %f", panel_on_off);
  addtopup(mymenu, "Spin On/Off %f", toggle_spin);
  addtopup(mymenu, "Interface On/Off %f", toggle_ui);
  addtopup(mymenu, "Exit Program %f", ui_exit);
#endif
}

void spin_draw(void)
{
#ifdef DEBUG
  fprintf(stderr,"void spin_draw()\n");
#endif
#ifndef _DISABLE_GL_
  if (ui_quiet)	{
    add_quats(spinrot, rvec, rvec); 
    drawObject();
  }
  if (p_open)	{
    drawPanel(0,0);
  }
#endif
}

int main(int argc,char** argv)
{
#ifdef DEBUG
  fprintf(stderr,"int main(int %d,char** %x)\n",argc,(unsigned int)argv);
#endif
#ifndef _DISABLE_GL_
  title = default_title;
  p_open = FALSE;
  p_event = FALSE;
  is_remember = FALSE;
#endif
  initialize();
  user_main(argc,argv);
#ifndef _DISABLE_GL_
  if (is_w_pos_set) {
    /*printf("set pos %d %d %d %d\n",wlx,wly,wrx,wry);*/
    prefposition(wlx,wrx,wly,wry);
  }
  mainwin = winopen(title);
  mymenu = newpup();
  reset_transforms();
  fminit();
  RGBmode();
  doublebuffer();
  zdraw(FALSE);
  gconfig();
  lsetdepth(getgdesc(GD_ZMIN), getgdesc(GD_ZMAX));
  getgdesc(GD_BITS_NORM_SNG_ALPHA);
  zbuffer(1);
  mmode(MPROJECTION);
  set_orth_graphic();
  mmode(MVIEWING);
  backface(TRUE);
  loadmatrix(MatI);
  perspective(400, 1.0, 0.1, 4.0);
  afunction(0,AF_NOTEQUAL);
  blendfunction(BF_ONE,BF_MSC);
  initialize_default_value();
  initialize_popup_menu();
  load_initial_file();
  add_event(ANY, RIGHTMOUSE, DOWN, (void(*)(void*,int))do_menus, 0);
  qdevice(RIGHTMOUSE);
  add_event(ANY, ESCKEY, UP, (void(*)(void*,int))ui_exit, 0);
  qdevice(ESCKEY);
  add_event(ANY, WINQUIT, ANY, (void(*)(void*,int))ui_exit, 0);
  qdevice(WINQUIT);
  add_event(mainwin, REDRAW, ANY,(void(*)(void*,int))ReDrawObject, 0);
  qdevice(REDRAW);
  add_update(&spin,(void(*)(void))spin_draw,0);
  back_ground_clear();
  gflush();
  swapbuffers();
  ui(remember_view);
  sphfree();
  gexit();
  return 0;
#else
  is_not_load_initial_file = FALSE;
  load_initial_file();
  is_not_load_initial_file = TRUE;
  while((!is_read_eof)) {
    interpriter();
  }
#endif
}





